<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('loans', function (Blueprint $table) {
            if(!Schema::hasColumn('loans' ,'percentage')){
                $table->double('percentage')->nullable();
            }
        });
        Schema::table('cheque', function (Blueprint $table) {
            if(!Schema::hasColumn('cheque' ,'comm_percentage_one')){
                $table->double('comm_percentage_one')->nullable();
            }
            if(!Schema::hasColumn('cheque' ,'comm_percentage_two')){
                $table->double('comm_percentage_two')->nullable();
            }
        }); 
        Schema::table('transfer_accounts', function (Blueprint $table) {
            if(!Schema::hasColumn('transfer_accounts' ,'comm_percentage')){
                $table->double('comm_percentage')->nullable();
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('loans', function (Blueprint $table) {
            //
        });
    }
};
