<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('payments', function (Blueprint $table) {
            if(!Schema::hasColumn('payments','fixed_asset_id')){
                $table->integer('fixed_asset_id')->nullable()->index();
            }
        });
		
        Schema::table('payment_by_factor_details', function (Blueprint $table) {
            if(!Schema::hasColumn('payment_by_factor_details','types')){
                $table->string('types')->nullable();
                $table->integer('fixed_payment_id')->nullable()->index();
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('payments', function (Blueprint $table) {
            //
        });
    }
};
