<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('customs_expense_stocks')) {
            Schema::create('customs_expense_stocks', function (Blueprint $table) {
                $table->id();
                $table->integer('customs_expense_id')->index();
                $table->integer('stock_id')->index();
                $table->double('quantity');
                $table->double('cost');
                $table->integer('company_id')->nullable()->index();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('customs_expense_stocks');
    }
};
