<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('customs_expenses')) {
            Schema::create('customs_expenses', function (Blueprint $table) {
                $table->id();
                $table->integer('number');
                $table->string('currency');
                $table->double('rate');
                $table->datetime('date');
                $table->string('type');
                $table->integer('type_id')->index();
                $table->integer('type_number');
                $table->string('ref_number')->nullable();
                $table->string('ref_name')->nullable();
                $table->integer('stock_id')->nullable()->index();
                $table->integer('loading_details_id')->nullable()->index();
                $table->integer('inventory_id')->nullable()->index();
                $table->double('amount')->nullable();
                $table->double('customs_quantity')->nullable();
                $table->double('quantity')->nullable();
                $table->double('differ_quantity')->nullable();
                $table->double('liter')->nullable();
                $table->double('density')->nullable();
                $table->integer('company_license_id')->nullable()->index();
                $table->integer('transaction_id')->nullable()->index();
                $table->integer('expense_transaction_id')->nullable()->index();
                $table->double('customs_amount')->nullable();
				$table->double('customs_percent')->nullable();
				$table->double('tax_percent')->nullable();
                $table->double('helal_ahmar_percent')->nullable();
                $table->double('total_amount')->nullable();
                $table->double('total_customs_amount')->nullable();
                $table->double('over_customs_amount')->nullable();
                $table->double('total_pay_amount')->nullable();
                $table->text('description')->nullable();
                $table->string('edit_type')->nullable();
                $table->double('holdingDays')->nullable();
                $table->double('remove_days')->nullable();
                $table->datetime('from_date')->nullable();
                $table->datetime('to_date')->nullable();
                $table->integer('user_id')->nullable()->index();
                $table->integer('company_id')->nullable()->index();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('customs_expenses');
    }
};
