<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
      if(!Schema::hasTable('company_licenses')) {
        Schema::create('company_licenses', function (Blueprint $table) {
          $table->id();
          $table->string('license_name')->nullable();
          $table->string('license_number')->nullable();
          $table->string('license_type')->nullable();
          $table->datetime('license_issue_date')->nullable();
          $table->datetime('license_expire_date')->nullable();
          $table->integer('user_id')->nullable()->index();
          $table->integer('company_id')->nullable()->index();
          $table->timestamps();
        });
      }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('company_licenses');
    }
};
