<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('customs_expense_options')) {
			Schema::create('customs_expense_options', function (Blueprint $table) {
				$table->id();
				$table->double('customs_amount')->nullable();
				$table->double('customs_percent')->nullable();
				$table->double('tax_percent')->nullable();
				$table->double('helal_ahmar_percent')->nullable();
				$table->integer('user_id')->nullable()->index();
				$table->integer('company_id')->nullable()->index();
				$table->timestamps();
			});
		}
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('customs_expense_options');
    }
};
