<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('customs_expense_categories')) {
			Schema::create('customs_expense_categories', function (Blueprint $table) {
				$table->id();
				$table->string('name')->nullable();
				$table->double('amount')->nullable();
				$table->string('amount_type')->nullable();
				$table->string('calculate_type')->nullable();
				$table->string('calculate_amount')->nullable();
				$table->text('description')->nullable();
				$table->integer('user_id')->nullable()->index();
				$table->integer('company_id')->nullable()->index();
				$table->timestamps();
			});
		}
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('customs_expense_categories');
    }
};
