<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('return_expense_details')) {
        Schema::create('return_expense_details', function (Blueprint $table) {
            $table->id();
            $table->integer('account_id')->nullable()->index();
            $table->datetime('date')->nullable();
            $table->integer('transaction_id')->nullable()->index();
            $table->text('description')->nullable();
            $table->integer('expense_category_id')->nullable()->index();
            $table->integer('project_id')->nullable()->index();
            $table->integer('contract_id')->nullable()->index();
            $table->integer('return_expense_id')->nullable()->index();
            $table->integer('sale_id')->nullable()->index();
            $table->string('status')->nullable();
            $table->integer('company_id')->nullable()->index();
            $table->string('build_expense_confirm')->nullable(); 
            $table->timestamps();
        });
    }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('return_expense_details');
    }
};
