<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('return_expense')) {
        Schema::create('return_expense', function (Blueprint $table) {
            $table->id();
            $table->string('number')->nullable();
            $table->integer('expense_number')->nullable();
            $table->integer('vendor_id')->nullable()->index();
            $table->integer('transaction_id')->nullable()->index();
            $table->datetime('date')->nullable();
            $table->time('hour')->nullable();
            $table->double('discount')->nullable();
            $table->double('rate')->nullable();
            $table->double('hq_rate')->nullable();
            $table->string('description')->nullable();
            $table->string('memo')->nullable();
            $table->string('type')->nullable();
            $table->integer('company_id')->nullable()->index();
            $table->integer('expense_ref')->nullable();
            $table->datetime('overdue_date')->nullable();
            $table->integer('purchase_id')->nullable()->index();
            $table->timestamps(); 
        });
    }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('return_expense');
    }
};
