<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('builds_statistic')) {
        Schema::create('builds_statistic', function (Blueprint $table) {
            $table->id();
			$table->integer('build_code')->nullable();
			$table->integer('item_id')->nullable()->index();
			$table->integer('mesure_id')->nullable()->index();
			$table->integer('quentity')->nullable();
			$table->integer('site_id')->nullable()->index();
			$table->datetime('date')->nullable();
			$table->time('hour')->nullable();
			$table->string('palet_number')->nullable();
			$table->string('person_by')->nullable();
			$table->integer('company_id')->nullable()->index();
            $table->integer('user_id')->nullable()->index();
            $table->timestamps();
        });
    }
	}

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('builds_statistic');
    }
};
