<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('sales_percentage')) {
        Schema::create('sales_percentage', function (Blueprint $table) {
            $table->id();
            $table->double('from_percentage')->nullable(); 
            $table->double('to_percentage')->nullable(); 
            $table->double('amount')->nullable(); 
            $table->integer('sale_order_id')->nullable()->index();
            $table->integer('company_id')->nullable()->index();
            $table->integer('user_id')->nullable()->index();
            $table->timestamps();
        });
    }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sales_percentage');
    }
};
