<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('employee_salary_category')) {
			Schema::create('employee_salary_category', function (Blueprint $table) {
				$table->id();
				$table->string('name')->nullable();
				$table->string('description')->nullable();
				$table->integer('user_id')->nullable()->index();
				$table->integer('company_id')->nullable()->index();
				$table->timestamps();
			});
		}
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('employee_salary_category');
    }
};
