<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('loan_temps')) {
        Schema::create('loan_temps', function (Blueprint $table) {
            $table->id();

            $table->integer('member')->nullable();
            $table->char('type')->nullable();
            $table->double('number')->nullable();
            $table->double('ref_number')->nullable();
            $table->string('referencen_name')->nullable();
            $table->string('bill_number')->nullable();
            $table->string('currency')->nullable();
            $table->integer('bank')->nullable();
            $table->double('rate')->nullable();
            $table->double('exchange_rate')->nullable();
            $table->string('exchange_currency')->nullable();
            $table->double('amount')->nullable();
            $table->double('category')->nullable();
            $table->time('hour')->nullable();
            $table->datetime('date')->nullable();
            $table->datetime('due_date')->nullable();
            $table->integer('expense')->nullable();
            $table->string('description')->nullable();
            $table->string('description1')->nullable();
            $table->string('description2')->nullable();
            $table->integer('company_id')->nullable();
            
            $table->timestamps();
        });
    }
}

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('loan_temps');
    }
};
