<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('item_expenses', function (Blueprint $table) {
            if (!Schema::hasColumn('item_expenses','holding')){
				$table->string('holding',50)->nullable();
            }
        });
		
        Schema::table('item_expense_details', function (Blueprint $table) {
            if (!Schema::hasColumn('item_expense_details','holdingDays')){
				$table->double('holdingDays')->nullable();
				$table->date('from_date')->nullable();
				$table->date('to_date')->nullable();
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('item_expenses', function (Blueprint $table) {
            //
        });
    }
};
