<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('contracts', function (Blueprint $table) {
            if (!Schema::hasColumn('contracts','percentage')){
				$table->double('percentage')->nullable();
				$table->double('per_percent_price')->nullable();
            }
        });
		
        Schema::table('contract_details', function (Blueprint $table) {
            if (!Schema::hasColumn('contract_details','sale_price')){
				$table->double('sale_price')->nullable();
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('contracts', function (Blueprint $table) {
            //
        });
    }
};
