<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('temp_measure')) {
            Schema::create('temp_measure', function (Blueprint $table) {
                $table->id();
                $table->integer('quantity_id')->nullable()->index();
                $table->string('name')->nullable();
                $table->string('unit')->nullable();
                $table->string('symbol',25)->nullable();
                $table->text('description')->nullable();
                $table->double('value')->default(0); 
                $table->integer('company_id')->nullable()->index();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('table_temp_measure');
    }
};
