<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('gas_station_counter')) {
            Schema::create('gas_station_counter', function (Blueprint $table) {
                $table->id();
				$table->integer('number')->nullable();
				$table->double('counter')->nullable();
				$table->text('description')->nullable();
				$table->datetime('date')->nullable();
				$table->integer('oil_part_id')->nullable()->index();
				$table->integer('company_id')->nullable()->index();
				$table->integer('user_id')->nullable()->index();
                $table->timestamps();
            });
        }
    }
    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('table_gas_station_counter');
    }
};
