<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('weighbridgedetails')) {
            Schema::create('weighbridgedetails', function (Blueprint $table) {
                $table->id();
				$table->string('qty')->nullable();
				$table->text('description')->nullable();
				$table->integer('weighbridge_id')->nullable()->index();
				$table->integer('weighbridge_cat_id')->nullable()->index();
				$table->integer('company_id')->nullable()->index();
				$table->integer('user_id')->nullable()->index();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('weighbridgedetails');
    }
};
