<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        
        if(!Schema::hasTable('weighbridgecategori')) {
            Schema::create('weighbridgecategori', function (Blueprint $table) {
                $table->id();
				$table->string('name')->nullable();
				$table->integer('company_id')->nullable()->index();
				$table->integer('user_id')->nullable()->index();
                $table->timestamps();
            });
        }
        Schema::table('weighbridges', function (Blueprint $table) { 
            if (!Schema::hasColumn('weighbridges','weight_cat_id')){
				$table->integer('weight_cat_id')->nullable()->index();
            }
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('table_weighbridgecategori');
    }
};
