<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('loans', function (Blueprint $table) {
            if (!Schema::hasColumn('loans','transaction_confirm')){
                $table->string('transaction_confirm')->nullable();
            }
        });

        Schema::table('cheque', function (Blueprint $table) {
            if (!Schema::hasColumn('cheque','transaction_confirm')){
                $table->string('transaction_confirm')->nullable();
            }
        });

        Schema::table('currency_exchanges', function (Blueprint $table) {
            if (!Schema::hasColumn('currency_exchanges','transaction_confirm')){
                $table->string('transaction_confirm')->nullable();
            }
        });

        
        Schema::table('exchange_brokers', function (Blueprint $table) {
            if (!Schema::hasColumn('exchange_brokers','transaction_confirm')){
                $table->string('transaction_confirm')->nullable();
            }
        });

        Schema::table('transfer_accounts', function (Blueprint $table) {
            if (!Schema::hasColumn('transfer_accounts','transaction_confirm')){
                $table->string('transaction_confirm')->nullable();
            }
        });

        Schema::table('member_transfers', function (Blueprint $table) {
            if (!Schema::hasColumn('member_transfers','transaction_confirm')){
                $table->string('transaction_confirm')->nullable();
            }
        });
        
        Schema::table('member_exchanges', function (Blueprint $table) {
            if (!Schema::hasColumn('member_exchanges','transaction_confirm')){
                $table->string('transaction_confirm')->nullable();
            }
        });

    

        
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('exchange', function (Blueprint $table) {
            //
        });
    }
};
