<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('stocks', function (Blueprint $table) {
            if (!Schema::hasColumn('stocks','model')) {
                $table->string('model')->nullable();
                $table->string('color')->nullable();
            }
        });
		
        Schema::table('purchases', function (Blueprint $table) {
            if (!Schema::hasColumn('purchases','check_sale_price')) {
                $table->string('check_sale_price', 20)->nullable();
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('stocks', function (Blueprint $table) {
            //
        });
    }
};
