<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('temp_transfer_discharge')) {
        Schema::create('temp_transfer_discharge', function (Blueprint $table) {
            $table->id();
            $table->integer('number')->nullable();
            $table->integer('ref_number')->nullable();
            $table->string('description')->nullable();
            $table->integer('adjustment_id')->nullable();
            $table->integer('category_id')->nullable();
            $table->integer('contract_id')->nullable();
			$table->integer('wagon_number_id')->nullable();
            $table->string('item_name_id')->nullable();
            $table->integer('from_site_id')->nullable();
            $table->integer('to_site_id')->nullable();
            $table->integer('quantity')->nullable();
            $table->integer('measure_id')->nullable();
            $table->integer('driver_type_id')->nullable();
            $table->integer('transporter_name_id')->nullable();
            $table->integer('driver_name_id')->nullable();
            $table->integer('plate_number')->nullable();
            $table->integer('vehicle_name_id')->nullable();
            $table->integer('tanker_number_id')->nullable();
			$table->integer('transite_number')->nullable();
            $table->integer('cmr_number')->nullable();
            $table->string('source')->nullable();
            $table->string('distination')->nullable();
            $table->integer('rent_tonazh')->nullable();
            $table->integer('price')->nullable();
            $table->integer('currency_id')->nullable();
			$table->integer('rate')->nullable();
            $table->integer('rent')->nullable();
            $table->timestamps();
        });
    }
}

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('temp_transfer_discharge');
    }
};
