<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        
        if(!Schema::hasTable('temp_fixed_asset')) {
            Schema::create('temp_fixed_asset', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->string('name')->index();
				$table->integer('number')->nullable()->index();
				$table->string('barcode_number')->nullable();
				$table->string('type')->nullable();
                $table->string('category')->nullable();
                $table->string('depreciation_type')->nullable();
                $table->string('depreciation_duration_typ')->nullable();
				$table->string('description')->nullable();
				$table->string('date')->nullable();
				$table->string('asset_id')->nullable()->index();
				$table->string('vendor_id')->nullable()->index();
				$table->string('cost')->nullable();
				$table->string('location')->nullable();
				$table->string('po_number')->nullable();
				$table->string('serial_number')->nullable();
				$table->string('status')->nullable();
				$table->string('note')->nullable();
                $table->integer('category_id')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('temp_fixed_asset');
    }
};
