<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
       
			// add indexs to cargo_receives
			if(Schema::hasTable('cargo_receives')) {
				Schema::table('cargo_receives', function (Blueprint $table) {
					if (Schema::hasColumn('cargo_receives','cargo_contract_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_receives WHERE key_name='cargo_receives_cargo_contract_id_index'"))) {
						$table->index('cargo_contract_id');
					} 
					if (Schema::hasColumn('cargo_receives','receivable_payment_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_receives WHERE key_name='cargo_receives_receivable_payment_id_index'"))) {
						$table->index('receivable_payment_id');
					}
					if (Schema::hasColumn('cargo_receives','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_receives WHERE key_name='cargo_receives_company_id_index'"))) {
						$table->index('company_id');
					} 
				});
			}		


			// add indexs to cargo_sites
			if(Schema::hasTable('cargo_sites')) {
				Schema::table('cargo_sites', function (Blueprint $table) {
					if (Schema::hasColumn('cargo_sites','name') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_sites WHERE key_name='cargo_sites_name_index'"))) {
						$table->index('name');
					} 
					if (Schema::hasColumn('cargo_sites','number') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_sites WHERE key_name='cargo_sites_number_index'"))) {
						$table->index('number');
					}
					if (Schema::hasColumn('cargo_sites','stock_man_phone') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_sites WHERE key_name='cargo_sites_stock_man_phone_index'"))) {
						$table->index('stock_man_phone');
					} 

					if (Schema::hasColumn('cargo_sites','parent_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_sites WHERE key_name='cargo_sites_parent_id_index'"))) {
						$table->index('parent_id');
					} 
					if (Schema::hasColumn('cargo_sites','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_sites WHERE key_name='cargo_sites_company_id_index'"))) {
						$table->index('company_id');
					}
				});
			}	

			

			// add indexs to cargo_stocks
			if(Schema::hasTable('cargo_stocks')) {
				Schema::table('cargo_stocks', function (Blueprint $table) {
					if (Schema::hasColumn('cargo_stocks','cargo_item_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_stocks WHERE key_name='cargo_stocks_cargo_item_id_index'"))) {
						$table->index('cargo_item_id');
					} 
					if (Schema::hasColumn('cargo_stocks','cargo_contract_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_stocks WHERE key_name='cargo_stocks_cargo_contract_id_index'"))) {
						$table->index('cargo_contract_id');
					}
					if (Schema::hasColumn('cargo_stocks','cargo_loading_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_stocks WHERE key_name='cargo_stocks_cargo_loading_id_index'"))) {
						$table->index('cargo_loading_id');
					} 

					if (Schema::hasColumn('cargo_stocks','date_in') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_stocks WHERE key_name='cargo_stocks_date_in_index'"))) {
						$table->index('date_in');
					} 
					if (Schema::hasColumn('cargo_stocks','quantity') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_stocks WHERE key_name='cargo_stocks_quantity_index'"))) {
						$table->index('quantity');
					}if (Schema::hasColumn('cargo_stocks','price') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_stocks WHERE key_name='cargo_stocks_price_index'"))) {
						$table->index('price');
					} 

					if (Schema::hasColumn('cargo_stocks','site_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_stocks WHERE key_name='cargo_stocks_site_id_index'"))) {
						$table->index('site_id');
					} 
					if (Schema::hasColumn('cargo_stocks','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_stocks WHERE key_name='cargo_stocks_company_id_index'"))) {
						$table->index('company_id');
					}


					if (Schema::hasColumn('cargo_stocks','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_stocks WHERE key_name='cargo_stocks_user_id_index'"))) {
						$table->index('user_id');
					} 

					if (Schema::hasColumn('cargo_stocks','cargo_discharge_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_stocks WHERE key_name='cargo_stocks_cargo_discharge_id_index'"))) {
						$table->index('cargo_discharge_id');
					} 
				});
			}







			// add indexs to cargo_stock_outs
			if(Schema::hasTable('cargo_stock_outs')) {
				Schema::table('cargo_stock_outs', function (Blueprint $table) {
					if (Schema::hasColumn('cargo_stock_outs','cargo_item_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_stock_outs WHERE key_name='cargo_stock_outs_cargo_item_id_index'"))) {
						$table->index('cargo_item_id');
					} 
					if (Schema::hasColumn('cargo_stock_outs','cargo_contract_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_stock_outs WHERE key_name='cargo_stock_outs_cargo_contract_id_index'"))) {
						$table->index('cargo_contract_id');
					}
					if (Schema::hasColumn('cargo_stock_outs','cargo_loading_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_stock_outs WHERE key_name='cargo_stock_outs_cargo_loading_id_index'"))) {
						$table->index('cargo_loading_id');
					} 

					if (Schema::hasColumn('cargo_stock_outs','stock_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_stock_outs WHERE key_name='cargo_stock_outs_stock_id_index'"))) {
						$table->index('stock_id');
					} 
					if (Schema::hasColumn('cargo_stock_outs','price') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_stock_outs WHERE key_name='cargo_stock_outs_price_index'"))) {
						$table->index('price');
					}

					if (Schema::hasColumn('cargo_stock_outs','site_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_stock_outs WHERE key_name='cargo_stock_outs_site_id_index'"))) {
						$table->index('site_id');
					} 

					if (Schema::hasColumn('cargo_stock_outs','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_stock_outs WHERE key_name='cargo_stock_outs_company_id_index'"))) {
						$table->index('company_id');
					} 
					if (Schema::hasColumn('cargo_stock_outs','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_stock_outs WHERE key_name='cargo_stock_outs_user_id_index'"))) {
						$table->index('user_id');
					}

					if (Schema::hasColumn('cargo_stock_outs','cargo_delivery_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_stock_outs WHERE key_name='cargo_stock_outs_cargo_delivery_id_index'"))) {
						$table->index('cargo_delivery_id');
					} 

					if (Schema::hasColumn('cargo_stock_outs','cargo_wastage_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_stock_outs WHERE key_name='cargo_stock_outs_cargo_wastage_id_index'"))) {
						$table->index('cargo_wastage_id');
					} 
				});
			}	


			// add indexs to cargo_wastages
			if(Schema::hasTable('cargo_wastages')) {
				Schema::table('cargo_wastages', function (Blueprint $table) {
					if (Schema::hasColumn('cargo_wastages','number') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_wastages WHERE key_name='cargo_wastages_number_index'"))) {
						$table->index('number');
					} 
					if (Schema::hasColumn('cargo_wastages','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_wastages WHERE key_name='cargo_wastages_member_id_index'"))) {
						$table->index('member_id');
					}
					if (Schema::hasColumn('cargo_wastages','payable_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_wastages WHERE key_name='cargo_wastages_payable_transaction_id_index'"))) {
						$table->index('payable_transaction_id');
					} 

					if (Schema::hasColumn('cargo_wastages','date') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_wastages WHERE key_name='cargo_wastages_date_index'"))) {
						$table->index('date');
					} 
					if (Schema::hasColumn('cargo_wastages','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_wastages WHERE key_name='cargo_wastages_company_id_index'"))) {
						$table->index('company_id');
					}

					if (Schema::hasColumn('cargo_wastages','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_wastages WHERE key_name='cargo_wastages_user_id_index'"))) {
						$table->index('user_id');
					} 
				});
			}	



			// add indexs to cargo_wastage_details
			if(Schema::hasTable('cargo_wastage_details')) {
				Schema::table('cargo_wastage_details', function (Blueprint $table) {
					if (Schema::hasColumn('cargo_wastage_details','cargo_wastage_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_wastage_details WHERE key_name='cargo_wastage_details_cargo_wastage_id_index'"))) {
						$table->index('cargo_wastage_id');
					} 
					if (Schema::hasColumn('cargo_wastage_details','cargo_loading_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_wastage_details WHERE key_name='cargo_wastage_details_cargo_loading_id_index'"))) {
						$table->index('cargo_loading_id');
					}
					if (Schema::hasColumn('cargo_wastage_details','cargo_contract_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_wastage_details WHERE key_name='cargo_wastage_details_cargo_contract_id_index'"))) {
						$table->index('cargo_contract_id');
					} 

					if (Schema::hasColumn('cargo_wastage_details','driver_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_wastage_details WHERE key_name='cargo_wastage_details_driver_id_index'"))) {
						$table->index('driver_id');
					} 
					if (Schema::hasColumn('cargo_wastage_details','vehicle_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_wastage_details WHERE key_name='cargo_wastage_details_vehicle_id_index'"))) {
						$table->index('vehicle_id');
					}

					if (Schema::hasColumn('cargo_wastage_details','container_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_wastage_details WHERE key_name='cargo_wastage_details_container_id_index'"))) {
						$table->index('container_id');
					} 


					if (Schema::hasColumn('cargo_wastage_details','cargo_item_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_wastage_details WHERE key_name='cargo_wastage_details_cargo_item_id_index'"))) {
						$table->index('cargo_item_id');
					} 
					if (Schema::hasColumn('cargo_wastage_details','site_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_wastage_details WHERE key_name='cargo_wastage_details_site_id_index'"))) {
						$table->index('site_id');
					}

					if (Schema::hasColumn('cargo_wastage_details','quantity') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_wastage_details WHERE key_name='cargo_wastage_details_quantity_index'"))) {
						$table->index('quantity');
					} 

					if (Schema::hasColumn('cargo_wastage_details','price') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_wastage_details WHERE key_name='cargo_wastage_details_price_index'"))) {
						$table->index('price');
					} 
					if (Schema::hasColumn('cargo_wastage_details','expense_tran_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_wastage_details WHERE key_name='cargo_wastage_details_expense_tran_id_index'"))) {
						$table->index('expense_tran_id');
					}

					if (Schema::hasColumn('cargo_wastage_details','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_wastage_details WHERE key_name='cargo_wastage_details_company_id_index'"))) {
						$table->index('company_id');
					}
				});
			}




				// add indexs to carpet_contracts
				if(Schema::hasTable('carpet_contracts')) {
					Schema::table('carpet_contracts', function (Blueprint $table) {
						if (Schema::hasColumn('carpet_contracts','number') && !DB::select(DB::raw("SHOW INDEXES FROM carpet_contracts WHERE key_name='carpet_contracts_number_index'"))) {
							$table->index('number');
						} 
						if (Schema::hasColumn('carpet_contracts','ref_no') && !DB::select(DB::raw("SHOW INDEXES FROM carpet_contracts WHERE key_name='carpet_contracts_ref_no_index'"))) {
							$table->index('ref_no');
						}
						if (Schema::hasColumn('carpet_contracts','customer_id') && !DB::select(DB::raw("SHOW INDEXES FROM carpet_contracts WHERE key_name='carpet_contracts_customer_id_index'"))) {
							$table->index('customer_id');
						} 
	
						if (Schema::hasColumn('carpet_contracts','graph_number') && !DB::select(DB::raw("SHOW INDEXES FROM carpet_contracts WHERE key_name='carpet_contracts_graph_number_index'"))) {
							$table->index('graph_number');
						} 
						if (Schema::hasColumn('carpet_contracts','quality') && !DB::select(DB::raw("SHOW INDEXES FROM carpet_contracts WHERE key_name='carpet_contracts_quality_index'"))) {
							$table->index('quality');
						}
	
						if (Schema::hasColumn('carpet_contracts','currency') && !DB::select(DB::raw("SHOW INDEXES FROM carpet_contracts WHERE key_name='carpet_contracts_currency_index'"))) {
							$table->index('currency');
						} 
	
	
						if (Schema::hasColumn('carpet_contracts','date') && !DB::select(DB::raw("SHOW INDEXES FROM carpet_contracts WHERE key_name='carpet_contracts_date_index'"))) {
							$table->index('date');
						} 
						if (Schema::hasColumn('carpet_contracts','start_date') && !DB::select(DB::raw("SHOW INDEXES FROM carpet_contracts WHERE key_name='carpet_contracts_start_date_index'"))) {
							$table->index('start_date');
						}
	
						if (Schema::hasColumn('carpet_contracts','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM carpet_contracts WHERE key_name='carpet_contracts_company_id_index'"))) {
							$table->index('company_id');
						} 
	
						if (Schema::hasColumn('carpet_contracts','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM carpet_contracts WHERE key_name='carpet_contracts_user_id_index'"))) {
							$table->index('user_id');
						} 
					});
				}
	





				// add indexs to carpet_contract_details
				if(Schema::hasTable('carpet_contract_details')) {
					Schema::table('carpet_contract_details', function (Blueprint $table) {
						if (Schema::hasColumn('carpet_contract_details','carpet_contract_id') && !DB::select(DB::raw("SHOW INDEXES FROM carpet_contract_details WHERE key_name='carpet_contract_details_carpet_contract_id_index'"))) {
							$table->index('carpet_contract_id');
						} 
						if (Schema::hasColumn('carpet_contract_details','inventory_id') && !DB::select(DB::raw("SHOW INDEXES FROM carpet_contract_details WHERE key_name='carpet_contract_details_inventory_id_index'"))) {
							$table->index('inventory_id');
						}
						if (Schema::hasColumn('carpet_contract_details','site_id') && !DB::select(DB::raw("SHOW INDEXES FROM carpet_contract_details WHERE key_name='carpet_contract_details_site_id_index'"))) {
							$table->index('site_id');
						} 
	
						if (Schema::hasColumn('carpet_contract_details','quantity') && !DB::select(DB::raw("SHOW INDEXES FROM carpet_contract_details WHERE key_name='carpet_contract_details_quantity_index'"))) {
							$table->index('quantity');
						} 
						if (Schema::hasColumn('carpet_contract_details','quality') && !DB::select(DB::raw("SHOW INDEXES FROM carpet_contract_details WHERE key_name='carpet_contract_details_quality_index'"))) {
							$table->index('quality');
						}
	
						if (Schema::hasColumn('carpet_contract_details','um_id') && !DB::select(DB::raw("SHOW INDEXES FROM carpet_contract_details WHERE key_name='carpet_contract_details_um_id_index'"))) {
							$table->index('um_id');
						} 
	
	
						if (Schema::hasColumn('carpet_contract_details','um1_id') && !DB::select(DB::raw("SHOW INDEXES FROM carpet_contract_details WHERE key_name='carpet_contract_details_um1_id_index'"))) {
							$table->index('um1_id');
						} 
						if (Schema::hasColumn('carpet_contract_details','um2_id') && !DB::select(DB::raw("SHOW INDEXES FROM carpet_contract_details WHERE key_name='carpet_contract_details_um2_id_index'"))) {
							$table->index('um2_id');
						}
	
						if (Schema::hasColumn('carpet_contract_details','um3_id') && !DB::select(DB::raw("SHOW INDEXES FROM carpet_contract_details WHERE key_name='carpet_contract_details_um3_id_index'"))) {
							$table->index('um3_id');
						} 
	
						if (Schema::hasColumn('carpet_contract_details','other_measure1') && !DB::select(DB::raw("SHOW INDEXES FROM carpet_contract_details WHERE key_name='carpet_contract_details_other_measure1_index'"))) {
							$table->index('other_measure1');
						} 

						if (Schema::hasColumn('carpet_contract_details','other_measure2') && !DB::select(DB::raw("SHOW INDEXES FROM carpet_contract_details WHERE key_name='carpet_contract_details_other_measure2_index'"))) {
							$table->index('other_measure2');
						}
	
						if (Schema::hasColumn('carpet_contract_details','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM carpet_contract_details WHERE key_name='carpet_contract_details_company_id_index'"))) {
							$table->index('company_id');
						} 
	
						if (Schema::hasColumn('carpet_contract_details','stock_id') && !DB::select(DB::raw("SHOW INDEXES FROM carpet_contract_details WHERE key_name='carpet_contract_details_stock_id_index'"))) {
							$table->index('stock_id');
						} 
					});
				}



				// add indexs to certificates
				if(Schema::hasTable('certificates')) {
					Schema::table('certificates', function (Blueprint $table) {
						if (Schema::hasColumn('certificates','emp_no') && !DB::select(DB::raw("SHOW INDEXES FROM certificates WHERE key_name='certificates_emp_no_index'"))) {
							$table->index('emp_no');
						} 
						if (Schema::hasColumn('certificates','print_no') && !DB::select(DB::raw("SHOW INDEXES FROM certificates WHERE key_name='certificates_print_no_index'"))) {
							$table->index('print_no');
						}
						if (Schema::hasColumn('certificates','group_list') && !DB::select(DB::raw("SHOW INDEXES FROM certificates WHERE key_name='certificates_group_list_index'"))) {
							$table->index('group_list');
						} 
	
						if (Schema::hasColumn('certificates','category') && !DB::select(DB::raw("SHOW INDEXES FROM certificates WHERE key_name='certificates_category_index'"))) {
							$table->index('category');
						}   
					});
				}




				// add indexs to commissions
				if(Schema::hasTable('commissions')) {
					Schema::table('commissions', function (Blueprint $table) {
						if (Schema::hasColumn('commissions','name') && !DB::select(DB::raw("SHOW INDEXES FROM commissions WHERE key_name='commissions_name_index'"))) {
							$table->index('name');
						} 
						if (Schema::hasColumn('commissions','percent') && !DB::select(DB::raw("SHOW INDEXES FROM commissions WHERE key_name='commissions_percent_index'"))) {
							$table->index('percent');
						}
						if (Schema::hasColumn('commissions','date') && !DB::select(DB::raw("SHOW INDEXES FROM commissions WHERE key_name='commissions_date_index'"))) {
							$table->index('date');
						} 
	
						if (Schema::hasColumn('commissions','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM commissions WHERE key_name='commissions_member_id_index'"))) {
							$table->index('member_id');
						}  
						
						if (Schema::hasColumn('commissions','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM commissions WHERE key_name='commissions_company_id_index'"))) {
							$table->index('company_id');
						}
						if (Schema::hasColumn('commissions','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM commissions WHERE key_name='commissions_user_id_index'"))) {
							$table->index('user_id');
						} 
	
						if (Schema::hasColumn('commissions','expense_id') && !DB::select(DB::raw("SHOW INDEXES FROM commissions WHERE key_name='commissions_expense_id_index'"))) {
							$table->index('expense_id');
						} 
					});
				}





				// add indexs to contract_closes
				if(Schema::hasTable('contract_closes')) {
					Schema::table('contract_closes', function (Blueprint $table) {
						if (Schema::hasColumn('contract_closes','contract_id') && !DB::select(DB::raw("SHOW INDEXES FROM contract_closes WHERE key_name='contract_closes_contract_id_index'"))) {
							$table->index('contract_id');
						} 
						if (Schema::hasColumn('contract_closes','income_id') && !DB::select(DB::raw("SHOW INDEXES FROM contract_closes WHERE key_name='contract_closes_income_id_index'"))) {
							$table->index('income_id');
						}
						if (Schema::hasColumn('contract_closes','expense_id') && !DB::select(DB::raw("SHOW INDEXES FROM contract_closes WHERE key_name='contract_closes_expense_id_index'"))) {
							$table->index('expense_id');
						} 
	
						if (Schema::hasColumn('contract_closes','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM contract_closes WHERE key_name='contract_closes_member_id_index'"))) {
							$table->index('member_id');
						}  
						
						if (Schema::hasColumn('contract_closes','owner_id') && !DB::select(DB::raw("SHOW INDEXES FROM contract_closes WHERE key_name='contract_closes_owner_id_index'"))) {
							$table->index('owner_id');
						}
						if (Schema::hasColumn('contract_closes','date') && !DB::select(DB::raw("SHOW INDEXES FROM contract_closes WHERE key_name='contract_closes_date_index'"))) {
							$table->index('date');
						}
					});
				}


				// add indexs to contract_close_details
				if(Schema::hasTable('contract_close_details')) {
					Schema::table('contract_close_details', function (Blueprint $table) {
						if (Schema::hasColumn('contract_close_details','contract_close_id') && !DB::select(DB::raw("SHOW INDEXES FROM contract_close_details WHERE key_name='contract_close_details_contract_close_id_index'"))) {
							$table->index('contract_close_id');
						} 
						if (Schema::hasColumn('contract_close_details','shareholder_id') && !DB::select(DB::raw("SHOW INDEXES FROM contract_close_details WHERE key_name='contract_close_details_shareholder_id_index'"))) {
							$table->index('shareholder_id');
						}
						if (Schema::hasColumn('contract_close_details','income_transection_id') && !DB::select(DB::raw("SHOW INDEXES FROM contract_close_details WHERE key_name='contract_close_details_income_transection_id_index'"))) {
							$table->index('income_transection_id');
						} 

						if (Schema::hasColumn('contract_close_details','expense_transection_id') && !DB::select(DB::raw("SHOW INDEXES FROM contract_close_details WHERE key_name='contract_close_details_expense_transection_id_index'"))) {
							$table->index('expense_transection_id');
						}  
						
						if (Schema::hasColumn('contract_close_details','shareholder_transection_id') && !DB::select(DB::raw("SHOW INDEXES FROM contract_close_details WHERE key_name='contract_close_details_shareholder_transection_id_index'"))) {
							$table->index('shareholder_transection_id');
						} 
					});
				}




				// add indexs to contract_expense_purchases
				if(Schema::hasTable('contract_expense_purchases')) {
					Schema::table('contract_expense_purchases', function (Blueprint $table) {
						if (Schema::hasColumn('contract_expense_purchases','purchase_id') && !DB::select(DB::raw("SHOW INDEXES FROM contract_expense_purchases WHERE key_name='contract_expense_purchases_purchase_id_index'"))) {
							$table->index('purchase_id');
						} 
						if (Schema::hasColumn('contract_expense_purchases','expense_id') && !DB::select(DB::raw("SHOW INDEXES FROM contract_expense_purchases WHERE key_name='contract_expense_purchases_expense_id_index'"))) {
							$table->index('expense_id');
						}
						if (Schema::hasColumn('contract_expense_purchases','contract_id') && !DB::select(DB::raw("SHOW INDEXES FROM contract_expense_purchases WHERE key_name='contract_expense_purchases_contract_id_index'"))) {
							$table->index('contract_id');
						} 

						if (Schema::hasColumn('contract_expense_purchases','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM contract_expense_purchases WHERE key_name='contract_expense_purchases_company_id_index'"))) {
							$table->index('company_id');
						}  
					});
				}





				// add indexs to contract_farmer
				if(Schema::hasTable('contract_farmer')) {
					Schema::table('contract_farmer', function (Blueprint $table) {
						if (Schema::hasColumn('contract_farmer','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM contract_farmer WHERE key_name='contract_farmer_member_id_index'"))) {
							$table->index('member_id');
						} 
						if (Schema::hasColumn('contract_farmer','number') && !DB::select(DB::raw("SHOW INDEXES FROM contract_farmer WHERE key_name='contract_farmer_number_index'"))) {
							$table->index('number');
						}
						if (Schema::hasColumn('contract_farmer','currency') && !DB::select(DB::raw("SHOW INDEXES FROM contract_farmer WHERE key_name='contract_farmer_currency_index'"))) {
							$table->index('currency');
						} 

						if (Schema::hasColumn('contract_farmer','status') && !DB::select(DB::raw("SHOW INDEXES FROM contract_farmer WHERE key_name='contract_farmer_status_index'"))) {
							$table->index('status');
						}  


						if (Schema::hasColumn('contract_farmer','measure_id') && !DB::select(DB::raw("SHOW INDEXES FROM contract_farmer WHERE key_name='contract_farmer_measure_id_index'"))) {
							$table->index('measure_id');
						} 

						if (Schema::hasColumn('contract_farmer','sale_id') && !DB::select(DB::raw("SHOW INDEXES FROM contract_farmer WHERE key_name='contract_farmer_sale_id_index'"))) {
							$table->index('sale_id');
						} 

						if (Schema::hasColumn('contract_farmer','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM contract_farmer WHERE key_name='contract_farmer_user_id_index'"))) {
							$table->index('user_id');
						} 

						if (Schema::hasColumn('contract_farmer','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM contract_farmer WHERE key_name='contract_farmer_company_id_index'"))) {
							$table->index('company_id');
						} 
					});
				}




			// add indexs to contract_farmer_details
			if(Schema::hasTable('contract_farmer_details')) {
				Schema::table('contract_farmer_details', function (Blueprint $table) {
					if (Schema::hasColumn('contract_farmer_details','contract_farmer_id') && !DB::select(DB::raw("SHOW INDEXES FROM contract_farmer_details WHERE key_name='contract_farmer_details_contract_farmer_id_index'"))) {
						$table->index('contract_farmer_id');
					} 
					if (Schema::hasColumn('contract_farmer_details','type') && !DB::select(DB::raw("SHOW INDEXES FROM contract_farmer_details WHERE key_name='contract_farmer_details_type_index'"))) {
						$table->index('type');
					}
					if (Schema::hasColumn('contract_farmer_details','number') && !DB::select(DB::raw("SHOW INDEXES FROM contract_farmer_details WHERE key_name='contract_farmer_details_number_index'"))) {
						$table->index('number');
					} 

					if (Schema::hasColumn('contract_farmer_details','ref_no') && !DB::select(DB::raw("SHOW INDEXES FROM contract_farmer_details WHERE key_name='contract_farmer_details_ref_no_index'"))) {
						$table->index('ref_no');
					}  


					if (Schema::hasColumn('contract_farmer_details','date') && !DB::select(DB::raw("SHOW INDEXES FROM contract_farmer_details WHERE key_name='contract_farmer_details_date_index'"))) {
						$table->index('date');
					} 

					if (Schema::hasColumn('contract_farmer_details','currency') && !DB::select(DB::raw("SHOW INDEXES FROM contract_farmer_details WHERE key_name='contract_farmer_details_currency_index'"))) {
						$table->index('currency');
					} 

					if (Schema::hasColumn('contract_farmer_details','inventory_id') && !DB::select(DB::raw("SHOW INDEXES FROM contract_farmer_details WHERE key_name='contract_farmer_details_inventory_id_index'"))) {
						$table->index('inventory_id');
					} 

					if (Schema::hasColumn('contract_farmer_details','measure_id') && !DB::select(DB::raw("SHOW INDEXES FROM contract_farmer_details WHERE key_name='contract_farmer_details_measure_id_index'"))) {
						$table->index('measure_id');
					} 


					if (Schema::hasColumn('contract_farmer_details','purchase_id') && !DB::select(DB::raw("SHOW INDEXES FROM contract_farmer_details WHERE key_name='contract_farmer_details_purchase_id_index'"))) {
						$table->index('purchase_id');
					} 

					if (Schema::hasColumn('contract_farmer_details','purchase_info_id') && !DB::select(DB::raw("SHOW INDEXES FROM contract_farmer_details WHERE key_name='contract_farmer_details_purchase_info_id_index'"))) {
						$table->index('purchase_info_id');
					} 

					if (Schema::hasColumn('contract_farmer_details','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM contract_farmer_details WHERE key_name='contract_farmer_details_user_id_index'"))) {
						$table->index('user_id');
					} 

					if (Schema::hasColumn('contract_farmer_details','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM contract_farmer_details WHERE key_name='contract_farmer_details_company_id_index'"))) {
						$table->index('company_id');
					} 
				});
			}






			// add indexs to contract_loading_dates
			if(Schema::hasTable('contract_loading_dates')) {
				Schema::table('contract_loading_dates', function (Blueprint $table) {
					if (Schema::hasColumn('contract_loading_dates','number') && !DB::select(DB::raw("SHOW INDEXES FROM contract_loading_dates WHERE key_name='contract_loading_dates_number_index'"))) {
						$table->index('number');
					} 
					if (Schema::hasColumn('contract_loading_dates','date') && !DB::select(DB::raw("SHOW INDEXES FROM contract_loading_dates WHERE key_name='contract_loading_dates_date_index'"))) {
						$table->index('date');
					}
					if (Schema::hasColumn('contract_loading_dates','contract_id') && !DB::select(DB::raw("SHOW INDEXES FROM contract_loading_dates WHERE key_name='contract_loading_dates_contract_id_index'"))) {
						$table->index('contract_id');
					} 

					if (Schema::hasColumn('contract_loading_dates','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM contract_loading_dates WHERE key_name='contract_loading_dates_user_id_index'"))) {
						$table->index('user_id');
					} if (Schema::hasColumn('contract_loading_dates','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM contract_loading_dates WHERE key_name='contract_loading_dates_company_id_index'"))) {
						$table->index('company_id');
					} 
				});
			}
			



			
			// add indexs to contract_loading_dates
			if(Schema::hasTable('contract_loading_dates')) {
				Schema::table('contract_loading_dates', function (Blueprint $table) {
					if (Schema::hasColumn('contract_loading_dates','number') && !DB::select(DB::raw("SHOW INDEXES FROM contract_loading_dates WHERE key_name='contract_loading_dates_number_index'"))) {
						$table->index('number');
					} 
					if (Schema::hasColumn('contract_loading_dates','date') && !DB::select(DB::raw("SHOW INDEXES FROM contract_loading_dates WHERE key_name='contract_loading_dates_date_index'"))) {
						$table->index('date');
					}
					if (Schema::hasColumn('contract_loading_dates','contract_id') && !DB::select(DB::raw("SHOW INDEXES FROM contract_loading_dates WHERE key_name='contract_loading_dates_contract_id_index'"))) {
						$table->index('contract_id');
					} 

					if (Schema::hasColumn('contract_loading_dates','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM contract_loading_dates WHERE key_name='contract_loading_dates_user_id_index'"))) {
						$table->index('user_id');
					} if (Schema::hasColumn('contract_loading_dates','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM contract_loading_dates WHERE key_name='contract_loading_dates_company_id_index'"))) {
						$table->index('company_id');
					} 
				});
			}
			


			// add indexs to contract_shareholders
			if(Schema::hasTable('contract_shareholders')) {
				Schema::table('contract_shareholders', function (Blueprint $table) {
					if (Schema::hasColumn('contract_shareholders','contract_id') && !DB::select(DB::raw("SHOW INDEXES FROM contract_shareholders WHERE key_name='contract_shareholders_contract_id_index'"))) {
						$table->index('contract_id');
					} 
					if (Schema::hasColumn('contract_shareholders','shareholder_id') && !DB::select(DB::raw("SHOW INDEXES FROM contract_shareholders WHERE key_name='contract_shareholders_shareholder_id_index'"))) {
						$table->index('shareholder_id');
					}if (Schema::hasColumn('contract_shareholders','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM contract_shareholders WHERE key_name='contract_shareholders_company_id_index'"))) {
						$table->index('company_id');
					} 
				});
			}



			// add indexs to costs
			if(Schema::hasTable('costs')) {
				Schema::table('costs', function (Blueprint $table) {
					if (Schema::hasColumn('costs','item_id') && !DB::select(DB::raw("SHOW INDEXES FROM costs WHERE key_name='costs_item_id_index'"))) {
						$table->index('item_id');
					} 
					if (Schema::hasColumn('costs','account_id') && !DB::select(DB::raw("SHOW INDEXES FROM costs WHERE key_name='costs_account_id_index'"))) {
						$table->index('account_id');
					}
					if (Schema::hasColumn('costs','amount') && !DB::select(DB::raw("SHOW INDEXES FROM costs WHERE key_name='costs_amount_index'"))) {
						$table->index('amount');
					} if (Schema::hasColumn('costs','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM costs WHERE key_name='costs_company_id_index'"))) {
						$table->index('company_id');
					} 
				});
			}



			// add indexs to cost_for_customers
			if(Schema::hasTable('cost_for_customers')) {
				Schema::table('cost_for_customers', function (Blueprint $table) {
					if (Schema::hasColumn('cost_for_customers','item_id') && !DB::select(DB::raw("SHOW INDEXES FROM cost_for_customers WHERE key_name='cost_for_customers_item_id_index'"))) {
						$table->index('item_id');
					} 
					if (Schema::hasColumn('cost_for_customers','account_id') && !DB::select(DB::raw("SHOW INDEXES FROM cost_for_customers WHERE key_name='cost_for_customers_account_id_index'"))) {
						$table->index('account_id');
					}
					if (Schema::hasColumn('cost_for_customers','amount') && !DB::select(DB::raw("SHOW INDEXES FROM cost_for_customers WHERE key_name='cost_for_customers_amount_index'"))) {
						$table->index('amount');
					} if (Schema::hasColumn('cost_for_customers','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM cost_for_customers WHERE key_name='cost_for_customers_company_id_index'"))) {
						$table->index('company_id');
					} if (Schema::hasColumn('cost_for_customers','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM cost_for_customers WHERE key_name='cost_for_customers_member_id_index'"))) {
						$table->index('member_id');
					}
				});
			}


			
			// add indexs to customer_delivery_item_details
				if(Schema::hasTable('customer_delivery_item_details')) {
					Schema::table('customer_delivery_item_details', function (Blueprint $table) {
						if (Schema::hasColumn('customer_delivery_item_details','cus_delivery_item_id') && !DB::select(DB::raw("SHOW INDEXES FROM customer_delivery_item_details WHERE key_name='customer_delivery_item_details_cus_delivery_item_id_index'"))) {
							$table->index('cus_delivery_item_id');
						} 
						if (Schema::hasColumn('customer_delivery_item_details','inventory_id') && !DB::select(DB::raw("SHOW INDEXES FROM customer_delivery_item_details WHERE key_name='customer_delivery_item_details_inventory_id_index'"))) {
							$table->index('inventory_id');
						}
						if (Schema::hasColumn('customer_delivery_item_details','site_id') && !DB::select(DB::raw("SHOW INDEXES FROM customer_delivery_item_details WHERE key_name='customer_delivery_item_details_site_id_index'"))) {
							$table->index('site_id');
						} if (Schema::hasColumn('customer_delivery_item_details','um_id') && !DB::select(DB::raw("SHOW INDEXES FROM customer_delivery_item_details WHERE key_name='customer_delivery_item_details_um_id_index'"))) {
							$table->index('um_id');
						} if (Schema::hasColumn('customer_delivery_item_details','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM customer_delivery_item_details WHERE key_name='customer_delivery_item_details_company_id_index'"))) {
							$table->index('company_id');
						}
					});
				}


				// add indexs to customer_openings
				if(Schema::hasTable('customer_openings')) {
					Schema::table('customer_openings', function (Blueprint $table) {
						if (Schema::hasColumn('customer_openings','customer_id') && !DB::select(DB::raw("SHOW INDEXES FROM customer_openings WHERE key_name='customer_openings_customer_id_index'"))) {
							$table->index('customer_id');
						} 
						if (Schema::hasColumn('customer_openings','inventory_id') && !DB::select(DB::raw("SHOW INDEXES FROM customer_openings WHERE key_name='customer_openings_inventory_id_index'"))) {
							$table->index('inventory_id');
						}
						if (Schema::hasColumn('customer_openings','site_id') && !DB::select(DB::raw("SHOW INDEXES FROM customer_openings WHERE key_name='customer_openings_site_id_index'"))) {
							$table->index('site_id');
						} if (Schema::hasColumn('customer_openings','quantity') && !DB::select(DB::raw("SHOW INDEXES FROM customer_openings WHERE key_name='customer_openings_quantity_index'"))) {
							$table->index('quantity');
						} if (Schema::hasColumn('customer_openings','um_id') && !DB::select(DB::raw("SHOW INDEXES FROM customer_openings WHERE key_name='customer_openings_um_id_index'"))) {
							$table->index('um_id');
						}
						if (Schema::hasColumn('customer_openings','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM customer_openings WHERE key_name='customer_openings_company_id_index'"))) {
							$table->index('company_id');
						} if (Schema::hasColumn('customer_openings','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM customer_openings WHERE key_name='customer_openings_user_id_index'"))) {
							$table->index('user_id');
						}
					});
				}




				// add indexs to customer_stocks
				if(Schema::hasTable('customer_stocks')) {
					Schema::table('customer_stocks', function (Blueprint $table) {
						if (Schema::hasColumn('customer_stocks','inventory_id') && !DB::select(DB::raw("SHOW INDEXES FROM customer_stocks WHERE key_name='customer_stocks_inventory_id_index'"))) {
							$table->index('inventory_id');
						} 
						if (Schema::hasColumn('customer_stocks','site_id') && !DB::select(DB::raw("SHOW INDEXES FROM customer_stocks WHERE key_name='customer_stocks_site_id_index'"))) {
							$table->index('site_id');
						}
						if (Schema::hasColumn('customer_stocks','customer_id') && !DB::select(DB::raw("SHOW INDEXES FROM customer_stocks WHERE key_name='customer_stocks_customer_id_index'"))) {
							$table->index('customer_id');
						} if (Schema::hasColumn('customer_stocks','type') && !DB::select(DB::raw("SHOW INDEXES FROM customer_stocks WHERE key_name='customer_stocks_type_index'"))) {
							$table->index('type');
						} if (Schema::hasColumn('customer_stocks','um_id') && !DB::select(DB::raw("SHOW INDEXES FROM customer_stocks WHERE key_name='customer_stocks_um_id_index'"))) {
							$table->index('um_id');
						}
						if (Schema::hasColumn('customer_stocks','type_id') && !DB::select(DB::raw("SHOW INDEXES FROM customer_stocks WHERE key_name='customer_stocks_type_id_index'"))) {
							$table->index('type_id');
						} if (Schema::hasColumn('customer_stocks','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM customer_stocks WHERE key_name='customer_stocks_user_id_index'"))) {
							$table->index('user_id');
						}if (Schema::hasColumn('customer_stocks','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM customer_stocks WHERE key_name='customer_stocks_company_id_index'"))) {
							$table->index('company_id');
						}
					});
				}


				// add indexs to customer_stock_outs
				if(Schema::hasTable('customer_stock_outs')) {
					Schema::table('customer_stock_outs', function (Blueprint $table) {
						if (Schema::hasColumn('customer_stock_outs','inventory_id') && !DB::select(DB::raw("SHOW INDEXES FROM customer_stock_outs WHERE key_name='customer_stock_outs_inventory_id_index'"))) {
							$table->index('inventory_id');
						} 
						if (Schema::hasColumn('customer_stock_outs','site_id') && !DB::select(DB::raw("SHOW INDEXES FROM customer_stock_outs WHERE key_name='customer_stock_outs_site_id_index'"))) {
							$table->index('site_id');
						}
						if (Schema::hasColumn('customer_stock_outs','stock_id') && !DB::select(DB::raw("SHOW INDEXES FROM customer_stock_outs WHERE key_name='customer_stock_outs_stock_id_index'"))) {
							$table->index('stock_id');
						} if (Schema::hasColumn('customer_stock_outs','um_id') && !DB::select(DB::raw("SHOW INDEXES FROM customer_stock_outs WHERE key_name='customer_stock_outs_um_id_index'"))) {
							$table->index('um_id');
						} if (Schema::hasColumn('customer_stock_outs','customer_id') && !DB::select(DB::raw("SHOW INDEXES FROM customer_stock_outs WHERE key_name='customer_stock_outs_customer_id_index'"))) {
							$table->index('customer_id');
						}
						if (Schema::hasColumn('customer_stock_outs','type_id') && !DB::select(DB::raw("SHOW INDEXES FROM customer_stock_outs WHERE key_name='customer_stock_outs_type_id_index'"))) {
							$table->index('type_id');
						} if (Schema::hasColumn('customer_stock_outs','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM customer_stock_outs WHERE key_name='customer_stock_outs_user_id_index'"))) {
							$table->index('user_id');
						}if (Schema::hasColumn('customer_stock_outs','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM customer_stock_outs WHERE key_name='customer_stock_outs_company_id_index'"))) {
							$table->index('company_id');
						}
					});
				}





				// add indexs to customer_transfer_items
				if(Schema::hasTable('customer_transfer_items')) {
					Schema::table('customer_transfer_items', function (Blueprint $table) {
						if (Schema::hasColumn('customer_transfer_items','number') && !DB::select(DB::raw("SHOW INDEXES FROM customer_transfer_items WHERE key_name='customer_transfer_items_number_index'"))) {
							$table->index('number');
						} 
						if (Schema::hasColumn('customer_transfer_items','ref_no') && !DB::select(DB::raw("SHOW INDEXES FROM customer_transfer_items WHERE key_name='customer_transfer_items_ref_no_index'"))) {
							$table->index('ref_no');
						}
						if (Schema::hasColumn('customer_transfer_items','from_customer_id') && !DB::select(DB::raw("SHOW INDEXES FROM customer_transfer_items WHERE key_name='customer_transfer_items_from_customer_id_index'"))) {
							$table->index('from_customer_id');
						} if (Schema::hasColumn('customer_transfer_items','to_customer_id') && !DB::select(DB::raw("SHOW INDEXES FROM customer_transfer_items WHERE key_name='customer_transfer_items_to_customer_id_index'"))) {
							$table->index('to_customer_id');
						} if (Schema::hasColumn('customer_transfer_items','customer_id') && !DB::select(DB::raw("SHOW INDEXES FROM customer_transfer_items WHERE key_name='customer_transfer_items_customer_id_index'"))) {
							$table->index('customer_id');
						}
						if (Schema::hasColumn('customer_transfer_items','date') && !DB::select(DB::raw("SHOW INDEXES FROM customer_transfer_items WHERE key_name='customer_transfer_items_date_index'"))) {
							$table->index('date');
						} if (Schema::hasColumn('customer_transfer_items','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM customer_transfer_items WHERE key_name='customer_transfer_items_user_id_index'"))) {
							$table->index('user_id');
						}if (Schema::hasColumn('customer_transfer_items','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM customer_transfer_items WHERE key_name='customer_transfer_items_company_id_index'"))) {
							$table->index('company_id');
						}
					});
				}





				// add indexs to customer_transfer_item_details
				if(Schema::hasTable('customer_transfer_item_details')) {
					Schema::table('customer_transfer_item_details', function (Blueprint $table) {
						if (Schema::hasColumn('customer_transfer_item_details','cus_transfer_item_id') && !DB::select(DB::raw("SHOW INDEXES FROM customer_transfer_item_details WHERE key_name='customer_transfer_item_details_cus_transfer_item_id_index'"))) {
							$table->index('cus_transfer_item_id');
						} 
						if (Schema::hasColumn('customer_transfer_item_details','inventory_id') && !DB::select(DB::raw("SHOW INDEXES FROM customer_transfer_item_details WHERE key_name='customer_transfer_item_details_inventory_id_index'"))) {
							$table->index('inventory_id');
						}
						if (Schema::hasColumn('customer_transfer_item_details','from_site_id') && !DB::select(DB::raw("SHOW INDEXES FROM customer_transfer_item_details WHERE key_name='customer_transfer_item_details_from_site_id_index'"))) {
							$table->index('from_site_id');
						} if (Schema::hasColumn('customer_transfer_item_details','to_site_id') && !DB::select(DB::raw("SHOW INDEXES FROM customer_transfer_item_details WHERE key_name='customer_transfer_item_details_to_site_id_index'"))) {
							$table->index('to_site_id');
						} if (Schema::hasColumn('customer_transfer_item_details','quantity') && !DB::select(DB::raw("SHOW INDEXES FROM customer_transfer_item_details WHERE key_name='customer_transfer_item_details_quantity_index'"))) {
							$table->index('quantity');
						}
						if (Schema::hasColumn('customer_transfer_item_details','um_id') && !DB::select(DB::raw("SHOW INDEXES FROM customer_transfer_item_details WHERE key_name='customer_transfer_item_details_um_id_index'"))) {
							$table->index('um_id');
						} if (Schema::hasColumn('customer_transfer_item_details','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM customer_transfer_item_details WHERE key_name='customer_transfer_item_details_company_id_index'"))) {
							$table->index('company_id');
						}
					});
				}





				
				// add indexs to custome_reports
				if(Schema::hasTable('custome_reports')) {
					Schema::table('custome_reports', function (Blueprint $table) {
						if (Schema::hasColumn('custome_reports','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM custome_reports WHERE key_name='custome_reports_user_id_index'"))) {
							$table->index('user_id');
						} 
						if (Schema::hasColumn('custome_reports','menu_column_id') && !DB::select(DB::raw("SHOW INDEXES FROM custome_reports WHERE key_name='custome_reports_menu_column_id_index'"))) {
							$table->index('menu_column_id');
						}
						if (Schema::hasColumn('custome_reports','type') && !DB::select(DB::raw("SHOW INDEXES FROM custome_reports WHERE key_name='custome_reports_type_index'"))) {
							$table->index('type');
						} if (Schema::hasColumn('custome_reports','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM custome_reports WHERE key_name='custome_reports_company_id_index'"))) {
							$table->index('company_id');
						} 
					});
				}



					// add indexs to customs
					if(Schema::hasTable('customs')) {
						Schema::table('customs', function (Blueprint $table) {
							if (Schema::hasColumn('customs','number') && !DB::select(DB::raw("SHOW INDEXES FROM customs WHERE key_name='customs_number_index'"))) {
								$table->index('number');
							} 
							if (Schema::hasColumn('customs','accd_number') && !DB::select(DB::raw("SHOW INDEXES FROM customs WHERE key_name='customs_accd_number_index'"))) {
								$table->index('accd_number');
							}
							if (Schema::hasColumn('customs','vehicle_number') && !DB::select(DB::raw("SHOW INDEXES FROM customs WHERE key_name='customs_vehicle_number_index'"))) {
								$table->index('vehicle_number');
							} if (Schema::hasColumn('customs','date') && !DB::select(DB::raw("SHOW INDEXES FROM customs WHERE key_name='customs_date_index'"))) {
								$table->index('date');
							} 
							if (Schema::hasColumn('customs','type') && !DB::select(DB::raw("SHOW INDEXES FROM customs WHERE key_name='customs_type_index'"))) {
								$table->index('type');
							} 
							if (Schema::hasColumn('customs','qty') && !DB::select(DB::raw("SHOW INDEXES FROM customs WHERE key_name='customs_qty_index'"))) {
								$table->index('qty');
							}
							if (Schema::hasColumn('customs','item_id') && !DB::select(DB::raw("SHOW INDEXES FROM customs WHERE key_name='customs_item_id_index'"))) {
								$table->index('item_id');
							} if (Schema::hasColumn('customs','um_id') && !DB::select(DB::raw("SHOW INDEXES FROM customs WHERE key_name='customs_um_id_index'"))) {
								$table->index('um_id');
							} 
							if (Schema::hasColumn('customs','foreign_data_id') && !DB::select(DB::raw("SHOW INDEXES FROM customs WHERE key_name='customs_foreign_data_id_index'"))) {
								$table->index('foreign_data_id');
							}
							if (Schema::hasColumn('customs','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM customs WHERE key_name='customs_user_id_index'"))) {
								$table->index('user_id');
							} if (Schema::hasColumn('customs','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM customs WHERE key_name='customs_company_id_index'"))) {
								$table->index('company_id');
							} 
						});
					}
	




					// add indexs to customs_details
					if(Schema::hasTable('customs_details')) {
						Schema::table('customs_details', function (Blueprint $table) {
							if (Schema::hasColumn('customs_details','customs_id') && !DB::select(DB::raw("SHOW INDEXES FROM customs_details WHERE key_name='customs_details_customs_id_index'"))) {
								$table->index('customs_id');
							} 
							if (Schema::hasColumn('customs_details','customs_field_id') && !DB::select(DB::raw("SHOW INDEXES FROM customs_details WHERE key_name='customs_details_customs_field_id_index'"))) {
								$table->index('customs_field_id');
							}
							if (Schema::hasColumn('customs_details','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM customs_details WHERE key_name='customs_details_user_id_index'"))) {
								$table->index('user_id');
							} if (Schema::hasColumn('customs_details','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM customs_details WHERE key_name='customs_details_company_id_index'"))) {
								$table->index('company_id');
							} 
						});
					}



					// add indexs to customs_fields
					if(Schema::hasTable('customs_fields')) {
						Schema::table('customs_fields', function (Blueprint $table) {
							if (Schema::hasColumn('customs_fields','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM customs_fields WHERE key_name='customs_fields_user_id_index'"))) {
								$table->index('user_id');
							} 
							if (Schema::hasColumn('customs_fields','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM customs_fields WHERE key_name='customs_fields_company_id_index'"))) {
								$table->index('company_id');
							} 
						});
					}


					// add indexs to deliveries
					if(Schema::hasTable('deliveries')) {
						Schema::table('deliveries', function (Blueprint $table) {
							if (Schema::hasColumn('deliveries','number') && !DB::select(DB::raw("SHOW INDEXES FROM deliveries WHERE key_name='deliveries_number_index'"))) {
								$table->index('number');
							} 
							if (Schema::hasColumn('deliveries','type') && !DB::select(DB::raw("SHOW INDEXES FROM deliveries WHERE key_name='deliveries_type_index'"))) {
								$table->index('type');
							} if (Schema::hasColumn('deliveries','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM deliveries WHERE key_name='deliveries_member_id_index'"))) {
								$table->index('member_id');
							} if (Schema::hasColumn('deliveries','project_id') && !DB::select(DB::raw("SHOW INDEXES FROM deliveries WHERE key_name='deliveries_project_id_index'"))) {
								$table->index('project_id');
							} if (Schema::hasColumn('deliveries','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM deliveries WHERE key_name='deliveries_user_id_index'"))) {
								$table->index('user_id');
							} if (Schema::hasColumn('deliveries','bank_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM deliveries WHERE key_name='deliveries_bank_transaction_index'"))) {
								$table->index('bank_transaction');
							} if (Schema::hasColumn('deliveries','expense_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM deliveries WHERE key_name='deliveries_expense_transaction_index'"))) {
								$table->index('expense_transaction');
							} if (Schema::hasColumn('deliveries','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM deliveries WHERE key_name='deliveries_company_id_index'"))) {
								$table->index('company_id');
							} 
						});
					}




					// add indexs to delivery_details
					if(Schema::hasTable('delivery_details')) {
						Schema::table('delivery_details', function (Blueprint $table) {
							if (Schema::hasColumn('delivery_details','delivery_id') && !DB::select(DB::raw("SHOW INDEXES FROM delivery_details WHERE key_name='delivery_details_delivery_id_index'"))) {
								$table->index('delivery_id');
							} 
							if (Schema::hasColumn('delivery_details','inventory_id') && !DB::select(DB::raw("SHOW INDEXES FROM delivery_details WHERE key_name='delivery_details_inventory_id_index'"))) {
								$table->index('inventory_id');
							} 
							if (Schema::hasColumn('delivery_details','project_item_id') && !DB::select(DB::raw("SHOW INDEXES FROM delivery_details WHERE key_name='delivery_details_project_item_id_index'"))) {
								$table->index('project_item_id');
							} 
							if (Schema::hasColumn('delivery_details','site_id') && !DB::select(DB::raw("SHOW INDEXES FROM delivery_details WHERE key_name='delivery_details_site_id_index'"))) {
								$table->index('site_id');
							} 
							if (Schema::hasColumn('delivery_details','um_id') && !DB::select(DB::raw("SHOW INDEXES FROM delivery_details WHERE key_name='delivery_details_um_id_index'"))) {
								$table->index('um_id');
							} 
							if (Schema::hasColumn('delivery_details','asset_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM delivery_details WHERE key_name='delivery_details_asset_transaction_index'"))) {
								$table->index('asset_transaction');
							} 


							if (Schema::hasColumn('delivery_details','cost_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM delivery_details WHERE key_name='delivery_details_cost_transaction_index'"))) {
								$table->index('cost_transaction');
							} 
							if (Schema::hasColumn('delivery_details','stock_out_id') && !DB::select(DB::raw("SHOW INDEXES FROM delivery_details WHERE key_name='delivery_details_stock_out_id_index'"))) {
								$table->index('stock_out_id');
							} 
							if (Schema::hasColumn('delivery_details','qty') && !DB::select(DB::raw("SHOW INDEXES FROM delivery_details WHERE key_name='delivery_details_qty_index'"))) {
								$table->index('qty');
							} 
							if (Schema::hasColumn('delivery_details','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM delivery_details WHERE key_name='delivery_details_company_id_index'"))) {
								$table->index('company_id');
							} 
						});
					}






					
					// add indexs to delivery_stock_outs
					if(Schema::hasTable('delivery_stock_outs')) {
						Schema::table('delivery_stock_outs', function (Blueprint $table) {
							if (Schema::hasColumn('delivery_stock_outs','project_stock_out_id') && !DB::select(DB::raw("SHOW INDEXES FROM delivery_stock_outs WHERE key_name='delivery_stock_outs_project_stock_out_id_index'"))) {
								$table->index('project_stock_out_id');
							} 
							if (Schema::hasColumn('delivery_stock_outs','stock_out_id') && !DB::select(DB::raw("SHOW INDEXES FROM delivery_stock_outs WHERE key_name='delivery_stock_outs_stock_out_id_index'"))) {
								$table->index('stock_out_id');
							} 
							if (Schema::hasColumn('delivery_stock_outs','delivery_id') && !DB::select(DB::raw("SHOW INDEXES FROM delivery_stock_outs WHERE key_name='delivery_stock_outs_delivery_id_index'"))) {
								$table->index('delivery_id');
							} 
							if (Schema::hasColumn('delivery_stock_outs','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM delivery_stock_outs WHERE key_name='delivery_stock_outs_company_id_index'"))) {
								$table->index('company_id');
							}
						});
					}



					// add indexs to drawings
					if(Schema::hasTable('drawings')) {
						Schema::table('drawings', function (Blueprint $table) {
							if (Schema::hasColumn('drawings','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM drawings WHERE key_name='drawings_member_id_index'"))) {
								$table->index('member_id');
							} 
							if (Schema::hasColumn('drawings','bank_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM drawings WHERE key_name='drawings_bank_transaction_index'"))) {
								$table->index('bank_transaction');
							} 
							if (Schema::hasColumn('drawings','drawing_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM drawings WHERE key_name='drawings_drawing_transaction_index'"))) {
								$table->index('drawing_transaction');
							} 
							if (Schema::hasColumn('drawings','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM drawings WHERE key_name='drawings_company_id_index'"))) {
								$table->index('company_id');
							}
						});
					}






					// add indexs to drivers
					if(Schema::hasTable('drivers')) {
						Schema::table('drivers', function (Blueprint $table) {
							if (Schema::hasColumn('drivers','name') && !DB::select(DB::raw("SHOW INDEXES FROM drivers WHERE key_name='drivers_name_index'"))) {
								$table->index('name');
							} 
							if (Schema::hasColumn('drivers','cartype') && !DB::select(DB::raw("SHOW INDEXES FROM drivers WHERE key_name='drivers_cartype_index'"))) {
								$table->index('cartype');
							} 
							if (Schema::hasColumn('drivers','plate') && !DB::select(DB::raw("SHOW INDEXES FROM drivers WHERE key_name='drivers_plate_index'"))) {
								$table->index('plate');
							} 
							if (Schema::hasColumn('drivers','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM drivers WHERE key_name='drivers_company_id_index'"))) {
								$table->index('company_id');
							}
						});
					}





					// add indexs to driver_info
					if(Schema::hasTable('driver_info')) {
						Schema::table('driver_info', function (Blueprint $table) {
							if (Schema::hasColumn('driver_info','cus_delivery_item_id') && !DB::select(DB::raw("SHOW INDEXES FROM driver_info WHERE key_name='driver_info_cus_delivery_item_id_index'"))) {
								$table->index('cus_delivery_item_id');
							} 
							if (Schema::hasColumn('driver_info','name') && !DB::select(DB::raw("SHOW INDEXES FROM driver_info WHERE key_name='driver_info_name_index'"))) {
								$table->index('name');
							} 
							if (Schema::hasColumn('driver_info','palet_number') && !DB::select(DB::raw("SHOW INDEXES FROM driver_info WHERE key_name='driver_info_palet_number_index'"))) {
								$table->index('palet_number');
							} 
							if (Schema::hasColumn('driver_info','source') && !DB::select(DB::raw("SHOW INDEXES FROM driver_info WHERE key_name='driver_info_source_index'"))) {
								$table->index('source');
							}


							if (Schema::hasColumn('driver_info','destination') && !DB::select(DB::raw("SHOW INDEXES FROM driver_info WHERE key_name='driver_info_destination_index'"))) {
								$table->index('destination');
							} 
							if (Schema::hasColumn('driver_info','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM driver_info WHERE key_name='driver_info_user_id_index'"))) {
								$table->index('user_id');
							} 
							if (Schema::hasColumn('driver_info','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM driver_info WHERE key_name='driver_info_company_id_index'"))) {
								$table->index('company_id');
							}
						});
					}




					// add indexs to employee_assessments
					if(Schema::hasTable('employee_assessments')) {
						Schema::table('employee_assessments', function (Blueprint $table) {
							if (Schema::hasColumn('employee_assessments','assessment_category_id') && !DB::select(DB::raw("SHOW INDEXES FROM employee_assessments WHERE key_name='employee_assessments_assessment_category_id_index'"))) {
								$table->index('assessment_category_id');
							} 
							if (Schema::hasColumn('employee_assessments','employee_id') && !DB::select(DB::raw("SHOW INDEXES FROM employee_assessments WHERE key_name='employee_assessments_employee_id_index'"))) {
								$table->index('employee_id');
							} 
							if (Schema::hasColumn('employee_assessments','number') && !DB::select(DB::raw("SHOW INDEXES FROM employee_assessments WHERE key_name='employee_assessments_number_index'"))) {
								$table->index('number');
							} 
							if (Schema::hasColumn('employee_assessments','type') && !DB::select(DB::raw("SHOW INDEXES FROM employee_assessments WHERE key_name='employee_assessments_type_index'"))) {
								$table->index('type');
							}if (Schema::hasColumn('employee_assessments','income_expense_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM employee_assessments WHERE key_name='employee_assessments_income_expense_transaction_index'"))) {
								$table->index('income_expense_transaction');
							} 
							if (Schema::hasColumn('employee_assessments','member_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM employee_assessments WHERE key_name='employee_assessments_member_transaction_index'"))) {
								$table->index('member_transaction');
							} 
							if (Schema::hasColumn('employee_assessments','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM employee_assessments WHERE key_name='employee_assessments_company_id_index'"))) {
								$table->index('company_id');
							}
							if (Schema::hasColumn('employee_assessments','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM employee_assessments WHERE key_name='employee_assessments_user_id_index'"))) {
								$table->index('user_id');
							}
						});
					}





				// add indexs to employee_assessment_categories
				if(Schema::hasTable('employee_assessment_categories')) {
					Schema::table('employee_assessment_categories', function (Blueprint $table) {
						if (Schema::hasColumn('employee_assessment_categories','name') && !DB::select(DB::raw("SHOW INDEXES FROM employee_assessment_categories WHERE key_name='employee_assessment_categories_name_index'"))) {
							$table->index('name');
						} 
						if (Schema::hasColumn('employee_assessment_categories','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM employee_assessment_categories WHERE key_name='employee_assessment_categories_company_id_index'"))) {
							$table->index('company_id');
						} 
						if (Schema::hasColumn('employee_assessment_categories','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM employee_assessment_categories WHERE key_name='employee_assessment_categories_user_id_index'"))) {
							$table->index('user_id');
						} 
					});
				}



				// add indexs to employee_attendance_classes
				if(Schema::hasTable('employee_attendance_classes')) {
					Schema::table('employee_attendance_classes', function (Blueprint $table) {
						if (Schema::hasColumn('employee_attendance_classes','name') && !DB::select(DB::raw("SHOW INDEXES FROM employee_attendance_classes WHERE key_name='employee_attendance_classes_name_index'"))) {
							$table->index('name');
						} 
						if (Schema::hasColumn('employee_attendance_classes','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM employee_attendance_classes WHERE key_name='employee_attendance_classes_company_id_index'"))) {
							$table->index('company_id');
						} 
						if (Schema::hasColumn('employee_attendance_classes','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM employee_attendance_classes WHERE key_name='employee_attendance_classes_user_id_index'"))) {
							$table->index('user_id');
						} 
					});
				}




                // add indexs to employee_payroll_taxes
				if(Schema::hasTable('employee_payroll_taxes')) {
					Schema::table('employee_payroll_taxes', function (Blueprint $table) {
						if (Schema::hasColumn('employee_payroll_taxes','payroll_id') && !DB::select(DB::raw("SHOW INDEXES FROM employee_payroll_taxes WHERE key_name='employee_payroll_taxes_payroll_id_index'"))) {
							$table->index('payroll_id');
						} 
						if (Schema::hasColumn('employee_payroll_taxes','expense_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM employee_payroll_taxes WHERE key_name='employee_payroll_taxes_expense_transaction_id_index'"))) {
							$table->index('expense_transaction_id');
						} 
						if (Schema::hasColumn('employee_payroll_taxes','transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM employee_payroll_taxes WHERE key_name='employee_payroll_taxes_transaction_id_index'"))) {
							$table->index('transaction_id');
						} 
                        if (Schema::hasColumn('employee_payroll_taxes','payroll_tax_detail_id') && !DB::select(DB::raw("SHOW INDEXES FROM employee_payroll_taxes WHERE key_name='employee_payroll_taxes_payroll_tax_detail_id_index'"))) {
							$table->index('payroll_tax_detail_id');
						} 
						if (Schema::hasColumn('employee_payroll_taxes','tax_member_id') && !DB::select(DB::raw("SHOW INDEXES FROM employee_payroll_taxes WHERE key_name='employee_payroll_taxes_tax_member_id_index'"))) {
							$table->index('tax_member_id');
						} 
					});
				}




                // add indexs to emp_overtime
				if(Schema::hasTable('emp_overtime')) {
					Schema::table('emp_overtime', function (Blueprint $table) {
						if (Schema::hasColumn('emp_overtime','number') && !DB::select(DB::raw("SHOW INDEXES FROM emp_overtime WHERE key_name='emp_overtime_number_index'"))) {
							$table->index('number');
						} 
						if (Schema::hasColumn('emp_overtime','code') && !DB::select(DB::raw("SHOW INDEXES FROM emp_overtime WHERE key_name='emp_overtime_code_index'"))) {
							$table->index('code');
						} 
						if (Schema::hasColumn('emp_overtime','date') && !DB::select(DB::raw("SHOW INDEXES FROM emp_overtime WHERE key_name='emp_overtime_date_index'"))) {
							$table->index('date');
						} 
                        if (Schema::hasColumn('emp_overtime','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM emp_overtime WHERE key_name='emp_overtime_member_id_index'"))) {
							$table->index('member_id');
						} 
						if (Schema::hasColumn('emp_overtime','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM emp_overtime WHERE key_name='emp_overtime_company_id_index'"))) {
							$table->index('company_id');
						} 
                        if (Schema::hasColumn('emp_overtime','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM emp_overtime WHERE key_name='emp_overtime_user_id_index'"))) {
							$table->index('user_id');
						} 
					});
				}





                 // add indexs to exchange_brokers
				if(Schema::hasTable('exchange_brokers')) {
					Schema::table('exchange_brokers', function (Blueprint $table) {
						if (Schema::hasColumn('exchange_brokers','saler_id') && !DB::select(DB::raw("SHOW INDEXES FROM exchange_brokers WHERE key_name='exchange_brokers_saler_id_index'"))) {
							$table->index('saler_id');
						} 
						if (Schema::hasColumn('exchange_brokers','number') && !DB::select(DB::raw("SHOW INDEXES FROM exchange_brokers WHERE key_name='exchange_brokers_number_index'"))) {
							$table->index('number');
						} 
						if (Schema::hasColumn('exchange_brokers','type') && !DB::select(DB::raw("SHOW INDEXES FROM exchange_brokers WHERE key_name='exchange_brokers_type_index'"))) {
							$table->index('type');
						} 
                        if (Schema::hasColumn('exchange_brokers','amount') && !DB::select(DB::raw("SHOW INDEXES FROM exchange_brokers WHERE key_name='exchange_brokers_amount_index'"))) {
							$table->index('amount');
						} 
						if (Schema::hasColumn('exchange_brokers','currency') && !DB::select(DB::raw("SHOW INDEXES FROM exchange_brokers WHERE key_name='exchange_brokers_currency_index'"))) {
							$table->index('currency');
						} 
                        if (Schema::hasColumn('exchange_brokers','date') && !DB::select(DB::raw("SHOW INDEXES FROM exchange_brokers WHERE key_name='exchange_brokers_date_index'"))) {
							$table->index('date');
						} 

                        if (Schema::hasColumn('exchange_brokers','commission_bank_tran_id') && !DB::select(DB::raw("SHOW INDEXES FROM exchange_brokers WHERE key_name='exchange_brokers_commission_bank_tran_id_index'"))) {
							$table->index('commission_bank_tran_id');
						} 
                        if (Schema::hasColumn('exchange_brokers','commission_income_tran_id') && !DB::select(DB::raw("SHOW INDEXES FROM exchange_brokers WHERE key_name='exchange_brokers_commission_income_tran_id_index'"))) {
							$table->index('commission_income_tran_id');
						} 
						if (Schema::hasColumn('exchange_brokers','commission_amount') && !DB::select(DB::raw("SHOW INDEXES FROM exchange_brokers WHERE key_name='exchange_brokers_commission_amount_index'"))) {
							$table->index('commission_amount');
						} 
                        if (Schema::hasColumn('exchange_brokers','commission_recievable_tran_id') && !DB::select(DB::raw("SHOW INDEXES FROM exchange_brokers WHERE key_name='exchange_brokers_commission_recievable_tran_id_index'"))) {
							$table->index('commission_recievable_tran_id');
						} 

                        if (Schema::hasColumn('exchange_brokers','class_id') && !DB::select(DB::raw("SHOW INDEXES FROM exchange_brokers WHERE key_name='exchange_brokers_class_id_index'"))) {
							$table->index('class_id');
						}  
						if (Schema::hasColumn('exchange_brokers','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM exchange_brokers WHERE key_name='exchange_brokers_company_id_index'"))) {
							$table->index('company_id');
						} 
                        if (Schema::hasColumn('exchange_brokers','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM exchange_brokers WHERE key_name='exchange_brokers_user_id_index'"))) {
							$table->index('user_id');
						}
					});
				}





                 // add indexs to exchange_broker_cheques
				if(Schema::hasTable('exchange_broker_cheques')) {
					Schema::table('exchange_broker_cheques', function (Blueprint $table) {
						if (Schema::hasColumn('exchange_broker_cheques','exchange_broker_id') && !DB::select(DB::raw("SHOW INDEXES FROM exchange_broker_cheques WHERE key_name='exchange_broker_cheques_exchange_broker_id_index'"))) {
							$table->index('exchange_broker_id');
						} 
						if (Schema::hasColumn('exchange_broker_cheques','exchange_broker_detail_id') && !DB::select(DB::raw("SHOW INDEXES FROM exchange_broker_cheques WHERE key_name='exchange_broker_cheques_exchange_broker_detail_id_index'"))) {
							$table->index('exchange_broker_detail_id');
						} 
						if (Schema::hasColumn('exchange_broker_cheques','from_member_id') && !DB::select(DB::raw("SHOW INDEXES FROM exchange_broker_cheques WHERE key_name='exchange_broker_cheques_from_member_id_index'"))) {
							$table->index('from_member_id');
						} 
                        if (Schema::hasColumn('exchange_broker_cheques','from_pay_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM exchange_broker_cheques WHERE key_name='exchange_broker_cheques_from_pay_transaction_id_index'"))) {
							$table->index('from_pay_transaction_id');
						} 
						if (Schema::hasColumn('exchange_broker_cheques','from_rec_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM exchange_broker_cheques WHERE key_name='exchange_broker_cheques_from_rec_transaction_id_index'"))) {
							$table->index('from_rec_transaction_id');
						} 
                        if (Schema::hasColumn('exchange_broker_cheques','to_member_id') && !DB::select(DB::raw("SHOW INDEXES FROM exchange_broker_cheques WHERE key_name='exchange_broker_cheques_to_member_id_index'"))) {
							$table->index('to_member_id');
						} 

                        if (Schema::hasColumn('exchange_broker_cheques','to_pay_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM exchange_broker_cheques WHERE key_name='exchange_broker_cheques_to_pay_transaction_id_index'"))) {
							$table->index('to_pay_transaction_id');
						} 
						if (Schema::hasColumn('exchange_broker_cheques','to_rec_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM exchange_broker_cheques WHERE key_name='exchange_broker_cheques_to_rec_transaction_id_index'"))) {
							$table->index('to_rec_transaction_id');
						} 
                        if (Schema::hasColumn('exchange_broker_cheques','account_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM exchange_broker_cheques WHERE key_name='exchange_broker_cheques_account_transaction_id_index'"))) {
							$table->index('account_transaction_id');
						} 
						if (Schema::hasColumn('exchange_broker_cheques','income_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM exchange_broker_cheques WHERE key_name='exchange_broker_cheques_income_transaction_id_index'"))) {
							$table->index('income_transaction_id');
						} 
                        if (Schema::hasColumn('exchange_broker_cheques','member_exp_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM exchange_broker_cheques WHERE key_name='exchange_broker_cheques_member_exp_transaction_id_index'"))) {
							$table->index('member_exp_transaction_id');
						}if (Schema::hasColumn('exchange_broker_cheques','exp_member_id') && !DB::select(DB::raw("SHOW INDEXES FROM exchange_broker_cheques WHERE key_name='exchange_broker_cheques_exp_member_id_index'"))) {
							$table->index('exp_member_id');
						} 
						if (Schema::hasColumn('exchange_broker_cheques','amount') && !DB::select(DB::raw("SHOW INDEXES FROM exchange_broker_cheques WHERE key_name='exchange_broker_cheques_amount_index'"))) {
							$table->index('amount');
						} 
                        if (Schema::hasColumn('exchange_broker_cheques','date') && !DB::select(DB::raw("SHOW INDEXES FROM exchange_broker_cheques WHERE key_name='exchange_broker_cheques_date_index'"))) {
							$table->index('date');
						} 
						if (Schema::hasColumn('exchange_broker_cheques','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM exchange_broker_cheques WHERE key_name='exchange_broker_cheques_company_id_index'"))) {
							$table->index('company_id');
						} 
                        if (Schema::hasColumn('exchange_broker_cheques','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM exchange_broker_cheques WHERE key_name='exchange_broker_cheques_user_id_index'"))) {
							$table->index('user_id');
						}
					});
				}




                // add indexs to exchange_broker_details
				if(Schema::hasTable('exchange_broker_details')) {
					Schema::table('exchange_broker_details', function (Blueprint $table) {
						if (Schema::hasColumn('exchange_broker_details','exchange_broker_id') && !DB::select(DB::raw("SHOW INDEXES FROM exchange_broker_details WHERE key_name='exchange_broker_details_exchange_broker_id_index'"))) {
							$table->index('exchange_broker_id');
						} 
						if (Schema::hasColumn('exchange_broker_details','buyer_id') && !DB::select(DB::raw("SHOW INDEXES FROM exchange_broker_details WHERE key_name='exchange_broker_details_buyer_id_index'"))) {
							$table->index('buyer_id');
						} 
						if (Schema::hasColumn('exchange_broker_details','amount') && !DB::select(DB::raw("SHOW INDEXES FROM exchange_broker_details WHERE key_name='exchange_broker_details_amount_index'"))) {
							$table->index('amount');
						} 
                        if (Schema::hasColumn('exchange_broker_details','currency') && !DB::select(DB::raw("SHOW INDEXES FROM exchange_broker_details WHERE key_name='exchange_broker_details_currency_index'"))) {
							$table->index('currency');
						} 
                        if (Schema::hasColumn('exchange_broker_details','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM exchange_broker_details WHERE key_name='exchange_broker_details_company_id_index'"))) {
							$table->index('company_id');
						} 
						if (Schema::hasColumn('exchange_broker_details','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM exchange_broker_details WHERE key_name='exchange_broker_details_user_id_index'"))) {
							$table->index('user_id');
						}  
					});
				}




                 // add indexs to finger_attendance_logs
				if(Schema::hasTable('finger_attendance_logs')) {
					Schema::table('finger_attendance_logs', function (Blueprint $table) {
						if (Schema::hasColumn('finger_attendance_logs','employee_id') && !DB::select(DB::raw("SHOW INDEXES FROM finger_attendance_logs WHERE key_name='finger_attendance_logs_employee_id_index'"))) {
							$table->index('employee_id');
						} 
						if (Schema::hasColumn('finger_attendance_logs','attendance_id') && !DB::select(DB::raw("SHOW INDEXES FROM finger_attendance_logs WHERE key_name='finger_attendance_logs_attendance_id_index'"))) {
							$table->index('attendance_id');
						} 
						if (Schema::hasColumn('finger_attendance_logs','attendance_type') && !DB::select(DB::raw("SHOW INDEXES FROM finger_attendance_logs WHERE key_name='finger_attendance_logs_attendance_type_index'"))) {
							$table->index('attendance_type');
						} 
                        if (Schema::hasColumn('finger_attendance_logs','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM finger_attendance_logs WHERE key_name='finger_attendance_logs_company_id_index'"))) {
							$table->index('company_id');
						} 
                        if (Schema::hasColumn('finger_attendance_logs','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM finger_attendance_logs WHERE key_name='finger_attendance_logs_user_id_index'"))) {
							$table->index('user_id');
						}  
					});
				}




                 // add indexs to fix_asset_depreciation
				if(Schema::hasTable('fix_asset_depreciation')) {
					Schema::table('fix_asset_depreciation', function (Blueprint $table) {
						if (Schema::hasColumn('fix_asset_depreciation','fixed_asset_id') && !DB::select(DB::raw("SHOW INDEXES FROM fix_asset_depreciation WHERE key_name='fix_asset_depreciation_fixed_asset_id_index'"))) {
							$table->index('fixed_asset_id');
						} 
						if (Schema::hasColumn('fix_asset_depreciation','date') && !DB::select(DB::raw("SHOW INDEXES FROM fix_asset_depreciation WHERE key_name='fix_asset_depreciation_date_index'"))) {
							$table->index('date');
						} 
						if (Schema::hasColumn('fix_asset_depreciation','currency') && !DB::select(DB::raw("SHOW INDEXES FROM fix_asset_depreciation WHERE key_name='fix_asset_depreciation_currency_index'"))) {
							$table->index('currency');
						} 
                        if (Schema::hasColumn('fix_asset_depreciation','expense_id') && !DB::select(DB::raw("SHOW INDEXES FROM fix_asset_depreciation WHERE key_name='fix_asset_depreciation_expense_id_index'"))) {
							$table->index('expense_id');
						} 
                        if (Schema::hasColumn('fix_asset_depreciation','asset_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM fix_asset_depreciation WHERE key_name='fix_asset_depreciation_asset_transaction_id_index'"))) {
							$table->index('asset_transaction_id');
						} 
                        
                        if (Schema::hasColumn('fix_asset_depreciation','expense_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM fix_asset_depreciation WHERE key_name='fix_asset_depreciation_expense_transaction_id_index'"))) {
							$table->index('expense_transaction_id');
						} 
						if (Schema::hasColumn('fix_asset_depreciation','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM fix_asset_depreciation WHERE key_name='fix_asset_depreciation_user_id_index'"))) {
							$table->index('user_id');
						} 
                        if (Schema::hasColumn('fix_asset_depreciation','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM fix_asset_depreciation WHERE key_name='fix_asset_depreciation_company_id_index'"))) {
							$table->index('company_id');
						}   
					});
				}




                  // add indexs to fix_asset_sales
				if(Schema::hasTable('fix_asset_sales')) {
					Schema::table('fix_asset_sales', function (Blueprint $table) {
						if (Schema::hasColumn('fix_asset_sales','fixed_asset_id') && !DB::select(DB::raw("SHOW INDEXES FROM fix_asset_sales WHERE key_name='fix_asset_sales_fixed_asset_id_index'"))) {
							$table->index('fixed_asset_id');
						} 
						if (Schema::hasColumn('fix_asset_sales','date') && !DB::select(DB::raw("SHOW INDEXES FROM fix_asset_sales WHERE key_name='fix_asset_sales_date_index'"))) {
							$table->index('date');
						} 
						if (Schema::hasColumn('fix_asset_sales','number') && !DB::select(DB::raw("SHOW INDEXES FROM fix_asset_sales WHERE key_name='fix_asset_sales_number_index'"))) {
							$table->index('number');
						} 
                        if (Schema::hasColumn('fix_asset_sales','customer_id') && !DB::select(DB::raw("SHOW INDEXES FROM fix_asset_sales WHERE key_name='fix_asset_sales_customer_id_index'"))) {
							$table->index('customer_id');
						} 
                        if (Schema::hasColumn('fix_asset_sales','expense_id') && !DB::select(DB::raw("SHOW INDEXES FROM fix_asset_sales WHERE key_name='fix_asset_sales_expense_id_index'"))) {
							$table->index('expense_id');
						} 
                        
                        if (Schema::hasColumn('fix_asset_sales','income_id') && !DB::select(DB::raw("SHOW INDEXES FROM fix_asset_sales WHERE key_name='fix_asset_sales_income_id_index'"))) {
							$table->index('income_id');
						} 
						if (Schema::hasColumn('fix_asset_sales','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM fix_asset_sales WHERE key_name='fix_asset_sales_user_id_index'"))) {
							$table->index('user_id');
						} 
                        if (Schema::hasColumn('fix_asset_sales','asset_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM fix_asset_sales WHERE key_name='fix_asset_sales_asset_transaction_id_index'"))) {
							$table->index('asset_transaction_id');
						} 
                        
                        if (Schema::hasColumn('fix_asset_sales','expense_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM fix_asset_sales WHERE key_name='fix_asset_sales_expense_transaction_id_index'"))) {
							$table->index('expense_transaction_id');
						} 
						if (Schema::hasColumn('fix_asset_sales','receivable_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM fix_asset_sales WHERE key_name='fix_asset_sales_receivable_transaction_id_index'"))) {
							$table->index('receivable_transaction_id');
						} 
                        if (Schema::hasColumn('fix_asset_sales','bank_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM fix_asset_sales WHERE key_name='fix_asset_sales_bank_transaction_id_index'"))) {
							$table->index('bank_transaction_id');
						}   

                        if (Schema::hasColumn('fix_asset_sales','income_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM fix_asset_sales WHERE key_name='fix_asset_sales_income_transaction_id_index'"))) {
							$table->index('income_transaction_id');
						} 
						
                        if (Schema::hasColumn('fix_asset_sales','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM fix_asset_sales WHERE key_name='fix_asset_sales_company_id_index'"))) {
							$table->index('company_id');
						}  
					});
				}





                
                  // add indexs to formulas
				if(Schema::hasTable('formulas')) {
					Schema::table('formulas', function (Blueprint $table) {
						if (Schema::hasColumn('formulas','item_id') && !DB::select(DB::raw("SHOW INDEXES FROM formulas WHERE key_name='formulas_item_id_index'"))) {
							$table->index('item_id');
						} 
						if (Schema::hasColumn('formulas','assembly_id') && !DB::select(DB::raw("SHOW INDEXES FROM formulas WHERE key_name='formulas_assembly_id_index'"))) {
							$table->index('assembly_id');
						} 
						if (Schema::hasColumn('formulas','um_id') && !DB::select(DB::raw("SHOW INDEXES FROM formulas WHERE key_name='formulas_um_id_index'"))) {
							$table->index('um_id');
						} 
                        if (Schema::hasColumn('formulas','type') && !DB::select(DB::raw("SHOW INDEXES FROM formulas WHERE key_name='formulas_type_index'"))) {
							$table->index('type');
						} 
                        if (Schema::hasColumn('formulas','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM formulas WHERE key_name='formulas_company_id_index'"))) {
							$table->index('company_id');
						} 
                        
					});
				}



                   // add indexs to formulas
				if(Schema::hasTable('formulas')) {
					Schema::table('formulas', function (Blueprint $table) {
						if (Schema::hasColumn('formulas','inventory_id') && !DB::select(DB::raw("SHOW INDEXES FROM formulas WHERE key_name='formulas_inventory_id_index'"))) {
							$table->index('inventory_id');
						} 
						if (Schema::hasColumn('formulas','site_id') && !DB::select(DB::raw("SHOW INDEXES FROM formulas WHERE key_name='formulas_site_id_index'"))) {
							$table->index('site_id');
						} 
						if (Schema::hasColumn('formulas','um_id') && !DB::select(DB::raw("SHOW INDEXES FROM formulas WHERE key_name='formulas_um_id_index'"))) {
							$table->index('um_id');
						} 
                        if (Schema::hasColumn('formulas','type_id') && !DB::select(DB::raw("SHOW INDEXES FROM formulas WHERE key_name='formulas_type_id_index'"))) {
							$table->index('type_id');
						} 
                        if (Schema::hasColumn('formulas','category_id') && !DB::select(DB::raw("SHOW INDEXES FROM formulas WHERE key_name='formulas_category_id_index'"))) {
							$table->index('category_id');
						} 
                        if (Schema::hasColumn('formulas','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM formulas WHERE key_name='formulas_company_id_index'"))) {
							$table->index('company_id');
						} 
					});
				}


                  // add indexs to gifts
				if(Schema::hasTable('gifts')) {
					Schema::table('gifts', function (Blueprint $table) {
						if (Schema::hasColumn('gifts','customer_id') && !DB::select(DB::raw("SHOW INDEXES FROM gifts WHERE key_name='gifts_customer_id_index'"))) {
							$table->index('customer_id');
						} 
						if (Schema::hasColumn('gifts','inventory_category_id') && !DB::select(DB::raw("SHOW INDEXES FROM gifts WHERE key_name='gifts_inventory_category_id_index'"))) {
							$table->index('inventory_category_id');
						} 
						if (Schema::hasColumn('gifts','categ_um_id') && !DB::select(DB::raw("SHOW INDEXES FROM gifts WHERE key_name='gifts_categ_um_id_index'"))) {
							$table->index('categ_um_id');
						} 
                        if (Schema::hasColumn('gifts','qty') && !DB::select(DB::raw("SHOW INDEXES FROM gifts WHERE key_name='gifts_qty_index'"))) {
							$table->index('qty');
						} 
                        if (Schema::hasColumn('gifts','item_id') && !DB::select(DB::raw("SHOW INDEXES FROM gifts WHERE key_name='gifts_item_id_index'"))) {
							$table->index('item_id');
						} 
                        if (Schema::hasColumn('gifts','gift_um_id') && !DB::select(DB::raw("SHOW INDEXES FROM gifts WHERE key_name='gifts_gift_um_id_index'"))) {
							$table->index('gift_um_id');
						} 

                        if (Schema::hasColumn('gifts','sale_id') && !DB::select(DB::raw("SHOW INDEXES FROM gifts WHERE key_name='gifts_sale_id_index'"))) {
							$table->index('sale_id');
						} 
                        if (Schema::hasColumn('gifts','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM gifts WHERE key_name='gifts_user_id_index'"))) {
							$table->index('user_id');
						} 
                        if (Schema::hasColumn('gifts','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM gifts WHERE key_name='gifts_company_id_index'"))) {
							$table->index('company_id');
						} 
					});
				}







                  // add indexs to glasses
				if(Schema::hasTable('glasses')) {
					Schema::table('glasses', function (Blueprint $table) {
						if (Schema::hasColumn('glasses','project_id') && !DB::select(DB::raw("SHOW INDEXES FROM glasses WHERE key_name='glasses_project_id_index'"))) {
							$table->index('project_id');
						} 
						if (Schema::hasColumn('glasses','measure_id') && !DB::select(DB::raw("SHOW INDEXES FROM glasses WHERE key_name='glasses_measure_id_index'"))) {
							$table->index('measure_id');
						} 
						if (Schema::hasColumn('glasses','site_id') && !DB::select(DB::raw("SHOW INDEXES FROM glasses WHERE key_name='glasses_site_id_index'"))) {
							$table->index('site_id');
						} 
                        if (Schema::hasColumn('glasses','parent_id') && !DB::select(DB::raw("SHOW INDEXES FROM glasses WHERE key_name='glasses_parent_id_index'"))) {
							$table->index('parent_id');
						} 
                        if (Schema::hasColumn('glasses','qty') && !DB::select(DB::raw("SHOW INDEXES FROM glasses WHERE key_name='glasses_qty_index'"))) {
							$table->index('qty');
						} 
                        if (Schema::hasColumn('glasses','item_id') && !DB::select(DB::raw("SHOW INDEXES FROM glasses WHERE key_name='glasses_item_id_index'"))) {
							$table->index('item_id');
						} 

                        if (Schema::hasColumn('glasses','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM glasses WHERE key_name='glasses_company_id_index'"))) {
							$table->index('company_id');
						} 
					});
				}



                   // add indexs to home_currencies
				if(Schema::hasTable('home_currencies')) {
					Schema::table('home_currencies', function (Blueprint $table) {
						if (Schema::hasColumn('home_currencies','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM home_currencies WHERE key_name='home_currencies_company_id_index'"))) {
							$table->index('company_id');
						} 
						if (Schema::hasColumn('home_currencies','currency_id') && !DB::select(DB::raw("SHOW INDEXES FROM home_currencies WHERE key_name='home_currencies_currency_id_index'"))) {
							$table->index('currency_id');
						} 
						if (Schema::hasColumn('home_currencies','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM home_currencies WHERE key_name='home_currencies_user_id_index'"))) {
							$table->index('user_id');
						}
					});
				}




                // add indexs to hot_prospect_clients
				if(Schema::hasTable('hot_prospect_clients')) {
					Schema::table('hot_prospect_clients', function (Blueprint $table) {
						if (Schema::hasColumn('hot_prospect_clients','prospectclient_id') && !DB::select(DB::raw("SHOW INDEXES FROM hot_prospect_clients WHERE key_name='hot_prospect_clients_prospectclient_id_index'"))) {
							$table->index('prospectclient_id');
						} 
						if (Schema::hasColumn('hot_prospect_clients','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM hot_prospect_clients WHERE key_name='hot_prospect_clients_user_id_index'"))) {
							$table->index('user_id');
						} 
						if (Schema::hasColumn('hot_prospect_clients','proposal_submitted_date') && !DB::select(DB::raw("SHOW INDEXES FROM hot_prospect_clients WHERE key_name='hot_prospect_clients_proposal_submitted_date_index'"))) {
							$table->index('proposal_submitted_date');
						}
					});
				}




                 // add indexs to information_to_updates
				if(Schema::hasTable('information_to_updates')) {
					Schema::table('information_to_updates', function (Blueprint $table) {
						if (Schema::hasColumn('information_to_updates','type_id') && !DB::select(DB::raw("SHOW INDEXES FROM information_to_updates WHERE key_name='information_to_updates_type_id_index'"))) {
							$table->index('type_id');
						} 
						if (Schema::hasColumn('information_to_updates','type') && !DB::select(DB::raw("SHOW INDEXES FROM information_to_updates WHERE key_name='information_to_updates_type_index'"))) {
							$table->index('type');
						} 
						if (Schema::hasColumn('information_to_updates','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM information_to_updates WHERE key_name='information_to_updates_company_id_index'"))) {
							$table->index('company_id');
						}
					});
				}




                // add indexs to installments
				if(Schema::hasTable('installments')) {
					Schema::table('installments', function (Blueprint $table) {
						if (Schema::hasColumn('installments','date') && !DB::select(DB::raw("SHOW INDEXES FROM installments WHERE key_name='installments_date_index'"))) {
							$table->index('date');
						} 
						if (Schema::hasColumn('installments','amount') && !DB::select(DB::raw("SHOW INDEXES FROM installments WHERE key_name='installments_amount_index'"))) {
							$table->index('amount');
						} 
						if (Schema::hasColumn('installments','sale_id') && !DB::select(DB::raw("SHOW INDEXES FROM installments WHERE key_name='installments_sale_id_index'"))) {
							$table->index('sale_id');
						}

                        if (Schema::hasColumn('installments','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM installments WHERE key_name='installments_user_id_index'"))) {
							$table->index('user_id');
						} 
						if (Schema::hasColumn('installments','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM installments WHERE key_name='installments_company_id_index'"))) {
							$table->index('company_id');
						}
                        if (Schema::hasColumn('installments','loan_id') && !DB::select(DB::raw("SHOW INDEXES FROM installments WHERE key_name='installments_loan_id_index'"))) {
							$table->index('loan_id');
						}
					});
				}


                 // add indexs to inventory_min_maxes
				if(Schema::hasTable('inventory_min_maxes')) {
					Schema::table('inventory_min_maxes', function (Blueprint $table) {
						if (Schema::hasColumn('inventory_min_maxes','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM inventory_min_maxes WHERE key_name='inventory_min_maxes_company_id_index'"))) {
							$table->index('company_id');
						} 
						if (Schema::hasColumn('inventory_min_maxes','inventory_id') && !DB::select(DB::raw("SHOW INDEXES FROM inventory_min_maxes WHERE key_name='inventory_min_maxes_inventory_id_index'"))) {
							$table->index('inventory_id');
						} 
						if (Schema::hasColumn('inventory_min_maxes','site_id') && !DB::select(DB::raw("SHOW INDEXES FROM inventory_min_maxes WHERE key_name='inventory_min_maxes_site_id_index'"))) {
							$table->index('site_id');
						}
					});
				}



                // add indexs to inventory_receives
				if(Schema::hasTable('inventory_receives')) {
					Schema::table('inventory_receives', function (Blueprint $table) {
						if (Schema::hasColumn('inventory_receives','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM inventory_receives WHERE key_name='inventory_receives_company_id_index'"))) {
							$table->index('company_id');
						} 
						if (Schema::hasColumn('inventory_receives','inventory_id') && !DB::select(DB::raw("SHOW INDEXES FROM inventory_receives WHERE key_name='inventory_receives_inventory_id_index'"))) {
							$table->index('inventory_id');
						} 
						if (Schema::hasColumn('inventory_receives','site_id') && !DB::select(DB::raw("SHOW INDEXES FROM inventory_receives WHERE key_name='inventory_receives_site_id_index'"))) {
							$table->index('site_id');
						}
						if (Schema::hasColumn('inventory_receives','purchase_id') && !DB::select(DB::raw("SHOW INDEXES FROM inventory_receives WHERE key_name='inventory_receives_purchase_id_index'"))) {
							$table->index('purchase_id');
						} 
						if (Schema::hasColumn('inventory_receives','sale_id') && !DB::select(DB::raw("SHOW INDEXES FROM inventory_receives WHERE key_name='inventory_receives_sale_id_index'"))) {
							$table->index('sale_id');
						}
						if (Schema::hasColumn('inventory_receives','inventory_transfer_id') && !DB::select(DB::raw("SHOW INDEXES FROM inventory_receives WHERE key_name='inventory_receives_inventory_transfer_id_index'"))) {
							$table->index('inventory_transfer_id');
						}
						if (Schema::hasColumn('inventory_receives','driver_id') && !DB::select(DB::raw("SHOW INDEXES FROM inventory_receives WHERE key_name='inventory_receives_driver_id_index'"))) {
							$table->index('driver_id');
						} 
						if (Schema::hasColumn('inventory_receives','tanker_number') && !DB::select(DB::raw("SHOW INDEXES FROM inventory_receives WHERE key_name='inventory_receives_tanker_number_index'"))) {
							$table->index('tanker_number');
						}
					});
				}




                  // add indexs to inventory_transfers
				if(Schema::hasTable('inventory_transfers')) {
					Schema::table('inventory_transfers', function (Blueprint $table) {
						if (Schema::hasColumn('inventory_transfers','date') && !DB::select(DB::raw("SHOW INDEXES FROM inventory_transfers WHERE key_name='inventory_transfers_date_index'"))) {
							$table->index('date');
						} 
						if (Schema::hasColumn('inventory_transfers','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM inventory_transfers WHERE key_name='inventory_transfers_company_id_index'"))) {
							$table->index('company_id');
						} 
						if (Schema::hasColumn('inventory_transfers','driver_id') && !DB::select(DB::raw("SHOW INDEXES FROM inventory_transfers WHERE key_name='inventory_transfers_driver_id_index'"))) {
							$table->index('driver_id');
						}
                        if (Schema::hasColumn('inventory_transfers','contract_id') && !DB::select(DB::raw("SHOW INDEXES FROM inventory_transfers WHERE key_name='inventory_transfers_contract_id_index'"))) {
							$table->index('contract_id');
						} 
						if (Schema::hasColumn('inventory_transfers','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM inventory_transfers WHERE key_name='inventory_transfers_user_id_index'"))) {
							$table->index('user_id');
						}
                        if (Schema::hasColumn('inventory_transfers','number') && !DB::select(DB::raw("SHOW INDEXES FROM inventory_transfers WHERE key_name='inventory_transfers_number_index'"))) {
							$table->index('number');
						} 
						if (Schema::hasColumn('inventory_transfers','employee_id') && !DB::select(DB::raw("SHOW INDEXES FROM inventory_transfers WHERE key_name='inventory_transfers_employee_id_index'"))) {
							$table->index('employee_id');
						}
						if (Schema::hasColumn('inventory_transfers','type') && !DB::select(DB::raw("SHOW INDEXES FROM inventory_transfers WHERE key_name='inventory_transfers_type_index'"))) {
							$table->index('type');
						} 
						if (Schema::hasColumn('inventory_transfers','contract_type') && !DB::select(DB::raw("SHOW INDEXES FROM inventory_transfers WHERE key_name='inventory_transfers_contract_type_index'"))) {
							$table->index('contract_type');
						} 
					});
				}




                // add indexs to inventory_transfer_details
				if(Schema::hasTable('inventory_transfer_details')) {
					Schema::table('inventory_transfer_details', function (Blueprint $table) {
						if (Schema::hasColumn('inventory_transfer_details','inventory_transfer_id') && !DB::select(DB::raw("SHOW INDEXES FROM inventory_transfer_details WHERE key_name='inventory_transfer_details_inventory_transfer_id_index'"))) {
							$table->index('inventory_transfer_id');
						} 
						if (Schema::hasColumn('inventory_transfer_details','stock_id') && !DB::select(DB::raw("SHOW INDEXES FROM inventory_transfer_details WHERE key_name='inventory_transfer_details_stock_id_index'"))) {
							$table->index('stock_id');
						} 
						if (Schema::hasColumn('inventory_transfer_details','stock_out_id') && !DB::select(DB::raw("SHOW INDEXES FROM inventory_transfer_details WHERE key_name='inventory_transfer_details_stock_out_id_index'"))) {
							$table->index('stock_out_id');
						}
                        if (Schema::hasColumn('inventory_transfer_details','inventory_transfer_info_id') && !DB::select(DB::raw("SHOW INDEXES FROM inventory_transfer_details WHERE key_name='inventory_transfer_details_inventory_transfer_info_id_index'"))) {
							$table->index('inventory_transfer_info_id');
						} 
						if (Schema::hasColumn('inventory_transfer_details','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM inventory_transfer_details WHERE key_name='inventory_transfer_details_company_id_index'"))) {
							$table->index('company_id');
						}
                        if (Schema::hasColumn('inventory_transfer_details','m_stock_id') && !DB::select(DB::raw("SHOW INDEXES FROM inventory_transfer_details WHERE key_name='inventory_transfer_details_m_stock_id_index'"))) {
							$table->index('m_stock_id');
						} 
						if (Schema::hasColumn('inventory_transfer_details','m_stock_out_id') && !DB::select(DB::raw("SHOW INDEXES FROM inventory_transfer_details WHERE key_name='inventory_transfer_details_m_stock_out_id_index'"))) {
							$table->index('m_stock_out_id');
						}
					});
				}




                   // add indexs to inventory_transfer_infos
				if(Schema::hasTable('inventory_transfer_infos')) {
					Schema::table('inventory_transfer_infos', function (Blueprint $table) {
						if (Schema::hasColumn('inventory_transfer_infos','inventory_category_id') && !DB::select(DB::raw("SHOW INDEXES FROM inventory_transfer_infos WHERE key_name='inventory_transfer_infos_inventory_category_id_index'"))) {
							$table->index('inventory_category_id');
						} 
						if (Schema::hasColumn('inventory_transfer_infos','inventory_id') && !DB::select(DB::raw("SHOW INDEXES FROM inventory_transfer_infos WHERE key_name='inventory_transfer_infos_inventory_id_index'"))) {
							$table->index('inventory_id');
						} 
						if (Schema::hasColumn('inventory_transfer_infos','from_site_id') && !DB::select(DB::raw("SHOW INDEXES FROM inventory_transfer_infos WHERE key_name='inventory_transfer_infos_from_site_id_index'"))) {
							$table->index('from_site_id');
						}
                        if (Schema::hasColumn('inventory_transfer_infos','to_site_id') && !DB::select(DB::raw("SHOW INDEXES FROM inventory_transfer_infos WHERE key_name='inventory_transfer_infos_to_site_id_index'"))) {
							$table->index('to_site_id');
						} 
						if (Schema::hasColumn('inventory_transfer_infos','um_id') && !DB::select(DB::raw("SHOW INDEXES FROM inventory_transfer_infos WHERE key_name='inventory_transfer_infos_um_id_index'"))) {
							$table->index('um_id');
						}
                        if (Schema::hasColumn('inventory_transfer_infos','inventory_transfer_id') && !DB::select(DB::raw("SHOW INDEXES FROM inventory_transfer_infos WHERE key_name='inventory_transfer_infos_inventory_transfer_id_index'"))) {
							$table->index('inventory_transfer_id');
						} 
						if (Schema::hasColumn('inventory_transfer_infos','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM inventory_transfer_infos WHERE key_name='inventory_transfer_infos_company_id_index'"))) {
							$table->index('company_id');
						}

                        if (Schema::hasColumn('inventory_transfer_infos','loading_detail_id') && !DB::select(DB::raw("SHOW INDEXES FROM inventory_transfer_infos WHERE key_name='inventory_transfer_infos_loading_detail_id_index'"))) {
							$table->index('loading_detail_id');
						} 
						if (Schema::hasColumn('inventory_transfer_infos','other_measure') && !DB::select(DB::raw("SHOW INDEXES FROM inventory_transfer_infos WHERE key_name='inventory_transfer_infos_other_measure_index'"))) {
							$table->index('other_measure');
						}
                        if (Schema::hasColumn('inventory_transfer_infos','other_measure2') && !DB::select(DB::raw("SHOW INDEXES FROM inventory_transfer_infos WHERE key_name='inventory_transfer_infos_other_measure2_index'"))) {
							$table->index('other_measure2');
						} 
						if (Schema::hasColumn('inventory_transfer_infos','contract_id') && !DB::select(DB::raw("SHOW INDEXES FROM inventory_transfer_infos WHERE key_name='inventory_transfer_infos_contract_id_index'"))) {
							$table->index('contract_id');
						}
					});
				}

                
                   // add indexs to invoices
				if(Schema::hasTable('invoices')) {
					Schema::table('invoices', function (Blueprint $table) {
						if (Schema::hasColumn('invoices','number') && !DB::select(DB::raw("SHOW INDEXES FROM invoices WHERE key_name='invoices_number_index'"))) {
							$table->index('number');
						} 
						if (Schema::hasColumn('invoices','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM invoices WHERE key_name='invoices_member_id_index'"))) {
							$table->index('member_id');
						} 
						if (Schema::hasColumn('invoices','sale_id') && !DB::select(DB::raw("SHOW INDEXES FROM invoices WHERE key_name='invoices_sale_id_index'"))) {
							$table->index('sale_id');
						}
                        if (Schema::hasColumn('invoices','account_id') && !DB::select(DB::raw("SHOW INDEXES FROM invoices WHERE key_name='invoices_account_id_index'"))) {
							$table->index('account_id');
						} 
						if (Schema::hasColumn('invoices','amount') && !DB::select(DB::raw("SHOW INDEXES FROM invoices WHERE key_name='invoices_amount_index'"))) {
							$table->index('amount');
						}
                        if (Schema::hasColumn('invoices','currency') && !DB::select(DB::raw("SHOW INDEXES FROM invoices WHERE key_name='invoices_currency_index'"))) {
							$table->index('currency');
						} 
						if (Schema::hasColumn('invoices','status') && !DB::select(DB::raw("SHOW INDEXES FROM invoices WHERE key_name='invoices_status_index'"))) {
							$table->index('status');
						}
					});
				}

 
                   // add indexs to invoice_payments
				if(Schema::hasTable('invoice_payments')) {
					Schema::table('invoice_payments', function (Blueprint $table) {
						if (Schema::hasColumn('invoice_payments','invoice_id') && !DB::select(DB::raw("SHOW INDEXES FROM invoice_payments WHERE key_name='invoice_payments_invoice_id_index'"))) {
							$table->index('invoice_id');
						} 
						if (Schema::hasColumn('invoice_payments','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM invoice_payments WHERE key_name='invoice_payments_member_id_index'"))) {
							$table->index('member_id');
						} 
						if (Schema::hasColumn('invoice_payments','bank_id') && !DB::select(DB::raw("SHOW INDEXES FROM invoice_payments WHERE key_name='invoice_payments_bank_id_index'"))) {
							$table->index('bank_id');
						}
                        if (Schema::hasColumn('invoice_payments','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM invoice_payments WHERE key_name='invoice_payments_user_id_index'"))) {
							$table->index('user_id');
						} 
						if (Schema::hasColumn('invoice_payments','date') && !DB::select(DB::raw("SHOW INDEXES FROM invoice_payments WHERE key_name='invoice_payments_date_index'"))) {
							$table->index('date');
						}
                        if (Schema::hasColumn('invoice_payments','amount') && !DB::select(DB::raw("SHOW INDEXES FROM invoice_payments WHERE key_name='invoice_payments_amount_index'"))) {
							$table->index('amount');
						}  
					});
				}

          
                

                
                   // add indexs to invoice_payments
				if(Schema::hasTable('invoice_payments')) {
					Schema::table('invoice_payments', function (Blueprint $table) {
						if (Schema::hasColumn('invoice_payments','invoice_id') && !DB::select(DB::raw("SHOW INDEXES FROM invoice_payments WHERE key_name='invoice_payments_invoice_id_index'"))) {
							$table->index('invoice_id');
						} 
						if (Schema::hasColumn('invoice_payments','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM invoice_payments WHERE key_name='invoice_payments_member_id_index'"))) {
							$table->index('member_id');
						} 
						if (Schema::hasColumn('invoice_payments','bank_id') && !DB::select(DB::raw("SHOW INDEXES FROM invoice_payments WHERE key_name='invoice_payments_bank_id_index'"))) {
							$table->index('bank_id');
						}
                        if (Schema::hasColumn('invoice_payments','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM invoice_payments WHERE key_name='invoice_payments_user_id_index'"))) {
							$table->index('user_id');
						} 
						if (Schema::hasColumn('invoice_payments','date') && !DB::select(DB::raw("SHOW INDEXES FROM invoice_payments WHERE key_name='invoice_payments_date_index'"))) {
							$table->index('date');
						}
                        if (Schema::hasColumn('invoice_payments','amount') && !DB::select(DB::raw("SHOW INDEXES FROM invoice_payments WHERE key_name='invoice_payments_amount_index'"))) {
							$table->index('amount');
						}  
					});
				}



                   
                   // add indexs to item_expense_outs
				if(Schema::hasTable('item_expense_outs')) {
					Schema::table('item_expense_outs', function (Blueprint $table) {
						if (Schema::hasColumn('item_expense_outs','type') && !DB::select(DB::raw("SHOW INDEXES FROM item_expense_outs WHERE key_name='item_expense_outs_type_index'"))) {
							$table->index('type');
						} 
						if (Schema::hasColumn('item_expense_outs','type_id') && !DB::select(DB::raw("SHOW INDEXES FROM item_expense_outs WHERE key_name='item_expense_outs_type_id_index'"))) {
							$table->index('type_id');
						} 
						if (Schema::hasColumn('item_expense_outs','transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM item_expense_outs WHERE key_name='item_expense_outs_transaction_id_index'"))) {
							$table->index('transaction_id');
						}
                        if (Schema::hasColumn('item_expense_outs','stock_id') && !DB::select(DB::raw("SHOW INDEXES FROM item_expense_outs WHERE key_name='item_expense_outs_stock_id_index'"))) {
							$table->index('stock_id');
						} 
						if (Schema::hasColumn('item_expense_outs','item_expense_id') && !DB::select(DB::raw("SHOW INDEXES FROM item_expense_outs WHERE key_name='item_expense_outs_item_expense_id_index'"))) {
							$table->index('item_expense_id');
						}
                        if (Schema::hasColumn('item_expense_outs','cost_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM item_expense_outs WHERE key_name='item_expense_outs_cost_transaction_id_index'"))) {
							$table->index('cost_transaction_id');
						}  if (Schema::hasColumn('item_expense_outs','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM item_expense_outs WHERE key_name='item_expense_outs_company_id_index'"))) {
							$table->index('company_id');
						} 
					});
				}


                   // add indexs to item_ex_categories_list
				if(Schema::hasTable('item_ex_categories_list')) {
					Schema::table('item_ex_categories_list', function (Blueprint $table) {
						if (Schema::hasColumn('item_ex_categories_list','item_expense_id') && !DB::select(DB::raw("SHOW INDEXES FROM item_ex_categories_list WHERE key_name='item_ex_categories_list_item_expense_id_index'"))) {
							$table->index('item_expense_id');
						} 
						if (Schema::hasColumn('item_ex_categories_list','item_expense_category_id') && !DB::select(DB::raw("SHOW INDEXES FROM item_ex_categories_list WHERE key_name='item_ex_categories_list_item_expense_category_id_index'"))) {
							$table->index('item_expense_category_id');
						} 
						if (Schema::hasColumn('item_ex_categories_list','amount') && !DB::select(DB::raw("SHOW INDEXES FROM item_ex_categories_list WHERE key_name='item_ex_categories_list_amount_index'"))) {
							$table->index('amount');
						}
                        if (Schema::hasColumn('item_ex_categories_list','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM item_ex_categories_list WHERE key_name='item_ex_categories_list_company_id_index'"))) {
							$table->index('company_id');
						} 
						if (Schema::hasColumn('item_ex_categories_list','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM item_ex_categories_list WHERE key_name='item_ex_categories_list_user_id_index'"))) {
							$table->index('user_id');
						}
					});
				}



                // add indexs to item_none_costs
				if(Schema::hasTable('item_none_costs')) {
					Schema::table('item_none_costs', function (Blueprint $table) {
						if (Schema::hasColumn('item_none_costs','account_id') && !DB::select(DB::raw("SHOW INDEXES FROM item_none_costs WHERE key_name='item_none_costs_account_id_index'"))) {
							$table->index('account_id');
						} 
						if (Schema::hasColumn('item_none_costs','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM item_none_costs WHERE key_name='item_none_costs_company_id_index'"))) {
							$table->index('company_id');
						} 
						if (Schema::hasColumn('item_none_costs','category_id') && !DB::select(DB::raw("SHOW INDEXES FROM item_none_costs WHERE key_name='item_none_costs_category_id_index'"))) {
							$table->index('category_id');
						}
                        if (Schema::hasColumn('item_none_costs','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM item_none_costs WHERE key_name='item_none_costs_user_id_index'"))) {
							$table->index('user_id');
						} 
						if (Schema::hasColumn('item_none_costs','type') && !DB::select(DB::raw("SHOW INDEXES FROM item_none_costs WHERE key_name='item_none_costs_type_index'"))) {
							$table->index('type');
						}
                        if (Schema::hasColumn('item_none_costs','contract_id') && !DB::select(DB::raw("SHOW INDEXES FROM item_none_costs WHERE key_name='item_none_costs_contract_id_index'"))) {
							$table->index('contract_id');
						}
					});
				}






                 // add indexs to item_none_cost_details
				if(Schema::hasTable('item_none_cost_details')) {
					Schema::table('item_none_cost_details', function (Blueprint $table) {
						if (Schema::hasColumn('item_none_cost_details','item_none_cost_id') && !DB::select(DB::raw("SHOW INDEXES FROM item_none_cost_details WHERE key_name='item_none_cost_details_item_none_cost_id_index'"))) {
							$table->index('item_none_cost_id');
						} 
						if (Schema::hasColumn('item_none_cost_details','asset_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM item_none_cost_details WHERE key_name='item_none_cost_details_asset_transaction_index'"))) {
							$table->index('asset_transaction');
						} 
						if (Schema::hasColumn('item_none_cost_details','cost_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM item_none_cost_details WHERE key_name='item_none_cost_details_cost_transaction_index'"))) {
							$table->index('cost_transaction');
						}
                        if (Schema::hasColumn('item_none_cost_details','site_id') && !DB::select(DB::raw("SHOW INDEXES FROM item_none_cost_details WHERE key_name='item_none_cost_details_site_id_index'"))) {
							$table->index('site_id');
						} 
						if (Schema::hasColumn('item_none_cost_details','um_id') && !DB::select(DB::raw("SHOW INDEXES FROM item_none_cost_details WHERE key_name='item_none_cost_details_um_id_index'"))) {
							$table->index('um_id');
						}
                        if (Schema::hasColumn('item_none_cost_details','inventory_id') && !DB::select(DB::raw("SHOW INDEXES FROM item_none_cost_details WHERE key_name='item_none_cost_details_inventory_id_index'"))) {
							$table->index('inventory_id');
						}

                        if (Schema::hasColumn('item_none_cost_details','inventory_category_id') && !DB::select(DB::raw("SHOW INDEXES FROM item_none_cost_details WHERE key_name='item_none_cost_details_inventory_category_id_index'"))) {
							$table->index('inventory_category_id');
						} 
						if (Schema::hasColumn('item_none_cost_details','quantity') && !DB::select(DB::raw("SHOW INDEXES FROM item_none_cost_details WHERE key_name='item_none_cost_details_quantity_index'"))) {
							$table->index('quantity');
						}
                        if (Schema::hasColumn('item_none_cost_details','m_stock_id') && !DB::select(DB::raw("SHOW INDEXES FROM item_none_cost_details WHERE key_name='item_none_cost_details_m_stock_id_index'"))) {
							$table->index('m_stock_id');
						}
					});
				}





             // add indexs to item_type_payrolls
				if(Schema::hasTable('item_type_payrolls')) {
					Schema::table('item_type_payrolls', function (Blueprint $table) {
						if (Schema::hasColumn('item_type_payrolls','name') && !DB::select(DB::raw("SHOW INDEXES FROM item_type_payrolls WHERE key_name='item_type_payrolls_name_index'"))) {
							$table->index('name');
						} 
						if (Schema::hasColumn('item_type_payrolls','account_id') && !DB::select(DB::raw("SHOW INDEXES FROM item_type_payrolls WHERE key_name='item_type_payrolls_account_id_index'"))) {
							$table->index('account_id');
						} 
						if (Schema::hasColumn('item_type_payrolls','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM item_type_payrolls WHERE key_name='item_type_payrolls_company_id_index'"))) {
							$table->index('company_id');
						}
					});
				}




                   // add indexs to item_type_payrolls
				if(Schema::hasTable('item_type_payrolls')) {
					Schema::table('item_type_payrolls', function (Blueprint $table) {
						if (Schema::hasColumn('item_type_payrolls','name') && !DB::select(DB::raw("SHOW INDEXES FROM item_type_payrolls WHERE key_name='item_type_payrolls_name_index'"))) {
							$table->index('name');
						} 
						if (Schema::hasColumn('item_type_payrolls','account_id') && !DB::select(DB::raw("SHOW INDEXES FROM item_type_payrolls WHERE key_name='item_type_payrolls_account_id_index'"))) {
							$table->index('account_id');
						} 
						if (Schema::hasColumn('item_type_payrolls','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM item_type_payrolls WHERE key_name='item_type_payrolls_company_id_index'"))) {
							$table->index('company_id');
						}
						if (Schema::hasColumn('item_type_payrolls','type') && !DB::select(DB::raw("SHOW INDEXES FROM item_type_payrolls WHERE key_name='item_type_payrolls_type_index'"))) {
							$table->index('type');
						} 
					});
				}



                   // add indexs to journal_entries
				if(Schema::hasTable('journal_entries')) {
					Schema::table('journal_entries', function (Blueprint $table) {
						if (Schema::hasColumn('journal_entries','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM journal_entries WHERE key_name='journal_entries_member_id_index'"))) {
							$table->index('member_id');
						} 
						if (Schema::hasColumn('journal_entries','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM journal_entries WHERE key_name='journal_entries_company_id_index'"))) {
							$table->index('company_id');
						} 
						if (Schema::hasColumn('journal_entries','number') && !DB::select(DB::raw("SHOW INDEXES FROM journal_entries WHERE key_name='journal_entries_number_index'"))) {
							$table->index('number');
						}if (Schema::hasColumn('journal_entries','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM journal_entries WHERE key_name='journal_entries_user_id_index'"))) {
							$table->index('user_id');
						}
					});
				}





                    // add indexs to journal_entry_details
				if(Schema::hasTable('journal_entry_details')) {
					Schema::table('journal_entry_details', function (Blueprint $table) {
						if (Schema::hasColumn('journal_entry_details','journal_id') && !DB::select(DB::raw("SHOW INDEXES FROM journal_entry_details WHERE key_name='journal_entry_details_journal_id_index'"))) {
							$table->index('journal_id');
						} 
						if (Schema::hasColumn('journal_entry_details','transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM journal_entry_details WHERE key_name='journal_entry_details_transaction_id_index'"))) {
							$table->index('transaction_id');
						} 
						if (Schema::hasColumn('journal_entry_details','account_id') && !DB::select(DB::raw("SHOW INDEXES FROM journal_entry_details WHERE key_name='journal_entry_details_account_id_index'"))) {
							$table->index('account_id');
						}if (Schema::hasColumn('journal_entry_details','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM journal_entry_details WHERE key_name='journal_entry_details_company_id_index'"))) {
							$table->index('company_id');
						}
                        if (Schema::hasColumn('journal_entry_details','project_id') && !DB::select(DB::raw("SHOW INDEXES FROM journal_entry_details WHERE key_name='journal_entry_details_project_id_index'"))) {
							$table->index('project_id');
						} 
						if (Schema::hasColumn('journal_entry_details','close_year_equity_id') && !DB::select(DB::raw("SHOW INDEXES FROM journal_entry_details WHERE key_name='journal_entry_details_close_year_equity_id_index'"))) {
							$table->index('close_year_equity_id');
						}
					});
				}




                    // add indexs to laboratories
				if(Schema::hasTable('laboratories')) {
					Schema::table('laboratories', function (Blueprint $table) {
						if (Schema::hasColumn('laboratories','number') && !DB::select(DB::raw("SHOW INDEXES FROM laboratories WHERE key_name='laboratories_number_index'"))) {
							$table->index('number');
						} 
						if (Schema::hasColumn('laboratories','vehicle_number') && !DB::select(DB::raw("SHOW INDEXES FROM laboratories WHERE key_name='laboratories_vehicle_number_index'"))) {
							$table->index('vehicle_number');
						} 
						if (Schema::hasColumn('laboratories','item_id') && !DB::select(DB::raw("SHOW INDEXES FROM laboratories WHERE key_name='laboratories_item_id_index'"))) {
							$table->index('item_id');
						}if (Schema::hasColumn('laboratories','um_id') && !DB::select(DB::raw("SHOW INDEXES FROM laboratories WHERE key_name='laboratories_um_id_index'"))) {
							$table->index('um_id');
						}
                        if (Schema::hasColumn('laboratories','foreign_data_id') && !DB::select(DB::raw("SHOW INDEXES FROM laboratories WHERE key_name='laboratories_foreign_data_id_index'"))) {
							$table->index('foreign_data_id');
						} 
						if (Schema::hasColumn('laboratories','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM laboratories WHERE key_name='laboratories_user_id_index'"))) {
							$table->index('user_id');
						}
                        if (Schema::hasColumn('laboratories','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM laboratories WHERE key_name='laboratories_company_id_index'"))) {
							$table->index('company_id');
						} 
						if (Schema::hasColumn('laboratories','type_detail_id') && !DB::select(DB::raw("SHOW INDEXES FROM laboratories WHERE key_name='laboratories_type_detail_id_index'"))) {
							$table->index('type_detail_id');
						}
						if (Schema::hasColumn('laboratories','type') && !DB::select(DB::raw("SHOW INDEXES FROM laboratories WHERE key_name='laboratories_type_index'"))) {
							$table->index('type');
						}
					});
				}



                     // add indexs to laboratory_details
				if(Schema::hasTable('laboratory_details')) {
					Schema::table('laboratory_details', function (Blueprint $table) {
						if (Schema::hasColumn('laboratory_details','qty') && !DB::select(DB::raw("SHOW INDEXES FROM laboratory_details WHERE key_name='laboratory_details_qty_index'"))) {
							$table->index('qty');
						} 
						if (Schema::hasColumn('laboratory_details','laboratory_id') && !DB::select(DB::raw("SHOW INDEXES FROM laboratory_details WHERE key_name='laboratory_details_laboratory_id_index'"))) {
							$table->index('laboratory_id');
						} 
						if (Schema::hasColumn('laboratory_details','laboratory_test_id') && !DB::select(DB::raw("SHOW INDEXES FROM laboratory_details WHERE key_name='laboratory_details_laboratory_test_id_index'"))) {
							$table->index('laboratory_test_id');
						}if (Schema::hasColumn('laboratory_details','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM laboratory_details WHERE key_name='laboratory_details_user_id_index'"))) {
							$table->index('user_id');
						}
                        if (Schema::hasColumn('laboratory_details','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM laboratory_details WHERE key_name='laboratory_details_company_id_index'"))) {
							$table->index('company_id');
						} 
					});
				}



                     // add indexs to laboratory_tests
				if(Schema::hasTable('laboratory_tests')) {
					Schema::table('laboratory_tests', function (Blueprint $table) {
						if (Schema::hasColumn('laboratory_tests','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM laboratory_tests WHERE key_name='laboratory_tests_user_id_index'"))) {
							$table->index('user_id');
						} 
						if (Schema::hasColumn('laboratory_tests','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM laboratory_tests WHERE key_name='laboratory_tests_company_id_index'"))) {
							$table->index('company_id');
						}  
					});
				}


                       // add indexs to leaves
				if(Schema::hasTable('leaves')) {
					Schema::table('leaves', function (Blueprint $table) {
						if (Schema::hasColumn('leaves','number') && !DB::select(DB::raw("SHOW INDEXES FROM leaves WHERE key_name='leaves_number_index'"))) {
							$table->index('number');
						} 
						if (Schema::hasColumn('leaves','code') && !DB::select(DB::raw("SHOW INDEXES FROM leaves WHERE key_name='leaves_code_index'"))) {
							$table->index('code');
						}  

                        if (Schema::hasColumn('leaves','type') && !DB::select(DB::raw("SHOW INDEXES FROM leaves WHERE key_name='leaves_type_index'"))) {
							$table->index('type');
						} 
						if (Schema::hasColumn('leaves','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM leaves WHERE key_name='leaves_member_id_index'"))) {
							$table->index('member_id');
						}  

                        if (Schema::hasColumn('leaves','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM leaves WHERE key_name='leaves_company_id_index'"))) {
							$table->index('company_id');
						} 
						if (Schema::hasColumn('leaves','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM leaves WHERE key_name='leaves_user_id_index'"))) {
							$table->index('user_id');
						}  
					});
				}


                
                       // add indexs to litters
				if(Schema::hasTable('litters')) {
					Schema::table('litters', function (Blueprint $table) {
						if (Schema::hasColumn('litters','number') && !DB::select(DB::raw("SHOW INDEXES FROM litters WHERE key_name='litters_number_index'"))) {
							$table->index('number');
						} 
						if (Schema::hasColumn('litters','reference_department_id') && !DB::select(DB::raw("SHOW INDEXES FROM litters WHERE key_name='litters_reference_department_id_index'"))) {
							$table->index('reference_department_id');
						}  

                        if (Schema::hasColumn('litters','litter_tittle_id') && !DB::select(DB::raw("SHOW INDEXES FROM litters WHERE key_name='litters_litter_tittle_id_index'"))) {
							$table->index('litter_tittle_id');
						} 
						if (Schema::hasColumn('litters','litter_category_id') && !DB::select(DB::raw("SHOW INDEXES FROM litters WHERE key_name='litters_litter_category_id_index'"))) {
							$table->index('litter_category_id');
						}  

                        if (Schema::hasColumn('litters','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM litters WHERE key_name='litters_user_id_index'"))) {
							$table->index('user_id');
						} 
						if (Schema::hasColumn('litters','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM litters WHERE key_name='litters_company_id_index'"))) {
							$table->index('company_id');
						}  
                        if (Schema::hasColumn('litters','financial_class_id') && !DB::select(DB::raw("SHOW INDEXES FROM litters WHERE key_name='litters_financial_class_id_index'"))) {
							$table->index('financial_class_id');
						}
					});
				}
                



                    // add indexs to litters
				if(Schema::hasTable('litters')) {
					Schema::table('litters', function (Blueprint $table) {
						if (Schema::hasColumn('litters','number') && !DB::select(DB::raw("SHOW INDEXES FROM litters WHERE key_name='litters_number_index'"))) {
							$table->index('number');
						} 
						if (Schema::hasColumn('litters','reference_department_id') && !DB::select(DB::raw("SHOW INDEXES FROM litters WHERE key_name='litters_reference_department_id_index'"))) {
							$table->index('reference_department_id');
						}  

                        if (Schema::hasColumn('litters','litter_tittle_id') && !DB::select(DB::raw("SHOW INDEXES FROM litters WHERE key_name='litters_litter_tittle_id_index'"))) {
							$table->index('litter_tittle_id');
						} 
						if (Schema::hasColumn('litters','litter_category_id') && !DB::select(DB::raw("SHOW INDEXES FROM litters WHERE key_name='litters_litter_category_id_index'"))) {
							$table->index('litter_category_id');
						}  

                        if (Schema::hasColumn('litters','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM litters WHERE key_name='litters_user_id_index'"))) {
							$table->index('user_id');
						} 
						if (Schema::hasColumn('litters','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM litters WHERE key_name='litters_company_id_index'"))) {
							$table->index('company_id');
						}  
                        if (Schema::hasColumn('litters','financial_class_id') && !DB::select(DB::raw("SHOW INDEXES FROM litters WHERE key_name='litters_financial_class_id_index'"))) {
							$table->index('financial_class_id');
						}
					});
				}




                


             // add indexs to main_stocks
             if(Schema::hasTable('main_stocks') ) {
				Schema::table('main_stocks', function (Blueprint $table) {
					if (Schema::hasColumn('main_stocks','date_in') && !DB::select(DB::raw("SHOW INDEXES FROM main_stocks WHERE key_name='main_stocks_date_in_index'"))) {
						$table->index('date_in');
					}
					if (Schema::hasColumn('main_stocks','qut_in') && !DB::select(DB::raw("SHOW INDEXES FROM main_stocks WHERE key_name='main_stocks_qut_in_index'"))) {
						$table->index('qut_in');
					} 
                    if (Schema::hasColumn('main_stocks','cost') && !DB::select(DB::raw("SHOW INDEXES FROM main_stocks WHERE key_name='main_stocks_cost_index'"))) {
						$table->index('cost');
					}
					if (Schema::hasColumn('main_stocks','status') && !DB::select(DB::raw("SHOW INDEXES FROM main_stocks WHERE key_name='main_stocks_status_index'"))) {
						$table->index('status');
					} 
                    if (Schema::hasColumn('main_stocks','expire_date') && !DB::select(DB::raw("SHOW INDEXES FROM main_stocks WHERE key_name='main_stocks_expire_date_index'"))) {
						$table->index('expire_date');
					}
					if (Schema::hasColumn('main_stocks','other_measure') && !DB::select(DB::raw("SHOW INDEXES FROM main_stocks WHERE key_name='main_stocks_other_measure_index'"))) {
						$table->index('other_measure');
					} 
                    if (Schema::hasColumn('main_stocks','expense_cost') && !DB::select(DB::raw("SHOW INDEXES FROM main_stocks WHERE key_name='main_stocks_expense_cost_index'"))) {
						$table->index('expense_cost');
					}
					if (Schema::hasColumn('main_stocks','type') && !DB::select(DB::raw("SHOW INDEXES FROM main_stocks WHERE key_name='main_stocks_type_index'"))) {
						$table->index('type');
					} 
                     
				});
			}
            

            
             // add indexs to member_contacts
             if(Schema::hasTable('member_contacts') ) {
				Schema::table('member_contacts', function (Blueprint $table) {
					if (Schema::hasColumn('member_contacts','number') && !DB::select(DB::raw("SHOW INDEXES FROM member_contacts WHERE key_name='member_contacts_number_index'"))) {
						$table->index('number');
					}
					if (Schema::hasColumn('member_contacts','ss_id') && !DB::select(DB::raw("SHOW INDEXES FROM member_contacts WHERE key_name='member_contacts_ss_id_index'"))) {
						$table->index('ss_id');
					} 
                    if (Schema::hasColumn('member_contacts','passport') && !DB::select(DB::raw("SHOW INDEXES FROM member_contacts WHERE key_name='member_contacts_passport_index'"))) {
						$table->index('passport');
					}
					if (Schema::hasColumn('member_contacts','member_contact_class_id') && !DB::select(DB::raw("SHOW INDEXES FROM member_contacts WHERE key_name='member_contacts_member_contact_class_id_index'"))) {
						$table->index('member_contact_class_id');
					} 
                    if (Schema::hasColumn('member_contacts','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM member_contacts WHERE key_name='member_contacts_company_id_index'"))) {
						$table->index('company_id');
					}
					if (Schema::hasColumn('member_contacts','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM member_contacts WHERE key_name='member_contacts_user_id_index'"))) {
						$table->index('user_id');
					}  
				});
			}


               // add indexs to member_exchanges
               if(Schema::hasTable('member_exchanges') ) {
				Schema::table('member_exchanges', function (Blueprint $table) {
					if (Schema::hasColumn('member_exchanges','type') && !DB::select(DB::raw("SHOW INDEXES FROM member_exchanges WHERE key_name='member_exchanges_type_index'"))) {
						$table->index('type');
					}
					if (Schema::hasColumn('member_exchanges','number') && !DB::select(DB::raw("SHOW INDEXES FROM member_exchanges WHERE key_name='member_exchanges_number_index'"))) {
						$table->index('number');
					} 
                    if (Schema::hasColumn('member_exchanges','ref_no') && !DB::select(DB::raw("SHOW INDEXES FROM member_exchanges WHERE key_name='member_exchanges_ref_no_index'"))) {
						$table->index('ref_no');
					}
					if (Schema::hasColumn('member_exchanges','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM member_exchanges WHERE key_name='member_exchanges_member_id_index'"))) {
						$table->index('member_id');
					} 
                    if (Schema::hasColumn('member_exchanges','payable_tran_id') && !DB::select(DB::raw("SHOW INDEXES FROM member_exchanges WHERE key_name='member_exchanges_payable_tran_id_index'"))) {
						$table->index('payable_tran_id');
					}
					if (Schema::hasColumn('member_exchanges','receivable_tran_id') && !DB::select(DB::raw("SHOW INDEXES FROM member_exchanges WHERE key_name='member_exchanges_receivable_tran_id_index'"))) {
						$table->index('receivable_tran_id');
					} 
                    if (Schema::hasColumn('member_exchanges','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM member_exchanges WHERE key_name='member_exchanges_user_id_index'"))) {
						$table->index('user_id');
					}
					if (Schema::hasColumn('member_exchanges','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM member_exchanges WHERE key_name='member_exchanges_company_id_index'"))) {
						$table->index('company_id');
					}   
				});
			}








			    // add indexs to member_guarantor
				if(Schema::hasTable('member_guarantor') ) {
					Schema::table('member_guarantor', function (Blueprint $table) {
						if (Schema::hasColumn('member_guarantor','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM member_guarantor WHERE key_name='member_guarantor_member_id_index'"))) {
							$table->index('member_id');
						}
						if (Schema::hasColumn('member_guarantor','name') && !DB::select(DB::raw("SHOW INDEXES FROM member_guarantor WHERE key_name='member_guarantor_name_index'"))) {
							$table->index('name');
						} 
						if (Schema::hasColumn('member_guarantor','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM member_guarantor WHERE key_name='member_guarantor_company_id_index'"))) {
							$table->index('company_id');
						}  
					});
				}



				  // add indexs to member_informations
				  if(Schema::hasTable('member_informations') ) {
					Schema::table('member_informations', function (Blueprint $table) {
						if (Schema::hasColumn('member_informations','city') && !DB::select(DB::raw("SHOW INDEXES FROM member_informations WHERE key_name='member_informations_city_index'"))) {
							$table->index('city');
						}
						if (Schema::hasColumn('member_informations','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM member_informations WHERE key_name='member_informations_member_id_index'"))) {
							$table->index('member_id');
						} 
						if (Schema::hasColumn('member_informations','class_id') && !DB::select(DB::raw("SHOW INDEXES FROM member_informations WHERE key_name='member_informations_class_id_index'"))) {
							$table->index('class_id');
						}  
						if (Schema::hasColumn('member_informations','transport_company_id') && !DB::select(DB::raw("SHOW INDEXES FROM member_informations WHERE key_name='member_informations_transport_company_id_index'"))) {
							$table->index('transport_company_id');
						}  
					});
				}



				  // add indexs to member_job_titles
				  if(Schema::hasTable('member_job_titles') ) {
					Schema::table('member_job_titles', function (Blueprint $table) {
						if (Schema::hasColumn('member_job_titles','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM member_job_titles WHERE key_name='member_job_titles_member_id_index'"))) {
							$table->index('member_id');
						}
						if (Schema::hasColumn('member_job_titles','job_title_id') && !DB::select(DB::raw("SHOW INDEXES FROM member_job_titles WHERE key_name='member_job_titles_job_title_id_index'"))) {
							$table->index('job_title_id');
						} 
						if (Schema::hasColumn('member_job_titles','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM member_job_titles WHERE key_name='member_job_titles_company_id_index'"))) {
							$table->index('company_id');
						}  
					});
				}



				  // add indexs to member_journals
				  if(Schema::hasTable('member_journals') ) {
					Schema::table('member_journals', function (Blueprint $table) {
						if (Schema::hasColumn('member_journals','type_id') && !DB::select(DB::raw("SHOW INDEXES FROM member_journals WHERE key_name='member_journals_type_id_index'"))) {
							$table->index('type_id');
						}
						if (Schema::hasColumn('member_journals','journal_id') && !DB::select(DB::raw("SHOW INDEXES FROM member_journals WHERE key_name='member_journals_journal_id_index'"))) {
							$table->index('journal_id');
						} 
						if (Schema::hasColumn('member_journals','type') && !DB::select(DB::raw("SHOW INDEXES FROM member_journals WHERE key_name='member_journals_type_index'"))) {
							$table->index('type');
						}  if (Schema::hasColumn('member_journals','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM member_journals WHERE key_name='member_journals_company_id_index'"))) {
							$table->index('company_id');
						}
					});
				}



				  // add indexs to member_journals
				  if(Schema::hasTable('member_journals') ) {
					Schema::table('member_journals', function (Blueprint $table) {
						if (Schema::hasColumn('member_journals','type_id') && !DB::select(DB::raw("SHOW INDEXES FROM member_journals WHERE key_name='member_journals_type_id_index'"))) {
							$table->index('type_id');
						}
						if (Schema::hasColumn('member_journals','journal_id') && !DB::select(DB::raw("SHOW INDEXES FROM member_journals WHERE key_name='member_journals_journal_id_index'"))) {
							$table->index('journal_id');
						} 
						if (Schema::hasColumn('member_journals','type') && !DB::select(DB::raw("SHOW INDEXES FROM member_journals WHERE key_name='member_journals_type_index'"))) {
							$table->index('type');
						}  if (Schema::hasColumn('member_journals','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM member_journals WHERE key_name='member_journals_company_id_index'"))) {
							$table->index('company_id');
						}
					});
				}


				  // add indexs to member_opening_balances
				  if(Schema::hasTable('member_opening_balances') ) {
					Schema::table('member_opening_balances', function (Blueprint $table) {
						if (Schema::hasColumn('member_opening_balances','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM member_opening_balances WHERE key_name='member_opening_balances_member_id_index'"))) {
							$table->index('member_id');
						}
						if (Schema::hasColumn('member_opening_balances','transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM member_opening_balances WHERE key_name='member_opening_balances_transaction_id_index'"))) {
							$table->index('transaction_id');
						} 
						if (Schema::hasColumn('member_opening_balances','opening_id') && !DB::select(DB::raw("SHOW INDEXES FROM member_opening_balances WHERE key_name='member_opening_balances_opening_id_index'"))) {
							$table->index('opening_id');
						}  if (Schema::hasColumn('member_opening_balances','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM member_opening_balances WHERE key_name='member_opening_balances_company_id_index'"))) {
							$table->index('company_id');
						}
					});
				}



				// add indexs to member_parents
				if(Schema::hasTable('member_parents') ) {
				Schema::table('member_parents', function (Blueprint $table) {
					if (Schema::hasColumn('member_parents','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM member_parents WHERE key_name='member_parents_member_id_index'"))) {
						$table->index('member_id');
					}
					if (Schema::hasColumn('member_parents','parent_id') && !DB::select(DB::raw("SHOW INDEXES FROM member_parents WHERE key_name='member_parents_parent_id_index'"))) {
						$table->index('parent_id');
					} 
					if (Schema::hasColumn('member_parents','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM member_parents WHERE key_name='member_parents_user_id_index'"))) {
						$table->index('user_id');
					}  if (Schema::hasColumn('member_parents','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM member_parents WHERE key_name='member_parents_company_id_index'"))) {
						$table->index('company_id');
					}
				});
			}


			// add indexs to member_payable_levels
			if(Schema::hasTable('member_payable_levels') ) {
				Schema::table('member_payable_levels', function (Blueprint $table) {
					if (Schema::hasColumn('member_payable_levels','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM member_payable_levels WHERE key_name='member_payable_levels_member_id_index'"))) {
						$table->index('member_id');
					}
					if (Schema::hasColumn('member_payable_levels','amount') && !DB::select(DB::raw("SHOW INDEXES FROM member_payable_levels WHERE key_name='member_payable_levels_amount_index'"))) {
						$table->index('amount');
					} 
					if (Schema::hasColumn('member_payable_levels','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM member_payable_levels WHERE key_name='member_payable_levels_company_id_index'"))) {
						$table->index('company_id');
					} 
				});
			}


			// add indexs to member_transactions
			if(Schema::hasTable('member_transactions') ) {
				Schema::table('member_transactions', function (Blueprint $table) {
					if (Schema::hasColumn('member_transactions','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM member_transactions WHERE key_name='member_transactions_member_id_index'"))) {
						$table->index('member_id');
					}
					if (Schema::hasColumn('member_transactions','transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM member_transactions WHERE key_name='member_transactions_transaction_id_index'"))) {
						$table->index('transaction_id');
					}  
				});
			}



			// add indexs to member_transfers
			if(Schema::hasTable('member_transfers') ) {
				Schema::table('member_transfers', function (Blueprint $table) {
					if (Schema::hasColumn('member_transfers','from_member_id') && !DB::select(DB::raw("SHOW INDEXES FROM member_transfers WHERE key_name='member_transfers_from_member_id_index'"))) {
						$table->index('from_member_id');
					}
					if (Schema::hasColumn('member_transfers','to_member_id') && !DB::select(DB::raw("SHOW INDEXES FROM member_transfers WHERE key_name='member_transfers_to_member_id_index'"))) {
						$table->index('to_member_id');
					}  
					if (Schema::hasColumn('member_transfers','from_sale_id') && !DB::select(DB::raw("SHOW INDEXES FROM member_transfers WHERE key_name='member_transfers_from_sale_id_index'"))) {
						$table->index('from_sale_id');
					}
					if (Schema::hasColumn('member_transfers','from_purchase_id') && !DB::select(DB::raw("SHOW INDEXES FROM member_transfers WHERE key_name='member_transfers_from_purchase_id_index'"))) {
						$table->index('from_purchase_id');
					}
					
					if (Schema::hasColumn('member_transfers','to_sale_id') && !DB::select(DB::raw("SHOW INDEXES FROM member_transfers WHERE key_name='member_transfers_to_sale_id_index'"))) {
						$table->index('to_sale_id');
					}  
					if (Schema::hasColumn('member_transfers','to_purchase_id') && !DB::select(DB::raw("SHOW INDEXES FROM member_transfers WHERE key_name='member_transfers_to_purchase_id_index'"))) {
						$table->index('to_purchase_id');
					}
					if (Schema::hasColumn('member_transfers','date') && !DB::select(DB::raw("SHOW INDEXES FROM member_transfers WHERE key_name='member_transfers_date_index'"))) {
						$table->index('date');
					}if (Schema::hasColumn('member_transfers','currency') && !DB::select(DB::raw("SHOW INDEXES FROM member_transfers WHERE key_name='member_transfers_currency_index'"))) {
						$table->index('currency');
					}  
					if (Schema::hasColumn('member_transfers','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM member_transfers WHERE key_name='member_transfers_company_id_index'"))) {
						$table->index('company_id');
					}
					if (Schema::hasColumn('member_transfers','contract_id') && !DB::select(DB::raw("SHOW INDEXES FROM member_transfers WHERE key_name='member_transfers_contract_id_index'"))) {
						$table->index('contract_id');
					} 
					if (Schema::hasColumn('member_transfers','number') && !DB::select(DB::raw("SHOW INDEXES FROM member_transfers WHERE key_name='member_transfers_number_index'"))) {
						$table->index('number');
					} 
				});
			}
				

			// add indexs to menus
			if(Schema::hasTable('menus') ) {
				Schema::table('menus', function (Blueprint $table) {
					if (Schema::hasColumn('menus','name') && !DB::select(DB::raw("SHOW INDEXES FROM menus WHERE key_name='menus_name_index'"))) {
						$table->index('name');
					}
					if (Schema::hasColumn('menus','parent_id') && !DB::select(DB::raw("SHOW INDEXES FROM menus WHERE key_name='menus_parent_id_index'"))) {
						$table->index('parent_id');
					} 
					if (Schema::hasColumn('menus','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM menus WHERE key_name='menus_company_id_index'"))) {
						$table->index('company_id');
					} 
				});
			}
	


			// add indexs to menu_columns
			if(Schema::hasTable('menu_columns') ) {
				Schema::table('menu_columns', function (Blueprint $table) {
					if (Schema::hasColumn('menu_columns','menu_id') && !DB::select(DB::raw("SHOW INDEXES FROM menu_columns WHERE key_name='menu_columns_menu_id_index'"))) {
						$table->index('menu_id');
					}
					if (Schema::hasColumn('menu_columns','column_name') && !DB::select(DB::raw("SHOW INDEXES FROM menu_columns WHERE key_name='menu_columns_column_name_index'"))) {
						$table->index('column_name');
					} 
					if (Schema::hasColumn('menu_columns','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM menu_columns WHERE key_name='menu_columns_company_id_index'"))) {
						$table->index('company_id');
					} 
				});
			}


			// add indexs to menu_menu_columns
			if(Schema::hasTable('menu_menu_columns') ) {
				Schema::table('menu_menu_columns', function (Blueprint $table) {
					if (Schema::hasColumn('menu_menu_columns','menu_id') && !DB::select(DB::raw("SHOW INDEXES FROM menu_menu_columns WHERE key_name='menu_menu_columns_menu_id_index'"))) {
						$table->index('menu_id');
					}
					if (Schema::hasColumn('menu_menu_columns','column_id') && !DB::select(DB::raw("SHOW INDEXES FROM menu_menu_columns WHERE key_name='menu_menu_columns_column_id_index'"))) {
						$table->index('column_id');
					} 
					if (Schema::hasColumn('menu_menu_columns','type') && !DB::select(DB::raw("SHOW INDEXES FROM menu_menu_columns WHERE key_name='menu_menu_columns_type_index'"))) {
						$table->index('type');
					} 
				});
			}


			// add indexs to menu_menu_columns
			if(Schema::hasTable('menu_menu_columns') ) {
				Schema::table('menu_menu_columns', function (Blueprint $table) {
					if (Schema::hasColumn('menu_menu_columns','menu_id') && !DB::select(DB::raw("SHOW INDEXES FROM menu_menu_columns WHERE key_name='menu_menu_columns_menu_id_index'"))) {
						$table->index('menu_id');
					}
					if (Schema::hasColumn('menu_menu_columns','column_id') && !DB::select(DB::raw("SHOW INDEXES FROM menu_menu_columns WHERE key_name='menu_menu_columns_column_id_index'"))) {
						$table->index('column_id');
					} 
					if (Schema::hasColumn('menu_menu_columns','type') && !DB::select(DB::raw("SHOW INDEXES FROM menu_menu_columns WHERE key_name='menu_menu_columns_type_index'"))) {
						$table->index('type');
					} 
				});
			}


			// add indexs to m_stocks_in
			if(Schema::hasTable('m_stocks_in') ) {
				Schema::table('m_stocks_in', function (Blueprint $table) {
					if (Schema::hasColumn('m_stocks_in','widths') && !DB::select(DB::raw("SHOW INDEXES FROM m_stocks_in WHERE key_name='m_stocks_in_widths_index'"))) {
						$table->index('widths');
					}
					if (Schema::hasColumn('m_stocks_in','code') && !DB::select(DB::raw("SHOW INDEXES FROM m_stocks_in WHERE key_name='m_stocks_in_code_index'"))) {
						$table->index('code');
					}  

					if (Schema::hasColumn('m_stocks_in','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM m_stocks_in WHERE key_name='m_stocks_in_company_id_index'"))) {
						$table->index('company_id');
					}
					if (Schema::hasColumn('m_stocks_in','qut_in') && !DB::select(DB::raw("SHOW INDEXES FROM m_stocks_in WHERE key_name='m_stocks_in_qut_in_index'"))) {
						$table->index('qut_in');
					} 
					if (Schema::hasColumn('m_stocks_in','cost') && !DB::select(DB::raw("SHOW INDEXES FROM m_stocks_in WHERE key_name='m_stocks_in_cost_index'"))) {
						$table->index('cost');
					}

					if (Schema::hasColumn('m_stocks_in','status') && !DB::select(DB::raw("SHOW INDEXES FROM m_stocks_in WHERE key_name='m_stocks_in_status_index'"))) {
						$table->index('status');
					}
					if (Schema::hasColumn('m_stocks_in','expire_date') && !DB::select(DB::raw("SHOW INDEXES FROM m_stocks_in WHERE key_name='m_stocks_in_expire_date_index'"))) {
						$table->index('expire_date');
					} 
					if (Schema::hasColumn('m_stocks_in','other_measure') && !DB::select(DB::raw("SHOW INDEXES FROM m_stocks_in WHERE key_name='m_stocks_in_other_measure_index'"))) {
						$table->index('other_measure');
					}
					if (Schema::hasColumn('m_stocks_in','khada') && !DB::select(DB::raw("SHOW INDEXES FROM m_stocks_in WHERE key_name='m_stocks_in_khada_index'"))) {
						$table->index('khada');
					} 
					if (Schema::hasColumn('m_stocks_in','price') && !DB::select(DB::raw("SHOW INDEXES FROM m_stocks_in WHERE key_name='m_stocks_in_price_index'"))) {
						$table->index('price');
					}
					
					if (Schema::hasColumn('m_stocks_in','other_measure2') && !DB::select(DB::raw("SHOW INDEXES FROM m_stocks_in WHERE key_name='m_stocks_in_other_measure2_index'"))) {
						$table->index('other_measure2');
					}  
					if (Schema::hasColumn('m_stocks_in','edit_type') && !DB::select(DB::raw("SHOW INDEXES FROM m_stocks_in WHERE key_name='m_stocks_in_edit_type_index'"))) {
						$table->index('edit_type');
					} 
				});
			}



			// add indexs to m_stocks_out
			if(Schema::hasTable('m_stocks_out') ) {
				Schema::table('m_stocks_out', function (Blueprint $table) {
					if (Schema::hasColumn('m_stocks_out','date_out') && !DB::select(DB::raw("SHOW INDEXES FROM m_stocks_out WHERE key_name='m_stocks_out_date_out_index'"))) {
						$table->index('date_out');
					}
					if (Schema::hasColumn('m_stocks_out','qut_out') && !DB::select(DB::raw("SHOW INDEXES FROM m_stocks_out WHERE key_name='m_stocks_out_qut_out_index'"))) {
						$table->index('qut_out');
					}  

					if (Schema::hasColumn('m_stocks_out','sales_price') && !DB::select(DB::raw("SHOW INDEXES FROM m_stocks_out WHERE key_name='m_stocks_out_sales_price_index'"))) {
						$table->index('sales_price');
					}
					if (Schema::hasColumn('m_stocks_out','status') && !DB::select(DB::raw("SHOW INDEXES FROM m_stocks_out WHERE key_name='m_stocks_out_status_index'"))) {
						$table->index('status');
					} 
					if (Schema::hasColumn('m_stocks_out','khada') && !DB::select(DB::raw("SHOW INDEXES FROM m_stocks_out WHERE key_name='m_stocks_out_khada_index'"))) {
						$table->index('khada');
					}

					if (Schema::hasColumn('m_stocks_out','type') && !DB::select(DB::raw("SHOW INDEXES FROM m_stocks_out WHERE key_name='m_stocks_out_type_index'"))) {
						$table->index('type');
					}
					if (Schema::hasColumn('m_stocks_out','other_measure') && !DB::select(DB::raw("SHOW INDEXES FROM m_stocks_out WHERE key_name='m_stocks_out_other_measure_index'"))) {
						$table->index('other_measure');
					} 
					if (Schema::hasColumn('m_stocks_out','other_measure2') && !DB::select(DB::raw("SHOW INDEXES FROM m_stocks_out WHERE key_name='m_stocks_out_other_measure2_index'"))) {
						$table->index('other_measure2');
					}
					if (Schema::hasColumn('m_stocks_out','width') && !DB::select(DB::raw("SHOW INDEXES FROM m_stocks_out WHERE key_name='m_stocks_out_width_index'"))) {
						$table->index('width');
					} 
					if (Schema::hasColumn('m_stocks_out','price_of_khada') && !DB::select(DB::raw("SHOW INDEXES FROM m_stocks_out WHERE key_name='m_stocks_out_price_of_khada_index'"))) {
						$table->index('price_of_khada');
					} 
				});
			}

			// add indexs to new_custom_reports
			if(Schema::hasTable('new_custom_reports') ) {
				Schema::table('new_custom_reports', function (Blueprint $table) {
					if (Schema::hasColumn('new_custom_reports','part_name') && !DB::select(DB::raw("SHOW INDEXES FROM new_custom_reports WHERE key_name='new_custom_reports_part_name_index'"))) {
						$table->index('part_name');
					}
					if (Schema::hasColumn('new_custom_reports','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM new_custom_reports WHERE key_name='new_custom_reports_company_id_index'"))) {
						$table->index('company_id');
					}  

					if (Schema::hasColumn('new_custom_reports','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM new_custom_reports WHERE key_name='new_custom_reports_user_id_index'"))) {
						$table->index('user_id');
					}
					if (Schema::hasColumn('new_custom_reports','percent') && !DB::select(DB::raw("SHOW INDEXES FROM new_custom_reports WHERE key_name='new_custom_reports_percent_index'"))) {
						$table->index('percent');
					}
				});
			}

			// add indexs to ngo_projects
			if(Schema::hasTable('ngo_projects') ) {
				Schema::table('ngo_projects', function (Blueprint $table) {
					if (Schema::hasColumn('ngo_projects','name') && !DB::select(DB::raw("SHOW INDEXES FROM ngo_projects WHERE key_name='ngo_projects_name_index'"))) {
						$table->index('name');
					}
					if (Schema::hasColumn('ngo_projects','code') && !DB::select(DB::raw("SHOW INDEXES FROM ngo_projects WHERE key_name='ngo_projects_code_index'"))) {
						$table->index('code');
					}  

					if (Schema::hasColumn('ngo_projects','ref_no') && !DB::select(DB::raw("SHOW INDEXES FROM ngo_projects WHERE key_name='ngo_projects_ref_no_index'"))) {
						$table->index('ref_no');
					}
					if (Schema::hasColumn('ngo_projects','start_date') && !DB::select(DB::raw("SHOW INDEXES FROM ngo_projects WHERE key_name='ngo_projects_start_date_index'"))) {
						$table->index('start_date');
					}

					if (Schema::hasColumn('ngo_projects','end_date') && !DB::select(DB::raw("SHOW INDEXES FROM ngo_projects WHERE key_name='ngo_projects_end_date_index'"))) {
						$table->index('end_date');
					}if (Schema::hasColumn('ngo_projects','status') && !DB::select(DB::raw("SHOW INDEXES FROM ngo_projects WHERE key_name='ngo_projects_status_index'"))) {
						$table->index('status');
					}
					if (Schema::hasColumn('ngo_projects','category_id') && !DB::select(DB::raw("SHOW INDEXES FROM ngo_projects WHERE key_name='ngo_projects_category_id_index'"))) {
						$table->index('category_id');
					}if (Schema::hasColumn('ngo_projects','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM ngo_projects WHERE key_name='ngo_projects_user_id_index'"))) {
						$table->index('user_id');
					}if (Schema::hasColumn('ngo_projects','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM ngo_projects WHERE key_name='ngo_projects_company_id_index'"))) {
						$table->index('company_id');
					}
					if (Schema::hasColumn('ngo_projects','amount') && !DB::select(DB::raw("SHOW INDEXES FROM ngo_projects WHERE key_name='ngo_projects_amount_index'"))) {
						$table->index('amount');
					}
 
				});
			}



			// add indexs to n_project_donator
			if(Schema::hasTable('n_project_donator') ) {
				Schema::table('n_project_donator', function (Blueprint $table) {
					if (Schema::hasColumn('n_project_donator','donator_id') && !DB::select(DB::raw("SHOW INDEXES FROM n_project_donator WHERE key_name='n_project_donator_donator_id_index'"))) {
						$table->index('donator_id');
					}
					if (Schema::hasColumn('n_project_donator','ngo_project_id') && !DB::select(DB::raw("SHOW INDEXES FROM n_project_donator WHERE key_name='n_project_donator_ngo_project_id_index'"))) {
						$table->index('ngo_project_id');
					}  

					if (Schema::hasColumn('n_project_donator','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM n_project_donator WHERE key_name='n_project_donator_user_id_index'"))) {
						$table->index('user_id');
					}
					if (Schema::hasColumn('n_project_donator','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM n_project_donator WHERE key_name='n_project_donator_company_id_index'"))) {
						$table->index('company_id');
					}
				});
			}



			// add indexs to n_pro_orders
			if(Schema::hasTable('n_pro_orders') ) {
				Schema::table('n_pro_orders', function (Blueprint $table) {
					if (Schema::hasColumn('n_pro_orders','number') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_orders WHERE key_name='n_pro_orders_number_index'"))) {
						$table->index('number');
					}
					if (Schema::hasColumn('n_pro_orders','ref_no') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_orders WHERE key_name='n_pro_orders_ref_no_index'"))) {
						$table->index('ref_no');
					}if (Schema::hasColumn('n_pro_orders','date') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_orders WHERE key_name='n_pro_orders_date_index'"))) {
						$table->index('date');
					}
					if (Schema::hasColumn('n_pro_orders','type') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_orders WHERE key_name='n_pro_orders_type_index'"))) {
						$table->index('type');
					}
					if (Schema::hasColumn('n_pro_orders','currency') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_orders WHERE key_name='n_pro_orders_currency_index'"))) {
						$table->index('currency');
					}
					if (Schema::hasColumn('n_pro_orders','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_orders WHERE key_name='n_pro_orders_member_id_index'"))) {
						$table->index('member_id');
					}
					if (Schema::hasColumn('n_pro_orders','category_id') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_orders WHERE key_name='n_pro_orders_category_id_index'"))) {
						$table->index('category_id');
					}
					if (Schema::hasColumn('n_pro_orders','ngo_project_id') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_orders WHERE key_name='n_pro_orders_ngo_project_id_index'"))) {
						$table->index('ngo_project_id');
					}

					if (Schema::hasColumn('n_pro_orders','driver_id') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_orders WHERE key_name='n_pro_orders_driver_id_index'"))) {
						$table->index('driver_id');
					}
					if (Schema::hasColumn('n_pro_orders','vehicle_id') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_orders WHERE key_name='n_pro_orders_vehicle_id_index'"))) {
						$table->index('vehicle_id');
					}
					if (Schema::hasColumn('n_pro_orders','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_orders WHERE key_name='n_pro_orders_user_id_index'"))) {
						$table->index('user_id');
					}
					if (Schema::hasColumn('n_pro_orders','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_orders WHERE key_name='n_pro_orders_company_id_index'"))) {
						$table->index('company_id');
					}
				});
			}

			// add indexs to n_pro_order_cycle_memoes
			if(Schema::hasTable('n_pro_order_cycle_memoes') ) {
				Schema::table('n_pro_order_cycle_memoes', function (Blueprint $table) {
					if (Schema::hasColumn('n_pro_order_cycle_memoes','type') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_cycle_memoes WHERE key_name='n_pro_order_cycle_memoes_type_index'"))) {
						$table->index('type');
					}
					if (Schema::hasColumn('n_pro_order_cycle_memoes','date') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_cycle_memoes WHERE key_name='n_pro_order_cycle_memoes_date_index'"))) {
						$table->index('date');
					}  

					if (Schema::hasColumn('n_pro_order_cycle_memoes','pro_order_id') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_cycle_memoes WHERE key_name='n_pro_order_cycle_memoes_pro_order_id_index'"))) {
						$table->index('pro_order_id');
					}
					if (Schema::hasColumn('n_pro_order_cycle_memoes','position_id') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_cycle_memoes WHERE key_name='n_pro_order_cycle_memoes_position_id_index'"))) {
						$table->index('position_id');
					}if (Schema::hasColumn('n_pro_order_cycle_memoes','parent_id') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_cycle_memoes WHERE key_name='n_pro_order_cycle_memoes_parent_id_index'"))) {
						$table->index('parent_id');
					}
					if (Schema::hasColumn('n_pro_order_cycle_memoes','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_cycle_memoes WHERE key_name='n_pro_order_cycle_memoes_user_id_index'"))) {
						$table->index('user_id');
					}
					if (Schema::hasColumn('n_pro_order_cycle_memoes','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_cycle_memoes WHERE key_name='n_pro_order_cycle_memoes_company_id_index'"))) {
						$table->index('company_id');
					}
				});
			}




			// add indexs to n_pro_order_details
			if(Schema::hasTable('n_pro_order_details') ) {
				Schema::table('n_pro_order_details', function (Blueprint $table) {
					if (Schema::hasColumn('n_pro_order_details','quantity') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_details WHERE key_name='n_pro_order_details_quantity_index'"))) {
						$table->index('quantity');
					}
					if (Schema::hasColumn('n_pro_order_details','um_id') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_details WHERE key_name='n_pro_order_details_um_id_index'"))) {
						$table->index('um_id');
					}  

					if (Schema::hasColumn('n_pro_order_details','price') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_details WHERE key_name='n_pro_order_details_price_index'"))) {
						$table->index('price');
					}
					if (Schema::hasColumn('n_pro_order_details','purchase_price') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_details WHERE key_name='n_pro_order_details_purchase_price_index'"))) {
						$table->index('purchase_price');
					}if (Schema::hasColumn('n_pro_order_details','pro_order_id') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_details WHERE key_name='n_pro_order_details_pro_order_id_index'"))) {
						$table->index('pro_order_id');
					}
					if (Schema::hasColumn('n_pro_order_details','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_details WHERE key_name='n_pro_order_details_user_id_index'"))) {
						$table->index('user_id');
					}
					if (Schema::hasColumn('n_pro_order_details','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_details WHERE key_name='n_pro_order_details_company_id_index'"))) {
						$table->index('company_id');
					}
					if (Schema::hasColumn('n_pro_order_details','type') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_details WHERE key_name='n_pro_order_details_type_index'"))) {
						$table->index('type');
					}
					if (Schema::hasColumn('n_pro_order_details','site_id') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_details WHERE key_name='n_pro_order_details_site_id_index'"))) {
						$table->index('site_id');
					}
					if (Schema::hasColumn('n_pro_order_details','inventory_id') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_details WHERE key_name='n_pro_order_details_inventory_id_index'"))) {
						$table->index('inventory_id');
					}
				});
			}



			// add indexs to n_pro_order_quotations
			if(Schema::hasTable('n_pro_order_quotations') ) {
				Schema::table('n_pro_order_quotations', function (Blueprint $table) {
					if (Schema::hasColumn('n_pro_order_quotations','number') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_quotations WHERE key_name='n_pro_order_quotations_number_index'"))) {
						$table->index('number');
					}
					if (Schema::hasColumn('n_pro_order_quotations','ref_no') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_quotations WHERE key_name='n_pro_order_quotations_ref_no_index'"))) {
						$table->index('ref_no');
					}  

					if (Schema::hasColumn('n_pro_order_quotations','date') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_quotations WHERE key_name='n_pro_order_quotations_date_index'"))) {
						$table->index('date');
					}
					if (Schema::hasColumn('n_pro_order_quotations','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_quotations WHERE key_name='n_pro_order_quotations_member_id_index'"))) {
						$table->index('member_id');
					}if (Schema::hasColumn('n_pro_order_quotations','ngo_project_id') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_quotations WHERE key_name='n_pro_order_quotations_ngo_project_id_index'"))) {
						$table->index('ngo_project_id');
					}
					if (Schema::hasColumn('n_pro_order_quotations','pro_order_id') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_quotations WHERE key_name='n_pro_order_quotations_pro_order_id_index'"))) {
						$table->index('pro_order_id');
					}
					if (Schema::hasColumn('n_pro_order_quotations','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_quotations WHERE key_name='n_pro_order_quotations_user_id_index'"))) {
						$table->index('user_id');
					}
					if (Schema::hasColumn('n_pro_order_quotations','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_quotations WHERE key_name='n_pro_order_quotations_company_id_index'"))) {
						$table->index('company_id');
					}
				});
			}



			// add indexs to n_pro_order_quotation_details
			if(Schema::hasTable('n_pro_order_quotation_details') ) {
				Schema::table('n_pro_order_quotation_details', function (Blueprint $table) {
					if (Schema::hasColumn('n_pro_order_quotation_details','um_id') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_quotation_details WHERE key_name='n_pro_order_quotation_details_um_id_index'"))) {
						$table->index('um_id');
					}
					if (Schema::hasColumn('n_pro_order_quotation_details','purchase_price') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_quotation_details WHERE key_name='n_pro_order_quotation_details_purchase_price_index'"))) {
						$table->index('purchase_price');
					}  

					if (Schema::hasColumn('n_pro_order_quotation_details','order_quotation_id') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_quotation_details WHERE key_name='n_pro_order_quotation_details_order_quotation_id_index'"))) {
						$table->index('order_quotation_id');
					}
					if (Schema::hasColumn('n_pro_order_quotation_details','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_quotation_details WHERE key_name='n_pro_order_quotation_details_user_id_index'"))) {
						$table->index('user_id');
					}if (Schema::hasColumn('n_pro_order_quotation_details','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_quotation_details WHERE key_name='n_pro_order_quotation_details_company_id_index'"))) {
						$table->index('company_id');
					} 
				});
			}




			// add indexs to n_pro_order_receive_and_pay
			if(Schema::hasTable('n_pro_order_receive_and_pay') ) {
				Schema::table('n_pro_order_receive_and_pay', function (Blueprint $table) {
					if (Schema::hasColumn('n_pro_order_receive_and_pay','number') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_receive_and_pay WHERE key_name='n_pro_order_receive_and_pay_number_index'"))) {
						$table->index('number');
					}
					if (Schema::hasColumn('n_pro_order_receive_and_pay','ref_no') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_receive_and_pay WHERE key_name='n_pro_order_receive_and_pay_ref_no_index'"))) {
						$table->index('ref_no');
					}if (Schema::hasColumn('n_pro_order_receive_and_pay','date') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_receive_and_pay WHERE key_name='n_pro_order_receive_and_pay_date_index'"))) {
						$table->index('date');
					}if (Schema::hasColumn('n_pro_order_receive_and_pay','bank_account_id') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_receive_and_pay WHERE key_name='n_pro_order_receive_and_pay_bank_account_id_index'"))) {
						$table->index('bank_account_id');
					}if (Schema::hasColumn('n_pro_order_receive_and_pay','vendor_id') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_receive_and_pay WHERE key_name='n_pro_order_receive_and_pay_vendor_id_index'"))) {
						$table->index('vendor_id');
					} if (Schema::hasColumn('n_pro_order_receive_and_pay','currency') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_receive_and_pay WHERE key_name='n_pro_order_receive_and_pay_currency_index'"))) {
						$table->index('currency');
					}
					if (Schema::hasColumn('n_pro_order_receive_and_pay','type') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_receive_and_pay WHERE key_name='n_pro_order_receive_and_pay_type_index'"))) {
						$table->index('type');
					}if (Schema::hasColumn('n_pro_order_receive_and_pay','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_receive_and_pay WHERE key_name='n_pro_order_receive_and_pay_member_id_index'"))) {
						$table->index('member_id');
					} if (Schema::hasColumn('n_pro_order_receive_and_pay','pro_order_id') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_receive_and_pay WHERE key_name='n_pro_order_receive_and_pay_pro_order_id_index'"))) {
						$table->index('pro_order_id');
					} if (Schema::hasColumn('n_pro_order_receive_and_pay','ngo_project_id') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_receive_and_pay WHERE key_name='n_pro_order_receive_and_pay_ngo_project_id_index'"))) {
						$table->index('ngo_project_id');
					}
					if (Schema::hasColumn('n_pro_order_receive_and_pay','transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_receive_and_pay WHERE key_name='n_pro_order_receive_and_pay_transaction_id_index'"))) {
						$table->index('transaction_id');
					}if (Schema::hasColumn('n_pro_order_receive_and_pay','expense_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_receive_and_pay WHERE key_name='n_pro_order_receive_and_pay_expense_transaction_id_index'"))) {
						$table->index('expense_transaction_id');
					} 

					if (Schema::hasColumn('n_pro_order_receive_and_pay','driver_id') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_receive_and_pay WHERE key_name='n_pro_order_receive_and_pay_driver_id_index'"))) {
						$table->index('driver_id');
					} if (Schema::hasColumn('n_pro_order_receive_and_pay','vehicle_id') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_receive_and_pay WHERE key_name='n_pro_order_receive_and_pay_vehicle_id_index'"))) {
						$table->index('vehicle_id');
					}
					if (Schema::hasColumn('n_pro_order_receive_and_pay','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_receive_and_pay WHERE key_name='n_pro_order_receive_and_pay_user_id_index'"))) {
						$table->index('user_id');
					}if (Schema::hasColumn('n_pro_order_receive_and_pay','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_receive_and_pay WHERE key_name='n_pro_order_receive_and_pay_company_id_index'"))) {
						$table->index('company_id');
					} 
				});
			}



			// add indexs to n_pro_order_receive_and_pay_details
			if(Schema::hasTable('n_pro_order_receive_and_pay_details') ) {
				Schema::table('n_pro_order_receive_and_pay_details', function (Blueprint $table) {
					if (Schema::hasColumn('n_pro_order_receive_and_pay_details','quantity') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_receive_and_pay_details WHERE key_name='n_pro_order_receive_and_pay_details_quantity_index'"))) {
						$table->index('quantity');
					}
					if (Schema::hasColumn('n_pro_order_receive_and_pay_details','um_id') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_receive_and_pay_details WHERE key_name='n_pro_order_receive_and_pay_details_um_id_index'"))) {
						$table->index('um_id');
					} if (Schema::hasColumn('n_pro_order_receive_and_pay_details','price') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_receive_and_pay_details WHERE key_name='n_pro_order_receive_and_pay_details_price_index'"))) {
						$table->index('price');
					}
					if (Schema::hasColumn('n_pro_order_receive_and_pay_details','order_receive_and_pay_id') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_receive_and_pay_details WHERE key_name='nporpd_ora_pay_id'"))) {
						$table->index('order_receive_and_pay_id', 'nporpd_ora_pay_id');
					}if (Schema::hasColumn('n_pro_order_receive_and_pay_details','pro_order_details_id') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_receive_and_pay_details WHERE key_name='nporpd_po_details_id'"))) {
						$table->index('pro_order_details_id', 'nporpd_po_details_id');
					}
					if (Schema::hasColumn('n_pro_order_receive_and_pay_details','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_receive_and_pay_details WHERE key_name='n_pro_order_receive_and_pay_details_user_id_index'"))) {
						$table->index('user_id');
					} if (Schema::hasColumn('n_pro_order_receive_and_pay_details','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_receive_and_pay_details WHERE key_name='n_pro_order_receive_and_pay_details_company_id_index'"))) {
						$table->index('company_id');
					}
					if (Schema::hasColumn('n_pro_order_receive_and_pay_details','site_id') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_receive_and_pay_details WHERE key_name='n_pro_order_receive_and_pay_details_site_id_index'"))) {
						$table->index('site_id');
					}if (Schema::hasColumn('n_pro_order_receive_and_pay_details','inventory_id') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_receive_and_pay_details WHERE key_name='n_pro_order_receive_and_pay_details_inventory_id_index'"))) {
						$table->index('inventory_id');
					}if (Schema::hasColumn('n_pro_order_receive_and_pay_details','asset_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_receive_and_pay_details WHERE key_name='nporpd_asset_transaction'"))) {
						$table->index('asset_transaction', 'nporpd_asset_transaction');
					}  
				});
			}
	



			// add indexs to n_pro_order_receive_and_pay_stock_outs
			if(Schema::hasTable('n_pro_order_receive_and_pay_stock_outs') ) {
				Schema::table('n_pro_order_receive_and_pay_stock_outs', function (Blueprint $table) {
					if (Schema::hasColumn('n_pro_order_receive_and_pay_stock_outs','order_receive_and_pay_id') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_receive_and_pay_stock_outs WHERE key_name='nporpso_ora_pay_od'"))) {
						$table->index('order_receive_and_pay_id', 'nporpso_ora_pay_od');
					}
					if (Schema::hasColumn('n_pro_order_receive_and_pay_stock_outs','stock_out_id') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_receive_and_pay_stock_outs WHERE key_name='n_pro_order_receive_and_pay_stock_outs_stock_out_id_index'"))) {
						$table->index('stock_out_id');
					} if (Schema::hasColumn('n_pro_order_receive_and_pay_stock_outs','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_receive_and_pay_stock_outs WHERE key_name='n_pro_order_receive_and_pay_stock_outs_user_id_index'"))) {
						$table->index('user_id');
					}
					if (Schema::hasColumn('n_pro_order_receive_and_pay_stock_outs','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM n_pro_order_receive_and_pay_stock_outs WHERE key_name='n_pro_order_receive_and_pay_stock_outs_company_id_index'"))) {
						$table->index('company_id');
					}   
				});
			}
	


			// add indexs to oil_parts
			if(Schema::hasTable('oil_parts') ) {
				Schema::table('oil_parts', function (Blueprint $table) {
					if (Schema::hasColumn('oil_parts','number') && !DB::select(DB::raw("SHOW INDEXES FROM oil_parts WHERE key_name='oil_parts_number_index'"))) {
						$table->index('number');
					}
					if (Schema::hasColumn('oil_parts','sale_number') && !DB::select(DB::raw("SHOW INDEXES FROM oil_parts WHERE key_name='oil_parts_sale_number_index'"))) {
						$table->index('sale_number');
					} if (Schema::hasColumn('oil_parts','employee_id') && !DB::select(DB::raw("SHOW INDEXES FROM oil_parts WHERE key_name='oil_parts_employee_id_index'"))) {
						$table->index('employee_id');
					}
					if (Schema::hasColumn('oil_parts','site_id') && !DB::select(DB::raw("SHOW INDEXES FROM oil_parts WHERE key_name='oil_parts_site_id_index'"))) {
						$table->index('site_id');
					}if (Schema::hasColumn('oil_parts','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM oil_parts WHERE key_name='oil_parts_company_id_index'"))) {
						$table->index('company_id');
					} 
					if (Schema::hasColumn('oil_parts','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM oil_parts WHERE key_name='oil_parts_user_id_index'"))) {
						$table->index('user_id');
					}
				});
			}
	


			// add indexs to online_item
			if(Schema::hasTable('online_item') ) {
				Schema::table('online_item', function (Blueprint $table) {
					if (Schema::hasColumn('online_item','item_id') && !DB::select(DB::raw("SHOW INDEXES FROM online_item WHERE key_name='online_item_item_id_index'"))) {
						$table->index('item_id');
					}
					if (Schema::hasColumn('online_item','name') && !DB::select(DB::raw("SHOW INDEXES FROM online_item WHERE key_name='online_item_name_index'"))) {
						$table->index('name');
					} if (Schema::hasColumn('online_item','price') && !DB::select(DB::raw("SHOW INDEXES FROM online_item WHERE key_name='online_item_price_index'"))) {
						$table->index('price');
					}
					if (Schema::hasColumn('online_item','category_id') && !DB::select(DB::raw("SHOW INDEXES FROM online_item WHERE key_name='online_item_category_id_index'"))) {
						$table->index('category_id');
					}if (Schema::hasColumn('online_item','brand_id') && !DB::select(DB::raw("SHOW INDEXES FROM online_item WHERE key_name='online_item_brand_id_index'"))) {
						$table->index('brand_id');
					} 
					if (Schema::hasColumn('online_item','um_id') && !DB::select(DB::raw("SHOW INDEXES FROM online_item WHERE key_name='online_item_um_id_index'"))) {
						$table->index('um_id');
					}
					if (Schema::hasColumn('online_item','currency') && !DB::select(DB::raw("SHOW INDEXES FROM online_item WHERE key_name='online_item_currency_index'"))) {
						$table->index('currency');
					} 
					if (Schema::hasColumn('online_item','type') && !DB::select(DB::raw("SHOW INDEXES FROM online_item WHERE key_name='online_item_type_index'"))) {
						$table->index('type');
					}

					if (Schema::hasColumn('online_item','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM online_item WHERE key_name='online_item_company_id_index'"))) {
						$table->index('company_id');
					}
					if (Schema::hasColumn('online_item','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM online_item WHERE key_name='online_item_user_id_index'"))) {
						$table->index('user_id');
					} 
					if (Schema::hasColumn('online_item','um_name') && !DB::select(DB::raw("SHOW INDEXES FROM online_item WHERE key_name='online_item_um_name_index'"))) {
						$table->index('um_name');
					}
				});
			}



			// add indexs to online_items
			if(Schema::hasTable('online_items') ) {
				Schema::table('online_items', function (Blueprint $table) {
					if (Schema::hasColumn('online_items','item_id') && !DB::select(DB::raw("SHOW INDEXES FROM online_items WHERE key_name='online_items_item_id_index'"))) {
						$table->index('item_id');
					}
					if (Schema::hasColumn('online_items','price') && !DB::select(DB::raw("SHOW INDEXES FROM online_items WHERE key_name='online_items_price_index'"))) {
						$table->index('price');
					} if (Schema::hasColumn('online_items','currency') && !DB::select(DB::raw("SHOW INDEXES FROM online_items WHERE key_name='online_items_currency_index'"))) {
						$table->index('currency');
					}
					if (Schema::hasColumn('online_items','type') && !DB::select(DB::raw("SHOW INDEXES FROM online_items WHERE key_name='online_items_type_index'"))) {
						$table->index('type');
					}if (Schema::hasColumn('online_items','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM online_items WHERE key_name='online_items_company_id_index'"))) {
						$table->index('company_id');
					} 
					if (Schema::hasColumn('online_items','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM online_items WHERE key_name='online_items_user_id_index'"))) {
						$table->index('user_id');
					}
				});
			}


			
			// add indexs to online_item_to_showes
			if(Schema::hasTable('online_item_to_showes') ) {
				Schema::table('online_item_to_showes', function (Blueprint $table) {
					if (Schema::hasColumn('online_item_to_showes','online_item_id') && !DB::select(DB::raw("SHOW INDEXES FROM online_item_to_showes WHERE key_name='online_item_to_showes_online_item_id_index'"))) {
						$table->index('online_item_id');
					}
					if (Schema::hasColumn('online_item_to_showes','type') && !DB::select(DB::raw("SHOW INDEXES FROM online_item_to_showes WHERE key_name='online_item_to_showes_type_index'"))) {
						$table->index('type');
					} if (Schema::hasColumn('online_item_to_showes','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM online_item_to_showes WHERE key_name='online_item_to_showes_company_id_index'"))) {
						$table->index('company_id');
					}
				});
			}



		// add indexs to online_order
		if(Schema::hasTable('online_order') ) {
			Schema::table('online_order', function (Blueprint $table) {
				if (Schema::hasColumn('online_order','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM online_order WHERE key_name='online_order_user_id_index'"))) {
					$table->index('user_id');
				}
				if (Schema::hasColumn('online_order','number') && !DB::select(DB::raw("SHOW INDEXES FROM online_order WHERE key_name='online_order_number_index'"))) {
					$table->index('number');
				} if (Schema::hasColumn('online_order','currency') && !DB::select(DB::raw("SHOW INDEXES FROM online_order WHERE key_name='online_order_currency_index'"))) {
					$table->index('currency');
				}
				if (Schema::hasColumn('online_order','date') && !DB::select(DB::raw("SHOW INDEXES FROM online_order WHERE key_name='online_order_date_index'"))) {
					$table->index('date');
				} if (Schema::hasColumn('online_order','delivery_date') && !DB::select(DB::raw("SHOW INDEXES FROM online_order WHERE key_name='online_order_delivery_date_index'"))) {
					$table->index('delivery_date');
				}
				if (Schema::hasColumn('online_order','type') && !DB::select(DB::raw("SHOW INDEXES FROM online_order WHERE key_name='online_order_type_index'"))) {
					$table->index('type');
				}
				if (Schema::hasColumn('online_order','status') && !DB::select(DB::raw("SHOW INDEXES FROM online_order WHERE key_name='online_order_status_index'"))) {
					$table->index('status');
				} if (Schema::hasColumn('online_order','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM online_order WHERE key_name='online_order_company_id_index'"))) {
					$table->index('company_id');
				}
			});
		}

		// add indexs to online_orders_item
		if(Schema::hasTable('online_orders_item') ) {
			Schema::table('online_orders_item', function (Blueprint $table) {
				if (Schema::hasColumn('online_orders_item','item_id') && !DB::select(DB::raw("SHOW INDEXES FROM online_orders_item WHERE key_name='online_orders_item_item_id_index'"))) {
					$table->index('item_id');
				}
				if (Schema::hasColumn('online_orders_item','session_id') && !DB::select(DB::raw("SHOW INDEXES FROM online_orders_item WHERE key_name='online_orders_item_session_id_index'"))) {
					$table->index('session_id');
				} if (Schema::hasColumn('online_orders_item','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM online_orders_item WHERE key_name='online_orders_item_user_id_index'"))) {
					$table->index('user_id');
				}
				if (Schema::hasColumn('online_orders_item','quantity') && !DB::select(DB::raw("SHOW INDEXES FROM online_orders_item WHERE key_name='online_orders_item_quantity_index'"))) {
					$table->index('quantity');
				} 
			});
		}



		// add indexs to online_order_detail
		if(Schema::hasTable('online_order_detail') ) {
			Schema::table('online_order_detail', function (Blueprint $table) {
				if (Schema::hasColumn('online_order_detail','order_id') && !DB::select(DB::raw("SHOW INDEXES FROM online_order_detail WHERE key_name='online_order_detail_order_id_index'"))) {
					$table->index('order_id');
				}
				if (Schema::hasColumn('online_order_detail','um_id') && !DB::select(DB::raw("SHOW INDEXES FROM online_order_detail WHERE key_name='online_order_detail_um_id_index'"))) {
					$table->index('um_id');
				} if (Schema::hasColumn('online_order_detail','quantity') && !DB::select(DB::raw("SHOW INDEXES FROM online_order_detail WHERE key_name='online_order_detail_quantity_index'"))) {
					$table->index('quantity');
				}
				if (Schema::hasColumn('online_order_detail','cost') && !DB::select(DB::raw("SHOW INDEXES FROM online_order_detail WHERE key_name='online_order_detail_cost_index'"))) {
					$table->index('cost');
				} 
				if (Schema::hasColumn('online_order_detail','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM online_order_detail WHERE key_name='online_order_detail_company_id_index'"))) {
					$table->index('company_id');
				}
				if (Schema::hasColumn('online_order_detail','item_id') && !DB::select(DB::raw("SHOW INDEXES FROM online_order_detail WHERE key_name='online_order_detail_item_id_index'"))) {
					$table->index('item_id');
				}
			});
		}



		// add indexs to online_order_details
		if(Schema::hasTable('online_order_details') ) {
			Schema::table('online_order_details', function (Blueprint $table) {
				if (Schema::hasColumn('online_order_details','order_id') && !DB::select(DB::raw("SHOW INDEXES FROM online_order_details WHERE key_name='online_order_details_order_id_index'"))) {
					$table->index('order_id');
				}
				if (Schema::hasColumn('online_order_details','um_id') && !DB::select(DB::raw("SHOW INDEXES FROM online_order_details WHERE key_name='online_order_details_um_id_index'"))) {
					$table->index('um_id');
				} if (Schema::hasColumn('online_order_details','quantity') && !DB::select(DB::raw("SHOW INDEXES FROM online_order_details WHERE key_name='online_order_details_quantity_index'"))) {
					$table->index('quantity');
				}
				if (Schema::hasColumn('online_order_details','cost') && !DB::select(DB::raw("SHOW INDEXES FROM online_order_details WHERE key_name='online_order_details_cost_index'"))) {
					$table->index('cost');
				} 
				if (Schema::hasColumn('online_order_details','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM online_order_details WHERE key_name='online_order_details_company_id_index'"))) {
					$table->index('company_id');
				} 
			});
		}
 
		// add indexs to online_order_records
		if(Schema::hasTable('online_order_records') ) {
			Schema::table('online_order_records', function (Blueprint $table) {
				if (Schema::hasColumn('online_order_records','order_id') && !DB::select(DB::raw("SHOW INDEXES FROM online_order_records WHERE key_name='online_order_records_order_id_index'"))) {
					$table->index('order_id');
				}
				if (Schema::hasColumn('online_order_records','order_detail_id') && !DB::select(DB::raw("SHOW INDEXES FROM online_order_records WHERE key_name='online_order_records_order_detail_id_index'"))) {
					$table->index('order_detail_id');
				} if (Schema::hasColumn('online_order_records','stock_out_id') && !DB::select(DB::raw("SHOW INDEXES FROM online_order_records WHERE key_name='online_order_records_stock_out_id_index'"))) {
					$table->index('stock_out_id');
				}
				if (Schema::hasColumn('online_order_records','m_stock_out_id') && !DB::select(DB::raw("SHOW INDEXES FROM online_order_records WHERE key_name='online_order_records_m_stock_out_id_index'"))) {
					$table->index('m_stock_out_id');
				} 
				if (Schema::hasColumn('online_order_records','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM online_order_records WHERE key_name='online_order_records_company_id_index'"))) {
					$table->index('company_id');
				} 
			});
		}
 
		// add indexs to online_system_config
		if(Schema::hasTable('online_system_config') ) {
			Schema::table('online_system_config', function (Blueprint $table) {
				if (Schema::hasColumn('online_system_config','company_name') && !DB::select(DB::raw("SHOW INDEXES FROM online_system_config WHERE key_name='online_system_config_company_name_index'"))) {
					$table->index('company_name');
				}
				if (Schema::hasColumn('online_system_config','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM online_system_config WHERE key_name='online_system_config_company_id_index'"))) {
					$table->index('company_id');
				} 
			});
		}



		// add indexs to overtimes
		if(Schema::hasTable('overtimes') ) {
			Schema::table('overtimes', function (Blueprint $table) {
				if (Schema::hasColumn('overtimes','employee_id') && !DB::select(DB::raw("SHOW INDEXES FROM overtimes WHERE key_name='overtimes_employee_id_index'"))) {
					$table->index('employee_id');
				}
				if (Schema::hasColumn('overtimes','overtime_type_id') && !DB::select(DB::raw("SHOW INDEXES FROM overtimes WHERE key_name='overtimes_overtime_type_id_index'"))) {
					$table->index('overtime_type_id');
				} 
				if (Schema::hasColumn('overtimes','date') && !DB::select(DB::raw("SHOW INDEXES FROM overtimes WHERE key_name='overtimes_date_index'"))) {
					$table->index('date');
				}
				if (Schema::hasColumn('overtimes','currency') && !DB::select(DB::raw("SHOW INDEXES FROM overtimes WHERE key_name='overtimes_currency_index'"))) {
					$table->index('currency');
				} 

				if (Schema::hasColumn('overtimes','status') && !DB::select(DB::raw("SHOW INDEXES FROM overtimes WHERE key_name='overtimes_status_index'"))) {
					$table->index('status');
				}
				if (Schema::hasColumn('overtimes','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM overtimes WHERE key_name='overtimes_company_id_index'"))) {
					$table->index('company_id');
				} 
				if (Schema::hasColumn('overtimes','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM overtimes WHERE key_name='overtimes_user_id_index'"))) {
					$table->index('user_id');
				}
				if (Schema::hasColumn('overtimes','requestovertime_id') && !DB::select(DB::raw("SHOW INDEXES FROM overtimes WHERE key_name='overtimes_requestovertime_id_index'"))) {
					$table->index('requestovertime_id');
				} 
			});
		}


			// add indexs to overtimes
			if(Schema::hasTable('overtimes') ) {
				Schema::table('overtimes', function (Blueprint $table) {
					if (Schema::hasColumn('overtimes','employee_id') && !DB::select(DB::raw("SHOW INDEXES FROM overtimes WHERE key_name='overtimes_employee_id_index'"))) {
						$table->index('employee_id');
					}
					if (Schema::hasColumn('overtimes','overtime_type_id') && !DB::select(DB::raw("SHOW INDEXES FROM overtimes WHERE key_name='overtimes_overtime_type_id_index'"))) {
						$table->index('overtime_type_id');
					} 
					if (Schema::hasColumn('overtimes','date') && !DB::select(DB::raw("SHOW INDEXES FROM overtimes WHERE key_name='overtimes_date_index'"))) {
						$table->index('date');
					}
					if (Schema::hasColumn('overtimes','currency') && !DB::select(DB::raw("SHOW INDEXES FROM overtimes WHERE key_name='overtimes_currency_index'"))) {
						$table->index('currency');
					} 
	
					if (Schema::hasColumn('overtimes','status') && !DB::select(DB::raw("SHOW INDEXES FROM overtimes WHERE key_name='overtimes_status_index'"))) {
						$table->index('status');
					}
					if (Schema::hasColumn('overtimes','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM overtimes WHERE key_name='overtimes_company_id_index'"))) {
						$table->index('company_id');
					} 
					if (Schema::hasColumn('overtimes','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM overtimes WHERE key_name='overtimes_user_id_index'"))) {
						$table->index('user_id');
					}
					if (Schema::hasColumn('overtimes','requestovertime_id') && !DB::select(DB::raw("SHOW INDEXES FROM overtimes WHERE key_name='overtimes_requestovertime_id_index'"))) {
						$table->index('requestovertime_id');
					} 
				});
			}

			


			// add indexs to overtime_types
		if(Schema::hasTable('overtime_types') ) {
			Schema::table('overtime_types', function (Blueprint $table) {
				if (Schema::hasColumn('overtime_types','name') && !DB::select(DB::raw("SHOW INDEXES FROM overtime_types WHERE key_name='overtime_types_name_index'"))) {
					$table->index('name');
				}
				if (Schema::hasColumn('overtime_types','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM overtime_types WHERE key_name='overtime_types_company_id_index'"))) {
					$table->index('company_id');
				}   
			});
		}


		// add indexs to package_details
		if(Schema::hasTable('package_details') ) {
			Schema::table('package_details', function (Blueprint $table) {
				if (Schema::hasColumn('package_details','package_id') && !DB::select(DB::raw("SHOW INDEXES FROM package_details WHERE key_name='package_details_package_id_index'"))) {
					$table->index('package_id');
				}
				if (Schema::hasColumn('package_details','build_id') && !DB::select(DB::raw("SHOW INDEXES FROM package_details WHERE key_name='package_details_build_id_index'"))) {
					$table->index('build_id');
				} 
				if (Schema::hasColumn('package_details','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM package_details WHERE key_name='package_details_company_id_index'"))) {
					$table->index('company_id');
				}     
			});
		}


		// add indexs to package_details
		if(Schema::hasTable('package_details') ) {
			Schema::table('package_details', function (Blueprint $table) {
				if (Schema::hasColumn('package_details','package_id') && !DB::select(DB::raw("SHOW INDEXES FROM package_details WHERE key_name='package_details_package_id_index'"))) {
					$table->index('package_id');
				}
				if (Schema::hasColumn('package_details','build_id') && !DB::select(DB::raw("SHOW INDEXES FROM package_details WHERE key_name='package_details_build_id_index'"))) {
					$table->index('build_id');
				} 
				if (Schema::hasColumn('package_details','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM package_details WHERE key_name='package_details_company_id_index'"))) {
					$table->index('company_id');
				}     
			});
		}


		// add indexs to payment_by_factors
		if(Schema::hasTable('payment_by_factors') ) {
			Schema::table('payment_by_factors', function (Blueprint $table) {
				if (Schema::hasColumn('payment_by_factors','number') && !DB::select(DB::raw("SHOW INDEXES FROM payment_by_factors WHERE key_name='payment_by_factors_number_index'"))) {
					$table->index('number');
				}
				if (Schema::hasColumn('payment_by_factors','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM payment_by_factors WHERE key_name='payment_by_factors_member_id_index'"))) {
					$table->index('member_id');
				} 
				if (Schema::hasColumn('payment_by_factors','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM payment_by_factors WHERE key_name='payment_by_factors_company_id_index'"))) {
					$table->index('company_id');
				} 
				if (Schema::hasColumn('payment_by_factors','date') && !DB::select(DB::raw("SHOW INDEXES FROM payment_by_factors WHERE key_name='payment_by_factors_date_index'"))) {
					$table->index('date');
				}
				if (Schema::hasColumn('payment_by_factors','currency') && !DB::select(DB::raw("SHOW INDEXES FROM payment_by_factors WHERE key_name='payment_by_factors_currency_index'"))) {
					$table->index('currency');
				} 
				if (Schema::hasColumn('payment_by_factors','account_id') && !DB::select(DB::raw("SHOW INDEXES FROM payment_by_factors WHERE key_name='payment_by_factors_account_id_index'"))) {
					$table->index('account_id');
				} 

				if (Schema::hasColumn('payment_by_factors','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM payment_by_factors WHERE key_name='payment_by_factors_user_id_index'"))) {
					$table->index('user_id');
				}
			});
		}
 
		// add indexs to payment_by_factor_details
		if(Schema::hasTable('payment_by_factor_details') ) {
			Schema::table('payment_by_factor_details', function (Blueprint $table) {
				if (Schema::hasColumn('payment_by_factor_details','payment_by_factor_id') && !DB::select(DB::raw("SHOW INDEXES FROM payment_by_factor_details WHERE key_name='payment_by_factor_details_payment_by_factor_id_index'"))) {
					$table->index('payment_by_factor_id');
				}
				if (Schema::hasColumn('payment_by_factor_details','purchase_payment_id') && !DB::select(DB::raw("SHOW INDEXES FROM payment_by_factor_details WHERE key_name='payment_by_factor_details_purchase_payment_id_index'"))) {
					$table->index('purchase_payment_id');
				} 
				if (Schema::hasColumn('payment_by_factor_details','gain_or_loss_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM payment_by_factor_details WHERE key_name='payment_by_factor_details_gain_or_loss_transaction_id_index'"))) {
					$table->index('gain_or_loss_transaction_id');
				} 
				if (Schema::hasColumn('payment_by_factor_details','gl_payable_id_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM payment_by_factor_details WHERE key_name='payment_by_factor_details_gl_payable_id_transaction_id_index'"))) {
					$table->index('gl_payable_id_transaction_id');
				}
				if (Schema::hasColumn('payment_by_factor_details','receivable_payments_id') && !DB::select(DB::raw("SHOW INDEXES FROM payment_by_factor_details WHERE key_name='payment_by_factor_details_receivable_payments_id_index'"))) {
					$table->index('receivable_payments_id');
				} 
			});
		}



		// add indexs to payment_by_factor_details
		if(Schema::hasTable('payment_by_factor_details') ) {
			Schema::table('payment_by_factor_details', function (Blueprint $table) {
				if (Schema::hasColumn('payment_by_factor_details','payment_by_factor_id') && !DB::select(DB::raw("SHOW INDEXES FROM payment_by_factor_details WHERE key_name='payment_by_factor_details_payment_by_factor_id_index'"))) {
					$table->index('payment_by_factor_id');
				}
				if (Schema::hasColumn('payment_by_factor_details','purchase_payment_id') && !DB::select(DB::raw("SHOW INDEXES FROM payment_by_factor_details WHERE key_name='payment_by_factor_details_purchase_payment_id_index'"))) {
					$table->index('purchase_payment_id');
				} 
				if (Schema::hasColumn('payment_by_factor_details','gain_or_loss_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM payment_by_factor_details WHERE key_name='payment_by_factor_details_gain_or_loss_transaction_id_index'"))) {
					$table->index('gain_or_loss_transaction_id');
				} 
				if (Schema::hasColumn('payment_by_factor_details','gl_payable_id_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM payment_by_factor_details WHERE key_name='payment_by_factor_details_gl_payable_id_transaction_id_index'"))) {
					$table->index('gl_payable_id_transaction_id');
				}
				if (Schema::hasColumn('payment_by_factor_details','receivable_payments_id') && !DB::select(DB::raw("SHOW INDEXES FROM payment_by_factor_details WHERE key_name='payment_by_factor_details_receivable_payments_id_index'"))) {
					$table->index('receivable_payments_id');
				} 
			});
		}


		// add indexs to payroll_forms
		if(Schema::hasTable('payroll_forms') ) {
			Schema::table('payroll_forms', function (Blueprint $table) {
				if (Schema::hasColumn('payroll_forms','amount') && !DB::select(DB::raw("SHOW INDEXES FROM payroll_forms WHERE key_name='payroll_forms_amount_index'"))) {
					$table->index('amount');
				}
				if (Schema::hasColumn('payroll_forms','currency') && !DB::select(DB::raw("SHOW INDEXES FROM payroll_forms WHERE key_name='payroll_forms_currency_index'"))) {
					$table->index('currency');
				} 
				if (Schema::hasColumn('payroll_forms','price_detail_id') && !DB::select(DB::raw("SHOW INDEXES FROM payroll_forms WHERE key_name='payroll_forms_price_detail_id_index'"))) {
					$table->index('price_detail_id');
				} 
				if (Schema::hasColumn('payroll_forms','expense_id') && !DB::select(DB::raw("SHOW INDEXES FROM payroll_forms WHERE key_name='payroll_forms_expense_id_index'"))) {
					$table->index('expense_id');
				}
				if (Schema::hasColumn('payroll_forms','payable_id') && !DB::select(DB::raw("SHOW INDEXES FROM payroll_forms WHERE key_name='payroll_forms_payable_id_index'"))) {
					$table->index('payable_id');
				} 

				if (Schema::hasColumn('payroll_forms','payroll_id') && !DB::select(DB::raw("SHOW INDEXES FROM payroll_forms WHERE key_name='payroll_forms_payroll_id_index'"))) {
					$table->index('payroll_id');
				} 
				if (Schema::hasColumn('payroll_forms','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM payroll_forms WHERE key_name='payroll_forms_company_id_index'"))) {
					$table->index('company_id');
				}
				if (Schema::hasColumn('payroll_forms','item_type_id') && !DB::select(DB::raw("SHOW INDEXES FROM payroll_forms WHERE key_name='payroll_forms_item_type_id_index'"))) {
					$table->index('item_type_id');
				} 

				if (Schema::hasColumn('payroll_forms','project_id') && !DB::select(DB::raw("SHOW INDEXES FROM payroll_forms WHERE key_name='payroll_forms_project_id_index'"))) {
					$table->index('project_id');
				}   
			});
		}


		// add indexs to payroll_forms
		if(Schema::hasTable('payroll_forms') ) {
			Schema::table('payroll_forms', function (Blueprint $table) {
				if (Schema::hasColumn('payroll_forms','payment_by_factor_id') && !DB::select(DB::raw("SHOW INDEXES FROM payroll_forms WHERE key_name='payroll_forms_payment_by_factor_id_index'"))) {
					$table->index('payment_by_factor_id');
				}
				if (Schema::hasColumn('payroll_forms','purchase_payment_id') && !DB::select(DB::raw("SHOW INDEXES FROM payroll_forms WHERE key_name='payroll_forms_purchase_payment_id_index'"))) {
					$table->index('purchase_payment_id');
				} 
				if (Schema::hasColumn('payroll_forms','gain_or_loss_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM payroll_forms WHERE key_name='payroll_forms_gain_or_loss_transaction_id_index'"))) {
					$table->index('gain_or_loss_transaction_id');
				} 
				if (Schema::hasColumn('payroll_forms','gl_payable_id_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM payroll_forms WHERE key_name='payroll_forms_gl_payable_id_transaction_id_index'"))) {
					$table->index('gl_payable_id_transaction_id');
				}
				if (Schema::hasColumn('payroll_forms','receivable_payments_id') && !DB::select(DB::raw("SHOW INDEXES FROM payroll_forms WHERE key_name='payroll_forms_receivable_payments_id_index'"))) {
					$table->index('receivable_payments_id');
				} 
			});
		}



		// add indexs to payroll_price_levels
		if(Schema::hasTable('payroll_price_levels') ) {
			Schema::table('payroll_price_levels', function (Blueprint $table) {
				if (Schema::hasColumn('payroll_price_levels','currency') && !DB::select(DB::raw("SHOW INDEXES FROM payroll_price_levels WHERE key_name='payroll_price_levels_currency_index'"))) {
					$table->index('currency');
				}
				if (Schema::hasColumn('payroll_price_levels','name') && !DB::select(DB::raw("SHOW INDEXES FROM payroll_price_levels WHERE key_name='payroll_price_levels_name_index'"))) {
					$table->index('name');
				} 
				if (Schema::hasColumn('payroll_price_levels','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM payroll_price_levels WHERE key_name='payroll_price_levels_company_id_index'"))) {
					$table->index('company_id');
				} 
				if (Schema::hasColumn('payroll_price_levels','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM payroll_price_levels WHERE key_name='payroll_price_levels_user_id_index'"))) {
					$table->index('user_id');
				}  
			});
		}



		// add indexs to payroll_price_level_details
		if(Schema::hasTable('payroll_price_level_details') ) {
			Schema::table('payroll_price_level_details', function (Blueprint $table) {
				if (Schema::hasColumn('payroll_price_level_details','measure_unit_id') && !DB::select(DB::raw("SHOW INDEXES FROM payroll_price_level_details WHERE key_name='payroll_price_level_details_measure_unit_id_index'"))) {
					$table->index('measure_unit_id');
				}
				if (Schema::hasColumn('payroll_price_level_details','payroll_price_level_id') && !DB::select(DB::raw("SHOW INDEXES FROM payroll_price_level_details WHERE key_name='payroll_price_level_details_payroll_price_level_id_index'"))) {
					$table->index('payroll_price_level_id');
				} 
				if (Schema::hasColumn('payroll_price_level_details','item_type_payroll_id') && !DB::select(DB::raw("SHOW INDEXES FROM payroll_price_level_details WHERE key_name='payroll_price_level_details_item_type_payroll_id_index'"))) {
					$table->index('item_type_payroll_id');
				} 
				if (Schema::hasColumn('payroll_price_level_details','amount') && !DB::select(DB::raw("SHOW INDEXES FROM payroll_price_level_details WHERE key_name='payroll_price_level_details_amount_index'"))) {
					$table->index('amount');
				}  
			});
		}



			// add indexs to payroll_tax
			if(Schema::hasTable('payroll_tax') ) {
				Schema::table('payroll_tax', function (Blueprint $table) {
					if (Schema::hasColumn('payroll_tax','currency') && !DB::select(DB::raw("SHOW INDEXES FROM payroll_tax WHERE key_name='payroll_tax_currency_index'"))) {
						$table->index('currency');
					}
					if (Schema::hasColumn('payroll_tax','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM payroll_tax WHERE key_name='payroll_tax_company_id_index'"))) {
						$table->index('company_id');
					}   
				});
			}
		
 
			// add indexs to payroll_taxes
			if(Schema::hasTable('payroll_taxes') ) {
				Schema::table('payroll_taxes', function (Blueprint $table) {
					if (Schema::hasColumn('payroll_taxes','title') && !DB::select(DB::raw("SHOW INDEXES FROM payroll_taxes WHERE key_name='payroll_taxes_title_index'"))) {
						$table->index('title');
					}
					if (Schema::hasColumn('payroll_taxes','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM payroll_taxes WHERE key_name='payroll_taxes_company_id_index'"))) {
						$table->index('company_id');
					}   
				});
			}
		


			// add indexs to payroll_tax_details
			if(Schema::hasTable('payroll_tax_details') ) {
				Schema::table('payroll_tax_details', function (Blueprint $table) {
					if (Schema::hasColumn('payroll_tax_details','from_amount') && !DB::select(DB::raw("SHOW INDEXES FROM payroll_tax_details WHERE key_name='payroll_tax_details_from_amount_index'"))) {
						$table->index('from_amount');
					}
					if (Schema::hasColumn('payroll_tax_details','to_amount') && !DB::select(DB::raw("SHOW INDEXES FROM payroll_tax_details WHERE key_name='payroll_tax_details_to_amount_index'"))) {
						$table->index('to_amount');
					}  
					if (Schema::hasColumn('payroll_tax_details','payroll_tax_id') && !DB::select(DB::raw("SHOW INDEXES FROM payroll_tax_details WHERE key_name='payroll_tax_details_payroll_tax_id_index'"))) {
						$table->index('payroll_tax_id');
					}   
				});
			}
		

			// add indexs to platts_rates
			if(Schema::hasTable('platts_rates') ) {
				Schema::table('platts_rates', function (Blueprint $table) {
					if (Schema::hasColumn('platts_rates','platts_category_id') && !DB::select(DB::raw("SHOW INDEXES FROM platts_rates WHERE key_name='platts_rates_platts_category_id_index'"))) {
						$table->index('platts_category_id');
					}
					if (Schema::hasColumn('platts_rates','date') && !DB::select(DB::raw("SHOW INDEXES FROM platts_rates WHERE key_name='platts_rates_date_index'"))) {
						$table->index('date');
					}  
					if (Schema::hasColumn('platts_rates','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM platts_rates WHERE key_name='platts_rates_company_id_index'"))) {
						$table->index('company_id');
					}  
					if (Schema::hasColumn('platts_rates','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM platts_rates WHERE key_name='platts_rates_user_id_index'"))) {
						$table->index('user_id');
					}   
				});
			}


			// add indexs to platts_rate_details
			if(Schema::hasTable('platts_rate_details') ) {
				Schema::table('platts_rate_details', function (Blueprint $table) {
					if (Schema::hasColumn('platts_rate_details','platts_rate_id') && !DB::select(DB::raw("SHOW INDEXES FROM platts_rate_details WHERE key_name='platts_rate_details_platts_rate_id_index'"))) {
						$table->index('platts_rate_id');
					}
					if (Schema::hasColumn('platts_rate_details','item_id') && !DB::select(DB::raw("SHOW INDEXES FROM platts_rate_details WHERE key_name='platts_rate_details_item_id_index'"))) {
						$table->index('item_id');
					}  
					if (Schema::hasColumn('platts_rate_details','um_id') && !DB::select(DB::raw("SHOW INDEXES FROM platts_rate_details WHERE key_name='platts_rate_details_um_id_index'"))) {
						$table->index('um_id');
					}  
					if (Schema::hasColumn('platts_rate_details','amount') && !DB::select(DB::raw("SHOW INDEXES FROM platts_rate_details WHERE key_name='platts_rate_details_amount_index'"))) {
						$table->index('amount');
					}  
					if (Schema::hasColumn('platts_rate_details','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM platts_rate_details WHERE key_name='platts_rate_details_company_id_index'"))) {
						$table->index('company_id');
					} 
					if (Schema::hasColumn('platts_rate_details','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM platts_rate_details WHERE key_name='platts_rate_details_user_id_index'"))) {
						$table->index('user_id');
					}  
				});
			}


			
			// add indexs to price_level_details
			if(Schema::hasTable('price_level_details') ) {
				Schema::table('price_level_details', function (Blueprint $table) {
					if (Schema::hasColumn('price_level_details','price_level_id') && !DB::select(DB::raw("SHOW INDEXES FROM price_level_details WHERE key_name='price_level_details_price_level_id_index'"))) {
						$table->index('price_level_id');
					}
					if (Schema::hasColumn('price_level_details','item_id') && !DB::select(DB::raw("SHOW INDEXES FROM price_level_details WHERE key_name='price_level_details_item_id_index'"))) {
						$table->index('item_id');
					}  
					if (Schema::hasColumn('price_level_details','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM price_level_details WHERE key_name='price_level_details_company_id_index'"))) {
						$table->index('company_id');
					}   
				});
			}



			// add indexs to price_lists
			if(Schema::hasTable('price_lists') ) {
				Schema::table('price_lists', function (Blueprint $table) {
					if (Schema::hasColumn('price_lists','source_id') && !DB::select(DB::raw("SHOW INDEXES FROM price_lists WHERE key_name='price_lists_source_id_index'"))) {
						$table->index('source_id');
					}
					if (Schema::hasColumn('price_lists','currency') && !DB::select(DB::raw("SHOW INDEXES FROM price_lists WHERE key_name='price_lists_currency_index'"))) {
						$table->index('currency');
					}  
					if (Schema::hasColumn('price_lists','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM price_lists WHERE key_name='price_lists_company_id_index'"))) {
						$table->index('company_id');
					}   
				});
			}
			
	
			// add indexs to price_list_amounts
			if(Schema::hasTable('price_list_amounts') ) {
				Schema::table('price_list_amounts', function (Blueprint $table) {
					if (Schema::hasColumn('price_list_amounts','number') && !DB::select(DB::raw("SHOW INDEXES FROM price_list_amounts WHERE key_name='price_list_amounts_number_index'"))) {
						$table->index('number');
					}
					if (Schema::hasColumn('price_list_amounts','quantity') && !DB::select(DB::raw("SHOW INDEXES FROM price_list_amounts WHERE key_name='price_list_amounts_quantity_index'"))) {
						$table->index('quantity');
					}  
					if (Schema::hasColumn('price_list_amounts','um_id') && !DB::select(DB::raw("SHOW INDEXES FROM price_list_amounts WHERE key_name='price_list_amounts_um_id_index'"))) {
						$table->index('um_id');
					}   if (Schema::hasColumn('price_list_amounts','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM price_list_amounts WHERE key_name='price_list_amounts_company_id_index'"))) {
						$table->index('company_id');
					} 
				});
			}
			

			// add indexs to price_list_details
			if(Schema::hasTable('price_list_details') ) {
				Schema::table('price_list_details', function (Blueprint $table) {
					if (Schema::hasColumn('price_list_details','destination_id') && !DB::select(DB::raw("SHOW INDEXES FROM price_list_details WHERE key_name='price_list_details_destination_id_index'"))) {
						$table->index('destination_id');
					}
					if (Schema::hasColumn('price_list_details','price_list_amount_id') && !DB::select(DB::raw("SHOW INDEXES FROM price_list_details WHERE key_name='price_list_details_price_list_amount_id_index'"))) {
						$table->index('price_list_amount_id');
					}  
					if (Schema::hasColumn('price_list_details','price_list_id') && !DB::select(DB::raw("SHOW INDEXES FROM price_list_details WHERE key_name='price_list_details_price_list_id_index'"))) {
						$table->index('price_list_id');
					}   if (Schema::hasColumn('price_list_details','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM price_list_details WHERE key_name='price_list_details_company_id_index'"))) {
						$table->index('company_id');
					} 
				});
			}


			// add indexs to products
			if(Schema::hasTable('products') ) {
				Schema::table('products', function (Blueprint $table) {
					if (Schema::hasColumn('products','name') && !DB::select(DB::raw("SHOW INDEXES FROM products WHERE key_name='products_name_index'"))) {
						$table->index('name');
					}
					if (Schema::hasColumn('products','type') && !DB::select(DB::raw("SHOW INDEXES FROM products WHERE key_name='products_type_index'"))) {
						$table->index('type');
					}  
					if (Schema::hasColumn('products','amount') && !DB::select(DB::raw("SHOW INDEXES FROM products WHERE key_name='products_amount_index'"))) {
						$table->index('amount');
					}   if (Schema::hasColumn('products','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM products WHERE key_name='products_company_id_index'"))) {
						$table->index('company_id');
					} 
				});
			}


			// add indexs to projects
			if(Schema::hasTable('projects') ) {
				Schema::table('projects', function (Blueprint $table) {
					if (Schema::hasColumn('projects','name') && !DB::select(DB::raw("SHOW INDEXES FROM projects WHERE key_name='projects_name_index'"))) {
						$table->index('name');
					}
					if (Schema::hasColumn('projects','number') && !DB::select(DB::raw("SHOW INDEXES FROM projects WHERE key_name='projects_number_index'"))) {
						$table->index('number');
					}  
					if (Schema::hasColumn('projects','customer_id') && !DB::select(DB::raw("SHOW INDEXES FROM projects WHERE key_name='projects_customer_id_index'"))) {
						$table->index('customer_id');
					}   if (Schema::hasColumn('projects','start_date') && !DB::select(DB::raw("SHOW INDEXES FROM projects WHERE key_name='projects_start_date_index'"))) {
						$table->index('start_date');
					} if (Schema::hasColumn('projects','end_date') && !DB::select(DB::raw("SHOW INDEXES FROM projects WHERE key_name='projects_end_date_index'"))) {
						$table->index('end_date');
					}  
					if (Schema::hasColumn('projects','project_progress_id') && !DB::select(DB::raw("SHOW INDEXES FROM projects WHERE key_name='projects_project_progress_id_index'"))) {
						$table->index('project_progress_id');
					}   if (Schema::hasColumn('projects','discount_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM projects WHERE key_name='projects_discount_transaction_index'"))) {
						$table->index('discount_transaction');
					} 
					
					if (Schema::hasColumn('projects','project_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM projects WHERE key_name='projects_project_transaction_index'"))) {
						$table->index('project_transaction');
					}  
					if (Schema::hasColumn('projects','income_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM projects WHERE key_name='projects_income_transaction_index'"))) {
						$table->index('income_transaction');
					}   if (Schema::hasColumn('projects','project_category_id') && !DB::select(DB::raw("SHOW INDEXES FROM projects WHERE key_name='projects_project_category_id_index'"))) {
						$table->index('project_category_id');
					} if (Schema::hasColumn('projects','income_account_id') && !DB::select(DB::raw("SHOW INDEXES FROM projects WHERE key_name='projects_income_account_id_index'"))) {
						$table->index('income_account_id');
					}  
					if (Schema::hasColumn('projects','expense_account_id') && !DB::select(DB::raw("SHOW INDEXES FROM projects WHERE key_name='projects_expense_account_id_index'"))) {
						$table->index('expense_account_id');
					}   if (Schema::hasColumn('projects','asset_account_id') && !DB::select(DB::raw("SHOW INDEXES FROM projects WHERE key_name='projects_asset_account_id_index'"))) {
						$table->index('asset_account_id');
					} 
					if (Schema::hasColumn('projects','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM projects WHERE key_name='projects_company_id_index'"))) {
						$table->index('company_id');
					}   if (Schema::hasColumn('projects','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM projects WHERE key_name='projects_user_id_index'"))) {
						$table->index('user_id');
					}
					if (Schema::hasColumn('projects','status') && !DB::select(DB::raw("SHOW INDEXES FROM projects WHERE key_name='projects_status_index'"))) {
						$table->index('status');
					}   if (Schema::hasColumn('projects','employee_id') && !DB::select(DB::raw("SHOW INDEXES FROM projects WHERE key_name='projects_employee_id_index'"))) {
						$table->index('employee_id');
					} if (Schema::hasColumn('projects','type') && !DB::select(DB::raw("SHOW INDEXES FROM projects WHERE key_name='projects_type_index'"))) {
						$table->index('type');
					}if (Schema::hasColumn('projects','work_type_id') && !DB::select(DB::raw("SHOW INDEXES FROM projects WHERE key_name='projects_work_type_id_index'"))) {
						$table->index('work_type_id');
					}

					
				});
			}  




			
			// add indexs to project_builds
			if(Schema::hasTable('project_builds') ) {
				Schema::table('project_builds', function (Blueprint $table) {
					if (Schema::hasColumn('project_builds','project_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_builds WHERE key_name='project_builds_project_id_index'"))) {
						$table->index('project_id');
					}
					if (Schema::hasColumn('project_builds','assembly_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_builds WHERE key_name='project_builds_assembly_id_index'"))) {
						$table->index('assembly_id');
					}  
					if (Schema::hasColumn('project_builds','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_builds WHERE key_name='project_builds_user_id_index'"))) {
						$table->index('user_id');
					}   if (Schema::hasColumn('project_builds','cost') && !DB::select(DB::raw("SHOW INDEXES FROM project_builds WHERE key_name='project_builds_cost_index'"))) {
						$table->index('cost');
					}if (Schema::hasColumn('project_builds','number') && !DB::select(DB::raw("SHOW INDEXES FROM project_builds WHERE key_name='project_builds_number_index'"))) {
						$table->index('number');
					}  
					if (Schema::hasColumn('project_builds','expense_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM project_builds WHERE key_name='project_builds_expense_transaction_index'"))) {
						$table->index('expense_transaction');
					}   if (Schema::hasColumn('project_builds','cost_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM project_builds WHERE key_name='project_builds_cost_transaction_index'"))) {
						$table->index('cost_transaction');
					} 

					if (Schema::hasColumn('project_builds','type') && !DB::select(DB::raw("SHOW INDEXES FROM project_builds WHERE key_name='project_builds_type_index'"))) {
						$table->index('type');
					}  
					if (Schema::hasColumn('project_builds','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_builds WHERE key_name='project_builds_company_id_index'"))) {
						$table->index('company_id');
					} 
				});
			}



			// add indexs to project_build_items
			if(Schema::hasTable('project_build_items') ) {
				Schema::table('project_build_items', function (Blueprint $table) {
					if (Schema::hasColumn('project_build_items','item_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_build_items WHERE key_name='project_build_items_item_id_index'"))) {
						$table->index('item_id');
					}
					if (Schema::hasColumn('project_build_items','um_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_build_items WHERE key_name='project_build_items_um_id_index'"))) {
						$table->index('um_id');
					}  
					if (Schema::hasColumn('project_build_items','project_build_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_build_items WHERE key_name='project_build_items_project_build_id_index'"))) {
						$table->index('project_build_id');
					}   if (Schema::hasColumn('project_build_items','project_details_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_build_items WHERE key_name='project_build_items_project_details_id_index'"))) {
						$table->index('project_details_id');
					}if (Schema::hasColumn('project_build_items','project_items_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_build_items WHERE key_name='project_build_items_project_items_id_index'"))) {
						$table->index('project_items_id');
					}  
					if (Schema::hasColumn('project_build_items','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_build_items WHERE key_name='project_build_items_company_id_index'"))) {
						$table->index('company_id');
					}  
				});
			}



			// add indexs to project_closes
			if(Schema::hasTable('project_closes') ) {
				Schema::table('project_closes', function (Blueprint $table) {
					if (Schema::hasColumn('project_closes','project_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_closes WHERE key_name='project_closes_project_id_index'"))) {
						$table->index('project_id');
					}
					if (Schema::hasColumn('project_closes','income_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_closes WHERE key_name='project_closes_income_id_index'"))) {
						$table->index('income_id');
					}  
					if (Schema::hasColumn('project_closes','expense_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_closes WHERE key_name='project_closes_expense_id_index'"))) {
						$table->index('expense_id');
					}   if (Schema::hasColumn('project_closes','owner_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_closes WHERE key_name='project_closes_owner_id_index'"))) {
						$table->index('owner_id');
					}if (Schema::hasColumn('project_closes','date') && !DB::select(DB::raw("SHOW INDEXES FROM project_closes WHERE key_name='project_closes_date_index'"))) {
						$table->index('date');
					}   
				});
			}



			// add indexs to project_close_details
			if(Schema::hasTable('project_close_details') ) {
				Schema::table('project_close_details', function (Blueprint $table) {
					if (Schema::hasColumn('project_close_details','project_close_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_close_details WHERE key_name='project_close_details_project_close_id_index'"))) {
						$table->index('project_close_id');
					}
					if (Schema::hasColumn('project_close_details','shareholder_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_close_details WHERE key_name='project_close_details_shareholder_id_index'"))) {
						$table->index('shareholder_id');
					}  
					if (Schema::hasColumn('project_close_details','income_transection_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_close_details WHERE key_name='project_close_details_income_transection_id_index'"))) {
						$table->index('income_transection_id');
					}   if (Schema::hasColumn('project_close_details','expense_transection_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_close_details WHERE key_name='project_close_details_expense_transection_id_index'"))) {
						$table->index('expense_transection_id');
					}if (Schema::hasColumn('project_close_details','shareholder_transection_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_close_details WHERE key_name='project_close_details_shareholder_transection_id_index'"))) {
						$table->index('shareholder_transection_id');
					}   
				});
			}



			// add indexs to project_details
			if(Schema::hasTable('project_details') ) {
				Schema::table('project_details', function (Blueprint $table) {
					if (Schema::hasColumn('project_details','production_item_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_details WHERE key_name='project_details_production_item_id_index'"))) {
						$table->index('production_item_id');
					}
					if (Schema::hasColumn('project_details','project_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_details WHERE key_name='project_details_project_id_index'"))) {
						$table->index('project_id');
					}  
					if (Schema::hasColumn('project_details','width') && !DB::select(DB::raw("SHOW INDEXES FROM project_details WHERE key_name='project_details_width_index'"))) {
						$table->index('width');
					}   if (Schema::hasColumn('project_details','measure_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_details WHERE key_name='project_details_measure_id_index'"))) {
						$table->index('measure_id');
					}if (Schema::hasColumn('project_details','item_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_details WHERE key_name='project_details_item_id_index'"))) {
						$table->index('item_id');
					}  
					if (Schema::hasColumn('project_details','assembly_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_details WHERE key_name='project_details_assembly_id_index'"))) {
						$table->index('assembly_id');
					}if (Schema::hasColumn('project_details','inventory_site_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_details WHERE key_name='project_details_inventory_site_id_index'"))) {
						$table->index('inventory_site_id');
					}if (Schema::hasColumn('project_details','type') && !DB::select(DB::raw("SHOW INDEXES FROM project_details WHERE key_name='project_details_type_index'"))) {
						$table->index('type');
					}    
				});
			}



			// add indexs to project_expenses
			if(Schema::hasTable('project_expenses') ) {
				Schema::table('project_expenses', function (Blueprint $table) {
					if (Schema::hasColumn('project_expenses','project_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_expenses WHERE key_name='project_expenses_project_id_index'"))) {
						$table->index('project_id');
					}
					if (Schema::hasColumn('project_expenses','bank_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM project_expenses WHERE key_name='project_expenses_bank_transaction_index'"))) {
						$table->index('bank_transaction');
					}  
					if (Schema::hasColumn('project_expenses','expense_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM project_expenses WHERE key_name='project_expenses_expense_transaction_index'"))) {
						$table->index('expense_transaction');
					}   if (Schema::hasColumn('project_expenses','receivable_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_expenses WHERE key_name='project_expenses_receivable_id_index'"))) {
						$table->index('receivable_id');
					}if (Schema::hasColumn('project_expenses','currency') && !DB::select(DB::raw("SHOW INDEXES FROM project_expenses WHERE key_name='project_expenses_currency_index'"))) {
						$table->index('currency');
					}  
					if (Schema::hasColumn('project_expenses','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_expenses WHERE key_name='project_expenses_company_id_index'"))) {
						$table->index('company_id');
					}if (Schema::hasColumn('project_expenses','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_expenses WHERE key_name='project_expenses_user_id_index'"))) {
						$table->index('user_id');
					}  
				});
			}




			// add indexs to project_expense_details
			if(Schema::hasTable('project_expense_details') ) {
				Schema::table('project_expense_details', function (Blueprint $table) {
					if (Schema::hasColumn('project_expense_details','project_expense_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_expense_details WHERE key_name='project_expense_details_project_expense_id_index'"))) {
						$table->index('project_expense_id');
					}
					if (Schema::hasColumn('project_expense_details','amount') && !DB::select(DB::raw("SHOW INDEXES FROM project_expense_details WHERE key_name='project_expense_details_amount_index'"))) {
						$table->index('amount');
					}  
					if (Schema::hasColumn('project_expense_details','stock_out_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_expense_details WHERE key_name='project_expense_details_stock_out_id_index'"))) {
						$table->index('stock_out_id');
					}   if (Schema::hasColumn('project_expense_details','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_expense_details WHERE key_name='project_expense_details_company_id_index'"))) {
						$table->index('company_id');
					}  
				});
			}
	

			// add indexs to project_finishes
			if(Schema::hasTable('project_finishes') ) {
				Schema::table('project_finishes', function (Blueprint $table) {
					if (Schema::hasColumn('project_finishes','project_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_finishes WHERE key_name='project_finishes_project_id_index'"))) {
						$table->index('project_id');
					}
					if (Schema::hasColumn('project_finishes','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_finishes WHERE key_name='project_finishes_company_id_index'"))) {
						$table->index('company_id');
					}  
					
				});
			}
	


			// add indexs to project_items
			if(Schema::hasTable('project_items') ) {
				Schema::table('project_items', function (Blueprint $table) {
					if (Schema::hasColumn('project_items','code') && !DB::select(DB::raw("SHOW INDEXES FROM project_items WHERE key_name='project_items_code_index'"))) {
						$table->index('code');
					}
					if (Schema::hasColumn('project_items','project_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_items WHERE key_name='project_items_project_id_index'"))) {
						$table->index('project_id');
					}  
					if (Schema::hasColumn('project_items','category') && !DB::select(DB::raw("SHOW INDEXES FROM project_items WHERE key_name='project_items_category_index'"))) {
						$table->index('category');
					}
					if (Schema::hasColumn('project_items','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_items WHERE key_name='project_items_company_id_index'"))) {
						$table->index('company_id');
					} if (Schema::hasColumn('project_items','type') && !DB::select(DB::raw("SHOW INDEXES FROM project_items WHERE key_name='project_items_type_index'"))) {
						$table->index('type');
					}  
					
				});
			}


			// add indexs to project_item_transactions
			if(Schema::hasTable('project_item_transactions') ) {
				Schema::table('project_item_transactions', function (Blueprint $table) {
					if (Schema::hasColumn('project_item_transactions','assembly_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_item_transactions WHERE key_name='project_item_transactions_assembly_id_index'"))) {
						$table->index('assembly_id');
					}
					if (Schema::hasColumn('project_item_transactions','inventory_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_item_transactions WHERE key_name='project_item_transactions_inventory_id_index'"))) {
						$table->index('inventory_id');
					}  
					if (Schema::hasColumn('project_item_transactions','cost_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM project_item_transactions WHERE key_name='project_item_transactions_cost_transaction_index'"))) {
						$table->index('cost_transaction');
					}
					if (Schema::hasColumn('project_item_transactions','income_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM project_item_transactions WHERE key_name='project_item_transactions_income_transaction_index'"))) {
						$table->index('income_transaction');
					}  
					if (Schema::hasColumn('project_item_transactions','asset_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM project_item_transactions WHERE key_name='project_item_transactions_asset_transaction_index'"))) {
						$table->index('asset_transaction');
					}
					if (Schema::hasColumn('project_item_transactions','project_item_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_item_transactions WHERE key_name='project_item_transactions_project_item_id_index'"))) {
						$table->index('project_item_id');
					} 
					if (Schema::hasColumn('project_item_transactions','delivery_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_item_transactions WHERE key_name='project_item_transactions_delivery_id_index'"))) {
						$table->index('delivery_id');
					}
					if (Schema::hasColumn('project_item_transactions','project_expense_detail_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_item_transactions WHERE key_name='project_item_transactions_project_expense_detail_id_index'"))) {
						$table->index('project_expense_detail_id');
					} 
					if (Schema::hasColumn('project_item_transactions','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_item_transactions WHERE key_name='project_item_transactions_company_id_index'"))) {
						$table->index('company_id');
					} if (Schema::hasColumn('project_item_transactions','type_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_item_transactions WHERE key_name='project_item_transactions_type_id_index'"))) {
						$table->index('type_id');
					} 

					
				});
			}


			// add indexs to project_services
			if(Schema::hasTable('project_services') ) {
				Schema::table('project_services', function (Blueprint $table) {
					if (Schema::hasColumn('project_services','project_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_services WHERE key_name='project_services_project_id_index'"))) {
						$table->index('project_id');
					}
					if (Schema::hasColumn('project_services','item_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_services WHERE key_name='project_services_item_id_index'"))) {
						$table->index('item_id');
					}  
					if (Schema::hasColumn('project_services','price') && !DB::select(DB::raw("SHOW INDEXES FROM project_services WHERE key_name='project_services_price_index'"))) {
						$table->index('price');
					}
					if (Schema::hasColumn('project_services','quantity') && !DB::select(DB::raw("SHOW INDEXES FROM project_services WHERE key_name='project_services_quantity_index'"))) {
						$table->index('quantity');
					}  
					if (Schema::hasColumn('project_services','um_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_services WHERE key_name='project_services_um_id_index'"))) {
						$table->index('um_id');
					}
					if (Schema::hasColumn('project_services','income_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM project_services WHERE key_name='project_services_income_transaction_index'"))) {
						$table->index('income_transaction');
					} 
					if (Schema::hasColumn('project_services','cost_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM project_services WHERE key_name='project_services_cost_transaction_index'"))) {
						$table->index('cost_transaction');
					}
					if (Schema::hasColumn('project_services','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_services WHERE key_name='project_services_company_id_index'"))) {
						$table->index('company_id');
					} 
					if (Schema::hasColumn('project_services','type') && !DB::select(DB::raw("SHOW INDEXES FROM project_services WHERE key_name='project_services_type_index'"))) {
						$table->index('type');
					} 
				});
			}




			// add indexs to project_shareholders
			if(Schema::hasTable('project_shareholders') ) {
				Schema::table('project_shareholders', function (Blueprint $table) {
					if (Schema::hasColumn('project_shareholders','project_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_shareholders WHERE key_name='project_shareholders_project_id_index'"))) {
						$table->index('project_id');
					}
					if (Schema::hasColumn('project_shareholders','shareholder_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_shareholders WHERE key_name='project_shareholders_shareholder_id_index'"))) {
						$table->index('shareholder_id');
					}  
					if (Schema::hasColumn('project_shareholders','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_shareholders WHERE key_name='project_shareholders_company_id_index'"))) {
						$table->index('company_id');
					}
				});
			}


			// add indexs to project_stocks
			if(Schema::hasTable('project_stocks') ) {
				Schema::table('project_stocks', function (Blueprint $table) {
					if (Schema::hasColumn('project_stocks','project_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_stocks WHERE key_name='project_stocks_project_id_index'"))) {
						$table->index('project_id');
					}
					if (Schema::hasColumn('project_stocks','project_item_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_stocks WHERE key_name='project_stocks_project_item_id_index'"))) {
						$table->index('project_item_id');
					}  
					if (Schema::hasColumn('project_stocks','stock_out_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_stocks WHERE key_name='project_stocks_stock_out_id_index'"))) {
						$table->index('stock_out_id');
					}
					if (Schema::hasColumn('project_stocks','date_in') && !DB::select(DB::raw("SHOW INDEXES FROM project_stocks WHERE key_name='project_stocks_date_in_index'"))) {
						$table->index('date_in');
					}  
					if (Schema::hasColumn('project_stocks','inventory_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_stocks WHERE key_name='project_stocks_inventory_id_index'"))) {
						$table->index('inventory_id');
					}
					if (Schema::hasColumn('project_stocks','inventory_site_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_stocks WHERE key_name='project_stocks_inventory_site_id_index'"))) {
						$table->index('inventory_site_id');
					}  
					if (Schema::hasColumn('project_stocks','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_stocks WHERE key_name='project_stocks_user_id_index'"))) {
						$table->index('user_id');
					}
					if (Schema::hasColumn('project_stocks','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_stocks WHERE key_name='project_stocks_company_id_index'"))) {
						$table->index('company_id');
					}
				});
			}
	


			// add indexs to project_stock_outs
			if(Schema::hasTable('project_stock_outs') ) {
				Schema::table('project_stock_outs', function (Blueprint $table) {
					if (Schema::hasColumn('project_stock_outs','project_build_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_stock_outs WHERE key_name='project_stock_outs_project_build_id_index'"))) {
						$table->index('project_build_id');
					}
					if (Schema::hasColumn('project_stock_outs','project_stock_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_stock_outs WHERE key_name='project_stock_outs_project_stock_id_index'"))) {
						$table->index('project_stock_id');
					}  
					if (Schema::hasColumn('project_stock_outs','asset_t_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_stock_outs WHERE key_name='project_stock_outs_asset_t_id_index'"))) {
						$table->index('asset_t_id');
					}
					if (Schema::hasColumn('project_stock_outs','item_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_stock_outs WHERE key_name='project_stock_outs_item_id_index'"))) {
						$table->index('item_id');
					}  
					if (Schema::hasColumn('project_stock_outs','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_stock_outs WHERE key_name='project_stock_outs_company_id_index'"))) {
						$table->index('company_id');
					}
				});
			}



			// add indexs to project_transactions
			if(Schema::hasTable('project_transactions') ) {
				Schema::table('project_transactions', function (Blueprint $table) {
					if (Schema::hasColumn('project_transactions','project_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_transactions WHERE key_name='project_transactions_project_id_index'"))) {
						$table->index('project_id');
					}
					if (Schema::hasColumn('project_transactions','transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_transactions WHERE key_name='project_transactions_transaction_id_index'"))) {
						$table->index('transaction_id');
					}  
					if (Schema::hasColumn('project_transactions','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_transactions WHERE key_name='project_transactions_company_id_index'"))) {
						$table->index('company_id');
					} 
				});
			}


		// add indexs to project_volunteeres
		if(Schema::hasTable('project_volunteeres') ) {
			Schema::table('project_volunteeres', function (Blueprint $table) {
				if (Schema::hasColumn('project_volunteeres','project_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_volunteeres WHERE key_name='project_volunteeres_project_id_index'"))) {
					$table->index('project_id');
				}
				if (Schema::hasColumn('project_volunteeres','name') && !DB::select(DB::raw("SHOW INDEXES FROM project_volunteeres WHERE key_name='project_volunteeres_name_index'"))) {
					$table->index('name');
				}  
				if (Schema::hasColumn('project_volunteeres','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_volunteeres WHERE key_name='project_volunteeres_company_id_index'"))) {
					$table->index('company_id');
				} if (Schema::hasColumn('project_volunteeres','type') && !DB::select(DB::raw("SHOW INDEXES FROM project_volunteeres WHERE key_name='project_volunteeres_type_index'"))) {
					$table->index('type');
				} 
			});
		}


		// add indexs to project_wastages
		if(Schema::hasTable('project_wastages') ) {
			Schema::table('project_wastages', function (Blueprint $table) {
				if (Schema::hasColumn('project_wastages','build_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_wastages WHERE key_name='project_wastages_build_id_index'"))) {
					$table->index('build_id');
				}
				if (Schema::hasColumn('project_wastages','item_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_wastages WHERE key_name='project_wastages_item_id_index'"))) {
					$table->index('item_id');
				}  
				if (Schema::hasColumn('project_wastages','um_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_wastages WHERE key_name='project_wastages_um_id_index'"))) {
					$table->index('um_id');
				} 
				if (Schema::hasColumn('project_wastages','type') && !DB::select(DB::raw("SHOW INDEXES FROM project_wastages WHERE key_name='project_wastages_type_index'"))) {
					$table->index('type');
				} 
				if (Schema::hasColumn('project_wastages','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM project_wastages WHERE key_name='project_wastages_company_id_index'"))) {
					$table->index('company_id');
				} 
			});
		}

 


		// add indexs to quantities
		if(Schema::hasTable('quantities') ) {
			Schema::table('quantities', function (Blueprint $table) {
				if (Schema::hasColumn('quantities','quantities') && !DB::select(DB::raw("SHOW INDEXES FROM quantities WHERE key_name='quantities_quantities_index'"))) {
					$table->index('quantities');
				}
				if (Schema::hasColumn('quantities','unit') && !DB::select(DB::raw("SHOW INDEXES FROM quantities WHERE key_name='quantities_unit_index'"))) {
					$table->index('unit');
				}  
				if (Schema::hasColumn('quantities','um_id') && !DB::select(DB::raw("SHOW INDEXES FROM quantities WHERE key_name='quantities_um_id_index'"))) {
					$table->index('um_id');
				} 
				if (Schema::hasColumn('quantities','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM quantities WHERE key_name='quantities_company_id_index'"))) {
					$table->index('company_id');
				}   
			});
		}


		// add indexs to receipts
		if(Schema::hasTable('receipts') ) {
			Schema::table('receipts', function (Blueprint $table) {
				if (Schema::hasColumn('receipts','customer_id') && !DB::select(DB::raw("SHOW INDEXES FROM receipts WHERE key_name='receipts_customer_id_index'"))) {
					$table->index('customer_id');
				}
				if (Schema::hasColumn('receipts','unit') && !DB::select(DB::raw("SHOW INDEXES FROM receipts WHERE key_name='receipts_unit_index'"))) {
					$table->index('unit');
				}  
				if (Schema::hasColumn('receipts','sales_type') && !DB::select(DB::raw("SHOW INDEXES FROM receipts WHERE key_name='receipts_sales_type_index'"))) {
					$table->index('sales_type');
				} 
				if (Schema::hasColumn('receipts','amount') && !DB::select(DB::raw("SHOW INDEXES FROM receipts WHERE key_name='receipts_amount_index'"))) {
					$table->index('amount');
				}   
			});
		}



		// add indexs to recipes
		if(Schema::hasTable('recipes') ) {
			Schema::table('recipes', function (Blueprint $table) {
				if (Schema::hasColumn('recipes','name') && !DB::select(DB::raw("SHOW INDEXES FROM recipes WHERE key_name='recipes_name_index'"))) {
					$table->index('name');
				}
				if (Schema::hasColumn('recipes','customer_id') && !DB::select(DB::raw("SHOW INDEXES FROM recipes WHERE key_name='recipes_customer_id_index'"))) {
					$table->index('customer_id');
				}  
				if (Schema::hasColumn('recipes','number') && !DB::select(DB::raw("SHOW INDEXES FROM recipes WHERE key_name='recipes_number_index'"))) {
					$table->index('number');
				} 
				if (Schema::hasColumn('recipes','width') && !DB::select(DB::raw("SHOW INDEXES FROM recipes WHERE key_name='recipes_width_index'"))) {
					$table->index('width');
				}  
				if (Schema::hasColumn('recipes','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM recipes WHERE key_name='recipes_company_id_index'"))) {
					$table->index('company_id');
				}  
			});
		}



		
		// add indexs to recipe_details
		if(Schema::hasTable('recipe_details') ) {
			Schema::table('recipe_details', function (Blueprint $table) {
				if (Schema::hasColumn('recipe_details','recipe_id') && !DB::select(DB::raw("SHOW INDEXES FROM recipe_details WHERE key_name='recipe_details_recipe_id_index'"))) {
					$table->index('recipe_id');
				}
				if (Schema::hasColumn('recipe_details','item_id') && !DB::select(DB::raw("SHOW INDEXES FROM recipe_details WHERE key_name='recipe_details_item_id_index'"))) {
					$table->index('item_id');
				}  
				if (Schema::hasColumn('recipe_details','width') && !DB::select(DB::raw("SHOW INDEXES FROM recipe_details WHERE key_name='recipe_details_width_index'"))) {
					$table->index('width');
				} 
				if (Schema::hasColumn('recipe_details','height') && !DB::select(DB::raw("SHOW INDEXES FROM recipe_details WHERE key_name='recipe_details_height_index'"))) {
					$table->index('height');
				}  
				if (Schema::hasColumn('recipe_details','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM recipe_details WHERE key_name='recipe_details_company_id_index'"))) {
					$table->index('company_id');
				}  
			});
		}



			
		// add indexs to recipe_operators
		if(Schema::hasTable('recipe_operators') ) {
			Schema::table('recipe_operators', function (Blueprint $table) {
				if (Schema::hasColumn('recipe_operators','recipe_id') && !DB::select(DB::raw("SHOW INDEXES FROM recipe_operators WHERE key_name='recipe_operators_recipe_id_index'"))) {
					$table->index('recipe_id');
				}
				if (Schema::hasColumn('recipe_operators','machine_id') && !DB::select(DB::raw("SHOW INDEXES FROM recipe_operators WHERE key_name='recipe_operators_machine_id_index'"))) {
					$table->index('machine_id');
				}  
				if (Schema::hasColumn('recipe_operators','employee_id') && !DB::select(DB::raw("SHOW INDEXES FROM recipe_operators WHERE key_name='recipe_operators_employee_id_index'"))) {
					$table->index('employee_id');
				} 
				if (Schema::hasColumn('recipe_operators','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM recipe_operators WHERE key_name='recipe_operators_company_id_index'"))) {
					$table->index('company_id');
				}  
			});
		}



		// add indexs to recipe_operators
		if(Schema::hasTable('recipe_operators') ) {
			Schema::table('recipe_operators', function (Blueprint $table) {
				if (Schema::hasColumn('recipe_operators','recipe_id') && !DB::select(DB::raw("SHOW INDEXES FROM recipe_operators WHERE key_name='recipe_operators_recipe_id_index'"))) {
					$table->index('recipe_id');
				}
				if (Schema::hasColumn('recipe_operators','machine_id') && !DB::select(DB::raw("SHOW INDEXES FROM recipe_operators WHERE key_name='recipe_operators_machine_id_index'"))) {
					$table->index('machine_id');
				}  
				if (Schema::hasColumn('recipe_operators','employee_id') && !DB::select(DB::raw("SHOW INDEXES FROM recipe_operators WHERE key_name='recipe_operators_employee_id_index'"))) {
					$table->index('employee_id');
				} 
				if (Schema::hasColumn('recipe_operators','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM recipe_operators WHERE key_name='recipe_operators_company_id_index'"))) {
					$table->index('company_id');
				}  
			});
		}



		// add indexs to reference_department
		if(Schema::hasTable('reference_department') ) {
			Schema::table('reference_department', function (Blueprint $table) {
				if (Schema::hasColumn('reference_department','number') && !DB::select(DB::raw("SHOW INDEXES FROM reference_department WHERE key_name='reference_department_number_index'"))) {
					$table->index('number');
				}
				if (Schema::hasColumn('reference_department','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM reference_department WHERE key_name='reference_department_user_id_index'"))) {
					$table->index('user_id');
				}
				if (Schema::hasColumn('reference_department','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM reference_department WHERE key_name='reference_department_company_id_index'"))) {
					$table->index('company_id');
				}  
			});
		}
	

		// add indexs to reference_department
		if(Schema::hasTable('reference_department') ) {
			Schema::table('reference_department', function (Blueprint $table) {
				if (Schema::hasColumn('reference_department','number') && !DB::select(DB::raw("SHOW INDEXES FROM reference_department WHERE key_name='reference_department_number_index'"))) {
					$table->index('number');
				}
				if (Schema::hasColumn('reference_department','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM reference_department WHERE key_name='reference_department_user_id_index'"))) {
					$table->index('user_id');
				}
				if (Schema::hasColumn('reference_department','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM reference_department WHERE key_name='reference_department_company_id_index'"))) {
					$table->index('company_id');
				}  
			});
		}


		// add indexs to refunds
		if(Schema::hasTable('refunds') ) {
			Schema::table('refunds', function (Blueprint $table) {
				if (Schema::hasColumn('refunds','sale_id') && !DB::select(DB::raw("SHOW INDEXES FROM refunds WHERE key_name='refunds_sale_id_index'"))) {
					$table->index('sale_id');
				}
				if (Schema::hasColumn('refunds','date') && !DB::select(DB::raw("SHOW INDEXES FROM refunds WHERE key_name='refunds_date_index'"))) {
					$table->index('date');
				}
				if (Schema::hasColumn('refunds','number') && !DB::select(DB::raw("SHOW INDEXES FROM refunds WHERE key_name='refunds_number_index'"))) {
					$table->index('number');
				}  
				if (Schema::hasColumn('refunds','type') && !DB::select(DB::raw("SHOW INDEXES FROM refunds WHERE key_name='refunds_type_index'"))) {
					$table->index('type');
				}
				if (Schema::hasColumn('refunds','currency') && !DB::select(DB::raw("SHOW INDEXES FROM refunds WHERE key_name='refunds_currency_index'"))) {
					$table->index('currency');
				}
				if (Schema::hasColumn('refunds','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM refunds WHERE key_name='refunds_member_id_index'"))) {
					$table->index('member_id');
				} 
				if (Schema::hasColumn('refunds','transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM refunds WHERE key_name='refunds_transaction_id_index'"))) {
					$table->index('transaction_id');
				}
				if (Schema::hasColumn('refunds','discount_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM refunds WHERE key_name='refunds_discount_transaction_index'"))) {
					$table->index('discount_transaction');
				}
				if (Schema::hasColumn('refunds','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM refunds WHERE key_name='refunds_company_id_index'"))) {
					$table->index('company_id');
				} 

				if (Schema::hasColumn('refunds','category') && !DB::select(DB::raw("SHOW INDEXES FROM refunds WHERE key_name='refunds_category_index'"))) {
					$table->index('category');
				}
				if (Schema::hasColumn('refunds','project_id') && !DB::select(DB::raw("SHOW INDEXES FROM refunds WHERE key_name='refunds_project_id_index'"))) {
					$table->index('project_id');
				}
				if (Schema::hasColumn('refunds','delivery_id') && !DB::select(DB::raw("SHOW INDEXES FROM refunds WHERE key_name='refunds_delivery_id_index'"))) {
					$table->index('delivery_id');
				} 
			});
		}



		
		// add indexs to refund_return_payments
		if(Schema::hasTable('refund_return_payments') ) {
			Schema::table('refund_return_payments', function (Blueprint $table) {
				if (Schema::hasColumn('refund_return_payments','type') && !DB::select(DB::raw("SHOW INDEXES FROM refund_return_payments WHERE key_name='refund_return_payments_type_index'"))) {
					$table->index('type');
				}
				if (Schema::hasColumn('refund_return_payments','type_id') && !DB::select(DB::raw("SHOW INDEXES FROM refund_return_payments WHERE key_name='refund_return_payments_type_id_index'"))) {
					$table->index('type_id');
				}
				if (Schema::hasColumn('refund_return_payments','inventory_id') && !DB::select(DB::raw("SHOW INDEXES FROM refund_return_payments WHERE key_name='refund_return_payments_inventory_id_index'"))) {
					$table->index('inventory_id');
				}  
				if (Schema::hasColumn('refund_return_payments','income_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM refund_return_payments WHERE key_name='refund_return_payments_income_transaction_index'"))) {
					$table->index('income_transaction');
				}
				if (Schema::hasColumn('refund_return_payments','cost_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM refund_return_payments WHERE key_name='refund_return_payments_cost_transaction_index'"))) {
					$table->index('cost_transaction');
				}
				if (Schema::hasColumn('refund_return_payments','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM refund_return_payments WHERE key_name='refund_return_payments_company_id_index'"))) {
					$table->index('company_id');
				} 
			});
		}




		// add indexs to refund_return_transactions
		if(Schema::hasTable('refund_return_transactions') ) {
			Schema::table('refund_return_transactions', function (Blueprint $table) {
				if (Schema::hasColumn('refund_return_transactions','type_id') && !DB::select(DB::raw("SHOW INDEXES FROM refund_return_transactions WHERE key_name='refund_return_transactions_type_id_index'"))) {
					$table->index('type_id');
				}
				if (Schema::hasColumn('refund_return_transactions','currency') && !DB::select(DB::raw("SHOW INDEXES FROM refund_return_transactions WHERE key_name='refund_return_transactions_currency_index'"))) {
					$table->index('currency');
				}
				if (Schema::hasColumn('refund_return_transactions','amount') && !DB::select(DB::raw("SHOW INDEXES FROM refund_return_transactions WHERE key_name='refund_return_transactions_amount_index'"))) {
					$table->index('amount');
				}  
				if (Schema::hasColumn('refund_return_transactions','account_id') && !DB::select(DB::raw("SHOW INDEXES FROM refund_return_transactions WHERE key_name='refund_return_transactions_account_id_index'"))) {
					$table->index('account_id');
				}
				if (Schema::hasColumn('refund_return_transactions','type') && !DB::select(DB::raw("SHOW INDEXES FROM refund_return_transactions WHERE key_name='refund_return_transactions_type_index'"))) {
					$table->index('type');
				}
				if (Schema::hasColumn('refund_return_transactions','receivable_payment_id') && !DB::select(DB::raw("SHOW INDEXES FROM refund_return_transactions WHERE key_name='refund_return_transactions_receivable_payment_id_index'"))) {
					$table->index('receivable_payment_id');
				} 
				if (Schema::hasColumn('refund_return_transactions','payment_id') && !DB::select(DB::raw("SHOW INDEXES FROM refund_return_transactions WHERE key_name='refund_return_transactions_payment_id_index'"))) {
					$table->index('payment_id');
				}
				if (Schema::hasColumn('refund_return_transactions','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM refund_return_transactions WHERE key_name='refund_return_transactions_company_id_index'"))) {
					$table->index('company_id');
				} 
				if (Schema::hasColumn('refund_return_transactions','inventory_id') && !DB::select(DB::raw("SHOW INDEXES FROM refund_return_transactions WHERE key_name='refund_return_transactions_inventory_id_index'"))) {
					$table->index('inventory_id');
				} if (Schema::hasColumn('refund_return_transactions','income_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM refund_return_transactions WHERE key_name='refund_return_transactions_income_transaction_index'"))) {
					$table->index('income_transaction');
				}  if (Schema::hasColumn('refund_return_transactions','sale_price') && !DB::select(DB::raw("SHOW INDEXES FROM refund_return_transactions WHERE key_name='refund_return_transactions_sale_price_index'"))) {
					$table->index('sale_price');
				} 
			});
		}



		// add indexs to refund_stocks
		if(Schema::hasTable('refund_stocks') ) {
			Schema::table('refund_stocks', function (Blueprint $table) {
				if (Schema::hasColumn('refund_stocks','refund_id') && !DB::select(DB::raw("SHOW INDEXES FROM refund_stocks WHERE key_name='refund_stocks_refund_id_index'"))) {
					$table->index('refund_id');
				}
				if (Schema::hasColumn('refund_stocks','stock_id') && !DB::select(DB::raw("SHOW INDEXES FROM refund_stocks WHERE key_name='refund_stocks_stock_id_index'"))) {
					$table->index('stock_id');
				}
				if (Schema::hasColumn('refund_stocks','transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM refund_stocks WHERE key_name='refund_stocks_transaction_id_index'"))) {
					$table->index('transaction_id');
				}  
				if (Schema::hasColumn('refund_stocks','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM refund_stocks WHERE key_name='refund_stocks_company_id_index'"))) {
					$table->index('company_id');
				}
				if (Schema::hasColumn('refund_stocks','m_stock_in_id') && !DB::select(DB::raw("SHOW INDEXES FROM refund_stocks WHERE key_name='refund_stocks_m_stock_in_id_index'"))) {
					$table->index('m_stock_in_id');
				}
			});
		}
		


		// add indexs to rents
		if(Schema::hasTable('rents') ) {
			Schema::table('rents', function (Blueprint $table) {
				if (Schema::hasColumn('rents','product_id') && !DB::select(DB::raw("SHOW INDEXES FROM rents WHERE key_name='rents_product_id_index'"))) {
					$table->index('product_id');
				}
				if (Schema::hasColumn('rents','amount') && !DB::select(DB::raw("SHOW INDEXES FROM rents WHERE key_name='rents_amount_index'"))) {
					$table->index('amount');
				}
				if (Schema::hasColumn('rents','driver_id') && !DB::select(DB::raw("SHOW INDEXES FROM rents WHERE key_name='rents_driver_id_index'"))) {
					$table->index('driver_id');
				}  
				if (Schema::hasColumn('rents','sale_id') && !DB::select(DB::raw("SHOW INDEXES FROM rents WHERE key_name='rents_sale_id_index'"))) {
					$table->index('sale_id');
				}
				if (Schema::hasColumn('rents','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM rents WHERE key_name='rents_company_id_index'"))) {
					$table->index('company_id');
				}
			});
		}
			

		// add indexs to return_backs
		if(Schema::hasTable('return_backs') ) {
			Schema::table('return_backs', function (Blueprint $table) {
				if (Schema::hasColumn('return_backs','purchase_id') && !DB::select(DB::raw("SHOW INDEXES FROM return_backs WHERE key_name='return_backs_purchase_id_index'"))) {
					$table->index('purchase_id');
				}
				if (Schema::hasColumn('return_backs','date') && !DB::select(DB::raw("SHOW INDEXES FROM return_backs WHERE key_name='return_backs_date_index'"))) {
					$table->index('date');
				}
				if (Schema::hasColumn('return_backs','number') && !DB::select(DB::raw("SHOW INDEXES FROM return_backs WHERE key_name='return_backs_number_index'"))) {
					$table->index('number');
				}  
				if (Schema::hasColumn('return_backs','type') && !DB::select(DB::raw("SHOW INDEXES FROM return_backs WHERE key_name='return_backs_type_index'"))) {
					$table->index('type');
				}
				if (Schema::hasColumn('return_backs','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM return_backs WHERE key_name='return_backs_member_id_index'"))) {
					$table->index('member_id');
				}

				if (Schema::hasColumn('return_backs','transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM return_backs WHERE key_name='return_backs_transaction_id_index'"))) {
					$table->index('transaction_id');
				}  
				if (Schema::hasColumn('return_backs','discount_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM return_backs WHERE key_name='return_backs_discount_transaction_index'"))) {
					$table->index('discount_transaction');
				}
				if (Schema::hasColumn('return_backs','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM return_backs WHERE key_name='return_backs_company_id_index'"))) {
					$table->index('company_id');
				}
			});
		}


		// add indexs to return_refund_details
		if(Schema::hasTable('return_refund_details') ) {
			Schema::table('return_refund_details', function (Blueprint $table) {
				if (Schema::hasColumn('return_refund_details','type_id') && !DB::select(DB::raw("SHOW INDEXES FROM return_refund_details WHERE key_name='return_refund_details_type_id_index'"))) {
					$table->index('type_id');
				}
				if (Schema::hasColumn('return_refund_details','item_id') && !DB::select(DB::raw("SHOW INDEXES FROM return_refund_details WHERE key_name='return_refund_details_item_id_index'"))) {
					$table->index('item_id');
				}
				if (Schema::hasColumn('return_refund_details','um_id') && !DB::select(DB::raw("SHOW INDEXES FROM return_refund_details WHERE key_name='return_refund_details_um_id_index'"))) {
					$table->index('um_id');
				}  
				if (Schema::hasColumn('return_refund_details','site_id') && !DB::select(DB::raw("SHOW INDEXES FROM return_refund_details WHERE key_name='return_refund_details_site_id_index'"))) {
					$table->index('site_id');
				}
				if (Schema::hasColumn('return_refund_details','transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM return_refund_details WHERE key_name='return_refund_details_transaction_id_index'"))) {
					$table->index('transaction_id');
				}

				if (Schema::hasColumn('return_refund_details','other_measure') && !DB::select(DB::raw("SHOW INDEXES FROM return_refund_details WHERE key_name='return_refund_details_other_measure_index'"))) {
					$table->index('other_measure');
				}  
				if (Schema::hasColumn('return_refund_details','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM return_refund_details WHERE key_name='return_refund_details_company_id_index'"))) {
					$table->index('company_id');
				}
				if (Schema::hasColumn('return_refund_details','return_stock_out_id') && !DB::select(DB::raw("SHOW INDEXES FROM return_refund_details WHERE key_name='return_refund_details_return_stock_out_id_index'"))) {
					$table->index('return_stock_out_id');
				}
			});
		}


		// add indexs to return_stock_outs
		if(Schema::hasTable('return_stock_outs') ) {
			Schema::table('return_stock_outs', function (Blueprint $table) {
				if (Schema::hasColumn('return_stock_outs','return_back_id') && !DB::select(DB::raw("SHOW INDEXES FROM return_stock_outs WHERE key_name='return_stock_outs_return_back_id_index'"))) {
					$table->index('return_back_id');
				}
				if (Schema::hasColumn('return_stock_outs','stock_out_id') && !DB::select(DB::raw("SHOW INDEXES FROM return_stock_outs WHERE key_name='return_stock_outs_stock_out_id_index'"))) {
					$table->index('stock_out_id');
				}
				if (Schema::hasColumn('return_stock_outs','m_stock_out_id') && !DB::select(DB::raw("SHOW INDEXES FROM return_stock_outs WHERE key_name='return_stock_outs_m_stock_out_id_index'"))) {
					$table->index('m_stock_out_id');
				}  
				if (Schema::hasColumn('return_stock_outs','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM return_stock_outs WHERE key_name='return_stock_outs_company_id_index'"))) {
					$table->index('company_id');
				}
			});
		}


		// add indexs to rewards
		if(Schema::hasTable('rewards') ) {
			Schema::table('rewards', function (Blueprint $table) {
				if (Schema::hasColumn('rewards','number') && !DB::select(DB::raw("SHOW INDEXES FROM rewards WHERE key_name='rewards_number_index'"))) {
					$table->index('number');
				}
				if (Schema::hasColumn('rewards','employee_id') && !DB::select(DB::raw("SHOW INDEXES FROM rewards WHERE key_name='rewards_employee_id_index'"))) {
					$table->index('employee_id');
				}
				if (Schema::hasColumn('rewards','expense_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM rewards WHERE key_name='rewards_expense_transaction_id_index'"))) {
					$table->index('expense_transaction_id');
				}  
				if (Schema::hasColumn('rewards','payable_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM rewards WHERE key_name='rewards_payable_transaction_id_index'"))) {
					$table->index('payable_transaction_id');
				}
				if (Schema::hasColumn('rewards','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM rewards WHERE key_name='rewards_company_id_index'"))) {
					$table->index('company_id');
				}  
				if (Schema::hasColumn('rewards','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM rewards WHERE key_name='rewards_user_id_index'"))) {
					$table->index('user_id');
				}
			});
		}
	


		// add indexs to risk_managements
		if(Schema::hasTable('risk_managements') ) {
			Schema::table('risk_managements', function (Blueprint $table) {
				if (Schema::hasColumn('risk_managements','type') && !DB::select(DB::raw("SHOW INDEXES FROM risk_managements WHERE key_name='risk_managements_type_index'"))) {
					$table->index('type');
				}
				if (Schema::hasColumn('risk_managements','currency') && !DB::select(DB::raw("SHOW INDEXES FROM risk_managements WHERE key_name='risk_managements_currency_index'"))) {
					$table->index('currency');
				}
				if (Schema::hasColumn('risk_managements','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM risk_managements WHERE key_name='risk_managements_company_id_index'"))) {
					$table->index('company_id');
				}  
				if (Schema::hasColumn('risk_managements','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM risk_managements WHERE key_name='risk_managements_user_id_index'"))) {
					$table->index('user_id');
				}
			});
		}
	

		// add indexs to salary_details
		if(Schema::hasTable('salary_details') ) {
			Schema::table('salary_details', function (Blueprint $table) {
				if (Schema::hasColumn('salary_details','employee_id') && !DB::select(DB::raw("SHOW INDEXES FROM salary_details WHERE key_name='salary_details_employee_id_index'"))) {
					$table->index('employee_id');
				}
				if (Schema::hasColumn('salary_details','amount') && !DB::select(DB::raw("SHOW INDEXES FROM salary_details WHERE key_name='salary_details_amount_index'"))) {
					$table->index('amount');
				}
				if (Schema::hasColumn('salary_details','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM salary_details WHERE key_name='salary_details_company_id_index'"))) {
					$table->index('company_id');
				}  
				if (Schema::hasColumn('salary_details','expense_account_id') && !DB::select(DB::raw("SHOW INDEXES FROM salary_details WHERE key_name='salary_details_expense_account_id_index'"))) {
					$table->index('expense_account_id');
				}
				if (Schema::hasColumn('salary_details','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM salary_details WHERE key_name='salary_details_user_id_index'"))) {
					$table->index('user_id');
				}if (Schema::hasColumn('salary_details','type') && !DB::select(DB::raw("SHOW INDEXES FROM salary_details WHERE key_name='salary_details_type_index'"))) {
					$table->index('type');
				}
			});
		}



		// add indexs to sales_order_details
		if(Schema::hasTable('sales_order_details') ) {
			Schema::table('sales_order_details', function (Blueprint $table) {
				if (Schema::hasColumn('sales_order_details','sales_order_id') && !DB::select(DB::raw("SHOW INDEXES FROM sales_order_details WHERE key_name='sales_order_details_sales_order_id_index'"))) {
					$table->index('sales_order_id');
				}
				if (Schema::hasColumn('sales_order_details','inventory_id') && !DB::select(DB::raw("SHOW INDEXES FROM sales_order_details WHERE key_name='sales_order_details_inventory_id_index'"))) {
					$table->index('inventory_id');
				}
				if (Schema::hasColumn('sales_order_details','site_id') && !DB::select(DB::raw("SHOW INDEXES FROM sales_order_details WHERE key_name='sales_order_details_site_id_index'"))) {
					$table->index('site_id');
				}  
				if (Schema::hasColumn('sales_order_details','um_id') && !DB::select(DB::raw("SHOW INDEXES FROM sales_order_details WHERE key_name='sales_order_details_um_id_index'"))) {
					$table->index('um_id');
				}
				if (Schema::hasColumn('sales_order_details','inventory_category_id') && !DB::select(DB::raw("SHOW INDEXES FROM sales_order_details WHERE key_name='sales_order_details_inventory_category_id_index'"))) {
					$table->index('inventory_category_id');
				}
				if (Schema::hasColumn('sales_order_details','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM sales_order_details WHERE key_name='sales_order_details_user_id_index'"))) {
					$table->index('user_id');
				}  
				if (Schema::hasColumn('sales_order_details','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM sales_order_details WHERE key_name='sales_order_details_company_id_index'"))) {
					$table->index('company_id');
				}
				if (Schema::hasColumn('sales_order_details','other_measure') && !DB::select(DB::raw("SHOW INDEXES FROM sales_order_details WHERE key_name='sales_order_details_other_measure_index'"))) {
					$table->index('other_measure');
				}
			});
		}



		// add indexs to sales_order_records
		if(Schema::hasTable('sales_order_records') ) {
			Schema::table('sales_order_records', function (Blueprint $table) {
				if (Schema::hasColumn('sales_order_records','sales_order_id') && !DB::select(DB::raw("SHOW INDEXES FROM sales_order_records WHERE key_name='sales_order_records_sales_order_id_index'"))) {
					$table->index('sales_order_id');
				}
				if (Schema::hasColumn('sales_order_records','stock_out_id') && !DB::select(DB::raw("SHOW INDEXES FROM sales_order_records WHERE key_name='sales_order_records_stock_out_id_index'"))) {
					$table->index('stock_out_id');
				}
				if (Schema::hasColumn('sales_order_records','sales_order_detail_id') && !DB::select(DB::raw("SHOW INDEXES FROM sales_order_records WHERE key_name='sales_order_records_sales_order_detail_id_index'"))) {
					$table->index('sales_order_detail_id');
				}  
				if (Schema::hasColumn('sales_order_records','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM sales_order_records WHERE key_name='sales_order_records_company_id_index'"))) {
					$table->index('company_id');
				}
				if (Schema::hasColumn('sales_order_records','m_stock_out_id') && !DB::select(DB::raw("SHOW INDEXES FROM sales_order_records WHERE key_name='sales_order_records_m_stock_out_id_index'"))) {
					$table->index('m_stock_out_id');
				} 
			});
		}



		// add indexs to sales_order_records
		if(Schema::hasTable('sales_order_records') ) {
			Schema::table('sales_order_records', function (Blueprint $table) {
				if (Schema::hasColumn('sales_order_records','sales_order_id') && !DB::select(DB::raw("SHOW INDEXES FROM sales_order_records WHERE key_name='sales_order_records_sales_order_id_index'"))) {
					$table->index('sales_order_id');
				}
				if (Schema::hasColumn('sales_order_records','stock_out_id') && !DB::select(DB::raw("SHOW INDEXES FROM sales_order_records WHERE key_name='sales_order_records_stock_out_id_index'"))) {
					$table->index('stock_out_id');
				}
				if (Schema::hasColumn('sales_order_records','sales_order_detail_id') && !DB::select(DB::raw("SHOW INDEXES FROM sales_order_records WHERE key_name='sales_order_records_sales_order_detail_id_index'"))) {
					$table->index('sales_order_detail_id');
				}  
				if (Schema::hasColumn('sales_order_records','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM sales_order_records WHERE key_name='sales_order_records_company_id_index'"))) {
					$table->index('company_id');
				}
				if (Schema::hasColumn('sales_order_records','m_stock_out_id') && !DB::select(DB::raw("SHOW INDEXES FROM sales_order_records WHERE key_name='sales_order_records_m_stock_out_id_index'"))) {
					$table->index('m_stock_out_id');
				} 
			});
		}


		// add indexs to sale_by_type_details
		if(Schema::hasTable('sale_by_type_details') ) {
			Schema::table('sale_by_type_details', function (Blueprint $table) {
				if (Schema::hasColumn('sale_by_type_details','sale_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_by_type_details WHERE key_name='sale_by_type_details_sale_id_index'"))) {
					$table->index('sale_id');
				}
				if (Schema::hasColumn('sale_by_type_details','type_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_by_type_details WHERE key_name='sale_by_type_details_type_id_index'"))) {
					$table->index('type_id');
				}
				if (Schema::hasColumn('sale_by_type_details','driver_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_by_type_details WHERE key_name='sale_by_type_details_driver_id_index'"))) {
					$table->index('driver_id');
				}  
				if (Schema::hasColumn('sale_by_type_details','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_by_type_details WHERE key_name='sale_by_type_details_company_id_index'"))) {
					$table->index('company_id');
				} if (Schema::hasColumn('sale_by_type_details','type') && !DB::select(DB::raw("SHOW INDEXES FROM sale_by_type_details WHERE key_name='sale_by_type_details_type_index'"))) {
					$table->index('type');
				} 
			});
		}



	// add indexs to sale_commissions
	if(Schema::hasTable('sale_commissions') ) {
		Schema::table('sale_commissions', function (Blueprint $table) {
			if (Schema::hasColumn('sale_commissions','commission_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_commissions WHERE key_name='sale_commissions_commission_id_index'"))) {
				$table->index('commission_id');
			}
			if (Schema::hasColumn('sale_commissions','sale_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_commissions WHERE key_name='sale_commissions_sale_id_index'"))) {
				$table->index('sale_id');
			}
			if (Schema::hasColumn('sale_commissions','sale_info_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_commissions WHERE key_name='sale_commissions_sale_info_id_index'"))) {
				$table->index('sale_info_id');
			}  
			if (Schema::hasColumn('sale_commissions','vendor_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_commissions WHERE key_name='sale_commissions_vendor_id_index'"))) {
				$table->index('vendor_id');
			} 

			if (Schema::hasColumn('sale_commissions','vendor_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_commissions WHERE key_name='sale_commissions_vendor_transaction_id_index'"))) {
				$table->index('vendor_transaction_id');
			}
			if (Schema::hasColumn('sale_commissions','customer_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_commissions WHERE key_name='sale_commissions_customer_id_index'"))) {
				$table->index('customer_id');
			}  
			if (Schema::hasColumn('sale_commissions','customer_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_commissions WHERE key_name='sale_commissions_customer_transaction_id_index'"))) {
				$table->index('customer_transaction_id');
			} 
		});
	}



	// add indexs to sale_details
	if(Schema::hasTable('sale_details') ) {
		Schema::table('sale_details', function (Blueprint $table) {
			if (Schema::hasColumn('sale_details','sale_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_details WHERE key_name='sale_details_sale_id_index'"))) {
				$table->index('sale_id');
			}
			if (Schema::hasColumn('sale_details','item_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_details WHERE key_name='sale_details_item_id_index'"))) {
				$table->index('item_id');
			}
			if (Schema::hasColumn('sale_details','amount') && !DB::select(DB::raw("SHOW INDEXES FROM sale_details WHERE key_name='sale_details_amount_index'"))) {
				$table->index('amount');
			}  
			if (Schema::hasColumn('sale_details','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_details WHERE key_name='sale_details_company_id_index'"))) {
				$table->index('company_id');
			}  
		});
	}



	// add indexs to sale_discount_date
	if(Schema::hasTable('sale_discount_date') ) {
		Schema::table('sale_discount_date', function (Blueprint $table) {
			if (Schema::hasColumn('sale_discount_date','name') && !DB::select(DB::raw("SHOW INDEXES FROM sale_discount_date WHERE key_name='sale_discount_date_name_index'"))) {
				$table->index('name');
			}
			if (Schema::hasColumn('sale_discount_date','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_discount_date WHERE key_name='sale_discount_date_company_id_index'"))) {
				$table->index('company_id');
			}
			if (Schema::hasColumn('sale_discount_date','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_discount_date WHERE key_name='sale_discount_date_user_id_index'"))) {
				$table->index('user_id');
			}  
		});
	}

	// add indexs to sale_fixed_asset
	if(Schema::hasTable('sale_fixed_asset') ) {
		Schema::table('sale_fixed_asset', function (Blueprint $table) {
			if (Schema::hasColumn('sale_fixed_asset','fixed_asset_manage_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_fixed_asset WHERE key_name='sale_fixed_asset_fixed_asset_manage_id_index'"))) {
				$table->index('fixed_asset_manage_id');
			}
			if (Schema::hasColumn('sale_fixed_asset','customer_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_fixed_asset WHERE key_name='sale_fixed_asset_customer_id_index'"))) {
				$table->index('customer_id');
			}
			if (Schema::hasColumn('sale_fixed_asset','transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_fixed_asset WHERE key_name='sale_fixed_asset_transaction_id_index'"))) {
				$table->index('transaction_id');
			} 
			if (Schema::hasColumn('sale_fixed_asset','opening_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_fixed_asset WHERE key_name='sale_fixed_asset_opening_transaction_id_index'"))) {
				$table->index('opening_transaction_id');
			}
			if (Schema::hasColumn('sale_fixed_asset','expense_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_fixed_asset WHERE key_name='sale_fixed_asset_expense_transaction_id_index'"))) {
				$table->index('expense_transaction_id');
			}
			if (Schema::hasColumn('sale_fixed_asset','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_fixed_asset WHERE key_name='sale_fixed_asset_user_id_index'"))) {
				$table->index('user_id');
			}
			
			if (Schema::hasColumn('sale_fixed_asset','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_fixed_asset WHERE key_name='sale_fixed_asset_company_id_index'"))) {
				$table->index('company_id');
			} 
		});
	}


	// add indexs to selected_dropdown
	if(Schema::hasTable('selected_dropdown') ) {
		Schema::table('selected_dropdown', function (Blueprint $table) {
			if (Schema::hasColumn('selected_dropdown','dropdown') && !DB::select(DB::raw("SHOW INDEXES FROM selected_dropdown WHERE key_name='selected_dropdown_dropdown_index'"))) {
				$table->index('dropdown');
			}
			if (Schema::hasColumn('selected_dropdown','selected_id') && !DB::select(DB::raw("SHOW INDEXES FROM selected_dropdown WHERE key_name='selected_dropdown_selected_id_index'"))) {
				$table->index('selected_id');
			}
			if (Schema::hasColumn('selected_dropdown','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM selected_dropdown WHERE key_name='selected_dropdown_company_id_index'"))) {
				$table->index('company_id');
			} 
			if (Schema::hasColumn('selected_dropdown','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM selected_dropdown WHERE key_name='selected_dropdown_user_id_index'"))) {
				$table->index('user_id');
			}    
		});
	}



	// add indexs to send_moneys
	if(Schema::hasTable('send_moneys') ) {
		Schema::table('send_moneys', function (Blueprint $table) {
			if (Schema::hasColumn('send_moneys','contract_id') && !DB::select(DB::raw("SHOW INDEXES FROM send_moneys WHERE key_name='send_moneys_contract_id_index'"))) {
				$table->index('contract_id');
			}
			if (Schema::hasColumn('send_moneys','account_id') && !DB::select(DB::raw("SHOW INDEXES FROM send_moneys WHERE key_name='send_moneys_account_id_index'"))) {
				$table->index('account_id');
			}
			if (Schema::hasColumn('send_moneys','transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM send_moneys WHERE key_name='send_moneys_transaction_id_index'"))) {
				$table->index('transaction_id');
			} 
			if (Schema::hasColumn('send_moneys','receivable_id') && !DB::select(DB::raw("SHOW INDEXES FROM send_moneys WHERE key_name='send_moneys_receivable_id_index'"))) {
				$table->index('receivable_id');
			}    

			if (Schema::hasColumn('send_moneys','payable_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM send_moneys WHERE key_name='send_moneys_payable_transaction_index'"))) {
				$table->index('payable_transaction');
			}
			if (Schema::hasColumn('send_moneys','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM send_moneys WHERE key_name='send_moneys_company_id_index'"))) {
				$table->index('company_id');
			} 
			if (Schema::hasColumn('send_moneys','expense_id') && !DB::select(DB::raw("SHOW INDEXES FROM send_moneys WHERE key_name='send_moneys_expense_id_index'"))) {
				$table->index('expense_id');
			} if (Schema::hasColumn('send_moneys','bank_comm_tran_id') && !DB::select(DB::raw("SHOW INDEXES FROM send_moneys WHERE key_name='send_moneys_bank_comm_tran_id_index'"))) {
				$table->index('bank_comm_tran_id');
			} 
			if (Schema::hasColumn('send_moneys','expense_comm_tran_id') && !DB::select(DB::raw("SHOW INDEXES FROM send_moneys WHERE key_name='send_moneys_expense_comm_tran_id_index'"))) {
				$table->index('expense_comm_tran_id');
			} if (Schema::hasColumn('send_moneys','type') && !DB::select(DB::raw("SHOW INDEXES FROM send_moneys WHERE key_name='send_moneys_type_index'"))) {
				$table->index('type');
			} if (Schema::hasColumn('send_moneys','edit_type') && !DB::select(DB::raw("SHOW INDEXES FROM send_moneys WHERE key_name='send_moneys_edit_type_index'"))) {
				$table->index('edit_type');
			} 
		});
	}



	// add indexs to stucks
	if(Schema::hasTable('stucks') ) {
		Schema::table('stucks', function (Blueprint $table) {
			if (Schema::hasColumn('stucks','item_id') && !DB::select(DB::raw("SHOW INDEXES FROM stucks WHERE key_name='stucks_item_id_index'"))) {
				$table->index('item_id');
			}
			if (Schema::hasColumn('stucks','quantity') && !DB::select(DB::raw("SHOW INDEXES FROM stucks WHERE key_name='stucks_quantity_index'"))) {
				$table->index('quantity');
			}  
		});
	}



	// add indexs to system_alerts
	if(Schema::hasTable('system_alerts') ) {
		Schema::table('system_alerts', function (Blueprint $table) {
			if (Schema::hasColumn('system_alerts','date') && !DB::select(DB::raw("SHOW INDEXES FROM system_alerts WHERE key_name='system_alerts_date_index'"))) {
				$table->index('date');
			}
			if (Schema::hasColumn('system_alerts','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM system_alerts WHERE key_name='system_alerts_member_id_index'"))) {
				$table->index('member_id');
			}  
			if (Schema::hasColumn('system_alerts','receive_id') && !DB::select(DB::raw("SHOW INDEXES FROM system_alerts WHERE key_name='system_alerts_receive_id_index'"))) {
				$table->index('receive_id');
			}
			if (Schema::hasColumn('system_alerts','payment_id') && !DB::select(DB::raw("SHOW INDEXES FROM system_alerts WHERE key_name='system_alerts_payment_id_index'"))) {
				$table->index('payment_id');
			}
			if (Schema::hasColumn('system_alerts','sale_id') && !DB::select(DB::raw("SHOW INDEXES FROM system_alerts WHERE key_name='system_alerts_sale_id_index'"))) {
				$table->index('sale_id');
			}  
			if (Schema::hasColumn('system_alerts','type') && !DB::select(DB::raw("SHOW INDEXES FROM system_alerts WHERE key_name='system_alerts_type_index'"))) {
				$table->index('type');
			}
			if (Schema::hasColumn('system_alerts','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM system_alerts WHERE key_name='system_alerts_company_id_index'"))) {
				$table->index('company_id');
			}
		});
	}



		// add indexs to taxations
		if(Schema::hasTable('taxations') ) {
			Schema::table('taxations', function (Blueprint $table) {
				if (Schema::hasColumn('taxations','name') && !DB::select(DB::raw("SHOW INDEXES FROM taxations WHERE key_name='taxations_name_index'"))) {
					$table->index('name');
				}
				if (Schema::hasColumn('taxations','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM taxations WHERE key_name='taxations_member_id_index'"))) {
					$table->index('member_id');
				}  
				if (Schema::hasColumn('taxations','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM taxations WHERE key_name='taxations_company_id_index'"))) {
					$table->index('company_id');
				}
				if (Schema::hasColumn('taxations','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM taxations WHERE key_name='taxations_user_id_index'"))) {
					$table->index('user_id');
				}
			});
		}



		// add indexs to temp_form
		if(Schema::hasTable('temp_form') ) {
			Schema::table('temp_form', function (Blueprint $table) {
				if (Schema::hasColumn('temp_form','type') && !DB::select(DB::raw("SHOW INDEXES FROM temp_form WHERE key_name='temp_form_type_index'"))) {
					$table->index('type');
				}
				if (Schema::hasColumn('temp_form','number') && !DB::select(DB::raw("SHOW INDEXES FROM temp_form WHERE key_name='temp_form_number_index'"))) {
					$table->index('number');
				}  
				if (Schema::hasColumn('temp_form','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM temp_form WHERE key_name='temp_form_member_id_index'"))) {
					$table->index('member_id');
				}
				if (Schema::hasColumn('temp_form','currency') && !DB::select(DB::raw("SHOW INDEXES FROM temp_form WHERE key_name='temp_form_currency_index'"))) {
					$table->index('currency');
				}
				if (Schema::hasColumn('temp_form','class_id') && !DB::select(DB::raw("SHOW INDEXES FROM temp_form WHERE key_name='temp_form_class_id_index'"))) {
					$table->index('class_id');
				}  
				if (Schema::hasColumn('temp_form','sale_area_id') && !DB::select(DB::raw("SHOW INDEXES FROM temp_form WHERE key_name='temp_form_sale_area_id_index'"))) {
					$table->index('sale_area_id');
				}
				if (Schema::hasColumn('temp_form','driver_id') && !DB::select(DB::raw("SHOW INDEXES FROM temp_form WHERE key_name='temp_form_driver_id_index'"))) {
					$table->index('driver_id');
				}

				if (Schema::hasColumn('temp_form','taxation_id') && !DB::select(DB::raw("SHOW INDEXES FROM temp_form WHERE key_name='temp_form_taxation_id_index'"))) {
					$table->index('taxation_id');
				}
				if (Schema::hasColumn('temp_form','price_level_id') && !DB::select(DB::raw("SHOW INDEXES FROM temp_form WHERE key_name='temp_form_price_level_id_index'"))) {
					$table->index('price_level_id');
				}  
				if (Schema::hasColumn('temp_form','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM temp_form WHERE key_name='temp_form_user_id_index'"))) {
					$table->index('user_id');
				}
				if (Schema::hasColumn('temp_form','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM temp_form WHERE key_name='temp_form_company_id_index'"))) {
					$table->index('company_id');
				}
			});
		}

			
		// add indexs to temp_form_detail
		if(Schema::hasTable('temp_form_detail') ) {
			Schema::table('temp_form_detail', function (Blueprint $table) {
				if (Schema::hasColumn('temp_form_detail','temp_form_id') && !DB::select(DB::raw("SHOW INDEXES FROM temp_form_detail WHERE key_name='temp_form_detail_temp_form_id_index'"))) {
					$table->index('temp_form_id');
				}
				if (Schema::hasColumn('temp_form_detail','inventory_id') && !DB::select(DB::raw("SHOW INDEXES FROM temp_form_detail WHERE key_name='temp_form_detail_inventory_id_index'"))) {
					$table->index('inventory_id');
				}  
				if (Schema::hasColumn('temp_form_detail','site_id') && !DB::select(DB::raw("SHOW INDEXES FROM temp_form_detail WHERE key_name='temp_form_detail_site_id_index'"))) {
					$table->index('site_id');
				}
				if (Schema::hasColumn('temp_form_detail','um_id') && !DB::select(DB::raw("SHOW INDEXES FROM temp_form_detail WHERE key_name='temp_form_detail_um_id_index'"))) {
					$table->index('um_id');
				}
				if (Schema::hasColumn('temp_form_detail','other_measure') && !DB::select(DB::raw("SHOW INDEXES FROM temp_form_detail WHERE key_name='temp_form_detail_other_measure_index'"))) {
					$table->index('other_measure');
				}
				if (Schema::hasColumn('temp_form_detail','um1_id') && !DB::select(DB::raw("SHOW INDEXES FROM temp_form_detail WHERE key_name='temp_form_detail_um1_id_index'"))) {
					$table->index('um1_id');
				}  
				if (Schema::hasColumn('temp_form_detail','um2_id') && !DB::select(DB::raw("SHOW INDEXES FROM temp_form_detail WHERE key_name='temp_form_detail_um2_id_index'"))) {
					$table->index('um2_id');
				}
				if (Schema::hasColumn('temp_form_detail','um3_id') && !DB::select(DB::raw("SHOW INDEXES FROM temp_form_detail WHERE key_name='temp_form_detail_um3_id_index'"))) {
					$table->index('um3_id');
				}

				if (Schema::hasColumn('temp_form_detail','loading_detail_id') && !DB::select(DB::raw("SHOW INDEXES FROM temp_form_detail WHERE key_name='temp_form_detail_loading_detail_id_index'"))) {
					$table->index('loading_detail_id');
				}
				if (Schema::hasColumn('temp_form_detail','row_taxation_id') && !DB::select(DB::raw("SHOW INDEXES FROM temp_form_detail WHERE key_name='temp_form_detail_row_taxation_id_index'"))) {
					$table->index('row_taxation_id');
				}
				if (Schema::hasColumn('temp_form_detail','vehicle_name') && !DB::select(DB::raw("SHOW INDEXES FROM temp_form_detail WHERE key_name='temp_form_detail_vehicle_name_index'"))) {
					$table->index('vehicle_name');
				}  
				if (Schema::hasColumn('temp_form_detail','price_level_id') && !DB::select(DB::raw("SHOW INDEXES FROM temp_form_detail WHERE key_name='temp_form_detail_price_level_id_index'"))) {
					$table->index('price_level_id');
				}
				if (Schema::hasColumn('temp_form_detail','online_order_detail_id') && !DB::select(DB::raw("SHOW INDEXES FROM temp_form_detail WHERE key_name='temp_form_detail_online_order_detail_id_index'"))) {
					$table->index('online_order_detail_id');
				}if (Schema::hasColumn('temp_form_detail','type') && !DB::select(DB::raw("SHOW INDEXES FROM temp_form_detail WHERE key_name='temp_form_detail_type_index'"))) {
					$table->index('type');
				}if (Schema::hasColumn('temp_form_detail','inventory_category_id') && !DB::select(DB::raw("SHOW INDEXES FROM temp_form_detail WHERE key_name='temp_form_detail_inventory_category_id_index'"))) {
					$table->index('inventory_category_id');
				}if (Schema::hasColumn('temp_form_detail','contract_id') && !DB::select(DB::raw("SHOW INDEXES FROM temp_form_detail WHERE key_name='temp_form_detail_contract_id_index'"))) {
					$table->index('contract_id');
				}if (Schema::hasColumn('temp_form_detail','sale_order_detail_id') && !DB::select(DB::raw("SHOW INDEXES FROM temp_form_detail WHERE key_name='temp_form_detail_sale_order_detail_id_index'"))) {
					$table->index('sale_order_detail_id');
				}if (Schema::hasColumn('temp_form_detail','cost') && !DB::select(DB::raw("SHOW INDEXES FROM temp_form_detail WHERE key_name='temp_form_detail_cost_index'"))) {
					$table->index('cost');
				}
			});
		}



		// add indexs to taxations
		if(Schema::hasTable('taxations') ) {
			Schema::table('taxations', function (Blueprint $table) {
				if (Schema::hasColumn('taxations','name') && !DB::select(DB::raw("SHOW INDEXES FROM taxations WHERE key_name='taxations_name_index'"))) {
					$table->index('name');
				}
				if (Schema::hasColumn('taxations','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM taxations WHERE key_name='taxations_member_id_index'"))) {
					$table->index('member_id');
				}  
				if (Schema::hasColumn('taxations','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM taxations WHERE key_name='taxations_company_id_index'"))) {
					$table->index('company_id');
				}
				if (Schema::hasColumn('taxations','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM taxations WHERE key_name='taxations_user_id_index'"))) {
					$table->index('user_id');
				}
			});
		}

		// add indexs to temp_item
		if(Schema::hasTable('temp_item') ) {
			Schema::table('temp_item', function (Blueprint $table) {
				if (Schema::hasColumn('temp_item','name') && !DB::select(DB::raw("SHOW INDEXES FROM temp_item WHERE key_name='temp_item_name_index'"))) {
					$table->index('name');
				}
				if (Schema::hasColumn('temp_item','code') && !DB::select(DB::raw("SHOW INDEXES FROM temp_item WHERE key_name='temp_item_code_index'"))) {
					$table->index('code');
				}  
				if (Schema::hasColumn('temp_item','purchase_rate') && !DB::select(DB::raw("SHOW INDEXES FROM temp_item WHERE key_name='temp_item_purchase_rate_index'"))) {
					$table->index('purchase_rate');
				}
				if (Schema::hasColumn('temp_item','um_id') && !DB::select(DB::raw("SHOW INDEXES FROM temp_item WHERE key_name='temp_item_um_id_index'"))) {
					$table->index('um_id');
				}
				if (Schema::hasColumn('temp_item','category') && !DB::select(DB::raw("SHOW INDEXES FROM temp_item WHERE key_name='temp_item_category_index'"))) {
					$table->index('category');
				}
				if (Schema::hasColumn('temp_item','inventory_category_id') && !DB::select(DB::raw("SHOW INDEXES FROM temp_item WHERE key_name='temp_item_inventory_category_id_index'"))) {
					$table->index('inventory_category_id');
				}
			});
		}
	

		// add indexs to temp_items
		if(Schema::hasTable('temp_items') ) {
			Schema::table('temp_items', function (Blueprint $table) {
				if (Schema::hasColumn('temp_items','name') && !DB::select(DB::raw("SHOW INDEXES FROM temp_items WHERE key_name='temp_items_name_index'"))) {
					$table->index('name');
				}
				if (Schema::hasColumn('temp_items','code') && !DB::select(DB::raw("SHOW INDEXES FROM temp_items WHERE key_name='temp_items_code_index'"))) {
					$table->index('code');
				}  
				if (Schema::hasColumn('temp_items','serial_number') && !DB::select(DB::raw("SHOW INDEXES FROM temp_items WHERE key_name='temp_items_serial_number_index'"))) {
					$table->index('serial_number');
				}
				if (Schema::hasColumn('temp_items','purchase_rate') && !DB::select(DB::raw("SHOW INDEXES FROM temp_items WHERE key_name='temp_items_purchase_rate_index'"))) {
					$table->index('purchase_rate');
				}
				if (Schema::hasColumn('temp_items','um_id') && !DB::select(DB::raw("SHOW INDEXES FROM temp_items WHERE key_name='temp_items_um_id_index'"))) {
					$table->index('um_id');
				}
				if (Schema::hasColumn('temp_items','inventory_category_id') && !DB::select(DB::raw("SHOW INDEXES FROM temp_items WHERE key_name='temp_items_inventory_category_id_index'"))) {
					$table->index('inventory_category_id');
				}

				if (Schema::hasColumn('temp_items','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM temp_items WHERE key_name='temp_items_company_id_index'"))) {
					$table->index('company_id');
				}
			});
		}




	// add indexs to temp_members
	if(Schema::hasTable('temp_members') ) {
		Schema::table('temp_members', function (Blueprint $table) {
			if (Schema::hasColumn('temp_members','code') && !DB::select(DB::raw("SHOW INDEXES FROM temp_members WHERE key_name='temp_members_code_index'"))) {
				$table->index('code');
			}
			if (Schema::hasColumn('temp_members','payable_id') && !DB::select(DB::raw("SHOW INDEXES FROM temp_members WHERE key_name='temp_members_payable_id_index'"))) {
				$table->index('payable_id');
			}  
			if (Schema::hasColumn('temp_members','receivable_id') && !DB::select(DB::raw("SHOW INDEXES FROM temp_members WHERE key_name='temp_members_receivable_id_index'"))) {
				$table->index('receivable_id');
			}
			if (Schema::hasColumn('temp_members','price_level_id') && !DB::select(DB::raw("SHOW INDEXES FROM temp_members WHERE key_name='temp_members_price_level_id_index'"))) {
				$table->index('price_level_id');
			}
			if (Schema::hasColumn('temp_members','class_id') && !DB::select(DB::raw("SHOW INDEXES FROM temp_members WHERE key_name='temp_members_class_id_index'"))) {
				$table->index('class_id');
			}
			if (Schema::hasColumn('temp_members','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM temp_members WHERE key_name='temp_members_company_id_index'"))) {
				$table->index('company_id');
			}

			if (Schema::hasColumn('temp_members','currency') && !DB::select(DB::raw("SHOW INDEXES FROM temp_members WHERE key_name='temp_members_currency_index'"))) {
				$table->index('currency');
			}
			
			if (Schema::hasColumn('temp_members','type') && !DB::select(DB::raw("SHOW INDEXES FROM temp_members WHERE key_name='temp_members_type_index'"))) {
				$table->index('type');
			}
		});
	}


	// add indexs to temp_site
	if(Schema::hasTable('temp_site') ) {
		Schema::table('temp_site', function (Blueprint $table) {
			if (Schema::hasColumn('temp_site','inventory_site_id') && !DB::select(DB::raw("SHOW INDEXES FROM temp_site WHERE key_name='temp_site_inventory_site_id_index'"))) {
				$table->index('inventory_site_id');
			}
			if (Schema::hasColumn('temp_site','item_id') && !DB::select(DB::raw("SHOW INDEXES FROM temp_site WHERE key_name='temp_site_item_id_index'"))) {
				$table->index('item_id');
			} 
		});
	}


	
	// add indexs to transfers
	if(Schema::hasTable('transfers') ) {
		Schema::table('transfers', function (Blueprint $table) {
			if (Schema::hasColumn('transfers','transport_id') && !DB::select(DB::raw("SHOW INDEXES FROM transfers WHERE key_name='transfers_transport_id_index'"))) {
				$table->index('transport_id');
			}
			if (Schema::hasColumn('transfers','type_id') && !DB::select(DB::raw("SHOW INDEXES FROM transfers WHERE key_name='transfers_type_id_index'"))) {
				$table->index('type_id');
			} 
			if (Schema::hasColumn('transfers','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM transfers WHERE key_name='transfers_company_id_index'"))) {
				$table->index('company_id');
			}
			if (Schema::hasColumn('transfers','plate_number') && !DB::select(DB::raw("SHOW INDEXES FROM transfers WHERE key_name='transfers_plate_number_index'"))) {
				$table->index('plate_number');
			} 
		});
	}



	
	// add indexs to transfer_accounts
	if(Schema::hasTable('transfer_accounts') ) {
		Schema::table('transfer_accounts', function (Blueprint $table) {
			if (Schema::hasColumn('transfer_accounts','from_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM transfer_accounts WHERE key_name='transfer_accounts_from_transaction_index'"))) {
				$table->index('from_transaction');
			}
			if (Schema::hasColumn('transfer_accounts','to_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM transfer_accounts WHERE key_name='transfer_accounts_to_transaction_index'"))) {
				$table->index('to_transaction');
			} 
			if (Schema::hasColumn('transfer_accounts','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM transfer_accounts WHERE key_name='transfer_accounts_user_id_index'"))) {
				$table->index('user_id');
			}
			if (Schema::hasColumn('transfer_accounts','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM transfer_accounts WHERE key_name='transfer_accounts_company_id_index'"))) {
				$table->index('company_id');
			} 

			if (Schema::hasColumn('transfer_accounts','expense_id') && !DB::select(DB::raw("SHOW INDEXES FROM transfer_accounts WHERE key_name='transfer_accounts_expense_id_index'"))) {
				$table->index('expense_id');
			}
			if (Schema::hasColumn('transfer_accounts','bank_comm_tran_id') && !DB::select(DB::raw("SHOW INDEXES FROM transfer_accounts WHERE key_name='transfer_accounts_bank_comm_tran_id_index'"))) {
				$table->index('bank_comm_tran_id');
			} 
			if (Schema::hasColumn('transfer_accounts','expense_comm_tran_id') && !DB::select(DB::raw("SHOW INDEXES FROM transfer_accounts WHERE key_name='transfer_accounts_expense_comm_tran_id_index'"))) {
				$table->index('expense_comm_tran_id');
			}
			if (Schema::hasColumn('transfer_accounts','project_id') && !DB::select(DB::raw("SHOW INDEXES FROM transfer_accounts WHERE key_name='transfer_accounts_project_id_index'"))) {
				$table->index('project_id');
			} if (Schema::hasColumn('transfer_accounts','gain_loss_tran_id') && !DB::select(DB::raw("SHOW INDEXES FROM transfer_accounts WHERE key_name='transfer_accounts_gain_loss_tran_id_index'"))) {
				$table->index('gain_loss_tran_id');
			} 
		});
	}




	// add indexs to transfer_and_loadings
	if(Schema::hasTable('transfer_and_loadings') ) {
		Schema::table('transfer_and_loadings', function (Blueprint $table) {
			if (Schema::hasColumn('transfer_and_loadings','type') && !DB::select(DB::raw("SHOW INDEXES FROM transfer_and_loadings WHERE key_name='transfer_and_loadings_type_index'"))) {
				$table->index('type');
			}
			if (Schema::hasColumn('transfer_and_loadings','type_id') && !DB::select(DB::raw("SHOW INDEXES FROM transfer_and_loadings WHERE key_name='transfer_and_loadings_type_id_index'"))) {
				$table->index('type_id');
			} 
			if (Schema::hasColumn('transfer_and_loadings','inventory_transfer_id') && !DB::select(DB::raw("SHOW INDEXES FROM transfer_and_loadings WHERE key_name='transfer_and_loadings_inventory_transfer_id_index'"))) {
				$table->index('inventory_transfer_id');
			}
			if (Schema::hasColumn('transfer_and_loadings','adjustment_id') && !DB::select(DB::raw("SHOW INDEXES FROM transfer_and_loadings WHERE key_name='transfer_and_loadings_adjustment_id_index'"))) {
				$table->index('adjustment_id');
			} 

			if (Schema::hasColumn('transfer_and_loadings','other_income_account_id') && !DB::select(DB::raw("SHOW INDEXES FROM transfer_and_loadings WHERE key_name='transfer_and_loadings_other_income_account_id_index'"))) {
				$table->index('other_income_account_id');
			}
			if (Schema::hasColumn('transfer_and_loadings','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM transfer_and_loadings WHERE key_name='transfer_and_loadings_company_id_index'"))) {
				$table->index('company_id');
			} 
			if (Schema::hasColumn('transfer_and_loadings','contract_id') && !DB::select(DB::raw("SHOW INDEXES FROM transfer_and_loadings WHERE key_name='transfer_and_loadings_contract_id_index'"))) {
				$table->index('contract_id');
			}
			if (Schema::hasColumn('transfer_and_loadings','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM transfer_and_loadings WHERE key_name='transfer_and_loadings_user_id_index'"))) {
				$table->index('user_id');
			}
		});
	}


		// add indexs to transfer_details
		if(Schema::hasTable('transfer_details') ) {
			Schema::table('transfer_details', function (Blueprint $table) {
				if (Schema::hasColumn('transfer_details','transfer_id') && !DB::select(DB::raw("SHOW INDEXES FROM transfer_details WHERE key_name='transfer_details_transfer_id_index'"))) {
					$table->index('transfer_id');
				}
				if (Schema::hasColumn('transfer_details','product_id') && !DB::select(DB::raw("SHOW INDEXES FROM transfer_details WHERE key_name='transfer_details_product_id_index'"))) {
					$table->index('product_id');
				} 
				if (Schema::hasColumn('transfer_details','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM transfer_details WHERE key_name='transfer_details_company_id_index'"))) {
					$table->index('company_id');
				}
			});
		}
	


	// add indexs to transports
	if(Schema::hasTable('transports') ) {
		Schema::table('transports', function (Blueprint $table) {
			if (Schema::hasColumn('transports','name') && !DB::select(DB::raw("SHOW INDEXES FROM transports WHERE key_name='transports_name_index'"))) {
				$table->index('name');
			}
			if (Schema::hasColumn('transports','tazkira_number') && !DB::select(DB::raw("SHOW INDEXES FROM transports WHERE key_name='transports_tazkira_number_index'"))) {
				$table->index('tazkira_number');
			} 
			if (Schema::hasColumn('transports','type') && !DB::select(DB::raw("SHOW INDEXES FROM transports WHERE key_name='transports_type_index'"))) {
				$table->index('type');
			} 
			if (Schema::hasColumn('transports','parent_id') && !DB::select(DB::raw("SHOW INDEXES FROM transports WHERE key_name='transports_parent_id_index'"))) {
				$table->index('parent_id');
			} 
			if (Schema::hasColumn('transports','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM transports WHERE key_name='transports_company_id_index'"))) {
				$table->index('company_id');
			}
		});
	}
	
	// add indexs to transport_companies
	if(Schema::hasTable('transport_companies') ) {
		Schema::table('transport_companies', function (Blueprint $table) {
			if (Schema::hasColumn('transport_companies','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM transport_companies WHERE key_name='transport_companies_company_id_index'"))) {
				$table->index('company_id');
			} 
			if (Schema::hasColumn('transport_companies','number') && !DB::select(DB::raw("SHOW INDEXES FROM transport_companies WHERE key_name='transport_companies_number_index'"))) {
				$table->index('number');
			} 
			if (Schema::hasColumn('transport_companies','expire_date') && !DB::select(DB::raw("SHOW INDEXES FROM transport_companies WHERE key_name='transport_companies_expire_date_index'"))) {
				$table->index('expire_date');
			} 
			if (Schema::hasColumn('transport_companies','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM transport_companies WHERE key_name='transport_companies_user_id_index'"))) {
				$table->index('user_id');
			}
		});
	}



	// add indexs to vehicle_cmr
	if(Schema::hasTable('vehicle_cmr') ) {
		Schema::table('vehicle_cmr', function (Blueprint $table) {
			if (Schema::hasColumn('vehicle_cmr','number') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_cmr WHERE key_name='vehicle_cmr_number_index'"))) {
				$table->index('number');
			} 
			if (Schema::hasColumn('vehicle_cmr','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_cmr WHERE key_name='vehicle_cmr_member_id_index'"))) {
				$table->index('member_id');
			} 
			if (Schema::hasColumn('vehicle_cmr','date') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_cmr WHERE key_name='vehicle_cmr_date_index'"))) {
				$table->index('date');
			} 
			if (Schema::hasColumn('vehicle_cmr','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_cmr WHERE key_name='vehicle_cmr_user_id_index'"))) {
				$table->index('user_id');
			}
			if (Schema::hasColumn('vehicle_cmr','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_cmr WHERE key_name='vehicle_cmr_company_id_index'"))) {
				$table->index('company_id');
			} 
			if (Schema::hasColumn('vehicle_cmr','income_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_cmr WHERE key_name='vehicle_cmr_income_id_index'"))) {
				$table->index('income_id');
			}
		});
	}




	
	// add indexs to vehicle_cmr_details
	if(Schema::hasTable('vehicle_cmr_details') ) {
		Schema::table('vehicle_cmr_details', function (Blueprint $table) {
			if (Schema::hasColumn('vehicle_cmr_details','vehicleCMR_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_cmr_details WHERE key_name='vehicle_cmr_details_vehicleCMR_id_index'"))) {
				$table->index('vehicleCMR_id');
			} 
			if (Schema::hasColumn('vehicle_cmr_details','driver_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_cmr_details WHERE key_name='vehicle_cmr_details_driver_id_index'"))) {
				$table->index('driver_id');
			} 
			if (Schema::hasColumn('vehicle_cmr_details','vehicle_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_cmr_details WHERE key_name='vehicle_cmr_details_vehicle_id_index'"))) {
				$table->index('vehicle_id');
			} 
			if (Schema::hasColumn('vehicle_cmr_details','transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_cmr_details WHERE key_name='vehicle_cmr_details_transaction_id_index'"))) {
				$table->index('transaction_id');
			}
			if (Schema::hasColumn('vehicle_cmr_details','income_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_cmr_details WHERE key_name='vehicle_cmr_details_income_transaction_id_index'"))) {
				$table->index('income_transaction_id');
			} 
			if (Schema::hasColumn('vehicle_cmr_details','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_cmr_details WHERE key_name='vehicle_cmr_details_user_id_index'"))) {
				$table->index('user_id');
			}

			if (Schema::hasColumn('vehicle_cmr_details','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_cmr_details WHERE key_name='vehicle_cmr_details_company_id_index'"))) {
				$table->index('company_id');
			}
			if (Schema::hasColumn('vehicle_cmr_details','expense_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_cmr_details WHERE key_name='vehicle_cmr_details_expense_transaction_id_index'"))) {
				$table->index('expense_transaction_id');
			}  
		});
	}




	// add indexs to vehicle_cmr_receives
	if(Schema::hasTable('vehicle_cmr_receives') ) {
		Schema::table('vehicle_cmr_receives', function (Blueprint $table) {
			if (Schema::hasColumn('vehicle_cmr_receives','vehicleCMR_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_cmr_receives WHERE key_name='vehicle_cmr_receives_vehicleCMR_id_index'"))) {
				$table->index('vehicleCMR_id');
			} 
			if (Schema::hasColumn('vehicle_cmr_receives','receivable_payment_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_cmr_receives WHERE key_name='vehicle_cmr_receives_receivable_payment_id_index'"))) {
				$table->index('receivable_payment_id');
			} 
		 
		});
	}


	// add indexs to vehicle_equipment
	if(Schema::hasTable('vehicle_equipment') ) {
		Schema::table('vehicle_equipment', function (Blueprint $table) {
			if (Schema::hasColumn('vehicle_equipment','name') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_equipment WHERE key_name='vehicle_equipment_name_index'"))) {
				$table->index('name');
			} 
			if (Schema::hasColumn('vehicle_equipment','vehicle_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_equipment WHERE key_name='vehicle_equipment_vehicle_id_index'"))) {
				$table->index('vehicle_id');
			}   
			if (Schema::hasColumn('vehicle_equipment','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_equipment WHERE key_name='vehicle_equipment_user_id_index'"))) {
				$table->index('user_id');
			} 
			if (Schema::hasColumn('vehicle_equipment','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_equipment WHERE key_name='vehicle_equipment_company_id_index'"))) {
				$table->index('company_id');
			}  
			if (Schema::hasColumn('vehicle_equipment','type') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_equipment WHERE key_name='vehicle_equipment_type_index'"))) {
				$table->index('type');
			}  
		});
	}



	// add indexs to vehicle_expenses
	if(Schema::hasTable('vehicle_expenses') ) {
		Schema::table('vehicle_expenses', function (Blueprint $table) {
			if (Schema::hasColumn('vehicle_expenses','vehicle_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_expenses WHERE key_name='vehicle_expenses_vehicle_id_index'"))) {
				$table->index('vehicle_id');
			}   
			if (Schema::hasColumn('vehicle_expenses','vehicle_receives_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_expenses WHERE key_name='vehicle_expenses_vehicle_receives_id_index'"))) {
				$table->index('vehicle_receives_id');
			} 
			if (Schema::hasColumn('vehicle_expenses','bank_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_expenses WHERE key_name='vehicle_expenses_bank_transaction_index'"))) {
				$table->index('bank_transaction');
			} 
			if (Schema::hasColumn('vehicle_expenses','expense_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_expenses WHERE key_name='vehicle_expenses_expense_transaction_index'"))) {
				$table->index('expense_transaction');
			}   
			if (Schema::hasColumn('vehicle_expenses','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_expenses WHERE key_name='vehicle_expenses_user_id_index'"))) {
				$table->index('user_id');
			} 
			if (Schema::hasColumn('vehicle_expenses','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_expenses WHERE key_name='vehicle_expenses_company_id_index'"))) {
				$table->index('company_id');
			}   
			  
			if (Schema::hasColumn('vehicle_expenses','vendor_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_expenses WHERE key_name='vehicle_expenses_vendor_id_index'"))) {
				$table->index('vendor_id');
			} 
			if (Schema::hasColumn('vehicle_expenses','receive_tran_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_expenses WHERE key_name='vehicle_expenses_receive_tran_id_index'"))) {
				$table->index('receive_tran_id');
			} if (Schema::hasColumn('vehicle_expenses','payable_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_expenses WHERE key_name='vehicle_expenses_payable_transaction_id_index'"))) {
				$table->index('payable_transaction_id');
			} 
			if (Schema::hasColumn('vehicle_expenses','category') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_expenses WHERE key_name='vehicle_expenses_category_index'"))) {
				$table->index('category');
			} 
			if (Schema::hasColumn('vehicle_expenses','type') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_expenses WHERE key_name='vehicle_expenses_type_index'"))) {
				$table->index('type');
			} 
		});
	}
	

 
	// add indexs to vehicle_expenses_details
	if(Schema::hasTable('vehicle_expenses_details') ) {
		Schema::table('vehicle_expenses_details', function (Blueprint $table) { 
			if (Schema::hasColumn('vehicle_expenses_details','vehicle_expenses_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_expenses_details WHERE key_name='vehicle_expenses_details_vehicle_expenses_id_index'"))) {
				$table->index('vehicle_expenses_id');
			}   
			if (Schema::hasColumn('vehicle_expenses_details','amount') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_expenses_details WHERE key_name='vehicle_expenses_details_amount_index'"))) {
				$table->index('amount');
			} 
			if (Schema::hasColumn('vehicle_expenses_details','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_expenses_details WHERE key_name='vehicle_expenses_details_company_id_index'"))) {
				$table->index('company_id');
			}    
		 
		});
	}


	// add indexs to vehicle_fixes
	if(Schema::hasTable('vehicle_fixes') ) {
		Schema::table('vehicle_fixes', function (Blueprint $table) { 
			if (Schema::hasColumn('vehicle_fixes','vehicle_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_fixes WHERE key_name='vehicle_fixes_vehicle_id_index'"))) {
				$table->index('vehicle_id');
			}   
			if (Schema::hasColumn('vehicle_fixes','bank_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_fixes WHERE key_name='vehicle_fixes_bank_transaction_index'"))) {
				$table->index('bank_transaction');
			} 
			if (Schema::hasColumn('vehicle_fixes','expense_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_fixes WHERE key_name='vehicle_fixes_expense_transaction_index'"))) {
				$table->index('expense_transaction');
			}    
		 
			if (Schema::hasColumn('vehicle_fixes','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_fixes WHERE key_name='vehicle_fixes_user_id_index'"))) {
				$table->index('user_id');
			} 
			if (Schema::hasColumn('vehicle_fixes','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_fixes WHERE key_name='vehicle_fixes_company_id_index'"))) {
				$table->index('company_id');
			} if (Schema::hasColumn('vehicle_fixes','type') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_fixes WHERE key_name='vehicle_fixes_type_index'"))) {
				$table->index('type');
			}   
		});
	}


		// add indexs to vehicle_fix_details
		if(Schema::hasTable('vehicle_fix_details') ) {
			Schema::table('vehicle_fix_details', function (Blueprint $table) { 
				if (Schema::hasColumn('vehicle_fix_details','vehicle_fix_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_fix_details WHERE key_name='vehicle_fix_details_vehicle_fix_id_index'"))) {
					$table->index('vehicle_fix_id');
				}   
				if (Schema::hasColumn('vehicle_fix_details','vehicle_equipment_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_fix_details WHERE key_name='vehicle_fix_details_vehicle_equipment_id_index'"))) {
					$table->index('vehicle_equipment_id');
				} 
				if (Schema::hasColumn('vehicle_fix_details','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_fix_details WHERE key_name='vehicle_fix_details_user_id_index'"))) {
					$table->index('user_id');
				}    
			 
				if (Schema::hasColumn('vehicle_fix_details','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_fix_details WHERE key_name='vehicle_fix_details_company_id_index'"))) {
					$table->index('company_id');
				}    
			});
		}



		// add indexs to vehicle_introduces
		if(Schema::hasTable('vehicle_introduces') ) {
			Schema::table('vehicle_introduces', function (Blueprint $table) { 
				if (Schema::hasColumn('vehicle_introduces','customer_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_introduces WHERE key_name='vehicle_introduces_customer_id_index'"))) {
					$table->index('customer_id');
				}   
				if (Schema::hasColumn('vehicle_introduces','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_introduces WHERE key_name='vehicle_introduces_user_id_index'"))) {
					$table->index('user_id');
				} 
				if (Schema::hasColumn('vehicle_introduces','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_introduces WHERE key_name='vehicle_introduces_company_id_index'"))) {
					$table->index('company_id');
				}     
			});
		}

 
		// add indexs to vehicle_introduce_details
		if(Schema::hasTable('vehicle_introduce_details') ) {
			Schema::table('vehicle_introduce_details', function (Blueprint $table) { 
				if (Schema::hasColumn('vehicle_introduce_details','vehicle_intro_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_introduce_details WHERE key_name='vehicle_introduce_details_vehicle_intro_id_index'"))) {
					$table->index('vehicle_intro_id');
				}   
				if (Schema::hasColumn('vehicle_introduce_details','driver_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_introduce_details WHERE key_name='vehicle_introduce_details_driver_id_index'"))) {
					$table->index('driver_id');
				} 
				if (Schema::hasColumn('vehicle_introduce_details','vehicle_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_introduce_details WHERE key_name='vehicle_introduce_details_vehicle_id_index'"))) {
					$table->index('vehicle_id');
				} 
				if (Schema::hasColumn('vehicle_introduce_details','date') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_introduce_details WHERE key_name='vehicle_introduce_details_date_index'"))) {
					$table->index('date');
				} if (Schema::hasColumn('vehicle_introduce_details','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_introduce_details WHERE key_name='vehicle_introduce_details_user_id_index'"))) {
					$table->index('user_id');
				} 
				if (Schema::hasColumn('vehicle_introduce_details','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_introduce_details WHERE key_name='vehicle_introduce_details_company_id_index'"))) {
					$table->index('company_id');
				} 
			});
		}


		// add indexs to vehicle_locations
		if(Schema::hasTable('vehicle_locations') ) {
			Schema::table('vehicle_locations', function (Blueprint $table) { 
				if (Schema::hasColumn('vehicle_locations','driver_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_locations WHERE key_name='vehicle_locations_driver_id_index'"))) {
					$table->index('driver_id');
				}   
				if (Schema::hasColumn('vehicle_locations','vehicle_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_locations WHERE key_name='vehicle_locations_vehicle_id_index'"))) {
					$table->index('vehicle_id');
				} 
				if (Schema::hasColumn('vehicle_locations','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_locations WHERE key_name='vehicle_locations_user_id_index'"))) {
					$table->index('user_id');
				} 
				if (Schema::hasColumn('vehicle_locations','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_locations WHERE key_name='vehicle_locations_company_id_index'"))) {
					$table->index('company_id');
				} if (Schema::hasColumn('vehicle_locations','vehicle_manage_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_locations WHERE key_name='vehicle_locations_vehicle_manage_id_index'"))) {
					$table->index('vehicle_manage_id');
				} 
				if (Schema::hasColumn('vehicle_locations','transferAndLoading_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_locations WHERE key_name='vehicle_locations_transferAndLoading_id_index'"))) {
					$table->index('transferAndLoading_id');
				} 

				if (Schema::hasColumn('vehicle_locations','cargo_loading_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_locations WHERE key_name='vehicle_locations_cargo_loading_id_index'"))) {
					$table->index('cargo_loading_id');
				} 
				if (Schema::hasColumn('vehicle_locations','cargo_delivery_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_locations WHERE key_name='vehicle_locations_cargo_delivery_id_index'"))) {
					$table->index('cargo_delivery_id');
				} 
			});
		}



		// add indexs to vehicle_log_books
		if(Schema::hasTable('vehicle_log_books') ) {
			Schema::table('vehicle_log_books', function (Blueprint $table) { 
				if (Schema::hasColumn('vehicle_log_books','number') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_log_books WHERE key_name='vehicle_log_books_number_index'"))) {
					$table->index('number');
				}   
				if (Schema::hasColumn('vehicle_log_books','date') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_log_books WHERE key_name='vehicle_log_books_date_index'"))) {
					$table->index('date');
				} 
				if (Schema::hasColumn('vehicle_log_books','vehicle_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_log_books WHERE key_name='vehicle_log_books_vehicle_id_index'"))) {
					$table->index('vehicle_id');
				} 
				if (Schema::hasColumn('vehicle_log_books','item_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_log_books WHERE key_name='vehicle_log_books_item_id_index'"))) {
					$table->index('item_id');
				} if (Schema::hasColumn('vehicle_log_books','driver_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_log_books WHERE key_name='vehicle_log_books_driver_id_index'"))) {
					$table->index('driver_id');
				} 
				if (Schema::hasColumn('vehicle_log_books','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_log_books WHERE key_name='vehicle_log_books_user_id_index'"))) {
					$table->index('user_id');
				} 

				if (Schema::hasColumn('vehicle_log_books','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_log_books WHERE key_name='vehicle_log_books_company_id_index'"))) {
					$table->index('company_id');
				} 
				if (Schema::hasColumn('vehicle_log_books','source') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_log_books WHERE key_name='vehicle_log_books_source_index'"))) {
					$table->index('source');
				} 
			});
		}



		// add indexs to vehicle_managements
		if(Schema::hasTable('vehicle_managements') ) {
			Schema::table('vehicle_managements', function (Blueprint $table) { 
				if (Schema::hasColumn('vehicle_managements','customer_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_managements WHERE key_name='vehicle_managements_customer_id_index'"))) {
					$table->index('customer_id');
				}   
				if (Schema::hasColumn('vehicle_managements','driver_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_managements WHERE key_name='vehicle_managements_driver_id_index'"))) {
					$table->index('driver_id');
				} 
				if (Schema::hasColumn('vehicle_managements','car_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_managements WHERE key_name='vehicle_managements_car_id_index'"))) {
					$table->index('car_id');
				} 
				if (Schema::hasColumn('vehicle_managements','tanker_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_managements WHERE key_name='vehicle_managements_tanker_id_index'"))) {
					$table->index('tanker_id');
				} if (Schema::hasColumn('vehicle_managements','location_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_managements WHERE key_name='vehicle_managements_location_id_index'"))) {
					$table->index('location_id');
				} 
				if (Schema::hasColumn('vehicle_managements','transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_managements WHERE key_name='vehicle_managements_transaction_id_index'"))) {
					$table->index('transaction_id');
				} 

				if (Schema::hasColumn('vehicle_managements','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_managements WHERE key_name='vehicle_managements_user_id_index'"))) {
					$table->index('user_id');
				} 
				if (Schema::hasColumn('vehicle_managements','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_managements WHERE key_name='vehicle_managements_company_id_index'"))) {
					$table->index('company_id');
				} 
				if (Schema::hasColumn('vehicle_managements','code') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_managements WHERE key_name='vehicle_managements_code_index'"))) {
					$table->index('code');
				} 
			});
		}


		// add indexs to vehicle_receives
		if(Schema::hasTable('vehicle_receives') ) {
			Schema::table('vehicle_receives', function (Blueprint $table) { 
				if (Schema::hasColumn('vehicle_receives','vehicle_manage_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_receives WHERE key_name='vehicle_receives_vehicle_manage_id_index'"))) {
					$table->index('vehicle_manage_id');
				}   
				if (Schema::hasColumn('vehicle_receives','receivable_payment_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicle_receives WHERE key_name='vehicle_receives_receivable_payment_id_index'"))) {
					$table->index('receivable_payment_id');
				} 
				  
			});
		}
	

		// add indexs to weighbridges
		if(Schema::hasTable('weighbridges') ) {
			Schema::table('weighbridges', function (Blueprint $table) { 
				if (Schema::hasColumn('weighbridges','number') && !DB::select(DB::raw("SHOW INDEXES FROM weighbridges WHERE key_name='weighbridges_number_index'"))) {
					$table->index('number');
				}   
				if (Schema::hasColumn('weighbridges','driver_name') && !DB::select(DB::raw("SHOW INDEXES FROM weighbridges WHERE key_name='weighbridges_driver_name_index'"))) {
					$table->index('driver_name');
				} 
				if (Schema::hasColumn('weighbridges','item_id') && !DB::select(DB::raw("SHOW INDEXES FROM weighbridges WHERE key_name='weighbridges_item_id_index'"))) {
					$table->index('item_id');
				}   
				if (Schema::hasColumn('weighbridges','um_id') && !DB::select(DB::raw("SHOW INDEXES FROM weighbridges WHERE key_name='weighbridges_um_id_index'"))) {
					$table->index('um_id');
				} 
				if (Schema::hasColumn('weighbridges','foreign_data_id') && !DB::select(DB::raw("SHOW INDEXES FROM weighbridges WHERE key_name='weighbridges_foreign_data_id_index'"))) {
					$table->index('foreign_data_id');
				}   
				if (Schema::hasColumn('weighbridges','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM weighbridges WHERE key_name='weighbridges_user_id_index'"))) {
					$table->index('user_id');
				} 	
				
				if (Schema::hasColumn('weighbridges','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM weighbridges WHERE key_name='weighbridges_company_id_index'"))) {
					$table->index('company_id');
				}   
				if (Schema::hasColumn('weighbridges','type_detail_id') && !DB::select(DB::raw("SHOW INDEXES FROM weighbridges WHERE key_name='weighbridges_type_detail_id_index'"))) {
					$table->index('type_detail_id');
				} if (Schema::hasColumn('weighbridges','type') && !DB::select(DB::raw("SHOW INDEXES FROM weighbridges WHERE key_name='weighbridges_type_index'"))) {
					$table->index('type');
				} 
			});
		}
	

				// add indexs to stock_outs
				if(Schema::hasTable('stock_outs')) {
					Schema::table('stock_outs', function (Blueprint $table) {
						if (Schema::hasColumn('stock_outs','date_out') && !DB::select(DB::raw("SHOW INDEXES FROM stock_outs WHERE key_name='stock_outs_date_out_index'"))) {
							$table->index('date_out');
						}
						if (Schema::hasColumn('stock_outs','qut_out') && !DB::select(DB::raw("SHOW INDEXES FROM stock_outs WHERE key_name='stock_outs_qut_out_index'"))) {
							$table->index('qut_out');
						} 
						if (Schema::hasColumn('stock_outs','sales_price') && !DB::select(DB::raw("SHOW INDEXES FROM stock_outs WHERE key_name='stock_outs_sales_price_index'"))) {
							$table->index('sales_price');
						} 
	
						if (Schema::hasColumn('stock_outs','status') && !DB::select(DB::raw("SHOW INDEXES FROM stock_outs WHERE key_name='stock_outs_status_index'"))) {
							$table->index('status');
						}
						if (Schema::hasColumn('stock_outs','type') && !DB::select(DB::raw("SHOW INDEXES FROM stock_outs WHERE key_name='stock_outs_type_index'"))) {
							$table->index('type');
						} 
						if (Schema::hasColumn('stock_outs','edit_type') && !DB::select(DB::raw("SHOW INDEXES FROM stock_outs WHERE key_name='stock_outs_edit_type_index'"))) {
							$table->index('edit_type');
						}  
					  
					});
				}
		

				


				  // add indexs to loading_details
				  if(Schema::hasTable('loading_details') ) {
					Schema::table('loading_details', function (Blueprint $table) {
						if (Schema::hasColumn('loading_details','source') && !DB::select(DB::raw("SHOW INDEXES FROM loading_details WHERE key_name='loading_details_source_index'"))) {
							$table->index('source');
						}
						if (Schema::hasColumn('loading_details','destination') && !DB::select(DB::raw("SHOW INDEXES FROM loading_details WHERE key_name='loading_details_destination_index'"))) {
							$table->index('destination');
						} 
						if (Schema::hasColumn('loading_details','transit_number') && !DB::select(DB::raw("SHOW INDEXES FROM loading_details WHERE key_name='loading_details_transit_number_index'"))) {
							$table->index('transit_number');
						}
						if (Schema::hasColumn('loading_details','type') && !DB::select(DB::raw("SHOW INDEXES FROM loading_details WHERE key_name='loading_details_type_index'"))) {
							$table->index('type');
						} 
						if (Schema::hasColumn('loading_details','driver_type') && !DB::select(DB::raw("SHOW INDEXES FROM loading_details WHERE key_name='loading_details_driver_type_index'"))) {
							$table->index('driver_type');
						}
						if (Schema::hasColumn('loading_details','load_type') && !DB::select(DB::raw("SHOW INDEXES FROM loading_details WHERE key_name='loading_details_load_type_index'"))) {
							$table->index('load_type');
						} 
					
					});
				}
	


					// add indexs to close_years
					if(Schema::hasTable('close_years') ) {
					Schema::table('close_years', function (Blueprint $table) {
						if (Schema::hasColumn('close_years','name') && !DB::select(DB::raw("SHOW INDEXES FROM close_years WHERE key_name='close_years_name_index'"))) {
							$table->index('name');
						}
						if (Schema::hasColumn('close_years','close_date') && !DB::select(DB::raw("SHOW INDEXES FROM close_years WHERE key_name='close_years_close_date_index'"))) {
							$table->index('close_date');
						} 
						if (Schema::hasColumn('close_years','opening_date') && !DB::select(DB::raw("SHOW INDEXES FROM close_years WHERE key_name='close_years_opening_date_index'"))) {
							$table->index('opening_date');
						}
						if (Schema::hasColumn('close_years','inventory_id') && !DB::select(DB::raw("SHOW INDEXES FROM close_years WHERE key_name='close_years_inventory_id_index'"))) {
							$table->index('inventory_id');
						} 
						if (Schema::hasColumn('close_years','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM close_years WHERE key_name='close_years_company_id_index'"))) {
							$table->index('company_id');
						}
						if (Schema::hasColumn('close_years','sale_no') && !DB::select(DB::raw("SHOW INDEXES FROM close_years WHERE key_name='close_years_sale_no_index'"))) {
							$table->index('sale_no');
						} 
					
					});
				}
	


				// add indexs to close_years
				if(Schema::hasTable('close_years') ) {
					Schema::table('close_years', function (Blueprint $table) {
						if (Schema::hasColumn('close_years','name') && !DB::select(DB::raw("SHOW INDEXES FROM close_years WHERE key_name='close_years_name_index'"))) {
							$table->index('name');
						}
						if (Schema::hasColumn('close_years','equity_account_id') && !DB::select(DB::raw("SHOW INDEXES FROM close_years WHERE key_name='close_years_equity_account_id_index'"))) {
							$table->index('equity_account_id');
						} 
						if (Schema::hasColumn('close_years','income_account_id') && !DB::select(DB::raw("SHOW INDEXES FROM close_years WHERE key_name='close_years_income_account_id_index'"))) {
							$table->index('income_account_id');
						}
						if (Schema::hasColumn('close_years','drawing_account_id') && !DB::select(DB::raw("SHOW INDEXES FROM close_years WHERE key_name='close_years_drawing_account_id_index'"))) {
							$table->index('drawing_account_id');
						} 
						if (Schema::hasColumn('close_years','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM close_years WHERE key_name='close_years_user_id_index'"))) {
							$table->index('user_id');
						} 
					});
				}


			// add indexs to close_years_equity
			if(Schema::hasTable('close_years_equity') ) {
				Schema::table('close_years_equity', function (Blueprint $table) {
					if (Schema::hasColumn('close_years_equity','close_year_id') && !DB::select(DB::raw("SHOW INDEXES FROM close_years_equity WHERE key_name='close_years_equity_close_year_id_index'"))) {
						$table->index('close_year_id');
					}
					if (Schema::hasColumn('close_years_equity','account_id') && !DB::select(DB::raw("SHOW INDEXES FROM close_years_equity WHERE key_name='close_years_equity_account_id_index'"))) {
						$table->index('account_id');
					} 
					if (Schema::hasColumn('close_years_equity','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM close_years_equity WHERE key_name='close_years_equity_member_id_index'"))) {
						$table->index('member_id');
					}
					if (Schema::hasColumn('close_years_equity','drawing_account_id') && !DB::select(DB::raw("SHOW INDEXES FROM close_years_equity WHERE key_name='close_years_equity_drawing_account_id_index'"))) {
						$table->index('drawing_account_id');
					} 
					if (Schema::hasColumn('close_years_equity','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM close_years_equity WHERE key_name='close_years_equity_user_id_index'"))) {
						$table->index('user_id');
					} 
					if (Schema::hasColumn('close_years_equity','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM close_years_equity WHERE key_name='close_years_equity_company_id_index'"))) {
						$table->index('company_id');
					} 
				});
			}


			// add indexs to close_year_accounts
			if(Schema::hasTable('close_year_accounts') ) {
				Schema::table('close_year_accounts', function (Blueprint $table) {
					if (Schema::hasColumn('close_year_accounts','close_year_id') && !DB::select(DB::raw("SHOW INDEXES FROM close_year_accounts WHERE key_name='close_year_accounts_close_year_id_index'"))) {
						$table->index('close_year_id');
					}
					if (Schema::hasColumn('close_year_accounts','account_id') && !DB::select(DB::raw("SHOW INDEXES FROM close_year_accounts WHERE key_name='close_year_accounts_account_id_index'"))) {
						$table->index('account_id');
					} 
					if (Schema::hasColumn('close_year_accounts','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM close_year_accounts WHERE key_name='close_year_accounts_member_id_index'"))) {
						$table->index('member_id');
					}
					if (Schema::hasColumn('close_year_accounts','drawing_account_id') && !DB::select(DB::raw("SHOW INDEXES FROM close_year_accounts WHERE key_name='close_year_accounts_drawing_account_id_index'"))) {
						$table->index('drawing_account_id');
					} 
					if (Schema::hasColumn('close_year_accounts','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM close_year_accounts WHERE key_name='close_year_accounts_user_id_index'"))) {
						$table->index('user_id');
					} 
					if (Schema::hasColumn('close_year_accounts','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM close_year_accounts WHERE key_name='close_year_accounts_company_id_index'"))) {
						$table->index('company_id');
					} 
				});
			}


			// add indexs to close_year_accounts
			if(Schema::hasTable('close_year_accounts') ) {
				Schema::table('close_year_accounts', function (Blueprint $table) {
					if (Schema::hasColumn('close_year_accounts','close_year_id') && !DB::select(DB::raw("SHOW INDEXES FROM close_year_accounts WHERE key_name='close_year_accounts_close_year_id_index'"))) {
						$table->index('close_year_id');
					}
					if (Schema::hasColumn('close_year_accounts','account_id') && !DB::select(DB::raw("SHOW INDEXES FROM close_year_accounts WHERE key_name='close_year_accounts_account_id_index'"))) {
						$table->index('account_id');
					} 
					if (Schema::hasColumn('close_year_accounts','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM close_year_accounts WHERE key_name='close_year_accounts_user_id_index'"))) {
						$table->index('user_id');
					}
					if (Schema::hasColumn('close_year_accounts','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM close_year_accounts WHERE key_name='close_year_accounts_company_id_index'"))) {
						$table->index('company_id');
					} 
					if (Schema::hasColumn('close_year_accounts','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM close_year_accounts WHERE key_name='close_year_accounts_user_id_index'"))) {
						$table->index('user_id');
					}  
				});
			}



			// add indexs to close_year_fix_assets
			if(Schema::hasTable('close_year_fix_assets') ) {
				Schema::table('close_year_fix_assets', function (Blueprint $table) {
					if (Schema::hasColumn('close_year_fix_assets','close_year_id') && !DB::select(DB::raw("SHOW INDEXES FROM close_year_fix_assets WHERE key_name='close_year_fix_assets_close_year_id_index'"))) {
						$table->index('close_year_id');
					}
					if (Schema::hasColumn('close_year_fix_assets','fixed_asset_id') && !DB::select(DB::raw("SHOW INDEXES FROM close_year_fix_assets WHERE key_name='close_year_fix_assets_fixed_asset_id_index'"))) {
						$table->index('fixed_asset_id');
					} 
					if (Schema::hasColumn('close_year_fix_assets','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM close_year_fix_assets WHERE key_name='close_year_fix_assets_user_id_index'"))) {
						$table->index('user_id');
					}
					if (Schema::hasColumn('close_year_fix_assets','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM close_year_fix_assets WHERE key_name='close_year_fix_assets_company_id_index'"))) {
						$table->index('company_id');
					}  
				});
			}



			// add indexs to close_year_member_statements
			if(Schema::hasTable('close_year_member_statements') ) {
				Schema::table('close_year_member_statements', function (Blueprint $table) {
					if (Schema::hasColumn('close_year_member_statements','close_year_id') && !DB::select(DB::raw("SHOW INDEXES FROM close_year_member_statements WHERE key_name='close_year_member_statements_close_year_id_index'"))) {
						$table->index('close_year_id');
					}
					if (Schema::hasColumn('close_year_member_statements','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM close_year_member_statements WHERE key_name='close_year_member_statements_member_id_index'"))) {
						$table->index('member_id');
					} 
					if (Schema::hasColumn('close_year_member_statements','account_id') && !DB::select(DB::raw("SHOW INDEXES FROM close_year_member_statements WHERE key_name='close_year_member_statements_account_id_index'"))) {
						$table->index('account_id');
					}
					if (Schema::hasColumn('close_year_member_statements','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM close_year_member_statements WHERE key_name='close_year_member_statements_user_id_index'"))) {
						$table->index('user_id');
					} if (Schema::hasColumn('close_year_member_statements','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM close_year_member_statements WHERE key_name='close_year_member_statements_company_id_index'"))) {
						$table->index('company_id');
					}  if (Schema::hasColumn('close_year_member_statements','type') && !DB::select(DB::raw("SHOW INDEXES FROM close_year_member_statements WHERE key_name='close_year_member_statements_type_index'"))) {
						$table->index('type');
					}
				});
			}



			// add indexs to close_year_stocks
			if(Schema::hasTable('close_year_stocks') ) {
				Schema::table('close_year_stocks', function (Blueprint $table) {
					if (Schema::hasColumn('close_year_stocks','close_year_id') && !DB::select(DB::raw("SHOW INDEXES FROM close_year_stocks WHERE key_name='close_year_stocks_close_year_id_index'"))) {
						$table->index('close_year_id');
					}
					if (Schema::hasColumn('close_year_stocks','inventory_id') && !DB::select(DB::raw("SHOW INDEXES FROM close_year_stocks WHERE key_name='close_year_stocks_inventory_id_index'"))) {
						$table->index('inventory_id');
					} 
					if (Schema::hasColumn('close_year_stocks','inventory_site_id') && !DB::select(DB::raw("SHOW INDEXES FROM close_year_stocks WHERE key_name='close_year_stocks_inventory_site_id_index'"))) {
						$table->index('inventory_site_id');
					}
					if (Schema::hasColumn('close_year_stocks','widths') && !DB::select(DB::raw("SHOW INDEXES FROM close_year_stocks WHERE key_name='close_year_stocks_widths_index'"))) {
						$table->index('widths');
					} if (Schema::hasColumn('close_year_stocks','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM close_year_stocks WHERE key_name='close_year_stocks_user_id_index'"))) {
						$table->index('user_id');
					}  if (Schema::hasColumn('close_year_stocks','other_measure') && !DB::select(DB::raw("SHOW INDEXES FROM close_year_stocks WHERE key_name='close_year_stocks_other_measure_index'"))) {
						$table->index('other_measure');
					}if (Schema::hasColumn('close_year_stocks','khada') && !DB::select(DB::raw("SHOW INDEXES FROM close_year_stocks WHERE key_name='close_year_stocks_khada_index'"))) {
						$table->index('khada');
					} if (Schema::hasColumn('close_year_stocks','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM close_year_stocks WHERE key_name='close_year_stocks_company_id_index'"))) {
						$table->index('company_id');
					}  if (Schema::hasColumn('close_year_stocks','brand_id') && !DB::select(DB::raw("SHOW INDEXES FROM close_year_stocks WHERE key_name='close_year_stocks_brand_id_index'"))) {
						$table->index('brand_id');
					}
				});
			}



			
			// add indexs to account_class
			if(Schema::hasTable('account_class') ) {
				Schema::table('account_class', function (Blueprint $table) {
					if (Schema::hasColumn('account_class','name') && !DB::select(DB::raw("SHOW INDEXES FROM account_class WHERE key_name='account_class_name_index'"))) {
						$table->index('name');
					}
					if (Schema::hasColumn('account_class','status') && !DB::select(DB::raw("SHOW INDEXES FROM account_class WHERE key_name='account_class_status_index'"))) {
						$table->index('status');
					} 
					if (Schema::hasColumn('account_class','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM account_class WHERE key_name='account_class_user_id_index'"))) {
						$table->index('user_id');
					} if (Schema::hasColumn('account_class','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM account_class WHERE key_name='account_class_company_id_index'"))) {
						$table->index('company_id');
					} 
				});
			}



			// add indexs to assemblies
			if(Schema::hasTable('assemblies') ) {
				Schema::table('assemblies', function (Blueprint $table) {
					if (Schema::hasColumn('assemblies','type') && !DB::select(DB::raw("SHOW INDEXES FROM assemblies WHERE key_name='assemblies_type_index'"))) {
						$table->index('type');
					} 
					if (Schema::hasColumn('assemblies','status') && !DB::select(DB::raw("SHOW INDEXES FROM assemblies WHERE key_name='assemblies_status_index'"))) {
						$table->index('status');
					} if (Schema::hasColumn('assemblies','code') && !DB::select(DB::raw("SHOW INDEXES FROM assemblies WHERE key_name='assemblies_code_index'"))) {
						$table->index('code');
					} 
				});
			}



			// add indexs to bank_checks
			if(Schema::hasTable('bank_checks') ) {
				Schema::table('bank_checks', function (Blueprint $table) { 
					if (Schema::hasColumn('bank_checks','check_number') && !DB::select(DB::raw("SHOW INDEXES FROM bank_checks WHERE key_name='bank_checks_check_number_index'"))) {
						$table->index('check_number');
					} 
					if (Schema::hasColumn('bank_checks','date') && !DB::select(DB::raw("SHOW INDEXES FROM bank_checks WHERE key_name='bank_checks_date_index'"))) {
						$table->index('date');
					} if (Schema::hasColumn('bank_checks','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM bank_checks WHERE key_name='bank_checks_member_id_index'"))) {
						$table->index('member_id');
					} 

					if (Schema::hasColumn('bank_checks','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM bank_checks WHERE key_name='bank_checks_company_id_index'"))) {
						$table->index('company_id');
					} 
					if (Schema::hasColumn('bank_checks','type') && !DB::select(DB::raw("SHOW INDEXES FROM bank_checks WHERE key_name='bank_checks_type_index'"))) {
						$table->index('type');
					} if (Schema::hasColumn('bank_checks','type_id') && !DB::select(DB::raw("SHOW INDEXES FROM bank_checks WHERE key_name='bank_checks_type_id_index'"))) {
						$table->index('type_id');
					} 
					if (Schema::hasColumn('bank_checks','account_id') && !DB::select(DB::raw("SHOW INDEXES FROM bank_checks WHERE key_name='bank_checks_account_id_index'"))) {
						$table->index('account_id');
					} if (Schema::hasColumn('bank_checks','class_id') && !DB::select(DB::raw("SHOW INDEXES FROM bank_checks WHERE key_name='bank_checks_class_id_index'"))) {
						$table->index('class_id');
					}  if (Schema::hasColumn('bank_checks','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM bank_checks WHERE key_name='bank_checks_user_id_index'"))) {
						$table->index('user_id');
					}
				});
			}




			// add indexs to bank_checks 
			if(Schema::hasTable('bank_checks') ) {
				Schema::table('bank_checks', function (Blueprint $table) {
					if (Schema::hasColumn('bank_checks','check_number') && !DB::select(DB::raw("SHOW INDEXES FROM bank_checks WHERE key_name='bank_checks_check_number_index'"))) {
						$table->index('check_number');
					} 
					if (Schema::hasColumn('bank_checks','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM bank_checks WHERE key_name='bank_checks_member_id_index'"))) {
						$table->index('member_id');
					} if (Schema::hasColumn('bank_checks','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM bank_checks WHERE key_name='bank_checks_company_id_index'"))) {
						$table->index('company_id');
					} 
					if (Schema::hasColumn('bank_checks','type') && !DB::select(DB::raw("SHOW INDEXES FROM bank_checks WHERE key_name='bank_checks_type_index'"))) {
						$table->index('type');
					} 
					if (Schema::hasColumn('bank_checks','type_id') && !DB::select(DB::raw("SHOW INDEXES FROM bank_checks WHERE key_name='bank_checks_type_id_index'"))) {
						$table->index('type_id');
					} if (Schema::hasColumn('bank_checks','account_id') && !DB::select(DB::raw("SHOW INDEXES FROM bank_checks WHERE key_name='bank_checks_account_id_index'"))) {
						$table->index('account_id');
					} 
					if (Schema::hasColumn('bank_checks','class_id') && !DB::select(DB::raw("SHOW INDEXES FROM bank_checks WHERE key_name='bank_checks_class_id_index'"))) {
						$table->index('class_id');
					} 
					if (Schema::hasColumn('bank_checks','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM bank_checks WHERE key_name='bank_checks_user_id_index'"))) {
						$table->index('user_id');
					}  
				});
			}



		// add indexs to build_stock_ins 
		if(Schema::hasTable('build_stock_ins') ) {
			Schema::table('build_stock_ins', function (Blueprint $table) {
				if (Schema::hasColumn('build_stock_ins','type') && !DB::select(DB::raw("SHOW INDEXES FROM build_stock_ins WHERE key_name='build_stock_ins_type_index'"))) {
					$table->index('type');
				}  
			});
		}


		// add indexs to build_stock_ins 
		if(Schema::hasTable('build_stock_ins') ) {
			Schema::table('build_stock_ins', function (Blueprint $table) {
				if (Schema::hasColumn('build_stock_ins','type') && !DB::select(DB::raw("SHOW INDEXES FROM build_stock_ins WHERE key_name='build_stock_ins_type_index'"))) {
					$table->index('type');
				}  
			});
		}


		// add indexs to build_stock_outs 
		if(Schema::hasTable('build_stock_outs') ) {
			Schema::table('build_stock_outs', function (Blueprint $table) {
				if (Schema::hasColumn('build_stock_outs','type') && !DB::select(DB::raw("SHOW INDEXES FROM build_stock_outs WHERE key_name='build_stock_outs_type_index'"))) {
					$table->index('type');
				}  
			});
		}



		// add indexs to cargo_contract_order 
		if(Schema::hasTable('cargo_contract_order') ) {
			Schema::table('cargo_contract_order', function (Blueprint $table) {
				if (Schema::hasColumn('cargo_contract_order','number') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_contract_order WHERE key_name='cargo_contract_order_number_index'"))) {
					$table->index('number');
				} 
				if (Schema::hasColumn('cargo_contract_order','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_contract_order WHERE key_name='cargo_contract_order_member_id_index'"))) {
					$table->index('member_id');
				}
				if (Schema::hasColumn('cargo_contract_order','date') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_contract_order WHERE key_name='cargo_contract_order_date_index'"))) {
					$table->index('date');
				} 
				if (Schema::hasColumn('cargo_contract_order','delivery_date') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_contract_order WHERE key_name='cargo_contract_order_delivery_date_index'"))) {
					$table->index('delivery_date');
				}
				if (Schema::hasColumn('cargo_contract_order','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_contract_order WHERE key_name='cargo_contract_order_user_id_index'"))) {
					$table->index('user_id');
				}
				if (Schema::hasColumn('cargo_contract_order','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_contract_order WHERE key_name='cargo_contract_order_company_id_index'"))) {
					$table->index('company_id');
				}
			});
		}


		
		// add indexs to cargo_contract_order 
		if(Schema::hasTable('cargo_contract_order') ) {
			Schema::table('cargo_contract_order', function (Blueprint $table) {
				if (Schema::hasColumn('cargo_contract_order','type') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_contract_order WHERE key_name='cargo_contract_order_type_index'"))) {
					$table->index('type');
				} 
			});
		}


		// add indexs to clients 
		if(Schema::hasTable('clients') ) {
			Schema::table('clients', function (Blueprint $table) {
				if (Schema::hasColumn('clients','date') && !DB::select(DB::raw("SHOW INDEXES FROM clients WHERE key_name='clients_date_index'"))) {
					$table->index('date');
				} 
				if (Schema::hasColumn('clients','customer_id') && !DB::select(DB::raw("SHOW INDEXES FROM clients WHERE key_name='clients_customer_id_index'"))) {
					$table->index('customer_id');
				} 
				if (Schema::hasColumn('clients','product_id') && !DB::select(DB::raw("SHOW INDEXES FROM clients WHERE key_name='clients_product_id_index'"))) {
					$table->index('product_id');
				} 
				if (Schema::hasColumn('clients','contact_no') && !DB::select(DB::raw("SHOW INDEXES FROM clients WHERE key_name='clients_contact_no_index'"))) {
					$table->index('contact_no');
				} 
				if (Schema::hasColumn('clients','payable') && !DB::select(DB::raw("SHOW INDEXES FROM clients WHERE key_name='clients_payable_index'"))) {
					$table->index('payable');
				} 
			});
		}

 
	// add indexs to companies 
	if(Schema::hasTable('companies') ) {
		Schema::table('companies', function (Blueprint $table) {
			if (Schema::hasColumn('companies','type') && !DB::select(DB::raw("SHOW INDEXES FROM companies WHERE key_name='companies_type_index'"))) {
				$table->index('type');
			}  
		});
	}


	// add indexs to company_contacts 
	if(Schema::hasTable('company_contacts') ) {
		Schema::table('company_contacts', function (Blueprint $table) {
			if (Schema::hasColumn('company_contacts','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM company_contacts WHERE key_name='company_contacts_company_id_index'"))) {
				$table->index('company_id');
			}  
		});
	}


	// add indexs to contarcted_clients 
	if(Schema::hasTable('contarcted_clients') ) {
		Schema::table('contarcted_clients', function (Blueprint $table) {
			if (Schema::hasColumn('contarcted_clients','hot_prospect_client_id') && !DB::select(DB::raw("SHOW INDEXES FROM contarcted_clients WHERE key_name='contarcted_clients_hot_prospect_client_id_index'"))) {
				$table->index('hot_prospect_client_id');
			} 
			if (Schema::hasColumn('contarcted_clients','risk_inception_date') && !DB::select(DB::raw("SHOW INDEXES FROM contarcted_clients WHERE key_name='contarcted_clients_risk_inception_date_index'"))) {
				$table->index('risk_inception_date');
			}  
			if (Schema::hasColumn('contarcted_clients','customer_id') && !DB::select(DB::raw("SHOW INDEXES FROM contarcted_clients WHERE key_name='contarcted_clients_customer_id_index'"))) {
				$table->index('customer_id');
			} 
			if (Schema::hasColumn('contarcted_clients','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM contarcted_clients WHERE key_name='contarcted_clients_user_id_index'"))) {
				$table->index('user_id');
			} 
		});
	}
 
	
	// add indexs to contracts 
	if(Schema::hasTable('contracts') ) {
		Schema::table('contracts', function (Blueprint $table) {
			if (Schema::hasColumn('contracts','company_name') && !DB::select(DB::raw("SHOW INDEXES FROM contracts WHERE key_name='contracts_company_name_index'"))) {
				$table->index('company_name');
			} 
			if (Schema::hasColumn('contracts','contract_no') && !DB::select(DB::raw("SHOW INDEXES FROM contracts WHERE key_name='contracts_contract_no_index'"))) {
				$table->index('contract_no');
			}  
			if (Schema::hasColumn('contracts','status') && !DB::select(DB::raw("SHOW INDEXES FROM contracts WHERE key_name='contracts_status_index'"))) {
				$table->index('status');
			} 
		});
	}



	// add indexs to currency_exchanges 
	if(Schema::hasTable('currency_exchanges') ) {
		Schema::table('currency_exchanges', function (Blueprint $table) {
			if (Schema::hasColumn('currency_exchanges','number') && !DB::select(DB::raw("SHOW INDEXES FROM currency_exchanges WHERE key_name='currency_exchanges_number_index'"))) {
				$table->index('number');
			} 
			if (Schema::hasColumn('currency_exchanges','type') && !DB::select(DB::raw("SHOW INDEXES FROM currency_exchanges WHERE key_name='currency_exchanges_type_index'"))) {
				$table->index('type');
			}  
			if (Schema::hasColumn('currency_exchanges','sp_account_id') && !DB::select(DB::raw("SHOW INDEXES FROM currency_exchanges WHERE key_name='currency_exchanges_sp_account_id_index'"))) {
				$table->index('sp_account_id');
			} 
			if (Schema::hasColumn('currency_exchanges','sp_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM currency_exchanges WHERE key_name='currency_exchanges_sp_transaction_id_index'"))) {
				$table->index('sp_transaction_id');
			} 
			if (Schema::hasColumn('currency_exchanges','ex_account_id') && !DB::select(DB::raw("SHOW INDEXES FROM currency_exchanges WHERE key_name='currency_exchanges_ex_account_id_index'"))) {
				$table->index('ex_account_id');
			}  
			if (Schema::hasColumn('currency_exchanges','ex_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM currency_exchanges WHERE key_name='currency_exchanges_ex_transaction_id_index'"))) {
				$table->index('ex_transaction_id');
			} 

			if (Schema::hasColumn('currency_exchanges','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM currency_exchanges WHERE key_name='currency_exchanges_member_id_index'"))) {
				$table->index('member_id');
			} 
			if (Schema::hasColumn('currency_exchanges','income_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM currency_exchanges WHERE key_name='currency_exchanges_income_transaction_id_index'"))) {
				$table->index('income_transaction_id');
			}  
			if (Schema::hasColumn('currency_exchanges','COGS_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM currency_exchanges WHERE key_name='currency_exchanges_COGS_transaction_id_index'"))) {
				$table->index('COGS_transaction_id');
			} 
			if (Schema::hasColumn('currency_exchanges','gain_loss_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM currency_exchanges WHERE key_name='currency_exchanges_gain_loss_transaction_id_index'"))) {
				$table->index('gain_loss_transaction_id');
			} 
			if (Schema::hasColumn('currency_exchanges','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM currency_exchanges WHERE key_name='currency_exchanges_user_id_index'"))) {
				$table->index('user_id');
			}  
			if (Schema::hasColumn('currency_exchanges','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM currency_exchanges WHERE key_name='currency_exchanges_company_id_index'"))) {
				$table->index('company_id');
			}   
		});
	}




	// add indexs to currency_rate_details 
	if(Schema::hasTable('currency_rate_details') ) {
		Schema::table('currency_rate_details', function (Blueprint $table) {
			if (Schema::hasColumn('currency_rate_details','currency_id') && !DB::select(DB::raw("SHOW INDEXES FROM currency_rate_details WHERE key_name='currency_rate_details_currency_id_index'"))) {
				$table->index('currency_id');
			} 
			if (Schema::hasColumn('currency_rate_details','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM currency_rate_details WHERE key_name='currency_rate_details_user_id_index'"))) {
				$table->index('user_id');
			}  
			if (Schema::hasColumn('currency_rate_details','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM currency_rate_details WHERE key_name='currency_rate_details_company_id_index'"))) {
				$table->index('company_id');
			} 
		});
	}




	// add indexs to customer_delivery_items 
	if(Schema::hasTable('customer_delivery_items') ) {
		Schema::table('customer_delivery_items', function (Blueprint $table) {
			if (Schema::hasColumn('customer_delivery_items','number') && !DB::select(DB::raw("SHOW INDEXES FROM customer_delivery_items WHERE key_name='customer_delivery_items_number_index'"))) {
				$table->index('number');
			} 
			if (Schema::hasColumn('customer_delivery_items','customer_id') && !DB::select(DB::raw("SHOW INDEXES FROM customer_delivery_items WHERE key_name='customer_delivery_items_customer_id_index'"))) {
				$table->index('customer_id');
			}  
			if (Schema::hasColumn('customer_delivery_items','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM customer_delivery_items WHERE key_name='customer_delivery_items_user_id_index'"))) {
				$table->index('user_id');
			} if (Schema::hasColumn('customer_delivery_items','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM customer_delivery_items WHERE key_name='customer_delivery_items_company_id_index'"))) {
				$table->index('company_id');
			} 
		});
	}



	// add indexs to customer_stock_outs 
	if(Schema::hasTable('customer_stock_outs') ) {
		Schema::table('customer_stock_outs', function (Blueprint $table) {
			if (Schema::hasColumn('customer_stock_outs','date_out') && !DB::select(DB::raw("SHOW INDEXES FROM customer_stock_outs WHERE key_name='customer_stock_outs_date_out_index'"))) {
				$table->index('date_out');
			} 
			if (Schema::hasColumn('customer_stock_outs','type') && !DB::select(DB::raw("SHOW INDEXES FROM customer_stock_outs WHERE key_name='customer_stock_outs_type_index'"))) {
				$table->index('type');
			}   
		});
	}


	// add indexs to drawings 
	if(Schema::hasTable('drawings') ) {
		Schema::table('drawings', function (Blueprint $table) {
			if (Schema::hasColumn('drawings','number') && !DB::select(DB::raw("SHOW INDEXES FROM drawings WHERE key_name='drawings_number_index'"))) {
				$table->index('number');
			} 
			if (Schema::hasColumn('drawings','type') && !DB::select(DB::raw("SHOW INDEXES FROM drawings WHERE key_name='drawings_type_index'"))) {
				$table->index('type');
			}   
		});
	}


	// add indexs to general_infos 
	if(Schema::hasTable('general_infos') ) {
		Schema::table('general_infos', function (Blueprint $table) {
			if (Schema::hasColumn('general_infos','inventory_id') && !DB::select(DB::raw("SHOW INDEXES FROM general_infos WHERE key_name='general_infos_inventory_id_index'"))) {
				$table->index('inventory_id');
			} 
			if (Schema::hasColumn('general_infos','site_id') && !DB::select(DB::raw("SHOW INDEXES FROM general_infos WHERE key_name='general_infos_site_id_index'"))) {
				$table->index('site_id');
			} 
			if (Schema::hasColumn('general_infos','um_id') && !DB::select(DB::raw("SHOW INDEXES FROM general_infos WHERE key_name='general_infos_um_id_index'"))) {
				$table->index('um_id');
			} 
			if (Schema::hasColumn('general_infos','type_id') && !DB::select(DB::raw("SHOW INDEXES FROM general_infos WHERE key_name='general_infos_type_id_index'"))) {
				$table->index('type_id');
			}   
			if (Schema::hasColumn('general_infos','type') && !DB::select(DB::raw("SHOW INDEXES FROM general_infos WHERE key_name='general_infos_type_index'"))) {
				$table->index('type');
			} 
			if (Schema::hasColumn('general_infos','category_id') && !DB::select(DB::raw("SHOW INDEXES FROM general_infos WHERE key_name='general_infos_category_id_index'"))) {
				$table->index('category_id');
			} 
			if (Schema::hasColumn('general_infos','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM general_infos WHERE key_name='general_infos_company_id_index'"))) {
				$table->index('company_id');
			} 
			if (Schema::hasColumn('general_infos','width') && !DB::select(DB::raw("SHOW INDEXES FROM general_infos WHERE key_name='general_infos_width_index'"))) {
				$table->index('width');
			} 
		});
	}



		// add indexs to last_close_year 
		if(Schema::hasTable('last_close_year') ) {
			Schema::table('last_close_year', function (Blueprint $table) {
				if (Schema::hasColumn('last_close_year','last_close_year_id') && !DB::select(DB::raw("SHOW INDEXES FROM last_close_year WHERE key_name='last_close_year_last_close_year_id_index'"))) {
					$table->index('last_close_year_id');
				} 
				if (Schema::hasColumn('last_close_year','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM last_close_year WHERE key_name='last_close_year_company_id_index'"))) {
					$table->index('company_id');
				} 
				if (Schema::hasColumn('last_close_year','opening_balance_id') && !DB::select(DB::raw("SHOW INDEXES FROM last_close_year WHERE key_name='last_close_year_opening_balance_id_index'"))) {
					$table->index('opening_balance_id');
				} 
				if (Schema::hasColumn('last_close_year','drawing_id') && !DB::select(DB::raw("SHOW INDEXES FROM last_close_year WHERE key_name='last_close_year_drawing_id_index'"))) {
					$table->index('drawing_id');
				} if (Schema::hasColumn('last_close_year','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM last_close_year WHERE key_name='last_close_year_user_id_index'"))) {
					$table->index('user_id');
				} 
			});
		}


		
		// add indexs to measure_exchanges 
		if(Schema::hasTable('measure_exchanges') ) {
			Schema::table('measure_exchanges', function (Blueprint $table) {
				if (Schema::hasColumn('measure_exchanges','from_um_id') && !DB::select(DB::raw("SHOW INDEXES FROM measure_exchanges WHERE key_name='measure_exchanges_from_um_id_index'"))) {
					$table->index('from_um_id');
				} 
				if (Schema::hasColumn('measure_exchanges','to_um_id') && !DB::select(DB::raw("SHOW INDEXES FROM measure_exchanges WHERE key_name='measure_exchanges_to_um_id_index'"))) {
					$table->index('to_um_id');
				} 
				if (Schema::hasColumn('measure_exchanges','opening_balance_id') && !DB::select(DB::raw("SHOW INDEXES FROM measure_exchanges WHERE key_name='measure_exchanges_opening_balance_id_index'"))) {
					$table->index('opening_balance_id');
				} 
				if (Schema::hasColumn('measure_exchanges','type') && !DB::select(DB::raw("SHOW INDEXES FROM measure_exchanges WHERE key_name='measure_exchanges_type_index'"))) {
					$table->index('type');
				} if (Schema::hasColumn('measure_exchanges','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM measure_exchanges WHERE key_name='measure_exchanges_company_id_index'"))) {
					$table->index('company_id');
				} 
			});
		}



		// add indexs to measure_exchanges 
		if(Schema::hasTable('measure_exchanges') ) {
			Schema::table('measure_exchanges', function (Blueprint $table) {
				if (Schema::hasColumn('measure_exchanges','from_um_id') && !DB::select(DB::raw("SHOW INDEXES FROM measure_exchanges WHERE key_name='measure_exchanges_from_um_id_index'"))) {
					$table->index('from_um_id');
				} 
				if (Schema::hasColumn('measure_exchanges','to_um_id') && !DB::select(DB::raw("SHOW INDEXES FROM measure_exchanges WHERE key_name='measure_exchanges_to_um_id_index'"))) {
					$table->index('to_um_id');
				} 
				if (Schema::hasColumn('measure_exchanges','opening_balance_id') && !DB::select(DB::raw("SHOW INDEXES FROM measure_exchanges WHERE key_name='measure_exchanges_opening_balance_id_index'"))) {
					$table->index('opening_balance_id');
				} 
				if (Schema::hasColumn('measure_exchanges','type') && !DB::select(DB::raw("SHOW INDEXES FROM measure_exchanges WHERE key_name='measure_exchanges_type_index'"))) {
					$table->index('type');
				} if (Schema::hasColumn('measure_exchanges','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM measure_exchanges WHERE key_name='measure_exchanges_company_id_index'"))) {
					$table->index('company_id');
				} 
			});
		}



		// add indexs to member_sites 
		if(Schema::hasTable('member_sites') ) {
			Schema::table('member_sites', function (Blueprint $table) {
				if (Schema::hasColumn('member_sites','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM member_sites WHERE key_name='member_sites_member_id_index'"))) {
					$table->index('member_id');
				} 
				if (Schema::hasColumn('member_sites','site_id') && !DB::select(DB::raw("SHOW INDEXES FROM member_sites WHERE key_name='member_sites_site_id_index'"))) {
					$table->index('site_id');
				} 
				if (Schema::hasColumn('member_sites','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM member_sites WHERE key_name='member_sites_company_id_index'"))) {
					$table->index('company_id');
				}  
			});
		}
	

		// add indexs to messages 
		if(Schema::hasTable('messages') ) {
			Schema::table('messages', function (Blueprint $table) {
				if (Schema::hasColumn('messages','session_id') && !DB::select(DB::raw("SHOW INDEXES FROM messages WHERE key_name='messages_session_id_index'"))) {
					$table->index('session_id');
				} 
				if (Schema::hasColumn('messages','user_in_id') && !DB::select(DB::raw("SHOW INDEXES FROM messages WHERE key_name='messages_user_in_id_index'"))) {
					$table->index('user_in_id');
				} 
				if (Schema::hasColumn('messages','user_out_id') && !DB::select(DB::raw("SHOW INDEXES FROM messages WHERE key_name='messages_user_out_id_index'"))) {
					$table->index('user_out_id');
				} if (Schema::hasColumn('messages','type') && !DB::select(DB::raw("SHOW INDEXES FROM messages WHERE key_name='messages_type_index'"))) {
					$table->index('type');
				}  
			});
		}
		
		// add indexs to messaging 
		if(Schema::hasTable('messaging') ) {
			Schema::table('messaging', function (Blueprint $table) {
				if (Schema::hasColumn('messaging','session_id') && !DB::select(DB::raw("SHOW INDEXES FROM messaging WHERE key_name='messaging_session_id_index'"))) {
					$table->index('session_id');
				} 
				if (Schema::hasColumn('messaging','user_in_id') && !DB::select(DB::raw("SHOW INDEXES FROM messaging WHERE key_name='messaging_user_in_id_index'"))) {
					$table->index('user_in_id');
				} 
				if (Schema::hasColumn('messaging','user_out_id') && !DB::select(DB::raw("SHOW INDEXES FROM messaging WHERE key_name='messaging_user_out_id_index'"))) {
					$table->index('user_out_id');
				} if (Schema::hasColumn('messaging','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM messaging WHERE key_name='messaging_user_id_index'"))) {
					$table->index('user_id');
				} if (Schema::hasColumn('messaging','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM messaging WHERE key_name='messaging_company_id_index'"))) {
					$table->index('company_id');
				}   
			});
		}



		// add indexs to online_comment 
		if(Schema::hasTable('online_comment') ) {
			Schema::table('online_comment', function (Blueprint $table) {
				if (Schema::hasColumn('online_comment','online_item_id') && !DB::select(DB::raw("SHOW INDEXES FROM online_comment WHERE key_name='online_comment_online_item_id_index'"))) {
					$table->index('online_item_id');
				} 
				if (Schema::hasColumn('online_comment','parent_id') && !DB::select(DB::raw("SHOW INDEXES FROM online_comment WHERE key_name='online_comment_parent_id_index'"))) {
					$table->index('parent_id');
				} 
				if (Schema::hasColumn('online_comment','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM online_comment WHERE key_name='online_comment_company_id_index'"))) {
					$table->index('company_id');
				} if (Schema::hasColumn('online_comment','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM online_comment WHERE key_name='online_comment_user_id_index'"))) {
					$table->index('user_id');
				}   
			});
		}

		// add indexs to online_orders_item 
		if(Schema::hasTable('online_orders_item') ) {
			Schema::table('online_orders_item', function (Blueprint $table) {
				if (Schema::hasColumn('online_orders_item','online_item_id') && !DB::select(DB::raw("SHOW INDEXES FROM online_orders_item WHERE key_name='online_orders_item_online_item_id_index'"))) {
					$table->index('online_item_id');
				} 
				if (Schema::hasColumn('online_orders_item','parent_id') && !DB::select(DB::raw("SHOW INDEXES FROM online_orders_item WHERE key_name='online_orders_item_parent_id_index'"))) {
					$table->index('parent_id');
				} 
				if (Schema::hasColumn('online_orders_item','category') && !DB::select(DB::raw("SHOW INDEXES FROM online_orders_item WHERE key_name='online_orders_item_category_index'"))) {
					$table->index('category');
				} if (Schema::hasColumn('online_orders_item','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM online_orders_item WHERE key_name='online_orders_item_company_id_index'"))) {
					$table->index('company_id');
				}
			});
		}


		// add indexs to opening_inventories 
		if(Schema::hasTable('opening_inventories') ) {
			Schema::table('opening_inventories', function (Blueprint $table) {
				if (Schema::hasColumn('opening_inventories','transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM opening_inventories WHERE key_name='opening_inventories_transaction_id_index'"))) {
					$table->index('transaction_id');
				} 
				if (Schema::hasColumn('opening_inventories','opening_id') && !DB::select(DB::raw("SHOW INDEXES FROM opening_inventories WHERE key_name='opening_inventories_opening_id_index'"))) {
					$table->index('opening_id');
				} 
				if (Schema::hasColumn('opening_inventories','cost') && !DB::select(DB::raw("SHOW INDEXES FROM opening_inventories WHERE key_name='opening_inventories_cost_index'"))) {
					$table->index('cost');
				} if (Schema::hasColumn('opening_inventories','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM opening_inventories WHERE key_name='opening_inventories_company_id_index'"))) {
					$table->index('company_id');
				}
			});
		}


		// add indexs to opening_stocks 
		if(Schema::hasTable('opening_stocks') ) {
			Schema::table('opening_stocks', function (Blueprint $table) {
				if (Schema::hasColumn('opening_stocks','inventory_id') && !DB::select(DB::raw("SHOW INDEXES FROM opening_stocks WHERE key_name='opening_stocks_inventory_id_index'"))) {
					$table->index('inventory_id');
				} 
				if (Schema::hasColumn('opening_stocks','stock_id') && !DB::select(DB::raw("SHOW INDEXES FROM opening_stocks WHERE key_name='opening_stocks_stock_id_index'"))) {
					$table->index('stock_id');
				} 
				if (Schema::hasColumn('opening_stocks','opening_inventory_id') && !DB::select(DB::raw("SHOW INDEXES FROM opening_stocks WHERE key_name='opening_stocks_opening_inventory_id_index'"))) {
					$table->index('opening_inventory_id');
				} if (Schema::hasColumn('opening_stocks','main_stock_id') && !DB::select(DB::raw("SHOW INDEXES FROM opening_stocks WHERE key_name='opening_stocks_main_stock_id_index'"))) {
					$table->index('main_stock_id');
				}if (Schema::hasColumn('opening_stocks','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM opening_stocks WHERE key_name='opening_stocks_company_id_index'"))) {
					$table->index('company_id');
				}if (Schema::hasColumn('opening_stocks','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM opening_stocks WHERE key_name='opening_stocks_user_id_index'"))) {
					$table->index('user_id');
				}
			});
		}

 
		// add indexs to other_builds 
		if(Schema::hasTable('other_builds') ) {
			Schema::table('other_builds', function (Blueprint $table) {
				if (Schema::hasColumn('other_builds','assembly_id') && !DB::select(DB::raw("SHOW INDEXES FROM other_builds WHERE key_name='other_builds_assembly_id_index'"))) {
					$table->index('assembly_id');
				} 
				if (Schema::hasColumn('other_builds','item_id') && !DB::select(DB::raw("SHOW INDEXES FROM other_builds WHERE key_name='other_builds_item_id_index'"))) {
					$table->index('item_id');
				} 
				if (Schema::hasColumn('other_builds','um_id') && !DB::select(DB::raw("SHOW INDEXES FROM other_builds WHERE key_name='other_builds_um_id_index'"))) {
					$table->index('um_id');
				}  
			});
		} 


		// add indexs to permission_permission_group 
		if(Schema::hasTable('permission_permission_group') ) {
			Schema::table('permission_permission_group', function (Blueprint $table) {
				if (Schema::hasColumn('permission_permission_group','assembly_id') && !DB::select(DB::raw("SHOW INDEXES FROM permission_permission_group WHERE key_name='permission_permission_group_assembly_id_index'"))) {
					$table->index('assembly_id');
				} 
				if (Schema::hasColumn('permission_permission_group','item_id') && !DB::select(DB::raw("SHOW INDEXES FROM permission_permission_group WHERE key_name='permission_permission_group_item_id_index'"))) {
					$table->index('item_id');
				} 
				if (Schema::hasColumn('permission_permission_group','um_id') && !DB::select(DB::raw("SHOW INDEXES FROM permission_permission_group WHERE key_name='permission_permission_group_um_id_index'"))) {
					$table->index('um_id');
				}  
			});
		}



		// add indexs to purchases 
		if(Schema::hasTable('purchases') ) {
			Schema::table('purchases', function (Blueprint $table) {
				if (Schema::hasColumn('purchases','type') && !DB::select(DB::raw("SHOW INDEXES FROM purchases WHERE key_name='purchases_type_index'"))) {
					$table->index('type');
				} 
				if (Schema::hasColumn('purchases','bank_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM purchases WHERE key_name='purchases_bank_transaction_id_index'"))) {
					$table->index('bank_transaction_id');
				} 
				if (Schema::hasColumn('purchases','expense_number') && !DB::select(DB::raw("SHOW INDEXES FROM purchases WHERE key_name='purchases_expense_number_index'"))) {
					$table->index('expense_number');
				}  
			});
		}
   
		
		// add indexs to sales_orders 
		if(Schema::hasTable('sales_orders') ) {
			Schema::table('sales_orders', function (Blueprint $table) {
				if (Schema::hasColumn('sales_orders','type') && !DB::select(DB::raw("SHOW INDEXES FROM sales_orders WHERE key_name='sales_orders_type_index'"))) {
					$table->index('type');
				} 
				if (Schema::hasColumn('sales_orders','number') && !DB::select(DB::raw("SHOW INDEXES FROM sales_orders WHERE key_name='sales_orders_number_index'"))) {
					$table->index('number');
				} 
			});
		}


		// add indexs to sale_transfer_rents 
		if(Schema::hasTable('sale_transfer_rents') ) {
			Schema::table('sale_transfer_rents', function (Blueprint $table) {
				if (Schema::hasColumn('sale_transfer_rents','type') && !DB::select(DB::raw("SHOW INDEXES FROM sale_transfer_rents WHERE key_name='sale_transfer_rents_type_index'"))) {
					$table->index('type');
				}  
			});
		}

	 


		// add indexs to vehicle 
		if(Schema::hasTable('vehicles') ) {
			Schema::table('vehicles', function (Blueprint $table) {
				if (Schema::hasColumn('vehicles','type') && !DB::select(DB::raw("SHOW INDEXES FROM vehicles WHERE key_name='vehicles_type_index'"))) {
					$table->index('type');
				} 
			});
		}
		

		// add indexs to washing 
		if(Schema::hasTable('washing') ) {
			Schema::table('washing', function (Blueprint $table) {
				if (Schema::hasColumn('washing','sale_id') && !DB::select(DB::raw("SHOW INDEXES FROM washing WHERE key_name='washing_sale_id_index'"))) {
					$table->index('sale_id');
				} if (Schema::hasColumn('washing','carpet_type') && !DB::select(DB::raw("SHOW INDEXES FROM washing WHERE key_name='washing_carpet_type_index'"))) {
					$table->index('carpet_type');
				} if (Schema::hasColumn('washing','date_in') && !DB::select(DB::raw("SHOW INDEXES FROM washing WHERE key_name='washing_date_in_index'"))) {
					$table->index('date_in');
				} if (Schema::hasColumn('washing','	company_id') && !DB::select(DB::raw("SHOW INDEXES FROM washing WHERE key_name='washing_	company_id_index'"))) {
					$table->index('	company_id');
				} 
			});
		}
		
    }



    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('all_tables', function (Blueprint $table) {
            //
        });
    }
};
