<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
	 *
	 * Add index to all searchable and foriegn_key columns in table [name, date, and foriegn_key]
	 * $table->index('column_name','index_name'); use when the table and column name is long
	 * $table->index('column_name');
	 * $table->dropIndex('column_name');
     */
    public function up()
    {
		$tableName = 'accounts';
		$IndexName = 'accounts_user_id_index';
		// $index = DB::raw("SHOW INDEXES FROM {$tableName} WHERE key_name='{$IndexName}'");
		// $index = DB::select(DB::raw("SHOW INDEXES FROM accounts WHERE key_name='accounts_user_id_index'"));
		// dd($index);
        // add indexs to accounts
		 if(Schema::hasTable('accounts')) {
			Schema::table('accounts', function (Blueprint $table) {
				if (Schema::hasColumn('accounts','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM accounts WHERE key_name='accounts_user_id_index'"))) {
					$table->index('user_id');
				}
				if (Schema::hasColumn('accounts','parent_id') && !DB::select(DB::raw("SHOW INDEXES FROM accounts WHERE key_name='accounts_parent_id_index'"))) {
					$table->index('parent_id');
				}if (Schema::hasColumn('accounts','transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM accounts WHERE key_name='accounts_transaction_id_index'"))) {
					$table->index('transaction_id');
				}if (Schema::hasColumn('accounts','opening_id') && !DB::select(DB::raw("SHOW INDEXES FROM accounts WHERE key_name='accounts_opening_id_index'"))) {
					$table->index('opening_id');
				}if (Schema::hasColumn('accounts','number') && !DB::select(DB::raw("SHOW INDEXES FROM accounts WHERE key_name='accounts_number_index'"))) {
					$table->index('number');
				}if (Schema::hasColumn('accounts','currency') && !DB::select(DB::raw("SHOW INDEXES FROM accounts WHERE key_name='accounts_currency_index'"))) {
					$table->index('currency');
				}if (Schema::hasColumn('accounts','name') && !DB::select(DB::raw("SHOW INDEXES FROM accounts WHERE key_name='accounts_name_index'"))) {
					$table->index('name');
				}if (Schema::hasColumn('accounts','type') && !DB::select(DB::raw("SHOW INDEXES FROM accounts WHERE key_name='accounts_type_index'"))) {
					$table->index('type');
				}if (Schema::hasColumn('accounts','bank_account_number') && !DB::select(DB::raw("SHOW INDEXES FROM accounts WHERE key_name='accounts_bank_account_number_index'"))) {
					$table->index('bank_account_number');
				}if (Schema::hasColumn('accounts','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM accounts WHERE key_name='accounts_company_id_index'"))) {
					$table->index('company_id');
				}if (Schema::hasColumn('accounts','class_id') && !DB::select(DB::raw("SHOW INDEXES FROM accounts WHERE key_name='accounts_class_id_index'"))) {
					$table->index('class_id');
				}if (Schema::hasColumn('accounts','exp_category_id') && !DB::select(DB::raw("SHOW INDEXES FROM accounts WHERE key_name='accounts_exp_category_id_index'"))) {
					$table->index('exp_category_id');
				}
			});
		}

		// add indexs to active_financial_class
		if(Schema::hasTable('active_financial_class')) {
			Schema::table('active_financial_class', function (Blueprint $table) {
				if (Schema::hasColumn('active_financial_class','fclass_id') && !DB::select(DB::raw("SHOW INDEXES FROM active_financial_class WHERE key_name='active_financial_class_fclass_id_index'"))) {
					$table->index('fclass_id');
				}if (Schema::hasColumn('active_financial_class','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM active_financial_class WHERE key_name='active_financial_class_user_id_index'"))) {
					$table->index('user_id');
				}if (Schema::hasColumn('active_financial_class','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM active_financial_class WHERE key_name='active_financial_class_company_id_index'"))) {
					$table->index('company_id');
				}
			});
		}

		// add indexs to adjustments
		if(Schema::hasTable('adjustments')) {
			Schema::table('adjustments', function (Blueprint $table) {
				if (Schema::hasColumn('adjustments','ref_no') && !DB::select(DB::raw("SHOW INDEXES FROM adjustments WHERE key_name='adjustments_ref_no_index'"))) {
					$table->index('ref_no');
				}if (Schema::hasColumn('adjustments','account_id') && !DB::select(DB::raw("SHOW INDEXES FROM adjustments WHERE key_name='adjustments_account_id_index'"))) {
					$table->index('account_id');
				}if (Schema::hasColumn('adjustments','date') && !DB::select(DB::raw("SHOW INDEXES FROM adjustments WHERE key_name='adjustments_date_index'"))) {
					$table->index('date');
				}if (Schema::hasColumn('adjustments','type') && !DB::select(DB::raw("SHOW INDEXES FROM adjustments WHERE key_name='adjustments_type_index'"))) {
					$table->index('type');
				}if (Schema::hasColumn('adjustments','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM adjustments WHERE key_name='adjustments_company_id_index'"))) {
					$table->index('company_id');
				}if (Schema::hasColumn('adjustments','category_id') && !DB::select(DB::raw("SHOW INDEXES FROM adjustments WHERE key_name='adjustments_category_id_index'"))) {
					$table->index('category_id');
				}if (Schema::hasColumn('adjustments','vehicle_id') && !DB::select(DB::raw("SHOW INDEXES FROM adjustments WHERE key_name='adjustments_vehicle_id_index'"))) {
					$table->index('vehicle_id');
				}if (Schema::hasColumn('adjustments','contract_id') && !DB::select(DB::raw("SHOW INDEXES FROM adjustments WHERE key_name='adjustments_contract_id_index'"))) {
					$table->index('contract_id');
				}if (Schema::hasColumn('adjustments','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM adjustments WHERE key_name='adjustments_user_id_index'"))) {
					$table->index('user_id');
				}if (Schema::hasColumn('adjustments','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM adjustments WHERE key_name='adjustments_member_id_index'"))) {
					$table->index('member_id');
				}
			});
		}


		
		// add indexs to adjustment_details
		if(Schema::hasTable('adjustment_details')) {
			Schema::table('adjustment_details', function (Blueprint $table) {
				if (Schema::hasColumn('adjustment_details','stock_out_id') && !DB::select(DB::raw("SHOW INDEXES FROM adjustment_details WHERE key_name='adjustment_details_stock_out_id_index'"))) {
					$table->index('stock_out_id');
				}if (Schema::hasColumn('adjustment_details','adjustment_id') && !DB::select(DB::raw("SHOW INDEXES FROM adjustment_details WHERE key_name='adjustment_details_adjustment_id_index'"))) {
					$table->index('adjustment_id');
				}if (Schema::hasColumn('adjustment_details','site_id') && !DB::select(DB::raw("SHOW INDEXES FROM adjustment_details WHERE key_name='adjustment_details_site_id_index'"))) {
					$table->index('site_id');
				}if (Schema::hasColumn('adjustment_details','um_id') && !DB::select(DB::raw("SHOW INDEXES FROM adjustment_details WHERE key_name='adjustment_details_um_id_index'"))) {
					$table->index('um_id');
				}if (Schema::hasColumn('adjustment_details','inventory_id') && !DB::select(DB::raw("SHOW INDEXES FROM adjustment_details WHERE key_name='adjustment_details_inventory_id_index'"))) {
					$table->index('inventory_id');
				}if (Schema::hasColumn('adjustment_details','inventory_category_id') && !DB::select(DB::raw("SHOW INDEXES FROM adjustment_details WHERE key_name='a_d_inventory_category_id'"))) {
					$table->index('inventory_category_id', 'a_d_inventory_category_id');
				}if (Schema::hasColumn('adjustment_details','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM adjustment_details WHERE key_name='adjustment_details_company_id_index'"))) {
					$table->index('company_id');
				}if (Schema::hasColumn('adjustment_details','m_stock_out_id') && !DB::select(DB::raw("SHOW INDEXES FROM adjustment_details WHERE key_name='a_d_m_stock_out_id'"))) {
					$table->index('m_stock_out_id', 'a_d_m_stock_out_id');
				}
			});
		}


	
		// add indexs to adjustment_stock_outs
		if(Schema::hasTable('adjustment_stock_outs')) {
			Schema::table('adjustment_stock_outs', function (Blueprint $table) {
				if (Schema::hasColumn('adjustment_stock_outs','stock_out_id') && !DB::select(DB::raw("SHOW INDEXES FROM adjustment_stock_outs WHERE key_name='adjustment_stock_outs_stock_out_id_index'"))) {
					$table->index('stock_out_id');
				}if (Schema::hasColumn('adjustment_stock_outs','adjustment_id') && !DB::select(DB::raw("SHOW INDEXES FROM adjustment_stock_outs WHERE key_name='adjustment_stock_outs_adjustment_id_index'"))) {
					$table->index('adjustment_id');
				}if (Schema::hasColumn('adjustment_stock_outs','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM adjustment_stock_outs WHERE key_name='adjustment_stock_outs_company_id_index'"))) {
					$table->index('company_id');
				}if (Schema::hasColumn('adjustment_stock_outs','m_stock_out_id') && !DB::select(DB::raw("SHOW INDEXES FROM adjustment_stock_outs WHERE key_name='adjustment_stock_outs_m_stock_out_id_index'"))) {
					$table->index('m_stock_out_id');
				}
			});
		}



		// add indexs to adjustment_transaction_details
		if(Schema::hasTable('adjustment_transaction_details')) {
			Schema::table('adjustment_transaction_details', function (Blueprint $table) {
				if (Schema::hasColumn('adjustment_transaction_details','transaction_id')&& !DB::select(DB::raw("SHOW INDEXES FROM adjustment_transaction_details WHERE key_name='a_t_d_transaction_id'"))) {
					$table->index('transaction_id', 'a_t_d_transaction_id');
				}if (Schema::hasColumn('adjustment_transaction_details','member_id')&& !DB::select(DB::raw("SHOW INDEXES FROM adjustment_transaction_details WHERE key_name='a_t_member_id'"))) {
					$table->index('member_id', 'a_t_member_id');
				}if (Schema::hasColumn('adjustment_transaction_details','type')&& !DB::select(DB::raw("SHOW INDEXES FROM adjustment_transaction_details WHERE key_name='adjustment_transaction_details_type_index'"))) {
					$table->index('type');
				}if (Schema::hasColumn('adjustment_transaction_details','type_id')&& !DB::select(DB::raw("SHOW INDEXES FROM adjustment_transaction_details WHERE key_name='a_t_d_type_id'"))) {
					$table->index('type_id', 'a_t_d_type_id');
				}if (Schema::hasColumn('adjustment_transaction_details','adjustment_id')&& !DB::select(DB::raw("SHOW INDEXES FROM adjustment_transaction_details WHERE key_name='a_t_d_adjustment_id'"))) {
					$table->index('adjustment_id', 'a_t_d_adjustment_id');
				} 
			});
		}

		// add indexs to attachments
		if(Schema::hasTable('attachments')) {
			Schema::table('attachments', function (Blueprint $table) {
				if (Schema::hasColumn('attachments','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM attachments WHERE key_name='attachments_company_id_index'"))) {
					$table->index('company_id');
				}if (Schema::hasColumn('attachments','attachment_category_id') && !DB::select(DB::raw("SHOW INDEXES FROM attachments WHERE key_name='attachments_attachment_category_id_index'"))) {
					$table->index('attachment_category_id');
				}if (Schema::hasColumn('attachments','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM attachments WHERE key_name='attachments_user_id_index'"))) {
					$table->index('user_id');
				}if (Schema::hasColumn('attachments','number') && !DB::select(DB::raw("SHOW INDEXES FROM attachments WHERE key_name='attachments_number_index'"))) {
					$table->index('number');
				}if (Schema::hasColumn('attachments','ref_number') && !DB::select(DB::raw("SHOW INDEXES FROM attachments WHERE key_name='attachments_ref_number_index'"))) {
					$table->index('ref_number');
				}if (Schema::hasColumn('attachments','in_sender') && !DB::select(DB::raw("SHOW INDEXES FROM attachments WHERE key_name='attachments_in_sender_index'"))) {
					$table->index('in_sender');
				}if (Schema::hasColumn('attachments','in_receiver') && !DB::select(DB::raw("SHOW INDEXES FROM attachments WHERE key_name='attachments_in_receiver_index'"))) {
					$table->index('in_receiver');
				}if (Schema::hasColumn('attachments','out_receiver') && !DB::select(DB::raw("SHOW INDEXES FROM attachments WHERE key_name='attachments_out_receiver_index'"))) {
					$table->index('out_receiver');
				}if (Schema::hasColumn('attachments','out_sender') && !DB::select(DB::raw("SHOW INDEXES FROM attachments WHERE key_name='attachments_out_sender_index'"))) {
					$table->index('out_sender');
				}if (Schema::hasColumn('attachments','in_date') && !DB::select(DB::raw("SHOW INDEXES FROM attachments WHERE key_name='attachments_in_date_index'"))) {
					$table->index('in_date');
				}if (Schema::hasColumn('attachments','main_receiver') && !DB::select(DB::raw("SHOW INDEXES FROM attachments WHERE key_name='attachments_main_receiver_index'"))) {
					$table->index('main_receiver');
				}if (Schema::hasColumn('attachments','attachment_class_id') && !DB::select(DB::raw("SHOW INDEXES FROM attachments WHERE key_name='attachments_attachment_class_id_index'"))) {
					$table->index('attachment_class_id');
				}if (Schema::hasColumn('attachments','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM attachments WHERE key_name='attachments_member_id_index'"))) {
					$table->index('member_id');
				}if (Schema::hasColumn('attachments','financial_class_id') && !DB::select(DB::raw("SHOW INDEXES FROM attachments WHERE key_name='attachments_financial_class_id_index'"))) {
					$table->index('financial_class_id');
				}  
			});
		}



		// add indexs to builds
		if(Schema::hasTable('builds')) {
			Schema::table('builds', function (Blueprint $table) {
				if (Schema::hasColumn('builds','number') && !DB::select(DB::raw("SHOW INDEXES FROM builds WHERE key_name='builds_number_index'"))) {
					$table->index('number');
				}if (Schema::hasColumn('builds','assembly_id') && !DB::select(DB::raw("SHOW INDEXES FROM builds WHERE key_name='builds_assembly_id_index'"))) {
					$table->index('assembly_id');
				}if (Schema::hasColumn('builds','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM builds WHERE key_name='builds_user_id_index'"))) {
					$table->index('user_id');
				}if (Schema::hasColumn('builds','date') && !DB::select(DB::raw("SHOW INDEXES FROM builds WHERE key_name='builds_date_index'"))) {
					$table->index('date');
				}if (Schema::hasColumn('builds','type') && !DB::select(DB::raw("SHOW INDEXES FROM builds WHERE key_name='builds_type_index'"))) {
					$table->index('type');
				}if (Schema::hasColumn('builds','expense_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM builds WHERE key_name='builds_expense_transaction_index'"))) {
					$table->index('expense_transaction');
				}if (Schema::hasColumn('builds','inventory_id') && !DB::select(DB::raw("SHOW INDEXES FROM builds WHERE key_name='builds_inventory_id_index'"))) {
					$table->index('inventory_id');
				}if (Schema::hasColumn('builds','project_id') && !DB::select(DB::raw("SHOW INDEXES FROM builds WHERE key_name='builds_project_id_index'"))) {
					$table->index('project_id');
				}if (Schema::hasColumn('builds','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM builds WHERE key_name='builds_company_id_index'"))) {
					$table->index('company_id');
				}if (Schema::hasColumn('builds','contract_id') && !DB::select(DB::raw("SHOW INDEXES FROM builds WHERE key_name='builds_contract_id_index'"))) {
					$table->index('contract_id');
				}if (Schema::hasColumn('builds','employee_id') && !DB::select(DB::raw("SHOW INDEXES FROM builds WHERE key_name='builds_employee_id_index'"))) {
					$table->index('employee_id');
				}if (Schema::hasColumn('builds','carpet_contract_id') && !DB::select(DB::raw("SHOW INDEXES FROM builds WHERE key_name='builds_carpet_contract_id_index'"))) {
					$table->index('carpet_contract_id');
				}if (Schema::hasColumn('builds','ref_no') && !DB::select(DB::raw("SHOW INDEXES FROM builds WHERE key_name='builds_ref_no_index'"))) {
					$table->index('ref_no');
				}
			});
		}



			// add indexs to build_details
			if(Schema::hasTable('build_details')) {
				Schema::table('build_details', function (Blueprint $table) {
					if (Schema::hasColumn('build_details','type')&& !DB::select(DB::raw("SHOW INDEXES FROM build_details WHERE key_name='build_details_type_index'"))) {
						$table->index('type');
					}if (Schema::hasColumn('build_details','item_id')&& !DB::select(DB::raw("SHOW INDEXES FROM build_details WHERE key_name='build_details_item_id_index'"))) {
						$table->index('item_id');
					}if (Schema::hasColumn('build_details','um_id')&& !DB::select(DB::raw("SHOW INDEXES FROM build_details WHERE key_name='build_details_um_id_index'"))) {
						$table->index('um_id');
					}if (Schema::hasColumn('build_details','build_id')&& !DB::select(DB::raw("SHOW INDEXES FROM build_details WHERE key_name='build_details_build_id_index'"))) {
						$table->index('build_id');
					}if (Schema::hasColumn('build_details','formula_id')&& !DB::select(DB::raw("SHOW INDEXES FROM build_details WHERE key_name='build_details_formula_id_index'"))) {
						$table->index('formula_id');
					}if (Schema::hasColumn('build_details','company_id')&& !DB::select(DB::raw("SHOW INDEXES FROM build_details WHERE key_name='build_details_company_id_index'"))) {
						$table->index('company_id');
					}if (Schema::hasColumn('build_details','site_id')&& !DB::select(DB::raw("SHOW INDEXES FROM build_details WHERE key_name='build_details_site_id_index'"))) {
						$table->index('site_id');
					}if (Schema::hasColumn('build_details','build_stock_in_id')&& !DB::select(DB::raw("SHOW INDEXES FROM build_details WHERE key_name='build_details_build_stock_in_id_index'"))) {
						$table->index('build_stock_in_id');
					}
				});
			}
	



			
			// add indexs to cheque
			if(Schema::hasTable('cheque')) {
				Schema::table('cheque', function (Blueprint $table) {
					if (Schema::hasColumn('cheque','ref_no')&& !DB::select(DB::raw("SHOW INDEXES FROM cheque WHERE key_name='cheque_ref_no_index'"))) {
						$table->index('ref_no');
					}if (Schema::hasColumn('cheque','type')&& !DB::select(DB::raw("SHOW INDEXES FROM cheque WHERE key_name='cheque_type_index'"))) {
						$table->index('type');
					}if (Schema::hasColumn('cheque','sender')&& !DB::select(DB::raw("SHOW INDEXES FROM cheque WHERE key_name='cheque_sender_index'"))) {
						$table->index('sender');
					}if (Schema::hasColumn('cheque','sender_id')&& !DB::select(DB::raw("SHOW INDEXES FROM cheque WHERE key_name='cheque_sender_id_index'"))) {
						$table->index('sender_id');
					}if (Schema::hasColumn('cheque','sen_ssn_number')&& !DB::select(DB::raw("SHOW INDEXES FROM cheque WHERE key_name='cheque_sen_ssn_number_index'"))) {
						$table->index('sen_ssn_number');
					}if (Schema::hasColumn('cheque','reciever')&& !DB::select(DB::raw("SHOW INDEXES FROM cheque WHERE key_name='cheque_reciever_index'"))) {
						$table->index('reciever');
					}if (Schema::hasColumn('cheque','reciever_id')&& !DB::select(DB::raw("SHOW INDEXES FROM cheque WHERE key_name='cheque_reciever_id_index'"))) {
						$table->index('reciever_id');
					}if (Schema::hasColumn('cheque','rec_ssn_number')&& !DB::select(DB::raw("SHOW INDEXES FROM cheque WHERE key_name='cheque_rec_ssn_number_index'"))) {
						$table->index('rec_ssn_number');
					}if (Schema::hasColumn('cheque','account_id')&& !DB::select(DB::raw("SHOW INDEXES FROM cheque WHERE key_name='cheque_account_id_index'"))) {
						$table->index('account_id');
					}if (Schema::hasColumn('cheque','currency')&& !DB::select(DB::raw("SHOW INDEXES FROM cheque WHERE key_name='cheque_currency_index'"))) {
						$table->index('currency');
					}if (Schema::hasColumn('cheque','bank_transaction_id')&& !DB::select(DB::raw("SHOW INDEXES FROM cheque WHERE key_name='cheque_bank_transaction_id_index'"))) {
						$table->index('bank_transaction_id');
					}if (Schema::hasColumn('cheque','cheque_transaction_id')&& !DB::select(DB::raw("SHOW INDEXES FROM cheque WHERE key_name='cheque_cheque_transaction_id_index'"))) {
						$table->index('cheque_transaction_id');
					}if (Schema::hasColumn('cheque','transaction_type')&& !DB::select(DB::raw("SHOW INDEXES FROM cheque WHERE key_name='cheque_transaction_type_index'"))) {
						$table->index('transaction_type');
					}if (Schema::hasColumn('cheque','commission_income_tran_id')&& !DB::select(DB::raw("SHOW INDEXES FROM cheque WHERE key_name='cheque_commission_income_tran_id_index'"))) {
						$table->index('commission_income_tran_id');
					}if (Schema::hasColumn('cheque','commission_bank_tran_id')&& !DB::select(DB::raw("SHOW INDEXES FROM cheque WHERE key_name='c_c_bank_tran_id'"))) {
						$table->index('commission_bank_tran_id', 'c_c_bank_tran_id');
					}if (Schema::hasColumn('cheque','commission_recievable_tran_id')&& !DB::select(DB::raw("SHOW INDEXES FROM cheque WHERE key_name='c_c_r_t'"))) {
						$table->index('commission_recievable_tran_id' , 'c_c_r_t');
					}if (Schema::hasColumn('cheque','member_id')&& !DB::select(DB::raw("SHOW INDEXES FROM cheque WHERE key_name='cheque_member_id_index'"))) {
						$table->index('member_id');
					}if (Schema::hasColumn('cheque','class_id')&& !DB::select(DB::raw("SHOW INDEXES FROM cheque WHERE key_name='cheque_class_id_index'"))) {
						$table->index('class_id');
					}if (Schema::hasColumn('cheque','date')&& !DB::select(DB::raw("SHOW INDEXES FROM cheque WHERE key_name='cheque_date_index'"))) {
						$table->index('date');
					}if (Schema::hasColumn('cheque','user_id')&& !DB::select(DB::raw("SHOW INDEXES FROM cheque WHERE key_name='cheque_user_id_index'"))) {
						$table->index('user_id');
					}if (Schema::hasColumn('cheque','company_id')&& !DB::select(DB::raw("SHOW INDEXES FROM cheque WHERE key_name='cheque_company_id_index'"))) {
						$table->index('company_id');
					}if (Schema::hasColumn('cheque','branch_company_id')&& !DB::select(DB::raw("SHOW INDEXES FROM cheque WHERE key_name='cheque_branch_company_id_index'"))) {
						$table->index('branch_company_id');
					}if (Schema::hasColumn('cheque','send_reci_transaction_id')&& !DB::select(DB::raw("SHOW INDEXES FROM cheque WHERE key_name='c_s_r_transaction_id'"))) {
						$table->index('send_reci_transaction_id', 'c_s_r_transaction_id');
					}if (Schema::hasColumn('cheque','commission_SR_transaction_id')&& !DB::select(DB::raw("SHOW INDEXES FROM cheque WHERE key_name='c_c_sr_t'"))) {
						$table->index('commission_SR_transaction_id', 'c_c_sr_t');
					}if (Schema::hasColumn('cheque','rec_phone')&& !DB::select(DB::raw("SHOW INDEXES FROM cheque WHERE key_name='cheque_rec_phone_index'"))) {
						$table->index('rec_phone');
					}if (Schema::hasColumn('cheque','commiss_currency')&& !DB::select(DB::raw("SHOW INDEXES FROM cheque WHERE key_name='cheque_commiss_currency_index'"))) {
						$table->index('commiss_currency');
					}if (Schema::hasColumn('cheque','commission_income_tran2_id')&& !DB::select(DB::raw("SHOW INDEXES FROM cheque WHERE key_name='cheque_commission_income_tran2_id_index'"))) {
						$table->index('commission_income_tran2_id');
					}if (Schema::hasColumn('cheque','commission_bank_tran2_id')&& !DB::select(DB::raw("SHOW INDEXES FROM cheque WHERE key_name='c_c_b_tran2_id'"))) {
						$table->index('commission_bank_tran2_id', 'c_c_b_tran2_id');
					}if (Schema::hasColumn('cheque','commission_recievable_tran2_id')&& !DB::select(DB::raw("SHOW INDEXES FROM cheque WHERE key_name='c_r_tran2_id'"))) {
						$table->index('commission_recievable_tran2_id', 'c_r_tran2_id');
					}if (Schema::hasColumn('cheque','commission_SR_transaction2_id')&& !DB::select(DB::raw("SHOW INDEXES FROM cheque WHERE key_name='c_sr_transaction2_id'"))) {
						$table->index('commission_SR_transaction2_id', 'c_sr_transaction2_id');
					}if (Schema::hasColumn('cheque','gain_loss_tran_id')&& !DB::select(DB::raw("SHOW INDEXES FROM cheque WHERE key_name='cheque_gain_loss_tran_id_index'"))) {
						$table->index('gain_loss_tran_id');
					}
				});
			}
	

			
			// add indexs to companies
			if(Schema::hasTable('companies')) {
				Schema::table('companies', function (Blueprint $table) {
					if (Schema::hasColumn('companies','system_config_id') && !DB::select(DB::raw("SHOW INDEXES FROM companies WHERE key_name='companies_system_config_id_index'"))) {
						$table->index('system_config_id');
					}if (Schema::hasColumn('companies','parent_id') && !DB::select(DB::raw("SHOW INDEXES FROM companies WHERE key_name='companies_parent_id_index'"))) {
						$table->index('parent_id');
					}
				});
			}

			 

			// add indexs to company_details
			if(Schema::hasTable('company_details')) {
				Schema::table('company_details', function (Blueprint $table) {
					if (Schema::hasColumn('company_details','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM company_details WHERE key_name='company_details_company_id_index'"))) {
						$table->index('company_id');
					}
				});
			}
 

			// add indexs to company_infos
			if(Schema::hasTable('company_infos')) {
				Schema::table('company_infos', function (Blueprint $table) {
					if (Schema::hasColumn('company_infos','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM company_infos WHERE key_name='company_infos_company_id_index'"))) {
						$table->index('company_id');
					}
					if (Schema::hasColumn('company_infos','name') && !DB::select(DB::raw("SHOW INDEXES FROM company_infos WHERE key_name='company_infos_name_index'"))) {
						$table->index('name');
					}
				});
			}
 

			// add indexs to contracts
			if(Schema::hasTable('contracts')) {
				Schema::table('contracts', function (Blueprint $table) {
					if (Schema::hasColumn('contracts','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM contracts WHERE key_name='contracts_member_id_index'"))) {
						$table->index('member_id');
					}
					if (Schema::hasColumn('contracts','name') && !DB::select(DB::raw("SHOW INDEXES FROM contracts WHERE key_name='contracts_name_index'"))) {
						$table->index('name');
					}if (Schema::hasColumn('contracts','receivable_id') && !DB::select(DB::raw("SHOW INDEXES FROM contracts WHERE key_name='contracts_receivable_id_index'"))) {
						$table->index('receivable_id');
					}
					if (Schema::hasColumn('contracts','name') && !DB::select(DB::raw("SHOW INDEXES FROM contracts WHERE key_name='contracts_account_id_index'"))) {
						$table->index('name');
					}if (Schema::hasColumn('contracts','account_id') && !DB::select(DB::raw("SHOW INDEXES FROM contracts WHERE key_name='contracts_transaction_id_index'"))) {
						$table->index('account_id');
					}
					if (Schema::hasColumn('contracts','transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM contracts WHERE key_name='contracts_date_index'"))) {
						$table->index('transaction_id');
					}
					if (Schema::hasColumn('contracts','date') && !DB::select(DB::raw("SHOW INDEXES FROM contracts WHERE key_name='contracts_owner_id_index'"))) {
						$table->index('date');
					}if (Schema::hasColumn('contracts','owner_id') && !DB::select(DB::raw("SHOW INDEXES FROM contracts WHERE key_name='contracts_company_id_index'"))) {
						$table->index('owner_id');
					}
					if (Schema::hasColumn('contracts','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM contracts WHERE key_name='contracts_currency_index'"))) {
						$table->index('company_id');
					}
					if (Schema::hasColumn('contracts','currency') && !DB::select(DB::raw("SHOW INDEXES FROM contracts WHERE key_name='contracts_start_date_index'"))) {
						$table->index('currency');
					}if (Schema::hasColumn('contracts','start_date')  && !DB::select(DB::raw("SHOW INDEXES FROM contracts WHERE key_name='contracts_start_date_index'"))) {
						$table->index('start_date');
					}
					if (Schema::hasColumn('contracts','end_date') && !DB::select(DB::raw("SHOW INDEXES FROM contracts WHERE key_name='contracts_end_date_index'"))) {
						$table->index('end_date');
					}
					if (Schema::hasColumn('contracts','platts_category_id') && !DB::select(DB::raw("SHOW INDEXES FROM contracts WHERE key_name='contracts_platts_category_id_index'"))) {
						$table->index('platts_category_id');
					}
					
				});
			}

			// add indexs to contract_details
			if(Schema::hasTable('contract_details')) {
				Schema::table('contract_details', function (Blueprint $table) {
					if (Schema::hasColumn('contract_details','contract_id') && !DB::select(DB::raw("SHOW INDEXES FROM contract_details WHERE key_name='contract_details_contract_id_index'"))) {
						$table->index('contract_id');
					}
					if (Schema::hasColumn('contract_details','inventory_id') && !DB::select(DB::raw("SHOW INDEXES FROM contract_details WHERE key_name='contract_details_inventory_id_index'"))) {
						$table->index('inventory_id');
					}if (Schema::hasColumn('contract_details','um_id') && !DB::select(DB::raw("SHOW INDEXES FROM contract_details WHERE key_name='contract_details_um_id_index'"))) {
						$table->index('um_id');
					}
					if (Schema::hasColumn('contract_details','site_id') && !DB::select(DB::raw("SHOW INDEXES FROM contract_details WHERE key_name='contract_details_site_id_index'"))) {
						$table->index('site_id');
					}if (Schema::hasColumn('contract_details','inventory_category_id') && !DB::select(DB::raw("SHOW INDEXES FROM contract_details WHERE key_name='contract_details_inventory_category_id_index'"))) {
						$table->index('inventory_category_id');
					}
					if (Schema::hasColumn('contract_details','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM contract_details WHERE key_name='contract_details_company_id_index'"))) {
						$table->index('company_id');
					}
				});
			}


			// add indexs to contract_stocks
			if(Schema::hasTable('contract_stocks')) {
				Schema::table('contract_stocks', function (Blueprint $table) {
					if (Schema::hasColumn('contract_stocks','stock_id') && !DB::select(DB::raw("SHOW INDEXES FROM contract_stocks WHERE key_name='contract_stocks_stock_id_index'"))) {
						$table->index('stock_id');
					}
					if (Schema::hasColumn('contract_stocks','contract_detail_id') && !DB::select(DB::raw("SHOW INDEXES FROM contract_stocks WHERE key_name='contract_stocks_contract_detail_id_index'"))) {
						$table->index('contract_detail_id');
					}if (Schema::hasColumn('contract_stocks','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM contract_stocks WHERE key_name='contract_stocks_company_id_index'"))) {
						$table->index('company_id');
					}
				});
			}


			// add indexs to contract_purchases
			if(Schema::hasTable('contract_purchases')) {
				Schema::table('contract_purchases', function (Blueprint $table) {
					if (Schema::hasColumn('contract_purchases','contract_id') && !DB::select(DB::raw("SHOW INDEXES FROM contract_purchases WHERE key_name='contract_purchases_contract_id_index'"))) {
						$table->index('contract_id');
					}if (Schema::hasColumn('contract_purchases','purchase_id') && !DB::select(DB::raw("SHOW INDEXES FROM contract_purchases WHERE key_name='contract_purchases_purchase_id_index'"))) {
						$table->index('purchase_id');
					}if (Schema::hasColumn('contract_purchases','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM contract_purchases WHERE key_name='contract_purchases_company_id_index'"))) {
						$table->index('company_id');
					}
				});
			}



			// add indexs to expenses
			if(Schema::hasTable('expenses')) {
				Schema::table('expenses', function (Blueprint $table) {
					if (Schema::hasColumn('expenses','transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM expenses WHERE key_name='expenses_transaction_id_index'"))) {
						$table->index('transaction_id');
					}
					if (Schema::hasColumn('expenses','purchase_id') && !DB::select(DB::raw("SHOW INDEXES FROM expenses WHERE key_name='expenses_purchase_id_index'"))) {
						$table->index('purchase_id');
					}if (Schema::hasColumn('expenses','date') && !DB::select(DB::raw("SHOW INDEXES FROM expenses WHERE key_name='expenses_date_index'"))) {
						$table->index('date');
					}
					if (Schema::hasColumn('expenses','expense_category_id') && !DB::select(DB::raw("SHOW INDEXES FROM expenses WHERE key_name='expenses_expense_category_id_index'"))) {
						$table->index('expense_category_id');
					}if (Schema::hasColumn('expenses','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM expenses WHERE key_name='expenses_company_id_index'"))) {
						$table->index('company_id');
					}
					if (Schema::hasColumn('expenses','project_id') && !DB::select(DB::raw("SHOW INDEXES FROM expenses WHERE key_name='expenses_project_id_index'"))) {
						$table->index('project_id');
					}
					if (Schema::hasColumn('expenses','contract_id') && !DB::select(DB::raw("SHOW INDEXES FROM expenses WHERE key_name='expenses_contract_id_index'"))) {
						$table->index('contract_id');
					}if (Schema::hasColumn('expenses','sale_id') && !DB::select(DB::raw("SHOW INDEXES FROM expenses WHERE key_name='expenses_sale_id_index'"))) {
						$table->index('sale_id');
					}
				});
			}


			
			// add indexs to daily_expenses
			if(Schema::hasTable('daily_expenses')) {
				Schema::table('daily_expenses', function (Blueprint $table) {
					if (Schema::hasColumn('daily_expenses','bank_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM daily_expenses WHERE key_name='daily_expenses_bank_transaction_index'"))) {
						$table->index('bank_transaction');
					}
					if (Schema::hasColumn('daily_expenses','expense_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM daily_expenses WHERE key_name='d_e_e_transaction'"))) {
						$table->index('expense_transaction', 'd_e_e_transaction');
					}if (Schema::hasColumn('daily_expenses','date') && !DB::select(DB::raw("SHOW INDEXES FROM daily_expenses WHERE key_name='daily_expenses_date_index'"))) {
						$table->index('date');
					}
					if (Schema::hasColumn('daily_expenses','category_id') && !DB::select(DB::raw("SHOW INDEXES FROM daily_expenses WHERE key_name='daily_expenses_category_id_index'"))) {
						$table->index('category_id');
					}if (Schema::hasColumn('daily_expenses','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM daily_expenses WHERE key_name='daily_expenses_company_id_index'"))) {
						$table->index('company_id');
					}
					if (Schema::hasColumn('daily_expenses','project_id') && !DB::select(DB::raw("SHOW INDEXES FROM daily_expenses WHERE key_name='daily_expenses_project_id_index'"))) {
						$table->index('project_id');
					}
				});
			}



			// add indexs to expense_details
			if(Schema::hasTable('expense_details')) {
				Schema::table('expense_details', function (Blueprint $table) {
					if (Schema::hasColumn('expense_details','expense_id')&& !DB::select(DB::raw("SHOW INDEXES FROM expense_details WHERE key_name='expense_details_expense_id_index'"))) {
						$table->index('expense_id');
					}
					if (Schema::hasColumn('expense_details','company_id')&& !DB::select(DB::raw("SHOW INDEXES FROM expense_details WHERE key_name='expense_details_company_id_index'"))) {
						$table->index('company_id');
					}
				});
			}


			// add indexs to fined_drivers
			if(Schema::hasTable('fined_drivers')) {
				Schema::table('fined_drivers', function (Blueprint $table) {
					if (Schema::hasColumn('fined_drivers','driver_id') && !DB::select(DB::raw("SHOW INDEXES FROM fined_drivers WHERE key_name='fined_drivers_driver_id_index'"))) {
						$table->index('driver_id');
					}
					if (Schema::hasColumn('fined_drivers','transfer_and_loading_id') && !DB::select(DB::raw("SHOW INDEXES FROM fined_drivers WHERE key_name='f_d_t_and_loading_id'"))) {
						$table->index('transfer_and_loading_id', 'f_d_t_and_loading_id');
					}if (Schema::hasColumn('fined_drivers','inventory_transfer_info_id') && !DB::select(DB::raw("SHOW INDEXES FROM fined_drivers WHERE key_name='f_d_i_t_info_id'"))) {
						$table->index('inventory_transfer_info_id', 'f_d_i_t_info_id');
					}
					if (Schema::hasColumn('fined_drivers','currency') && !DB::select(DB::raw("SHOW INDEXES FROM fined_drivers WHERE key_name='fined_drivers_currency_index'"))) {
						$table->index('currency');
					}if (Schema::hasColumn('fined_drivers','transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM fined_drivers WHERE key_name='fined_drivers_transaction_id_index'"))) {
						$table->index('transaction_id');
					}
					if (Schema::hasColumn('fined_drivers','other_income_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM fined_drivers WHERE key_name='f_d_o_i_transaction_id'"))) {
						$table->index('other_income_transaction_id', 'f_d_o_i_transaction_id');
					}if (Schema::hasColumn('fined_drivers','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM fined_drivers WHERE key_name='fined_drivers_company_id_index'"))) {
						$table->index('company_id');
					}
					if (Schema::hasColumn('fined_drivers','adjustment_id') && !DB::select(DB::raw("SHOW INDEXES FROM fined_drivers WHERE key_name='fined_drivers_adjustment_id_index'"))) {
						$table->index('adjustment_id');
					}if (Schema::hasColumn('fined_drivers','over_load_id') && !DB::select(DB::raw("SHOW INDEXES FROM fined_drivers WHERE key_name='fined_drivers_over_load_id_index'"))) {
						$table->index('over_load_id');
					}
					if (Schema::hasColumn('fined_drivers','vehicle_id') && !DB::select(DB::raw("SHOW INDEXES FROM fined_drivers WHERE key_name='fined_drivers_vehicle_id_index'"))) {
						$table->index('vehicle_id');
					}if (Schema::hasColumn('fined_drivers','sale_info_id') && !DB::select(DB::raw("SHOW INDEXES FROM fined_drivers WHERE key_name='fined_drivers_sale_info_id_index'"))) {
						$table->index('sale_info_id');
					}
					if (Schema::hasColumn('fined_drivers','loading_detail_id') && !DB::select(DB::raw("SHOW INDEXES FROM fined_drivers WHERE key_name='fined_drivers_loading_detail_id_index'"))) {
						$table->index('loading_detail_id');
					}
					if (Schema::hasColumn('fined_drivers','um_id') && !DB::select(DB::raw("SHOW INDEXES FROM fined_drivers WHERE key_name='fined_drivers_um_id_index'"))) {
						$table->index('um_id');
					}if (Schema::hasColumn('fined_drivers','account_id') && !DB::select(DB::raw("SHOW INDEXES FROM fined_drivers WHERE key_name='fined_drivers_account_id_index'"))) {
						$table->index('account_id');
					}
					if (Schema::hasColumn('fined_drivers','driver_over_load_id') && !DB::select(DB::raw("SHOW INDEXES FROM fined_drivers WHERE key_name='f_d_d_o_load_id'"))) {
						$table->index('driver_over_load_id', 'f_d_d_o_load_id');
					}if (Schema::hasColumn('fined_drivers','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM fined_drivers WHERE key_name='fined_drivers_user_id_index'"))) {
						$table->index('user_id');
					}
				});
			}




			// add indexs to fixed_asset_management
			if(Schema::hasTable('fixed_asset_management')) {
				Schema::table('fixed_asset_management', function (Blueprint $table) {
					if (Schema::hasColumn('fixed_asset_management','name') && !DB::select(DB::raw("SHOW INDEXES FROM fixed_asset_management WHERE key_name='fixed_asset_management_name_index'"))) {
						$table->index('name');
					}
					if (Schema::hasColumn('fixed_asset_management','number') && !DB::select(DB::raw("SHOW INDEXES FROM fixed_asset_management WHERE key_name='fixed_asset_management_number_index'"))) {
						$table->index('number');
					}
					if (Schema::hasColumn('fixed_asset_management','type') && !DB::select(DB::raw("SHOW INDEXES FROM fixed_asset_management WHERE key_name='fixed_asset_management_type_index'"))) {
						$table->index('type');
					}
					if (Schema::hasColumn('fixed_asset_management','date') && !DB::select(DB::raw("SHOW INDEXES FROM fixed_asset_management WHERE key_name='fixed_asset_management_date_index'"))) {
						$table->index('date');
					}
					if (Schema::hasColumn('fixed_asset_management','asset_id') && !DB::select(DB::raw("SHOW INDEXES FROM fixed_asset_management WHERE key_name='fixed_asset_management_asset_id_index'"))) {
						$table->index('asset_id');
					}
					if (Schema::hasColumn('fixed_asset_management','vendor_id') && !DB::select(DB::raw("SHOW INDEXES FROM fixed_asset_management WHERE key_name='fixed_asset_management_vendor_id_index'"))) {
						$table->index('vendor_id');
					}
					if (Schema::hasColumn('fixed_asset_management','currency') && !DB::select(DB::raw("SHOW INDEXES FROM fixed_asset_management WHERE key_name='fixed_asset_management_currency_index'"))) {
						$table->index('currency');
					}
					if (Schema::hasColumn('fixed_asset_management','po_number') && !DB::select(DB::raw("SHOW INDEXES FROM fixed_asset_management WHERE key_name='fixed_asset_management_po_number_index'"))) {
						$table->index('po_number');
					}
					if (Schema::hasColumn('fixed_asset_management','transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM fixed_asset_management WHERE key_name='f_a_m_transaction_id'"))) {
						$table->index('transaction_id', 'f_a_m_transaction_id');
					}
					if (Schema::hasColumn('fixed_asset_management','opening_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM fixed_asset_management WHERE key_name='f_a_m_o_transaction_id'"))) {
						$table->index('opening_transaction_id', 'f_a_m_o_transaction_id');
					}
					if (Schema::hasColumn('fixed_asset_management','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM fixed_asset_management WHERE key_name='fixed_asset_management_user_id_index'"))) {
						$table->index('user_id');
					}
					if (Schema::hasColumn('fixed_asset_management','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM fixed_asset_management WHERE key_name='fixed_asset_management_company_id_index'"))) {
						$table->index('company_id');
					}
					if (Schema::hasColumn('fixed_asset_management','bank_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM fixed_asset_management WHERE key_name='f_a_m_b_transaction_id'"))) {
						$table->index('bank_transaction_id', 'f_a_m_b_transaction_id');
					}
					if (Schema::hasColumn('fixed_asset_management','payable_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM fixed_asset_management WHERE key_name='f_a_m_p_transaction_id'"))) {
						$table->index('payable_transaction_id' , 'f_a_m_p_transaction_id');
					}
					if (Schema::hasColumn('fixed_asset_management','category_id') && !DB::select(DB::raw("SHOW INDEXES FROM fixed_asset_management WHERE key_name='f_a_m_category_id'"))) {
						$table->index('category_id', 'f_a_m_category_id');
					}
				});
			}



			// add indexs to inventories
			if(Schema::hasTable('inventories')) {
				Schema::table('inventories', function (Blueprint $table) {
					if (Schema::hasColumn('inventories','item_id') && !DB::select(DB::raw("SHOW INDEXES FROM inventories WHERE key_name='inventories_item_id_index'"))) {
						$table->index('item_id');
					}
					if (Schema::hasColumn('inventories','inventory_category_id') && !DB::select(DB::raw("SHOW INDEXES FROM inventories WHERE key_name='inventories_inventory_category_id_index'"))) {
						$table->index('inventory_category_id');
					}
					if (Schema::hasColumn('inventories','transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM inventories WHERE key_name='inventories_transaction_id_index'"))) {
						$table->index('transaction_id');
					}
					if (Schema::hasColumn('inventories','opening_id') && !DB::select(DB::raw("SHOW INDEXES FROM inventories WHERE key_name='inventories_opening_id_index'"))) {
						$table->index('opening_id');
					}
					if (Schema::hasColumn('inventories','account_id') && !DB::select(DB::raw("SHOW INDEXES FROM inventories WHERE key_name='inventories_account_id_index'"))) {
						$table->index('account_id');
					}
					if (Schema::hasColumn('inventories','cost_id') && !DB::select(DB::raw("SHOW INDEXES FROM inventories WHERE key_name='inventories_cost_id_index'"))) {
						$table->index('cost_id');
					}
					if (Schema::hasColumn('inventories','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM inventories WHERE key_name='inventories_company_id_index'"))) {
						$table->index('company_id');
					}
					if (Schema::hasColumn('inventories','inventory_brand_id') && !DB::select(DB::raw("SHOW INDEXES FROM inventories WHERE key_name='inventories_inventory_brand_id_index'"))) {
						$table->index('inventory_brand_id');
					}
				});
			}



			// add indexs to items
			if(Schema::hasTable('items') ) {
				Schema::table('items', function (Blueprint $table) {
					if (Schema::hasColumn('items','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM items WHERE key_name='items_user_id_index'"))) {
						$table->index('user_id');
					}
					if (Schema::hasColumn('items','account_id') && !DB::select(DB::raw("SHOW INDEXES FROM items WHERE key_name='items_account_id_index'"))) {
						$table->index('account_id');
					}
					if (Schema::hasColumn('items','service_class_id') && !DB::select(DB::raw("SHOW INDEXES FROM items WHERE key_name='items_service_class_id_index'"))) {
						$table->index('service_class_id');
					}
					if (Schema::hasColumn('items','parent_id') && !DB::select(DB::raw("SHOW INDEXES FROM items WHERE key_name='items_parent_id_index'"))) {
						$table->index('parent_id');
					}
					if (Schema::hasColumn('items','um_id') && !DB::select(DB::raw("SHOW INDEXES FROM items WHERE key_name='items_um_id_index'"))) {
						$table->index('um_id');
					}
					if (Schema::hasColumn('items','number') && !DB::select(DB::raw("SHOW INDEXES FROM items WHERE key_name='items_number_index'"))) {
						$table->index('number');
					}
					if (Schema::hasColumn('items','name') && !DB::select(DB::raw("SHOW INDEXES FROM items WHERE key_name='items_name_index'"))) {
						$table->index('name');
					}
					if (Schema::hasColumn('items','type') && !DB::select(DB::raw("SHOW INDEXES FROM items WHERE key_name='items_type_index'"))) {
						$table->index('type');
					}
					if (Schema::hasColumn('items','other_um_id') && !DB::select(DB::raw("SHOW INDEXES FROM items WHERE key_name='items_other_um_id_index'"))) {
						$table->index('other_um_id');
					}
					if (Schema::hasColumn('items','sub_um_id') && !DB::select(DB::raw("SHOW INDEXES FROM items WHERE key_name='items_sub_um_id_index'"))) {
						$table->index('sub_um_id');
					}
					if (Schema::hasColumn('items','serial_number') && !DB::select(DB::raw("SHOW INDEXES FROM items WHERE key_name='items_serial_number_index'"))) {
						$table->index('serial_number');
					}
					if (Schema::hasColumn('items','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM items WHERE key_name='items_company_id_index'"))) {
						$table->index('company_id');
					}
					if (Schema::hasColumn('items','um1_id') && !DB::select(DB::raw("SHOW INDEXES FROM items WHERE key_name='items_um1_id_index'"))) {
						$table->index('um1_id');
					}
					if (Schema::hasColumn('items','um2_id') && !DB::select(DB::raw("SHOW INDEXES FROM items WHERE key_name='items_um2_id_index'"))) {
						$table->index('um2_id');
					}
					if (Schema::hasColumn('items','um3_id') && !DB::select(DB::raw("SHOW INDEXES FROM items WHERE key_name='items_um3_id_index'"))) {
						$table->index('um3_id');
					}
				});
			}



			// add indexs to item_expenses
			if(Schema::hasTable('item_expenses') ) {
				Schema::table('item_expenses', function (Blueprint $table) {
					if (Schema::hasColumn('item_expenses','number') && !DB::select(DB::raw("SHOW INDEXES FROM item_expenses WHERE key_name='item_expenses_number_index'"))) {
						$table->index('number');
					}
					if (Schema::hasColumn('item_expenses','type') && !DB::select(DB::raw("SHOW INDEXES FROM item_expenses WHERE key_name='item_expenses_type_index'"))) {
						$table->index('type');
					}
					if (Schema::hasColumn('item_expenses','currency') && !DB::select(DB::raw("SHOW INDEXES FROM item_expenses WHERE key_name='item_expenses_currency_index'"))) {
						$table->index('currency');
					}
					if (Schema::hasColumn('item_expenses','date') && !DB::select(DB::raw("SHOW INDEXES FROM item_expenses WHERE key_name='item_expenses_date_index'"))) {
						$table->index('date');
					}
					if (Schema::hasColumn('item_expenses','purchase_id') && !DB::select(DB::raw("SHOW INDEXES FROM item_expenses WHERE key_name='item_expenses_purchase_id_index'"))) {
						$table->index('purchase_id');
					}
					if (Schema::hasColumn('item_expenses','type_id') && !DB::select(DB::raw("SHOW INDEXES FROM item_expenses WHERE key_name='item_expenses_type_id_index'"))) {
						$table->index('type_id');
					}
					if (Schema::hasColumn('item_expenses','expense_category_id') && !DB::select(DB::raw("SHOW INDEXES FROM item_expenses WHERE key_name='item_expenses_expense_category_id_index'"))) {
						$table->index('expense_category_id');
					}
					if (Schema::hasColumn('item_expenses','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM item_expenses WHERE key_name='item_expenses_company_id_index'"))) {
						$table->index('company_id');
					}
                    if (Schema::hasColumn('item_expenses','inventory_id') && !DB::select(DB::raw("SHOW INDEXES FROM item_expenses WHERE key_name='item_expenses_inventory_id_index'"))) {
						$table->index('inventory_id');
					}
					if (Schema::hasColumn('item_expenses','inventory_category_id') && !DB::select(DB::raw("SHOW INDEXES FROM item_expenses WHERE key_name='i_e_i_category_id'"))) {
						$table->index('inventory_category_id', 'i_e_i_category_id');
					}
					if (Schema::hasColumn('item_expenses','income_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM item_expenses WHERE key_name='item_expenses_income_transaction_id_index'"))) {
						$table->index('income_transaction_id');
					}
					if (Schema::hasColumn('item_expenses','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM item_expenses WHERE key_name='item_expenses_user_id_index'"))) {
						$table->index('user_id');
					}
					 
				});
			}



	        // add indexs to item_expense_details
            if(Schema::hasTable('item_expense_details') ) {
				Schema::table('item_expense_details', function (Blueprint $table) {
					if (Schema::hasColumn('item_expense_details','item_expense_id') && !DB::select(DB::raw("SHOW INDEXES FROM item_expense_details WHERE key_name='item_expense_details_item_expense_id_index'"))) {
						$table->index('item_expense_id');
					}
					if (Schema::hasColumn('item_expense_details','stock_id') && !DB::select(DB::raw("SHOW INDEXES FROM item_expense_details WHERE key_name='item_expense_details_stock_id_index'"))) {
						$table->index('stock_id');
					}
					if (Schema::hasColumn('item_expense_details','transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM item_expense_details WHERE key_name='item_expense_details_transaction_id_index'"))) {
						$table->index('transaction_id');
					}
					if (Schema::hasColumn('item_expense_details','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM item_expense_details WHERE key_name='item_expense_details_company_id_index'"))) {
						$table->index('company_id');
					}
					if (Schema::hasColumn('item_expense_details','item_expense_category_id') && !DB::select(DB::raw("SHOW INDEXES FROM item_expense_details WHERE key_name='i_e_d_i_e_category_id'"))) {
						$table->index('item_expense_category_id', 'i_e_d_i_e_category_id');
					}
					if (Schema::hasColumn('item_expense_details','m_stock_id') && !DB::select(DB::raw("SHOW INDEXES FROM item_expense_details WHERE key_name='item_expense_details_m_stock_id_index'"))) {
						$table->index('m_stock_id');
					}
					if (Schema::hasColumn('item_expense_details','expense_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM item_expense_details WHERE key_name='i_e_d_e_transaction_id'"))) {
						$table->index('expense_transaction_id', 'i_e_d_e_transaction_id');
					}
					if (Schema::hasColumn('item_expense_details','inventory_id') && !DB::select(DB::raw("SHOW INDEXES FROM item_expense_details WHERE key_name='item_expense_details_inventory_id_index'"))) {
						$table->index('inventory_id');
					}
                    if (Schema::hasColumn('item_expense_details','loading_details_id') && !DB::select(DB::raw("SHOW INDEXES FROM item_expense_details WHERE key_name='i_e_d_l_details_id'"))) {
						$table->index('loading_details_id', 'i_e_d_l_details_id');
					}
					if (Schema::hasColumn('item_expense_details','type') && !DB::select(DB::raw("SHOW INDEXES FROM item_expense_details WHERE key_name='item_expense_details_type_index'"))) {
						$table->index('type');
					}	 
				});
			}





              // add indexs to loadings
              if(Schema::hasTable('loadings') ) {
				Schema::table('loadings', function (Blueprint $table) {
					if (Schema::hasColumn('loadings','type') && !DB::select(DB::raw("SHOW INDEXES FROM loadings WHERE key_name='loadings_type_index'"))) {
						$table->index('type');
					}
					if (Schema::hasColumn('loadings','type_id') && !DB::select(DB::raw("SHOW INDEXES FROM loadings WHERE key_name='loadings_type_id_index'"))) {
						$table->index('type_id');
					} 
				});
			}


            // add indexs to loading_details
            if(Schema::hasTable('loading_details') ) {
				Schema::table('loading_details', function (Blueprint $table) {
					if (Schema::hasColumn('loading_details','loading_id') && !DB::select(DB::raw("SHOW INDEXES FROM loading_details WHERE key_name='loading_details_loading_id_index'"))) {
						$table->index('loading_id');
					}
					if (Schema::hasColumn('loading_details','driver_id') && !DB::select(DB::raw("SHOW INDEXES FROM loading_details WHERE key_name='loading_details_driver_id_index'"))) {
						$table->index('driver_id');
					} 
                    if (Schema::hasColumn('loading_details','vehicle_id') && !DB::select(DB::raw("SHOW INDEXES FROM loading_details WHERE key_name='loading_details_vehicle_id_index'"))) {
						$table->index('vehicle_id');
					}
					if (Schema::hasColumn('loading_details','inventory_id') && !DB::select(DB::raw("SHOW INDEXES FROM loading_details WHERE key_name='loading_details_inventory_id_index'"))) {
						$table->index('inventory_id');
					} 
                    if (Schema::hasColumn('loading_details','site_id') && !DB::select(DB::raw("SHOW INDEXES FROM loading_details WHERE key_name='loading_details_site_id_index'"))) {
						$table->index('site_id');
					}
					if (Schema::hasColumn('loading_details','um_id') && !DB::select(DB::raw("SHOW INDEXES FROM loading_details WHERE key_name='loading_details_um_id_index'"))) {
						$table->index('um_id');
					} 
                    if (Schema::hasColumn('loading_details','loading_date') && !DB::select(DB::raw("SHOW INDEXES FROM loading_details WHERE key_name='loading_details_loading_date_index'"))) {
						$table->index('loading_date');
					} 
                    if (Schema::hasColumn('loading_details','currency') && !DB::select(DB::raw("SHOW INDEXES FROM loading_details WHERE key_name='loading_details_currency_index'"))) {
						$table->index('currency');
					}
					if (Schema::hasColumn('loading_details','vehicle_location_id') && !DB::select(DB::raw("SHOW INDEXES FROM loading_details WHERE key_name='loading_details_vehicle_location_id_index'"))) {
						$table->index('vehicle_location_id');
					} 
                    if (Schema::hasColumn('loading_details','income_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM loading_details WHERE key_name='l_d_i_transaction_id'"))) {
						$table->index('income_transaction_id', 'l_d_i_transaction_id');
					} 
                    if (Schema::hasColumn('loading_details','asset_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM loading_details WHERE key_name='loading_details_asset_transaction_id_index'"))) {
						$table->index('asset_transaction_id');
					} 
                    if (Schema::hasColumn('loading_details','type_id') && !DB::select(DB::raw("SHOW INDEXES FROM loading_details WHERE key_name='loading_details_type_id_index'"))) {
						$table->index('type_id');
					}
					if (Schema::hasColumn('loading_details','tanker_id') && !DB::select(DB::raw("SHOW INDEXES FROM loading_details WHERE key_name='loading_details_tanker_id_index'"))) {
						$table->index('tanker_id');
					}
                    if (Schema::hasColumn('loading_details','Purchase_info_id') && !DB::select(DB::raw("SHOW INDEXES FROM loading_details WHERE key_name='loading_details_Purchase_info_id_index'"))) {
						$table->index('Purchase_info_id');
					} 
                    if (Schema::hasColumn('loading_details','inventory_transfer_info_id') && !DB::select(DB::raw("SHOW INDEXES FROM loading_details WHERE key_name='l_d_i_t_info_id'"))) {
						$table->index('inventory_transfer_info_id', 'l_d_i_t_info_id');
					}
					if (Schema::hasColumn('loading_details','adjustment_id') && !DB::select(DB::raw("SHOW INDEXES FROM loading_details WHERE key_name='loading_details_adjustment_id_index'"))) {
						$table->index('adjustment_id');
					}
                    if (Schema::hasColumn('loading_details','over_load_id') && !DB::select(DB::raw("SHOW INDEXES FROM loading_details WHERE key_name='loading_details_over_load_id_index'"))) {
						$table->index('over_load_id');
					}
                    if (Schema::hasColumn('loading_details','contract_id') && !DB::select(DB::raw("SHOW INDEXES FROM loading_details WHERE key_name='loading_details_contract_id_index'"))) {
						$table->index('contract_id');
					} 
                    if (Schema::hasColumn('loading_details','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM loading_details WHERE key_name='loading_details_user_id_index'"))) {
						$table->index('user_id');
					}
					 
				});
			}




              // add indexs to loans
              if(Schema::hasTable('loans') ) {
				Schema::table('loans', function (Blueprint $table) {
					if (Schema::hasColumn('loans','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM loans WHERE key_name='loans_member_id_index'"))) {
						$table->index('member_id');
					}
					if (Schema::hasColumn('loans','account_id') && !DB::select(DB::raw("SHOW INDEXES FROM loans WHERE key_name='loans_account_id_index'"))) {
						$table->index('account_id');
					} 
                    if (Schema::hasColumn('loans','contract_id') && !DB::select(DB::raw("SHOW INDEXES FROM loans WHERE key_name='loans_contract_id_index'"))) {
						$table->index('contract_id');
					}
					if (Schema::hasColumn('loans','bank_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM loans WHERE key_name='loans_bank_transaction_index'"))) {
						$table->index('bank_transaction');
					} 
                    if (Schema::hasColumn('loans','loan_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM loans WHERE key_name='loans_loan_transaction_index'"))) {
						$table->index('loan_transaction');
					}
					if (Schema::hasColumn('loans','date') && !DB::select(DB::raw("SHOW INDEXES FROM loans WHERE key_name='loans_date_index'"))) {
						$table->index('date');
					} 
                    if (Schema::hasColumn('loans','type') && !DB::select(DB::raw("SHOW INDEXES FROM loans WHERE key_name='loans_type_index'"))) {
						$table->index('type');
					}  
                    if (Schema::hasColumn('loans','ref_no') && !DB::select(DB::raw("SHOW INDEXES FROM loans WHERE key_name='loans_ref_no_index'"))) {
						$table->index('ref_no');
					}
					if (Schema::hasColumn('loans','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM loans WHERE key_name='loans_company_id_index'"))) {
						$table->index('company_id');
					} 
                    if (Schema::hasColumn('loans','class_id') && !DB::select(DB::raw("SHOW INDEXES FROM loans WHERE key_name='loans_class_id_index'"))) {
						$table->index('class_id');
					}
					if (Schema::hasColumn('loans','branch_company_id') && !DB::select(DB::raw("SHOW INDEXES FROM loans WHERE key_name='loans_branch_company_id_index'"))) {
						$table->index('branch_company_id');
					} 
                    if (Schema::hasColumn('loans','expense_id') && !DB::select(DB::raw("SHOW INDEXES FROM loans WHERE key_name='loans_expense_id_index'"))) {
						$table->index('expense_id');
					}
					if (Schema::hasColumn('loans','bank_comm_tran_id') && !DB::select(DB::raw("SHOW INDEXES FROM loans WHERE key_name='loans_bank_comm_tran_id_index'"))) {
						$table->index('bank_comm_tran_id');
					} 
                    if (Schema::hasColumn('loans','expense_comm_tran_id') && !DB::select(DB::raw("SHOW INDEXES FROM loans WHERE key_name='loans_expense_comm_tran_id_index'"))) {
						$table->index('expense_comm_tran_id');
					} 
                   
				});
			}





             // add indexs to main_stocks
             if(Schema::hasTable('main_stocks') ) {
				Schema::table('main_stocks', function (Blueprint $table) {
					if (Schema::hasColumn('main_stocks','inventory_id') && !DB::select(DB::raw("SHOW INDEXES FROM main_stocks WHERE key_name='main_stocks_inventory_id_index'"))) {
						$table->index('inventory_id');
					}
					if (Schema::hasColumn('main_stocks','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM main_stocks WHERE key_name='main_stocks_user_id_index'"))) {
						$table->index('user_id');
					} 
                    if (Schema::hasColumn('main_stocks','inventory_site_id') && !DB::select(DB::raw("SHOW INDEXES FROM main_stocks WHERE key_name='main_stocks_inventory_site_id_index'"))) {
						$table->index('inventory_site_id');
					}
					if (Schema::hasColumn('main_stocks','purchase_id') && !DB::select(DB::raw("SHOW INDEXES FROM main_stocks WHERE key_name='main_stocks_purchase_id_index'"))) {
						$table->index('purchase_id');
					} 
                    if (Schema::hasColumn('main_stocks','vendor_id') && !DB::select(DB::raw("SHOW INDEXES FROM main_stocks WHERE key_name='main_stocks_vendor_id_index'"))) {
						$table->index('vendor_id');
					}
					if (Schema::hasColumn('main_stocks','purchase_um_id') && !DB::select(DB::raw("SHOW INDEXES FROM main_stocks WHERE key_name='main_stocks_purchase_um_id_index'"))) {
						$table->index('purchase_um_id');
					} 
                    if (Schema::hasColumn('main_stocks','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM main_stocks WHERE key_name='main_stocks_company_id_index'"))) {
						$table->index('company_id');
					}
					if (Schema::hasColumn('main_stocks','type_id') && !DB::select(DB::raw("SHOW INDEXES FROM main_stocks WHERE key_name='main_stocks_type_id_index'"))) {
						$table->index('type_id');
					} 
                    if (Schema::hasColumn('main_stocks','order_id') && !DB::select(DB::raw("SHOW INDEXES FROM main_stocks WHERE key_name='main_stocks_order_id_index'"))) {
						$table->index('order_id');
					}
				});
			}





		
             // add indexs to member_member_type
             if(Schema::hasTable('member_member_type')) {
				Schema::table('member_member_type', function (Blueprint $table) {
					if (Schema::hasColumn('member_member_type','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM member_member_type WHERE key_name='member_member_type_member_id_index'"))) {
						$table->index('member_id');
					}
					if (Schema::hasColumn('member_member_type','member_type_id') && !DB::select(DB::raw("SHOW INDEXES FROM member_member_type WHERE key_name='member_member_type_member_type_id_index'"))) {
						$table->index('member_type_id');
					}  
				});
			}



			// add indexs to m_stocks_in
			if(Schema::hasTable('m_stocks_in') ) {
				Schema::table('m_stocks_in', function (Blueprint $table) {
					if (Schema::hasColumn('m_stocks_in','main_stock_id') && !DB::select(DB::raw("SHOW INDEXES FROM m_stocks_in WHERE key_name='m_stocks_in_main_stock_id_index'"))) {
						$table->index('main_stock_id');
					}
					if (Schema::hasColumn('m_stocks_in','date_in') && !DB::select(DB::raw("SHOW INDEXES FROM m_stocks_in WHERE key_name='m_stocks_in_date_in_index'"))) {
						$table->index('date_in');
					}  

					if (Schema::hasColumn('m_stocks_in','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM m_stocks_in WHERE key_name='m_stocks_in_company_id_index'"))) {
						$table->index('company_id');
					}
					if (Schema::hasColumn('m_stocks_in','order_id') && !DB::select(DB::raw("SHOW INDEXES FROM m_stocks_in WHERE key_name='m_stocks_in_order_id_index'"))) {
						$table->index('order_id');
					} 
					if (Schema::hasColumn('m_stocks_in','brand_id') && !DB::select(DB::raw("SHOW INDEXES FROM m_stocks_in WHERE key_name='m_stocks_in_brand_id_index'"))) {
						$table->index('brand_id');
					}
					 
				});
			}




			// add indexs to m_stocks_out
			if(Schema::hasTable('m_stocks_out') ) {
				Schema::table('m_stocks_out', function (Blueprint $table) {
					if (Schema::hasColumn('m_stocks_out','stock_id') && !DB::select(DB::raw("SHOW INDEXES FROM m_stocks_out WHERE key_name='m_stocks_out_stock_id_index'"))) {
						$table->index('stock_id');
					}
					if (Schema::hasColumn('m_stocks_out','main_stock_id') && !DB::select(DB::raw("SHOW INDEXES FROM m_stocks_out WHERE key_name='m_stocks_out_main_stock_id_index'"))) {
						$table->index('main_stock_id');
					}  

					if (Schema::hasColumn('m_stocks_out','inventory_id') && !DB::select(DB::raw("SHOW INDEXES FROM m_stocks_out WHERE key_name='m_stocks_out_inventory_id_index'"))) {
						$table->index('inventory_id');
					}
					if (Schema::hasColumn('m_stocks_out','sale_id') && !DB::select(DB::raw("SHOW INDEXES FROM m_stocks_out WHERE key_name='m_stocks_out_sale_id_index'"))) {
						$table->index('sale_id');
					} 
					if (Schema::hasColumn('m_stocks_out','sale_um_id') && !DB::select(DB::raw("SHOW INDEXES FROM m_stocks_out WHERE key_name='m_stocks_out_sale_um_id_index'"))) {
						$table->index('sale_um_id');
					}
					if (Schema::hasColumn('m_stocks_out','customer_id') && !DB::select(DB::raw("SHOW INDEXES FROM m_stocks_out WHERE key_name='m_stocks_out_customer_id_index'"))) {
						$table->index('customer_id');
					}  

					if (Schema::hasColumn('m_stocks_out','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM m_stocks_out WHERE key_name='m_stocks_out_user_id_index'"))) {
						$table->index('user_id');
					}
					if (Schema::hasColumn('m_stocks_out','build_id') && !DB::select(DB::raw("SHOW INDEXES FROM m_stocks_out WHERE key_name='m_stocks_out_build_id_index'"))) {
						$table->index('build_id');
					} 
					if (Schema::hasColumn('m_stocks_out','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM m_stocks_out WHERE key_name='m_stocks_out_company_id_index'"))) {
						$table->index('company_id');
					}
					if (Schema::hasColumn('m_stocks_out','type_id') && !DB::select(DB::raw("SHOW INDEXES FROM m_stocks_out WHERE key_name='m_stocks_out_type_id_index'"))) {
						$table->index('type_id');
					} 
				});
			}





			
             // add indexs to members
             if(Schema::hasTable('members') ) {
				Schema::table('members', function (Blueprint $table) {
					if (Schema::hasColumn('members','payable_id') && !DB::select(DB::raw("SHOW INDEXES FROM members WHERE key_name='members_payable_id_index'"))) {
						$table->index('payable_id');
					}
					if (Schema::hasColumn('members','receivable_id') && !DB::select(DB::raw("SHOW INDEXES FROM members WHERE key_name='members_receivable_id_index'"))) {
						$table->index('receivable_id');
					} 
                    if (Schema::hasColumn('members','name') && !DB::select(DB::raw("SHOW INDEXES FROM members WHERE key_name='members_name_index'"))) {
						$table->index('name');
					}
					if (Schema::hasColumn('members','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM members WHERE key_name='members_company_id_index'"))) {
						$table->index('company_id');
					} 
                    if (Schema::hasColumn('members','payroll_price_level_id') && !DB::select(DB::raw("SHOW INDEXES FROM members WHERE key_name='members_payroll_price_level_id_index'"))) {
						$table->index('payroll_price_level_id');
					}
					if (Schema::hasColumn('members','ss_id') && !DB::select(DB::raw("SHOW INDEXES FROM members WHERE key_name='members_ss_id_index'"))) {
						$table->index('ss_id');
					} 
                    if (Schema::hasColumn('members','price_level_id') && !DB::select(DB::raw("SHOW INDEXES FROM members WHERE key_name='members_price_level_id_index'"))) {
						$table->index('price_level_id');
					}
					if (Schema::hasColumn('members','ref_no') && !DB::select(DB::raw("SHOW INDEXES FROM members WHERE key_name='members_ref_no_index'"))) {
						$table->index('ref_no');
					} 
                    if (Schema::hasColumn('members','employee_attendance_class_id') && !DB::select(DB::raw("SHOW INDEXES FROM members WHERE key_name='m_e_a_class_id'"))) {
						$table->index('employee_attendance_class_id', 'm_e_a_class_id');
					}
					if (Schema::hasColumn('members','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM members WHERE key_name='members_user_id_index'"))) {
						$table->index('user_id');
					} 
                    if (Schema::hasColumn('members','parent_id') && !DB::select(DB::raw("SHOW INDEXES FROM members WHERE key_name='members_parent_id_index'"))) {
						$table->index('parent_id');
					}
					if (Schema::hasColumn('members','shift_id') && !DB::select(DB::raw("SHOW INDEXES FROM members WHERE key_name='members_shift_id_index'"))) {
						$table->index('shift_id');
					} 
				});
			}





             // add indexs to measure_units
             if(Schema::hasTable('measure_units') ) {
				Schema::table('measure_units', function (Blueprint $table) {
					if (Schema::hasColumn('measure_units','quantity_id') && !DB::select(DB::raw("SHOW INDEXES FROM measure_units WHERE key_name='measure_units_quantity_id_index'"))) {
						$table->index('quantity_id');
					}
					if (Schema::hasColumn('measure_units','name') && !DB::select(DB::raw("SHOW INDEXES FROM measure_units WHERE key_name='measure_units_name_index'"))) {
						$table->index('name');
					} 
                    if (Schema::hasColumn('measure_units','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM measure_units WHERE key_name='measure_units_company_id_index'"))) {
						$table->index('company_id');
					}
				});
			}





			// add indexs to payments
			if(Schema::hasTable('payments') ) {
				Schema::table('payments', function (Blueprint $table) {
					if (Schema::hasColumn('payments','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM payments WHERE key_name='payments_member_id_index'"))) {
						$table->index('member_id');
					}
					if (Schema::hasColumn('payments','type') && !DB::select(DB::raw("SHOW INDEXES FROM payments WHERE key_name='payments_type_index'"))) {
						$table->index('type');
					}  
					if (Schema::hasColumn('payments','ref_no') && !DB::select(DB::raw("SHOW INDEXES FROM payments WHERE key_name='payments_ref_no_index'"))) {
						$table->index('ref_no');
					} 
					if (Schema::hasColumn('payments','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM payments WHERE key_name='payments_company_id_index'"))) {
						$table->index('company_id');
					}

					if (Schema::hasColumn('payments','class_id') && !DB::select(DB::raw("SHOW INDEXES FROM payments WHERE key_name='payments_class_id_index'"))) {
						$table->index('class_id');
					}
					if (Schema::hasColumn('payments','expense_id') && !DB::select(DB::raw("SHOW INDEXES FROM payments WHERE key_name='payments_expense_id_index'"))) {
						$table->index('expense_id');
					} 
					if (Schema::hasColumn('payments','bank_comm_tran_id') && !DB::select(DB::raw("SHOW INDEXES FROM payments WHERE key_name='payments_bank_comm_tran_id_index'"))) {
						$table->index('bank_comm_tran_id');
					}

					if (Schema::hasColumn('payments','expense_comm_tran_id') && !DB::select(DB::raw("SHOW INDEXES FROM payments WHERE key_name='p_e_c_tran_id'"))) {
						$table->index('expense_comm_tran_id', 'p_e_c_tran_id');
					}
					if (Schema::hasColumn('payments','contract_farmer_id') && !DB::select(DB::raw("SHOW INDEXES FROM payments WHERE key_name='payments_contract_farmer_id_index'"))) {
						$table->index('contract_farmer_id');
					} 
					if (Schema::hasColumn('payments','to_company_id') && !DB::select(DB::raw("SHOW INDEXES FROM payments WHERE key_name='payments_to_company_id_index'"))) {
						$table->index('to_company_id');
					}
					if (Schema::hasColumn('payments','order_pay_id') && !DB::select(DB::raw("SHOW INDEXES FROM payments WHERE key_name='payments_order_pay_id_index'"))) {
						$table->index('order_pay_id');
					} 
					if (Schema::hasColumn('payments','carpet_contract_id') && !DB::select(DB::raw("SHOW INDEXES FROM payments WHERE key_name='payments_carpet_contract_id_index'"))) {
						$table->index('carpet_contract_id');
					}
					 
				});
			}





			
			// add indexs to payrolls
			if(Schema::hasTable('payrolls') ) {
			Schema::table('payrolls', function (Blueprint $table) {
				if (Schema::hasColumn('payrolls','employee_id') && !DB::select(DB::raw("SHOW INDEXES FROM payrolls WHERE key_name='payrolls_employee_id_index'"))) {
					$table->index('employee_id');
				}
				if (Schema::hasColumn('payrolls','salary_id') && !DB::select(DB::raw("SHOW INDEXES FROM payrolls WHERE key_name='payrolls_salary_id_index'"))) {
					$table->index('salary_id');
				} 
				if (Schema::hasColumn('payrolls','expense_id') && !DB::select(DB::raw("SHOW INDEXES FROM payrolls WHERE key_name='payrolls_expense_id_index'"))) {
					$table->index('expense_id');
				}
				if (Schema::hasColumn('payrolls','type') && !DB::select(DB::raw("SHOW INDEXES FROM payrolls WHERE key_name='payrolls_type_index'"))) {
					$table->index('type');
				}
				if (Schema::hasColumn('payrolls','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM payrolls WHERE key_name='payrolls_company_id_index'"))) {
					$table->index('company_id');
				} 
				if (Schema::hasColumn('payrolls','number') && !DB::select(DB::raw("SHOW INDEXES FROM payrolls WHERE key_name='payrolls_number_index'"))) {
					$table->index('number');
				}
				if (Schema::hasColumn('payrolls','date') && !DB::select(DB::raw("SHOW INDEXES FROM payrolls WHERE key_name='payrolls_date_index'"))) {
					$table->index('date');
				}
				if (Schema::hasColumn('payrolls','project_id') && !DB::select(DB::raw("SHOW INDEXES FROM payrolls WHERE key_name='payrolls_project_id_index'"))) {
					$table->index('project_id');
				} 
				if (Schema::hasColumn('payrolls','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM payrolls WHERE key_name='payrolls_user_id_index'"))) {
					$table->index('user_id');
				}
				if (Schema::hasColumn('payrolls','ngo_project_id') && !DB::select(DB::raw("SHOW INDEXES FROM payrolls WHERE key_name='payrolls_ngo_project_id_index'"))) {
					$table->index('ngo_project_id');
				}
				if (Schema::hasColumn('payrolls','carpet_contract_id') && !DB::select(DB::raw("SHOW INDEXES FROM payrolls WHERE key_name='payrolls_carpet_contract_id_index'"))) {
					$table->index('carpet_contract_id');
				}
			});
		}
		

		  // add indexs to permissions
		  if(Schema::hasTable('permissions') ) {
				Schema::table('permissions', function (Blueprint $table) {
					if (Schema::hasColumn('permissions','name') && !DB::select(DB::raw("SHOW INDEXES FROM permissions WHERE key_name='permissions_name_index'"))) {
						$table->index('name');
					}
				});
			}


			// add indexs to permission_role
			if(Schema::hasTable('permission_role')  ) {
				Schema::table('permission_role', function (Blueprint $table) {
					if (Schema::hasColumn('permission_role','permission_id') && !DB::select(DB::raw("SHOW INDEXES FROM permission_role WHERE key_name='permission_role_permission_id_index'"))) {
						$table->index('permission_id');
					}
					if (Schema::hasColumn('permission_role','role_id') && !DB::select(DB::raw("SHOW INDEXES FROM permission_role WHERE key_name='permission_role_role_id_index'"))) {
						$table->index('role_id');
					} 
				});
			}


			
			// add indexs to position
			if(Schema::hasTable('position') ) {
				Schema::table('position', function (Blueprint $table) {
					if (Schema::hasColumn('position','name') && !DB::select(DB::raw("SHOW INDEXES FROM position WHERE key_name='position_name_index'"))) {
						$table->index('name');
					}
					if (Schema::hasColumn('position','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM position WHERE key_name='position_user_id_index'"))) {
						$table->index('user_id');
					} 
					if (Schema::hasColumn('position','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM position WHERE key_name='position_company_id_index'"))) {
						$table->index('company_id');
					} 
				});
			}



			// add indexs to purchases
			if(Schema::hasTable('purchases')  ) {
				Schema::table('purchases', function (Blueprint $table) {
					if (Schema::hasColumn('purchases','number') && !DB::select(DB::raw("SHOW INDEXES FROM purchases WHERE key_name='purchases_number_index'"))) {
						$table->index('number');
					}
					if (Schema::hasColumn('purchases','vendor_id') && !DB::select(DB::raw("SHOW INDEXES FROM purchases WHERE key_name='purchases_vendor_id_index'"))) {
						$table->index('vendor_id');
					} 
					if (Schema::hasColumn('purchases','transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM purchases WHERE key_name='purchases_transaction_id_index'"))) {
						$table->index('transaction_id');
					} 
					if (Schema::hasColumn('purchases','date') && !DB::select(DB::raw("SHOW INDEXES FROM purchases WHERE key_name='purchases_date_index'"))) {
						$table->index('date');
					} 
					if (Schema::hasColumn('purchases','class_id') && !DB::select(DB::raw("SHOW INDEXES FROM purchases WHERE key_name='purchases_class_id_index'"))) {
						$table->index('class_id');
					} 
					if (Schema::hasColumn('purchases','ref_no') && !DB::select(DB::raw("SHOW INDEXES FROM purchases WHERE key_name='purchases_ref_no_index'"))) {
						$table->index('ref_no');
					} 
					if (Schema::hasColumn('purchases','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM purchases WHERE key_name='purchases_company_id_index'"))) {
						$table->index('company_id');
					} 
					if (Schema::hasColumn('purchases','order_id') && !DB::select(DB::raw("SHOW INDEXES FROM purchases WHERE key_name='purchases_order_id_index'"))) {
						$table->index('order_id');
					} 
				});
			}


			

			// add indexs to receivable_payments
			if(Schema::hasTable('receivable_payments')  ) {
				Schema::table('receivable_payments', function (Blueprint $table) {
					if (Schema::hasColumn('receivable_payments','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM receivable_payments WHERE key_name='receivable_payments_member_id_index'"))) {
						$table->index('member_id');
					}
					if (Schema::hasColumn('receivable_payments','bank_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM receivable_payments WHERE key_name='receivable_payments_bank_transaction_index'"))) {
						$table->index('bank_transaction');
					} 
					if (Schema::hasColumn('receivable_payments','project_id') && !DB::select(DB::raw("SHOW INDEXES FROM receivable_payments WHERE key_name='receivable_payments_project_id_index'"))) {
						$table->index('project_id');
					} 
					if (Schema::hasColumn('receivable_payments','discount_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM receivable_payments WHERE key_name='r_p_d_transaction'"))) {
						$table->index('discount_transaction', 'r_p_d_transaction');
					} 
					if (Schema::hasColumn('receivable_payments','ref_no') && !DB::select(DB::raw("SHOW INDEXES FROM receivable_payments WHERE key_name='receivable_payments_ref_no_index'"))) {
						$table->index('ref_no');
					} 
					if (Schema::hasColumn('receivable_payments','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM receivable_payments WHERE key_name='receivable_payments_company_id_index'"))) {
						$table->index('company_id');
					} 
					if (Schema::hasColumn('receivable_payments','class_id') && !DB::select(DB::raw("SHOW INDEXES FROM receivable_payments WHERE key_name='receivable_payments_class_id_index'"))) {
						$table->index('class_id');
					} 
					if (Schema::hasColumn('receivable_payments','vehicle_m_id') && !DB::select(DB::raw("SHOW INDEXES FROM receivable_payments WHERE key_name='receivable_payments_vehicle_m_id_index'"))) {
						$table->index('vehicle_m_id');
					} 
					if (Schema::hasColumn('receivable_payments','contract_farmer_id') && !DB::select(DB::raw("SHOW INDEXES FROM receivable_payments WHERE key_name='receivable_payments_contract_farmer_id_index'"))) {
						$table->index('contract_farmer_id');
					}
				});
			}



		
			// add indexs to receive_by_factors
			if(Schema::hasTable('receive_by_factors')  ) {
				Schema::table('receive_by_factors', function (Blueprint $table) {
					if (Schema::hasColumn('receive_by_factors','ref_no') && !DB::select(DB::raw("SHOW INDEXES FROM receive_by_factors WHERE key_name='receive_by_factors_ref_no_index'"))) {
						$table->index('ref_no');
					}
					if (Schema::hasColumn('receive_by_factors','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM receive_by_factors WHERE key_name='receive_by_factors_member_id_index'"))) {
						$table->index('member_id');
					} 
					if (Schema::hasColumn('receive_by_factors','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM receive_by_factors WHERE key_name='receive_by_factors_company_id_index'"))) {
						$table->index('company_id');
					}if (Schema::hasColumn('receive_by_factors','account_id') && !DB::select(DB::raw("SHOW INDEXES FROM receive_by_factors WHERE key_name='receive_by_factors_account_id_index'"))) {
						$table->index('account_id');
					}
					if (Schema::hasColumn('receive_by_factors','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM receive_by_factors WHERE key_name='receive_by_factors_user_id_index'"))) {
						$table->index('user_id');
					}  
				});
			}




			// add indexs to receive_by_factor_details
			if(Schema::hasTable('receive_by_factor_details') ) {
				Schema::table('receive_by_factor_details', function (Blueprint $table) {
					if (Schema::hasColumn('receive_by_factor_details','receive_by_factor_id') && !DB::select(DB::raw("SHOW INDEXES FROM receive_by_factor_details WHERE key_name='r_b_f_d_r_b_factor_id'"))) {
						$table->index('receive_by_factor_id', 'r_b_f_d_r_b_factor_id');
					}
					if (Schema::hasColumn('receive_by_factor_details','sale_receive_id') && !DB::select(DB::raw("SHOW INDEXES FROM receive_by_factor_details WHERE key_name='r_b_f_d_s_receive_id'"))) {
						$table->index('sale_receive_id', 'r_b_f_d_s_receive_id');
					} 
					if (Schema::hasColumn('receive_by_factor_details','gain_or_loss_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM receive_by_factor_details WHERE key_name='r_b_f_d_g_l_transaction_if'"))) {
						$table->index('gain_or_loss_transaction_id', 'r_b_f_d_g_l_transaction_if');
					}if (Schema::hasColumn('receive_by_factor_details','gl_receivable_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM receive_by_factor_details WHERE key_name='r_f_d_gr_transaction_id'"))) {
						$table->index('gl_receivable_transaction_id', 'r_f_d_gr_transaction_id');
					}
					if (Schema::hasColumn('receive_by_factor_details','receivable_payments_id') && !DB::select(DB::raw("SHOW INDEXES FROM receive_by_factor_details WHERE key_name='rfc_r_payment_id'"))) {
						$table->index('receivable_payments_id', 'rfc_r_payment_id');
					}  
				});
			}



			



			// add indexs to purchase_discounts
			if(Schema::hasTable('purchase_discounts') ) {
				Schema::table('purchase_discounts', function (Blueprint $table) {
					if (Schema::hasColumn('purchase_discounts','purchase_id') && !DB::select(DB::raw("SHOW INDEXES FROM purchase_discounts WHERE key_name='purchase_discounts_purchase_id_index'"))) {
						$table->index('purchase_id');
					}
					if (Schema::hasColumn('purchase_discounts','income_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM purchase_discounts WHERE key_name='purchase_discounts_income_transaction_index'"))) {
						$table->index('income_transaction');
					} 
					if (Schema::hasColumn('purchase_discounts','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM purchase_discounts WHERE key_name='purchase_discounts_company_id_index'"))) {
						$table->index('company_id');
					} 
				});
			}



			// add indexs to purchase_infos
			if(Schema::hasTable('purchase_infos') ) {
				Schema::table('purchase_infos', function (Blueprint $table) {
					if (Schema::hasColumn('purchase_infos','inventory_id') && !DB::select(DB::raw("SHOW INDEXES FROM purchase_infos WHERE key_name='purchase_infos_inventory_id_index'"))) {
						$table->index('inventory_id');
					}
					if (Schema::hasColumn('purchase_infos','site_id') && !DB::select(DB::raw("SHOW INDEXES FROM purchase_infos WHERE key_name='purchase_infos_site_id_index'"))) {
						$table->index('site_id');
					} 
					if (Schema::hasColumn('purchase_infos','um_id') && !DB::select(DB::raw("SHOW INDEXES FROM purchase_infos WHERE key_name='purchase_infos_um_id_index'"))) {
						$table->index('um_id');
					} 
					if (Schema::hasColumn('purchase_infos','purchase_id') && !DB::select(DB::raw("SHOW INDEXES FROM purchase_infos WHERE key_name='purchase_infos_purchase_id_index'"))) {
						$table->index('purchase_id');
					} 
					if (Schema::hasColumn('purchase_infos','inventory_category_id') && !DB::select(DB::raw("SHOW INDEXES FROM purchase_infos WHERE key_name='purchase_infos_inventory_category_id_index'"))) {
						$table->index('inventory_category_id');
					} 

					if (Schema::hasColumn('purchase_infos','purchase_order_detail_id') && !DB::select(DB::raw("SHOW INDEXES FROM purchase_infos WHERE key_name='purchase_infos_purchase_order_detail_id_index'"))) {
						$table->index('purchase_order_detail_id');
					} 
					if (Schema::hasColumn('purchase_infos','contract_detail_id') && !DB::select(DB::raw("SHOW INDEXES FROM purchase_infos WHERE key_name='purchase_infos_contract_detail_id_index'"))) {
						$table->index('contract_detail_id');
					} 
					if (Schema::hasColumn('purchase_infos','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM purchase_infos WHERE key_name='purchase_infos_company_id_index'"))) {
						$table->index('company_id');
					} 
					if (Schema::hasColumn('purchase_infos','order_id') && !DB::select(DB::raw("SHOW INDEXES FROM purchase_infos WHERE key_name='purchase_infos_order_id_index'"))) {
						$table->index('order_id');
					} 

					if (Schema::hasColumn('purchase_infos','um1_id') && !DB::select(DB::raw("SHOW INDEXES FROM purchase_infos WHERE key_name='purchase_infos_um1_id_index'"))) {
						$table->index('um1_id');
					} 
					if (Schema::hasColumn('purchase_infos','um2_id') && !DB::select(DB::raw("SHOW INDEXES FROM purchase_infos WHERE key_name='purchase_infos_um2_id_index'"))) {
						$table->index('um2_id');
					} 

					if (Schema::hasColumn('purchase_infos','um3_id') && !DB::select(DB::raw("SHOW INDEXES FROM purchase_infos WHERE key_name='purchase_infos_um3_id_index'"))) {
						$table->index('um3_id');
					} 
					if (Schema::hasColumn('purchase_infos','inventory_brand_id') && !DB::select(DB::raw("SHOW INDEXES FROM purchase_infos WHERE key_name='purchase_infos_inventory_brand_id_index'"))) {
						$table->index('inventory_brand_id');
					}
				});
			}

 

			// add indexs to purchase_discounts
			if(Schema::hasTable('purchase_orders') ) {
				Schema::table('purchase_orders', function (Blueprint $table) {
					if (Schema::hasColumn('purchase_orders','vendor_id') && !DB::select(DB::raw("SHOW INDEXES FROM purchase_orders WHERE key_name='purchase_orders_vendor_id_index'"))) {
						$table->index('vendor_id');
					}
					if (Schema::hasColumn('purchase_orders','currency') && !DB::select(DB::raw("SHOW INDEXES FROM purchase_orders WHERE key_name='purchase_orders_currency_index'"))) {
						$table->index('currency');
					} 
					if (Schema::hasColumn('purchase_orders','date') && !DB::select(DB::raw("SHOW INDEXES FROM purchase_orders WHERE key_name='purchase_orders_date_index'"))) {
						$table->index('date');
					} 

					if (Schema::hasColumn('purchase_orders','type') && !DB::select(DB::raw("SHOW INDEXES FROM purchase_orders WHERE key_name='purchase_orders_type_index'"))) {
						$table->index('type');
					}
					if (Schema::hasColumn('purchase_orders','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM purchase_orders WHERE key_name='purchase_orders_company_id_index'"))) {
						$table->index('company_id');
					} 
				});
			}




			// add indexs to purchase_order_details
			if(Schema::hasTable('purchase_order_details') ) {
				Schema::table('purchase_order_details', function (Blueprint $table) {
					if (Schema::hasColumn('purchase_order_details','purchase_order_id') && !DB::select(DB::raw("SHOW INDEXES FROM purchase_order_details WHERE key_name='purchase_order_details_purchase_order_id_index'"))) {
						$table->index('purchase_order_id');
					}
					if (Schema::hasColumn('purchase_order_details','inventory_id') && !DB::select(DB::raw("SHOW INDEXES FROM purchase_order_details WHERE key_name='purchase_order_details_inventory_id_index'"))) {
						$table->index('inventory_id');
					} 
					if (Schema::hasColumn('purchase_order_details','site_id') && !DB::select(DB::raw("SHOW INDEXES FROM purchase_order_details WHERE key_name='purchase_order_details_site_id_index'"))) {
						$table->index('site_id');
					} 

					if (Schema::hasColumn('purchase_order_details','um_id') && !DB::select(DB::raw("SHOW INDEXES FROM purchase_order_details WHERE key_name='purchase_order_details_um_id_index'"))) {
						$table->index('um_id');
					}
					if (Schema::hasColumn('purchase_order_details','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM purchase_order_details WHERE key_name='purchase_order_details_user_id_index'"))) {
						$table->index('user_id');
					} 
					if (Schema::hasColumn('purchase_order_details','inventory_category_id') && !DB::select(DB::raw("SHOW INDEXES FROM purchase_order_details WHERE key_name='purchase_order_details_inventory_category_id_index'"))) {
						$table->index('inventory_category_id');
					}
					if (Schema::hasColumn('purchase_order_details','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM purchase_order_details WHERE key_name='purchase_order_details_company_id_index'"))) {
						$table->index('company_id');
					} 
				});
			}



			
			// add indexs to purchase_order_payments
			if(Schema::hasTable('purchase_order_payments')) {
				Schema::table('purchase_order_payments', function (Blueprint $table) {
					if (Schema::hasColumn('purchase_order_payments','purchase_order_id') && !DB::select(DB::raw("SHOW INDEXES FROM purchase_order_payments WHERE key_name='purchase_order_payments_purchase_order_id_index'"))) {
						$table->index('purchase_order_id');
					}
					if (Schema::hasColumn('purchase_order_payments','payment_id') && !DB::select(DB::raw("SHOW INDEXES FROM purchase_order_payments WHERE key_name='purchase_order_payments_payment_id_index'"))) {
						$table->index('payment_id');
					}  
				});
			}



			// add indexs to purchase_order_records
			if(Schema::hasTable('purchase_order_records')) {
				Schema::table('purchase_order_records', function (Blueprint $table) {
					if (Schema::hasColumn('purchase_order_records','purchase_order_id') && !DB::select(DB::raw("SHOW INDEXES FROM purchase_order_records WHERE key_name='purchase_order_records_purchase_order_id_index'"))) {
						$table->index('purchase_order_id');
					}
					if (Schema::hasColumn('purchase_order_records','stock_out_id') && !DB::select(DB::raw("SHOW INDEXES FROM purchase_order_records WHERE key_name='purchase_order_records_stock_out_id_index'"))) {
						$table->index('stock_out_id');
					}  
					if (Schema::hasColumn('purchase_order_records','purchase_order_detail_id') && !DB::select(DB::raw("SHOW INDEXES FROM purchase_order_records WHERE key_name='purchase_order_records_purchase_order_detail_id_index'"))) {
						$table->index('purchase_order_detail_id');
					}
					if (Schema::hasColumn('purchase_order_records','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM purchase_order_records WHERE key_name='purchase_order_records_company_id_index'"))) {
						$table->index('company_id');
					}  
				});
			}


			// add indexs to purchase_payments
			if(Schema::hasTable('purchase_payments')) {
				Schema::table('purchase_payments', function (Blueprint $table) {
					if (Schema::hasColumn('purchase_payments','purchase_id') && !DB::select(DB::raw("SHOW INDEXES FROM purchase_payments WHERE key_name='purchase_payments_purchase_id_index'"))) {
						$table->index('purchase_id');
					}
					if (Schema::hasColumn('purchase_payments','payment_id') && !DB::select(DB::raw("SHOW INDEXES FROM purchase_payments WHERE key_name='purchase_payments_payment_id_index'"))) {
						$table->index('payment_id');
					} 
				});
			}


			// add indexs to purchase_transactions
			if(Schema::hasTable('purchase_transactions') ) {
				Schema::table('purchase_transactions', function (Blueprint $table) {
					if (Schema::hasColumn('purchase_transactions','purchase_id') && !DB::select(DB::raw("SHOW INDEXES FROM purchase_transactions WHERE key_name='purchase_transactions_purchase_id_index'"))) {
						$table->index('purchase_id');
					}
					if (Schema::hasColumn('purchase_transactions','transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM purchase_transactions WHERE key_name='purchase_transactions_transaction_id_index'"))) {
						$table->index('transaction_id');
					} 
				});
			}


			// add indexs to roles
			if(Schema::hasTable('roles')) {
				Schema::table('roles', function (Blueprint $table) {
					if (Schema::hasColumn('roles','name') && !DB::select(DB::raw("SHOW INDEXES FROM roles WHERE key_name='roles_name_index'"))) {
						$table->index('name');
					}
				});
			}



			// add indexs to role_user
			if(Schema::hasTable('role_user')) {
				Schema::table('role_user', function (Blueprint $table) {
					if (Schema::hasColumn('role_user','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM role_user WHERE key_name='role_user_user_id_index'"))) {
						$table->index('user_id');
					}
					if (Schema::hasColumn('role_user','role_id') && !DB::select(DB::raw("SHOW INDEXES FROM role_user WHERE key_name='role_user_role_id_index'"))) {
						$table->index('role_id');
					}
				});
			}



			// add indexs to sales
			if(Schema::hasTable('sales')) {
				Schema::table('sales', function (Blueprint $table) {
					if (Schema::hasColumn('sales','number') && !DB::select(DB::raw("SHOW INDEXES FROM sales WHERE key_name='sales_number_index'"))) {
						$table->index('number');
					}
					if (Schema::hasColumn('sales','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM sales WHERE key_name='sales_member_id_index'"))) {
						$table->index('member_id');
					}
					if (Schema::hasColumn('sales','transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM sales WHERE key_name='sales_transaction_id_index'"))) {
						$table->index('transaction_id');
					}
					if (Schema::hasColumn('sales','date') && !DB::select(DB::raw("SHOW INDEXES FROM sales WHERE key_name='sales_date_index'"))) {
						$table->index('date');
					}
					if (Schema::hasColumn('sales','type') && !DB::select(DB::raw("SHOW INDEXES FROM sales WHERE key_name='sales_type_index'"))) {
						$table->index('type');
					}
					if (Schema::hasColumn('sales','discount_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM sales WHERE key_name='sales_discount_transaction_index'"))) {
						$table->index('discount_transaction');
					}

					if (Schema::hasColumn('sales','class_id') && !DB::select(DB::raw("SHOW INDEXES FROM sales WHERE key_name='sales_class_id_index'"))) {
						$table->index('class_id');
					}
					if (Schema::hasColumn('sales','sale_area_id') && !DB::select(DB::raw("SHOW INDEXES FROM sales WHERE key_name='sales_sale_area_id_index'"))) {
						$table->index('sale_area_id');
					}
					if (Schema::hasColumn('sales','ref_no') && !DB::select(DB::raw("SHOW INDEXES FROM sales WHERE key_name='sales_ref_no_index'"))) {
						$table->index('ref_no');
					}
					if (Schema::hasColumn('sales','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM sales WHERE key_name='sales_company_id_index'"))) {
						$table->index('company_id');
					}

					if (Schema::hasColumn('sales','driver_id') && !DB::select(DB::raw("SHOW INDEXES FROM sales WHERE key_name='sales_driver_id_index'"))) {
						$table->index('driver_id');
					}
					if (Schema::hasColumn('sales','taxation_id') && !DB::select(DB::raw("SHOW INDEXES FROM sales WHERE key_name='sales_taxation_id_index'"))) {
						$table->index('taxation_id');
					}
					if (Schema::hasColumn('sales','taxation_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM sales WHERE key_name='sales_taxation_transaction_index'"))) {
						$table->index('taxation_transaction');
					}
					if (Schema::hasColumn('sales','price_level_id') && !DB::select(DB::raw("SHOW INDEXES FROM sales WHERE key_name='sales_price_level_id_index'"))) {
						$table->index('price_level_id');
					}

					if (Schema::hasColumn('sales','sale_discount_id') && !DB::select(DB::raw("SHOW INDEXES FROM sales WHERE key_name='sales_sale_discount_id_index'"))) {
						$table->index('sale_discount_id');
					}
					if (Schema::hasColumn('sales','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM sales WHERE key_name='sales_user_id_index'"))) {
						$table->index('user_id');
					}
					if (Schema::hasColumn('sales','member_cloth_id') && !DB::select(DB::raw("SHOW INDEXES FROM sales WHERE key_name='sales_member_cloth_id_index'"))) {
						$table->index('member_cloth_id');
					}
					if (Schema::hasColumn('sales','commission_id') && !DB::select(DB::raw("SHOW INDEXES FROM sales WHERE key_name='sales_commission_id_index'"))) {
						$table->index('commission_id');
					}

					if (Schema::hasColumn('sales','oil_part_id') && !DB::select(DB::raw("SHOW INDEXES FROM sales WHERE key_name='sales_oil_part_id_index'"))) {
						$table->index('oil_part_id');
					}
				});

			}




			

			// add indexs to sales_orders
			if(Schema::hasTable('sales_orders')) {
				Schema::table('sales_orders', function (Blueprint $table) {
					if (Schema::hasColumn('sales_orders','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM sales_orders WHERE key_name='sales_orders_member_id_index'"))) {
						$table->index('member_id');
					}
					if (Schema::hasColumn('sales_orders','currency') && !DB::select(DB::raw("SHOW INDEXES FROM sales_orders WHERE key_name='sales_orders_currency_index'"))) {
						$table->index('currency');
					}
					if (Schema::hasColumn('sales_orders','delivery_date') && !DB::select(DB::raw("SHOW INDEXES FROM sales_orders WHERE key_name='sales_orders_delivery_date_index'"))) {
						$table->index('delivery_date');
					}
					if (Schema::hasColumn('sales_orders','sale_area_id') && !DB::select(DB::raw("SHOW INDEXES FROM sales_orders WHERE key_name='sales_orders_sale_area_id_index'"))) {
						$table->index('sale_area_id');
					}
					if (Schema::hasColumn('sales_orders','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM sales_orders WHERE key_name='sales_orders_company_id_index'"))) {
						$table->index('company_id');
					}
					if (Schema::hasColumn('sales_orders','class_id') && !DB::select(DB::raw("SHOW INDEXES FROM sales_orders WHERE key_name='sales_orders_class_id_index'"))) {
						$table->index('class_id');
					}
					if (Schema::hasColumn('sales_orders','account_id') && !DB::select(DB::raw("SHOW INDEXES FROM sales_orders WHERE key_name='sales_orders_account_id_index'"))) {
						$table->index('account_id');
					}
					if (Schema::hasColumn('sales_orders','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM sales_orders WHERE key_name='sales_orders_user_id_index'"))) {
						$table->index('user_id');
					}
					if (Schema::hasColumn('sales_orders','price_level_id') && !DB::select(DB::raw("SHOW INDEXES FROM sales_orders WHERE key_name='sales_orders_price_level_id_index'"))) {
						$table->index('price_level_id');
					}
				});
			}




			

			// add indexs to sale_infos
			if(Schema::hasTable('sale_infos') ) {
				Schema::table('sale_infos', function (Blueprint $table) {
					if (Schema::hasColumn('sale_infos','inventory_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_infos WHERE key_name='sale_infos_inventory_id_index'"))) {
						$table->index('inventory_id');
					}
					if (Schema::hasColumn('sale_infos','site_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_infos WHERE key_name='sale_infos_site_id_index'"))) {
						$table->index('site_id');
					}
					if (Schema::hasColumn('sale_infos','um_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_infos WHERE key_name='sale_infos_um_id_index'"))) {
						$table->index('um_id');
					}
					if (Schema::hasColumn('sale_infos','sale_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_infos WHERE key_name='sale_infos_sale_id_index'"))) {
						$table->index('sale_id');
					}
					if (Schema::hasColumn('sale_infos','stock_out_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_infos WHERE key_name='sale_infos_stock_out_id_index'"))) {
						$table->index('stock_out_id');
					}
					if (Schema::hasColumn('sale_infos','inventory_category_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_infos WHERE key_name='sale_infos_inventory_category_id_index'"))) {
						$table->index('inventory_category_id');
					}
					if (Schema::hasColumn('sale_infos','contract_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_infos WHERE key_name='sale_infos_contract_id_index'"))) {
						$table->index('contract_id');
					}
					if (Schema::hasColumn('sale_infos','sale_order_detail_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_infos WHERE key_name='sale_infos_sale_order_detail_id_index'"))) {
						$table->index('sale_order_detail_id');
					}
					if (Schema::hasColumn('sale_infos','um1_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_infos WHERE key_name='sale_infos_um1_id_index'"))) {
						$table->index('um1_id');
					}
					if (Schema::hasColumn('sale_infos','um2_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_infos WHERE key_name='sale_infos_um2_id_index'"))) {
						$table->index('um2_id');
					}

					if (Schema::hasColumn('sale_infos','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_infos WHERE key_name='sale_infos_company_id_index'"))) {
						$table->index('company_id');
					}
					if (Schema::hasColumn('sale_infos','m_stock_out_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_infos WHERE key_name='sale_infos_m_stock_out_id_index'"))) {
						$table->index('m_stock_out_id');
					}
					if (Schema::hasColumn('sale_infos','um3_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_infos WHERE key_name='sale_infos_um3_id_index'"))) {
						$table->index('um3_id');
					}
					if (Schema::hasColumn('sale_infos','loading_detail_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_infos WHERE key_name='sale_infos_loading_detail_id_index'"))) {
						$table->index('loading_detail_id');
					}
					if (Schema::hasColumn('sale_infos','row_taxation_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_infos WHERE key_name='sale_infos_row_taxation_id_index'"))) {
						$table->index('row_taxation_id');
					}
					if (Schema::hasColumn('sale_infos','price_level_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_infos WHERE key_name='sale_infos_price_level_id_index'"))) {
						$table->index('price_level_id');
					}if (Schema::hasColumn('sale_infos','driver_name') && !DB::select(DB::raw("SHOW INDEXES FROM sale_infos WHERE key_name='sale_infos_driver_name_index'"))) {
						$table->index('driver_name');
					}
					if (Schema::hasColumn('sale_infos','online_order_detail_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_infos WHERE key_name='sale_infos_online_order_detail_id_index'"))) {
						$table->index('online_order_detail_id');
					}
					if (Schema::hasColumn('sale_infos','inventory_brand_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_infos WHERE key_name='sale_infos_inventory_brand_id_index'"))) {
						$table->index('inventory_brand_id');
					}
					if (Schema::hasColumn('sale_infos','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_infos WHERE key_name='sale_infos_user_id_index'"))) {
						$table->index('user_id');
					}
				});
			}


 
			// add indexs to sale_items
			if(Schema::hasTable('sale_items')) {
				Schema::table('sale_items', function (Blueprint $table) {
					if (Schema::hasColumn('sale_items','item_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_items WHERE key_name='sale_items_item_id_index'"))) {
						$table->index('item_id');
					}
					if (Schema::hasColumn('sale_items','customer_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_items WHERE key_name='sale_items_customer_id_index'"))) {
						$table->index('customer_id');
					} 
				});
			}


			// add indexs to sale_order_receives
			if(Schema::hasTable('sale_order_receives')) {
				Schema::table('sale_order_receives', function (Blueprint $table) {
					if (Schema::hasColumn('sale_order_receives','sale_order_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_order_receives WHERE key_name='sale_order_receives_sale_order_id_index'"))) {
						$table->index('sale_order_id');
					}
					if (Schema::hasColumn('sale_order_receives','receivable_payment_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_order_receives WHERE key_name='sale_order_receives_receivable_payment_id_index'"))) {
						$table->index('receivable_payment_id');
					} if (Schema::hasColumn('sale_order_receives','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_order_receives WHERE key_name='sale_order_receives_company_id_index'"))) {
						$table->index('company_id');
					} 
				});
			}


			// add indexs to sale_order_services
			if(Schema::hasTable('sale_order_services') ) {
				Schema::table('sale_order_services', function (Blueprint $table) {
					if (Schema::hasColumn('sale_order_services','sale_order_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_order_services WHERE key_name='sale_order_services_sale_order_id_index'"))) {
						$table->index('sale_order_id');
					}
					if (Schema::hasColumn('sale_order_services','item_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_order_services WHERE key_name='sale_order_services_item_id_index'"))) {
						$table->index('item_id');
					} if (Schema::hasColumn('sale_order_services','um_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_order_services WHERE key_name='sale_order_services_um_id_index'"))) {
						$table->index('um_id');
					}  
					if (Schema::hasColumn('sale_order_services','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_order_services WHERE key_name='sale_order_services_company_id_index'"))) {
						$table->index('company_id');
					} 
				});
			}



			// add indexs to sale_payments
			if(Schema::hasTable('sale_payments')) {
				Schema::table('sale_payments', function (Blueprint $table) {
					if (Schema::hasColumn('sale_payments','sale_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_payments WHERE key_name='sale_payments_sale_id_index'"))) {
						$table->index('sale_id');
					}
					if (Schema::hasColumn('sale_payments','currency') && !DB::select(DB::raw("SHOW INDEXES FROM sale_payments WHERE key_name='sale_payments_currency_index'"))) {
						$table->index('currency');
					} 
				});
			}

			// add indexs to sale_receives
			if(Schema::hasTable('sale_receives')) {
				Schema::table('sale_receives', function (Blueprint $table) {
					if (Schema::hasColumn('sale_receives','sale_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_receives WHERE key_name='sale_receives_sale_id_index'"))) {
						$table->index('sale_id');
					}
					if (Schema::hasColumn('sale_receives','receivable_payment_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_receives WHERE key_name='sale_receives_receivable_payment_id_index'"))) {
						$table->index('receivable_payment_id');
					} 
					if (Schema::hasColumn('sale_receives','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_receives WHERE key_name='sale_receives_company_id_index'"))) {
						$table->index('company_id');
					} 
				});
			}



			// add indexs to sale_services
			if(Schema::hasTable('sale_services')) {
				Schema::table('sale_services', function (Blueprint $table) {
					if (Schema::hasColumn('sale_services','sale_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_services WHERE key_name='sale_services_sale_id_index'"))) {
						$table->index('sale_id');
					}
					if (Schema::hasColumn('sale_services','item_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_services WHERE key_name='sale_services_item_id_index'"))) {
						$table->index('item_id');
					} 
					if (Schema::hasColumn('sale_services','sale_um_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_services WHERE key_name='sale_services_sale_um_id_index'"))) {
						$table->index('sale_um_id');
					} 

					if (Schema::hasColumn('sale_services','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_services WHERE key_name='sale_services_company_id_index'"))) {
						$table->index('company_id');
					}
					if (Schema::hasColumn('sale_services','online_order_detail_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_services WHERE key_name='sale_services_online_order_detail_id_index'"))) {
						$table->index('online_order_detail_id');
					} 
					if (Schema::hasColumn('sale_services','order_detail_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_services WHERE key_name='sale_services_order_detail_id_index'"))) {
						$table->index('order_detail_id');
					} 
					if (Schema::hasColumn('sale_services','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_services WHERE key_name='sale_services_user_id_index'"))) {
						$table->index('user_id');
					} 
					if (Schema::hasColumn('sale_services','contract_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_services WHERE key_name='sale_services_contract_id_index'"))) {
						$table->index('contract_id');
					} 
				});
			}




			
			// add indexs to sale_taxations
			if(Schema::hasTable('sale_taxations')) {
				Schema::table('sale_taxations', function (Blueprint $table) {
					if (Schema::hasColumn('sale_taxations','taxation_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_taxations WHERE key_name='sale_taxations_taxation_id_index'"))) {
						$table->index('taxation_id');
					}
					if (Schema::hasColumn('sale_taxations','sale_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_taxations WHERE key_name='sale_taxations_sale_id_index'"))) {
						$table->index('sale_id');
					} 
					if (Schema::hasColumn('sale_taxations','sale_info_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_taxations WHERE key_name='sale_taxations_sale_info_id_index'"))) {
						$table->index('sale_info_id');
					} 

					if (Schema::hasColumn('sale_taxations','vendor_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_taxations WHERE key_name='sale_taxations_vendor_id_index'"))) {
						$table->index('vendor_id');
					}
					if (Schema::hasColumn('sale_taxations','vendor_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_taxations WHERE key_name='sale_taxations_vendor_transaction_id_index'"))) {
						$table->index('vendor_transaction_id');
					} 
					if (Schema::hasColumn('sale_taxations','customer_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_taxations WHERE key_name='sale_taxations_customer_id_index'"))) {
						$table->index('customer_id');
					} 
					if (Schema::hasColumn('sale_taxations','customer_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_taxations WHERE key_name='sale_taxations_customer_transaction_id_index'"))) {
						$table->index('customer_transaction_id');
					} 
				});
			}




				// add indexs to sale_transactions
				if(Schema::hasTable('sale_transactions')) {
				Schema::table('sale_transactions', function (Blueprint $table) {
					if (Schema::hasColumn('sale_transactions','sale_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_transactions WHERE key_name='sale_transactions_sale_id_index'"))) {
						$table->index('sale_id');
					}
					if (Schema::hasColumn('sale_transactions','inventory_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_transactions WHERE key_name='sale_transactions_inventory_id_index'"))) {
						$table->index('inventory_id');
					} 
					if (Schema::hasColumn('sale_transactions','income_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM sale_transactions WHERE key_name='sale_transactions_income_transaction_index'"))) {
						$table->index('income_transaction');
					} 

					if (Schema::hasColumn('sale_transactions','cost_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM sale_transactions WHERE key_name='sale_transactions_cost_transaction_index'"))) {
						$table->index('cost_transaction');
					}
					if (Schema::hasColumn('sale_transactions','asset_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM sale_transactions WHERE key_name='sale_transactions_asset_transaction_index'"))) {
						$table->index('asset_transaction');
					} 
					if (Schema::hasColumn('sale_transactions','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_transactions WHERE key_name='sale_transactions_company_id_index'"))) {
						$table->index('company_id');
					}  
				});
			}





			// add indexs to sale_transfer_rents
			if(Schema::hasTable('sale_transfer_rents')) {
				Schema::table('sale_transfer_rents', function (Blueprint $table) {
					if (Schema::hasColumn('sale_transfer_rents','sale_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_transfer_rents WHERE key_name='sale_transfer_rents_sale_id_index'"))) {
						$table->index('sale_id');
					}
					if (Schema::hasColumn('sale_transfer_rents','receivable_member_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_transfer_rents WHERE key_name='sale_transfer_rents_receivable_member_id_index'"))) {
						$table->index('receivable_member_id');
					} 
					if (Schema::hasColumn('sale_transfer_rents','payable_member_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_transfer_rents WHERE key_name='sale_transfer_rents_payable_member_id_index'"))) {
						$table->index('payable_member_id');
					} 

					if (Schema::hasColumn('sale_transfer_rents','receivable_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM sale_transfer_rents WHERE key_name='sale_transfer_rents_receivable_transaction_index'"))) {
						$table->index('receivable_transaction');
					}
					if (Schema::hasColumn('sale_transfer_rents','payable_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM sale_transfer_rents WHERE key_name='sale_transfer_rents_payable_transaction_index'"))) {
						$table->index('payable_transaction');
					} 
					if (Schema::hasColumn('sale_transfer_rents','bank_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM sale_transfer_rents WHERE key_name='sale_transfer_rents_bank_transaction_index'"))) {
						$table->index('bank_transaction');
					}  

					if (Schema::hasColumn('sale_transfer_rents','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_transfer_rents WHERE key_name='sale_transfer_rents_user_id_index'"))) {
						$table->index('user_id');
					} 
					if (Schema::hasColumn('sale_transfer_rents','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM sale_transfer_rents WHERE key_name='sale_transfer_rents_company_id_index'"))) {
						$table->index('company_id');
					}
				});
			}







			// add indexs to stocks
			if(Schema::hasTable('stocks')) {
				Schema::table('stocks', function (Blueprint $table) {
					if (Schema::hasColumn('stocks','inventory_id') && !DB::select(DB::raw("SHOW INDEXES FROM stocks WHERE key_name='stocks_inventory_id_index'"))) {
						$table->index('inventory_id');
					}
					if (Schema::hasColumn('stocks','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM stocks WHERE key_name='stocks_user_id_index'"))) {
						$table->index('user_id');
					} 
					if (Schema::hasColumn('stocks','payable_member_id') && !DB::select(DB::raw("SHOW INDEXES FROM stocks WHERE key_name='stocks_payable_member_id_index'"))) {
						$table->index('payable_member_id');
					} 

					if (Schema::hasColumn('stocks','inventory_site_id') && !DB::select(DB::raw("SHOW INDEXES FROM stocks WHERE key_name='stocks_inventory_site_id_index'"))) {
						$table->index('inventory_site_id');
					}
					if (Schema::hasColumn('stocks','purchase_id') && !DB::select(DB::raw("SHOW INDEXES FROM stocks WHERE key_name='stocks_purchase_id_index'"))) {
						$table->index('purchase_id');
					} 
					if (Schema::hasColumn('stocks','vendor_id') && !DB::select(DB::raw("SHOW INDEXES FROM stocks WHERE key_name='stocks_vendor_id_index'"))) {
						$table->index('vendor_id');
					}  

					if (Schema::hasColumn('stocks','date_in') && !DB::select(DB::raw("SHOW INDEXES FROM stocks WHERE key_name='stocks_date_in_index'"))) {
						$table->index('date_in');
					} 
					if (Schema::hasColumn('stocks','qut_in') && !DB::select(DB::raw("SHOW INDEXES FROM stocks WHERE key_name='stocks_qut_in_index'"))) {
						$table->index('qut_in');
					}


					if (Schema::hasColumn('stocks','cost') && !DB::select(DB::raw("SHOW INDEXES FROM stocks WHERE key_name='stocks_cost_index'"))) {
						$table->index('cost');
					}
					if (Schema::hasColumn('stocks','status') && !DB::select(DB::raw("SHOW INDEXES FROM stocks WHERE key_name='stocks_status_index'"))) {
						$table->index('status');
					} 
					if (Schema::hasColumn('stocks','expire_date') && !DB::select(DB::raw("SHOW INDEXES FROM stocks WHERE key_name='stocks_expire_date_index'"))) {
						$table->index('expire_date');
					}  

					if (Schema::hasColumn('stocks','other_measure') && !DB::select(DB::raw("SHOW INDEXES FROM stocks WHERE key_name='stocks_other_measure_index'"))) {
						$table->index('other_measure');
					} 
					if (Schema::hasColumn('stocks','purchase_um_id') && !DB::select(DB::raw("SHOW INDEXES FROM stocks WHERE key_name='stocks_purchase_um_id_index'"))) {
						$table->index('purchase_um_id');
					}


                    if (Schema::hasColumn('stocks','expense_cost') && !DB::select(DB::raw("SHOW INDEXES FROM stocks WHERE key_name='stocks_expense_cost_index'"))) {
						$table->index('expense_cost');
					}
					
                    if (Schema::hasColumn('stocks','contract_id') && !DB::select(DB::raw("SHOW INDEXES FROM stocks WHERE key_name='stocks_contract_id_index'"))) {
						$table->index('contract_id');
					}
					
                    if (Schema::hasColumn('stocks','other_measure2') && !DB::select(DB::raw("SHOW INDEXES FROM stocks WHERE key_name='stocks_other_measure2_index'"))) {
						$table->index('other_measure2');
					}
					
                    if (Schema::hasColumn('stocks','type') && !DB::select(DB::raw("SHOW INDEXES FROM stocks WHERE key_name='stocks_type_index'"))) {
						$table->index('type');
					}
                    if (Schema::hasColumn('stocks','type_id') && !DB::select(DB::raw("SHOW INDEXES FROM stocks WHERE key_name='stocks_type_id_index'"))) {
						$table->index('type_id');
					}
                    if (Schema::hasColumn('stocks','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM stocks WHERE key_name='stocks_company_id_index'"))) {
						$table->index('company_id');
					}
                    if (Schema::hasColumn('stocks','purchase_info_id') && !DB::select(DB::raw("SHOW INDEXES FROM stocks WHERE key_name='stocks_purchase_info_id_index'"))) {
						$table->index('purchase_info_id');
					}
					


                    if (Schema::hasColumn('stocks','wagon_number') && !DB::select(DB::raw("SHOW INDEXES FROM stocks WHERE key_name='stocks_wagon_number_index'"))) {
						$table->index('wagon_number');
					}
					
                    if (Schema::hasColumn('stocks','per_qty') && !DB::select(DB::raw("SHOW INDEXES FROM stocks WHERE key_name='stocks_per_qty_index'"))) {
						$table->index('per_qty');
					}
					
                    if (Schema::hasColumn('stocks','per_qty2') && !DB::select(DB::raw("SHOW INDEXES FROM stocks WHERE key_name='stocks_per_qty2_index'"))) {
						$table->index('per_qty2');
					}

                    if (Schema::hasColumn('stocks','location') && !DB::select(DB::raw("SHOW INDEXES FROM stocks WHERE key_name='stocks_location_index'"))) {
						$table->index('location');
					}
					
				});
			}





			// add indexs to stock_outs
			if(Schema::hasTable('stock_outs')) {
				Schema::table('stock_outs', function (Blueprint $table) {
					if (Schema::hasColumn('stock_outs','stock_id') && !DB::select(DB::raw("SHOW INDEXES FROM stock_outs WHERE key_name='stock_outs_stock_id_index'"))) {
						$table->index('stock_id');
					}
					if (Schema::hasColumn('stock_outs','sale_id') && !DB::select(DB::raw("SHOW INDEXES FROM stock_outs WHERE key_name='stock_outs_sale_id_index'"))) {
						$table->index('sale_id');
					} 
					if (Schema::hasColumn('stock_outs','sale_um_id') && !DB::select(DB::raw("SHOW INDEXES FROM stock_outs WHERE key_name='stock_outs_sale_um_id_index'"))) {
						$table->index('sale_um_id');
					} 

					if (Schema::hasColumn('stock_outs','inventory_id') && !DB::select(DB::raw("SHOW INDEXES FROM stock_outs WHERE key_name='stock_outs_inventory_id_index'"))) {
						$table->index('inventory_id');
					}
					if (Schema::hasColumn('stock_outs','customer_id') && !DB::select(DB::raw("SHOW INDEXES FROM stock_outs WHERE key_name='stock_outs_customer_id_index'"))) {
						$table->index('customer_id');
					} 
					if (Schema::hasColumn('stock_outs','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM stock_outs WHERE key_name='stock_outs_user_id_index'"))) {
						$table->index('user_id');
					} if (Schema::hasColumn('stock_outs','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM stock_outs WHERE key_name='stock_outs_company_id_index'"))) {
						$table->index('company_id');
					}
					if (Schema::hasColumn('stock_outs','type_id') && !DB::select(DB::raw("SHOW INDEXES FROM stock_outs WHERE key_name='stock_outs_type_id_index'"))) {
						$table->index('type_id');
					} 
					if (Schema::hasColumn('stock_outs','sale_info_id') && !DB::select(DB::raw("SHOW INDEXES FROM stock_outs WHERE key_name='stock_outs_sale_info_id_index'"))) {
						$table->index('sale_info_id');
					}  
					if (Schema::hasColumn('stock_outs','loading_detail_id') && !DB::select(DB::raw("SHOW INDEXES FROM stock_outs WHERE key_name='stock_outs_loading_detail_id_index'"))) {
						$table->index('loading_detail_id');
					}  
				});
			}





			
			// add indexs to transactions
			if(Schema::hasTable('transactions')) {
				Schema::table('transactions', function (Blueprint $table) {
					if (Schema::hasColumn('transactions','account_id') && !DB::select(DB::raw("SHOW INDEXES FROM transactions WHERE key_name='transactions_account_id_index'"))) {
						$table->index('account_id');
					}
					if (Schema::hasColumn('transactions','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM transactions WHERE key_name='transactions_user_id_index'"))) {
						$table->index('user_id');
					} 
					if (Schema::hasColumn('transactions','date') && !DB::select(DB::raw("SHOW INDEXES FROM transactions WHERE key_name='transactions_date_index'"))) {
						$table->index('date');
					} 

					if (Schema::hasColumn('transactions','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM transactions WHERE key_name='transactions_company_id_index'"))) {
						$table->index('company_id');
					}
					if (Schema::hasColumn('transactions','class_id') && !DB::select(DB::raw("SHOW INDEXES FROM transactions WHERE key_name='transactions_class_id_index'"))) {
						$table->index('class_id');
					} 
					if (Schema::hasColumn('transactions','unit') && !DB::select(DB::raw("SHOW INDEXES FROM transactions WHERE key_name='transactions_unit_index'"))) {
						$table->index('unit');
					} if (Schema::hasColumn('transactions','remark_fa') && !DB::select(DB::raw("SHOW INDEXES FROM transactions WHERE key_name='transactions_remark_fa_index'"))) {
						$table->index('remark_fa');
					}
					if (Schema::hasColumn('transactions','remark_en') && !DB::select(DB::raw("SHOW INDEXES FROM transactions WHERE key_name='transactions_remark_en_index'"))) {
						$table->index('remark_en');
					} 
					if (Schema::hasColumn('transactions','page_route') && !DB::select(DB::raw("SHOW INDEXES FROM transactions WHERE key_name='transactions_page_route_index'"))) {
						$table->index('page_route');
					}  
					if (Schema::hasColumn('transactions','checkout') && !DB::select(DB::raw("SHOW INDEXES FROM transactions WHERE key_name='transactions_checkout_index'"))) {
						$table->index('checkout');
					}  
				});
			}




			// add indexs to vehicles
			if(Schema::hasTable('vehicles')) {
				Schema::table('vehicles', function (Blueprint $table) {
					if (Schema::hasColumn('vehicles','vehicle_type_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicles WHERE key_name='vehicles_vehicle_type_id_index'"))) {
						$table->index('vehicle_type_id');
					}
					if (Schema::hasColumn('vehicles','palet_number') && !DB::select(DB::raw("SHOW INDEXES FROM vehicles WHERE key_name='vehicles_palet_number_index'"))) {
						$table->index('palet_number');
					} 
					if (Schema::hasColumn('vehicles','tanker_number') && !DB::select(DB::raw("SHOW INDEXES FROM vehicles WHERE key_name='vehicles_tanker_number_index'"))) {
						$table->index('tanker_number');
					} 

					if (Schema::hasColumn('vehicles','expense_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicles WHERE key_name='vehicles_expense_id_index'"))) {
						$table->index('expense_id');
					}
					if (Schema::hasColumn('vehicles','income_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicles WHERE key_name='vehicles_income_id_index'"))) {
						$table->index('income_id');
					} 
					if (Schema::hasColumn('vehicles','phone') && !DB::select(DB::raw("SHOW INDEXES FROM vehicles WHERE key_name='vehicles_phone_index'"))) {
						$table->index('phone');
					} if (Schema::hasColumn('vehicles','chassis_number') && !DB::select(DB::raw("SHOW INDEXES FROM vehicles WHERE key_name='vehicles_chassis_number_index'"))) {
						$table->index('chassis_number');
					}
					if (Schema::hasColumn('vehicles','engine_number') && !DB::select(DB::raw("SHOW INDEXES FROM vehicles WHERE key_name='vehicles_engine_number_index'"))) {
						$table->index('engine_number');
					} 
					if (Schema::hasColumn('vehicles','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicles WHERE key_name='vehicles_user_id_index'"))) {
						$table->index('user_id');
					}  
					if (Schema::hasColumn('vehicles','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicles WHERE key_name='vehicles_company_id_index'"))) {
						$table->index('company_id');
					}  

					if (Schema::hasColumn('vehicles','driver_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicles WHERE key_name='vehicles_driver_id_index'"))) {
						$table->index('driver_id');
					} 
					if (Schema::hasColumn('vehicles','currency') && !DB::select(DB::raw("SHOW INDEXES FROM vehicles WHERE key_name='vehicles_currency_index'"))) {
						$table->index('currency');
					}  
					if (Schema::hasColumn('vehicles','equity_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicles WHERE key_name='vehicles_equity_id_index'"))) {
						$table->index('equity_id');
					} 
					if (Schema::hasColumn('vehicles','income_tran_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicles WHERE key_name='vehicles_income_tran_id_index'"))) {
						$table->index('income_tran_id');
					} 
					if (Schema::hasColumn('vehicles','asset_tran_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicles WHERE key_name='vehicles_asset_tran_id_index'"))) {
						$table->index('asset_tran_id');
					}  
					if (Schema::hasColumn('vehicles','main_driver_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicles WHERE key_name='vehicles_main_driver_id_index'"))) {
						$table->index('main_driver_id');
					}if (Schema::hasColumn('vehicles','vehicle_category_id') && !DB::select(DB::raw("SHOW INDEXES FROM vehicles WHERE key_name='vehicles_vehicle_category_id_index'"))) {
						$table->index('vehicle_category_id');
					}  
				});
			}





			
			// add indexs to users
			if(Schema::hasTable('users')) {
				Schema::table('users', function (Blueprint $table) {
					if (Schema::hasColumn('users','name') && !DB::select(DB::raw("SHOW INDEXES FROM users WHERE key_name='users_name_index'"))) {
						$table->index('name');
					}
					if (Schema::hasColumn('users','lockout_time') && !DB::select(DB::raw("SHOW INDEXES FROM users WHERE key_name='users_lockout_time_index'"))) {
						$table->index('lockout_time');
					} 
					if (Schema::hasColumn('users','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM users WHERE key_name='users_company_id_index'"))) {
						$table->index('company_id');
					} 

					if (Schema::hasColumn('users','photo') && !DB::select(DB::raw("SHOW INDEXES FROM users WHERE key_name='users_photo_index'"))) {
						$table->index('photo');
					}
					if (Schema::hasColumn('users','position_id') && !DB::select(DB::raw("SHOW INDEXES FROM users WHERE key_name='users_position_id_index'"))) {
						$table->index('position_id');
					}   
				});
			}








			// add indexs to add_stocks
			if(Schema::hasTable('add_stocks')) {
				Schema::table('add_stocks', function (Blueprint $table) {
					if (Schema::hasColumn('add_stocks','number') && !DB::select(DB::raw("SHOW INDEXES FROM add_stocks WHERE key_name='add_stocks_number_index'"))) {
						$table->index('number');
					}
					if (Schema::hasColumn('add_stocks','date') && !DB::select(DB::raw("SHOW INDEXES FROM add_stocks WHERE key_name='add_stocks_date_index'"))) {
						$table->index('date');
					} 
					if (Schema::hasColumn('add_stocks','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM add_stocks WHERE key_name='add_stocks_company_id_index'"))) {
						$table->index('company_id');
					} 

					if (Schema::hasColumn('add_stocks','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM add_stocks WHERE key_name='add_stocks_user_id_index'"))) {
						$table->index('user_id');
					}   
				});
			}



			// add indexs to add_stock_details
			if(Schema::hasTable('add_stock_details')) {
				Schema::table('add_stock_details', function (Blueprint $table) {
					if (Schema::hasColumn('add_stock_details','add_stock_id') && !DB::select(DB::raw("SHOW INDEXES FROM add_stock_details WHERE key_name='add_stock_details_add_stock_id_index'"))) {
						$table->index('add_stock_id');
					}
					if (Schema::hasColumn('add_stock_details','inventory_id') && !DB::select(DB::raw("SHOW INDEXES FROM add_stock_details WHERE key_name='add_stock_details_inventory_id_index'"))) {
						$table->index('inventory_id');
					} 
					if (Schema::hasColumn('add_stock_details','quantity') && !DB::select(DB::raw("SHOW INDEXES FROM add_stock_details WHERE key_name='add_stock_details_quantity_index'"))) {
						$table->index('quantity');
					} 

					if (Schema::hasColumn('add_stock_details','stock_id') && !DB::select(DB::raw("SHOW INDEXES FROM add_stock_details WHERE key_name='add_stock_details_stock_id_index'"))) {
						$table->index('stock_id');
					}  
					
					if (Schema::hasColumn('add_stock_details','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM add_stock_details WHERE key_name='add_stock_details_company_id_index'"))) {
						$table->index('company_id');
					} 

					if (Schema::hasColumn('add_stock_details','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM add_stock_details WHERE key_name='add_stock_details_user_id_index'"))) {
						$table->index('user_id');
					} 
					if (Schema::hasColumn('add_stock_details','other_measure') && !DB::select(DB::raw("SHOW INDEXES FROM add_stock_details WHERE key_name='add_stock_details_other_measure_index'"))) {
						$table->index('other_measure');
					} 

					if (Schema::hasColumn('add_stock_details','other_measure2') && !DB::select(DB::raw("SHOW INDEXES FROM add_stock_details WHERE key_name='add_stock_details_other_measure2_index'"))) {
						$table->index('other_measure2');
					} 
				});
			}




			// add indexs to advance_pricings
			if(Schema::hasTable('advance_pricings')) {
				Schema::table('advance_pricings', function (Blueprint $table) {
					if (Schema::hasColumn('advance_pricings','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM advance_pricings WHERE key_name='advance_pricings_user_id_index'"))) {
						$table->index('user_id');
					}
					if (Schema::hasColumn('advance_pricings','inventory_category_id') && !DB::select(DB::raw("SHOW INDEXES FROM advance_pricings WHERE key_name='advance_pricings_inventory_category_id_index'"))) {
						$table->index('inventory_category_id');
					} 
					if (Schema::hasColumn('advance_pricings','amount') && !DB::select(DB::raw("SHOW INDEXES FROM advance_pricings WHERE key_name='advance_pricings_amount_index'"))) {
						$table->index('amount');
					} 

					if (Schema::hasColumn('advance_pricings','type') && !DB::select(DB::raw("SHOW INDEXES FROM advance_pricings WHERE key_name='advance_pricings_type_index'"))) {
						$table->index('type');
					}  
					
					if (Schema::hasColumn('advance_pricings','date') && !DB::select(DB::raw("SHOW INDEXES FROM advance_pricings WHERE key_name='advance_pricings_date_index'"))) {
						$table->index('date');
					} 

					if (Schema::hasColumn('advance_pricings','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM advance_pricings WHERE key_name='advance_pricings_company_id_index'"))) {
						$table->index('company_id');
					} 
					 
				});
			}
  

			// add indexs to advance_pricing_details
			if(Schema::hasTable('advance_pricing_details')) {
				Schema::table('advance_pricing_details', function (Blueprint $table) {
					if (Schema::hasColumn('advance_pricing_details','advance_pricing_id') && !DB::select(DB::raw("SHOW INDEXES FROM advance_pricing_details WHERE key_name='advance_pricing_details_advance_pricing_id_index'"))) {
						$table->index('advance_pricing_id');
					}
					if (Schema::hasColumn('advance_pricing_details','item_id') && !DB::select(DB::raw("SHOW INDEXES FROM advance_pricing_details WHERE key_name='advance_pricing_details_item_id_index'"))) {
						$table->index('item_id');
					} 
					if (Schema::hasColumn('advance_pricing_details','amount') && !DB::select(DB::raw("SHOW INDEXES FROM advance_pricing_details WHERE key_name='advance_pricing_details_amount_index'"))) {
						$table->index('amount');
					} 

					if (Schema::hasColumn('advance_pricing_details','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM advance_pricing_details WHERE key_name='advance_pricing_details_company_id_index'"))) {
						$table->index('company_id');
					}   
				});
			}



			// add indexs to assemblies
			if(Schema::hasTable('assemblies')) {
				Schema::table('assemblies', function (Blueprint $table) {
					if (Schema::hasColumn('assemblies','item_id') && !DB::select(DB::raw("SHOW INDEXES FROM assemblies WHERE key_name='assemblies_item_id_index'"))) {
						$table->index('item_id');
					}
					if (Schema::hasColumn('assemblies','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM assemblies WHERE key_name='assemblies_user_id_index'"))) {
						$table->index('user_id');
					} 
					if (Schema::hasColumn('assemblies','name') && !DB::select(DB::raw("SHOW INDEXES FROM assemblies WHERE key_name='assemblies_name_index'"))) {
						$table->index('name');
					} 

					if (Schema::hasColumn('assemblies','date') && !DB::select(DB::raw("SHOW INDEXES FROM assemblies WHERE key_name='assemblies_date_index'"))) {
						$table->index('date');
					}  
					if (Schema::hasColumn('assemblies','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM assemblies WHERE key_name='assemblies_company_id_index'"))) {
						$table->index('company_id');
					}   
				});
			}



			
			// add indexs to assembly_expenses
			if(Schema::hasTable('assembly_expenses')) {
				Schema::table('assembly_expenses', function (Blueprint $table) {
					if (Schema::hasColumn('assembly_expenses','assembly_id') && !DB::select(DB::raw("SHOW INDEXES FROM assembly_expenses WHERE key_name='assembly_expenses_assembly_id_index'"))) {
						$table->index('assembly_id');
					}
					if (Schema::hasColumn('assembly_expenses','account_id') && !DB::select(DB::raw("SHOW INDEXES FROM assembly_expenses WHERE key_name='assembly_expenses_account_id_index'"))) {
						$table->index('account_id');
					} 
					if (Schema::hasColumn('assembly_expenses','amount') && !DB::select(DB::raw("SHOW INDEXES FROM assembly_expenses WHERE key_name='assembly_expenses_amount_index'"))) {
						$table->index('amount');
					} 

					if (Schema::hasColumn('assembly_expenses','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM assembly_expenses WHERE key_name='assembly_expenses_company_id_index'"))) {
						$table->index('company_id');
					}  
					   
				});
			}






			// add indexs to attendances
			if(Schema::hasTable('attendances')) {
				Schema::table('attendances', function (Blueprint $table) {
					if (Schema::hasColumn('attendances','date') && !DB::select(DB::raw("SHOW INDEXES FROM attendances WHERE key_name='attendances_date_index'"))) {
						$table->index('date');
					}
					if (Schema::hasColumn('attendances','number') && !DB::select(DB::raw("SHOW INDEXES FROM attendances WHERE key_name='attendances_number_index'"))) {
						$table->index('number');
					} 
					if (Schema::hasColumn('attendances','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM attendances WHERE key_name='attendances_company_id_index'"))) {
						$table->index('company_id');
					} 

					if (Schema::hasColumn('attendances','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM attendances WHERE key_name='attendances_user_id_index'"))) {
						$table->index('user_id');
					}  
					
					if (Schema::hasColumn('attendances','employee_attendance_class_id') && !DB::select(DB::raw("SHOW INDEXES FROM attendances WHERE key_name='attendances_employee_attendance_class_id_index'"))) {
						$table->index('employee_attendance_class_id');
					}  

				});
			}




			// add indexs to attendance_sheets
			if(Schema::hasTable('attendance_sheets')) {
				Schema::table('attendance_sheets', function (Blueprint $table) {
					if (Schema::hasColumn('attendance_sheets','employee_id') && !DB::select(DB::raw("SHOW INDEXES FROM attendance_sheets WHERE key_name='attendance_sheets_employee_id_index'"))) {
						$table->index('employee_id');
					}
					if (Schema::hasColumn('attendance_sheets','attendance_id') && !DB::select(DB::raw("SHOW INDEXES FROM attendance_sheets WHERE key_name='attendance_sheets_attendance_id_index'"))) {
						$table->index('attendance_id');
					} 
					if (Schema::hasColumn('attendance_sheets','date') && !DB::select(DB::raw("SHOW INDEXES FROM attendance_sheets WHERE key_name='attendance_sheets_date_index'"))) {
						$table->index('date');
					} 

					if (Schema::hasColumn('attendance_sheets','leave_id') && !DB::select(DB::raw("SHOW INDEXES FROM attendance_sheets WHERE key_name='attendance_sheets_leave_id_index'"))) {
						$table->index('leave_id');
					}  
					
					if (Schema::hasColumn('attendance_sheets','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM attendance_sheets WHERE key_name='attendance_sheets_company_id_index'"))) {
						$table->index('company_id');
					}  


					if (Schema::hasColumn('attendance_sheets','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM attendance_sheets WHERE key_name='attendance_sheets_user_id_index'"))) {
						$table->index('user_id');
					} 

					if (Schema::hasColumn('attendance_sheets','rent') && !DB::select(DB::raw("SHOW INDEXES FROM attendance_sheets WHERE key_name='attendance_sheets_rent_index'"))) {
						$table->index('rent');
					}  
					
					if (Schema::hasColumn('attendance_sheets','overtime_qty') && !DB::select(DB::raw("SHOW INDEXES FROM attendance_sheets WHERE key_name='attendance_sheets_overtime_qty_index'"))) {
						$table->index('overtime_qty');
					}  
				});
			}
	




			// add indexs to audits
			if(Schema::hasTable('audits')) {
				Schema::table('audits', function (Blueprint $table) {
					if (Schema::hasColumn('audits','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM audits WHERE key_name='audits_user_id_index'"))) {
						$table->index('user_id');
					}
					if (Schema::hasColumn('audits','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM audits WHERE key_name='audits_company_id_index'"))) {
						$table->index('company_id');
					}   
				});
			}



			// add indexs to bank_check
			if(Schema::hasTable('bank_check')) {
				Schema::table('bank_check', function (Blueprint $table) {
					if (Schema::hasColumn('bank_check','transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM bank_check WHERE key_name='bank_check_transaction_id_index'"))) {
						$table->index('transaction_id');
					}
					if (Schema::hasColumn('bank_check','bank_id') && !DB::select(DB::raw("SHOW INDEXES FROM bank_check WHERE key_name='bank_check_bank_id_index'"))) {
						$table->index('bank_id');
					}
					if (Schema::hasColumn('bank_check','bank_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM bank_check WHERE key_name='bank_check_bank_transaction_index'"))) {
						$table->index('bank_transaction');
					}
					if (Schema::hasColumn('bank_check','customer_id') && !DB::select(DB::raw("SHOW INDEXES FROM bank_check WHERE key_name='bank_check_customer_id_index'"))) {
						$table->index('customer_id');
					}
					if (Schema::hasColumn('bank_check','receivable_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM bank_check WHERE key_name='bank_check_receivable_transaction_index'"))) {
						$table->index('receivable_transaction');
					}
					if (Schema::hasColumn('bank_check','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM bank_check WHERE key_name='bank_check_user_id_index'"))) {
						$table->index('user_id');
					}
					if (Schema::hasColumn('bank_check','qty') && !DB::select(DB::raw("SHOW INDEXES FROM bank_check WHERE key_name='bank_check_qty_index'"))) {
						$table->index('qty');
					}
					if (Schema::hasColumn('bank_check','date') && !DB::select(DB::raw("SHOW INDEXES FROM bank_check WHERE key_name='bank_check_date_index'"))) {
						$table->index('date');
					}  

					if (Schema::hasColumn('bank_check','type') && !DB::select(DB::raw("SHOW INDEXES FROM bank_check WHERE key_name='bank_check_type_index'"))) {
						$table->index('type');
					} 
				});
			}



			// add indexs to bills
			if(Schema::hasTable('bills')) {
				Schema::table('bills', function (Blueprint $table) {
					if (Schema::hasColumn('bills','number') && !DB::select(DB::raw("SHOW INDEXES FROM bills WHERE key_name='bills_number_index'"))) {
						$table->index('number');
					}
					if (Schema::hasColumn('bills','purchase_id') && !DB::select(DB::raw("SHOW INDEXES FROM bills WHERE key_name='bills_purchase_id_index'"))) {
						$table->index('purchase_id');
					}
					if (Schema::hasColumn('bills','account_id') && !DB::select(DB::raw("SHOW INDEXES FROM bills WHERE key_name='bills_account_id_index'"))) {
						$table->index('account_id');
					}
					if (Schema::hasColumn('bills','date') && !DB::select(DB::raw("SHOW INDEXES FROM bills WHERE key_name='bills_date_index'"))) {
						$table->index('date');
					}
					if (Schema::hasColumn('bills','receivable_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM bills WHERE key_name='bills_receivable_transaction_index'"))) {
						$table->index('receivable_transaction');
					}
					if (Schema::hasColumn('bills','amount') && !DB::select(DB::raw("SHOW INDEXES FROM bills WHERE key_name='bills_amount_index'"))) {
						$table->index('amount');
					}   
				});
			}


			
			// add indexs to bill_payments
			if(Schema::hasTable('bill_payments')) {
				Schema::table('bill_payments', function (Blueprint $table) {
					if (Schema::hasColumn('bill_payments','bill_id') && !DB::select(DB::raw("SHOW INDEXES FROM bill_payments WHERE key_name='bill_payments_bill_id_index'"))) {
						$table->index('bill_id');
					}
					if (Schema::hasColumn('bill_payments','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM bill_payments WHERE key_name='bill_payments_member_id_index'"))) {
						$table->index('member_id');
					}
					if (Schema::hasColumn('bill_payments','bank_id') && !DB::select(DB::raw("SHOW INDEXES FROM bill_payments WHERE key_name='bill_payments_bank_id_index'"))) {
						$table->index('bank_id');
					}
					if (Schema::hasColumn('bill_payments','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM bill_payments WHERE key_name='bill_payments_user_id_index'"))) {
						$table->index('user_id');
					}
					if (Schema::hasColumn('bill_payments','date') && !DB::select(DB::raw("SHOW INDEXES FROM bill_payments WHERE key_name='bill_payments_date_index'"))) {
						$table->index('date');
					}
					if (Schema::hasColumn('bill_payments','amount') && !DB::select(DB::raw("SHOW INDEXES FROM bill_payments WHERE key_name='bill_payments_amount_index'"))) {
						$table->index('amount');
					} 
				});
			}




			// add indexs to branch_transfers
			if(Schema::hasTable('branch_transfers')) {
				Schema::table('branch_transfers', function (Blueprint $table) {
					if (Schema::hasColumn('branch_transfers','ref_no') && !DB::select(DB::raw("SHOW INDEXES FROM branch_transfers WHERE key_name='branch_transfers_ref_no_index'"))) {
						$table->index('ref_no');
					}
					if (Schema::hasColumn('branch_transfers','date') && !DB::select(DB::raw("SHOW INDEXES FROM branch_transfers WHERE key_name='branch_transfers_date_index'"))) {
						$table->index('date');
					}
					if (Schema::hasColumn('branch_transfers','type') && !DB::select(DB::raw("SHOW INDEXES FROM branch_transfers WHERE key_name='branch_transfers_type_index'"))) {
						$table->index('type');
					}
					if (Schema::hasColumn('branch_transfers','from_member_id') && !DB::select(DB::raw("SHOW INDEXES FROM branch_transfers WHERE key_name='branch_transfers_from_member_id_index'"))) {
						$table->index('from_member_id');
					}
					if (Schema::hasColumn('branch_transfers','to_member_id') && !DB::select(DB::raw("SHOW INDEXES FROM branch_transfers WHERE key_name='branch_transfers_to_member_id_index'"))) {
						$table->index('to_member_id');
					} 
					if (Schema::hasColumn('branch_transfers','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM branch_transfers WHERE key_name='branch_transfers_company_id_index'"))) {
						$table->index('company_id');
					}
					if (Schema::hasColumn('branch_transfers','from_company_id') && !DB::select(DB::raw("SHOW INDEXES FROM branch_transfers WHERE key_name='branch_transfers_from_company_id_index'"))) {
						$table->index('from_company_id');
					}
					if (Schema::hasColumn('branch_transfers','to_company_id') && !DB::select(DB::raw("SHOW INDEXES FROM branch_transfers WHERE key_name='branch_transfers_to_company_id_index'"))) {
						$table->index('to_company_id');
					}
					if (Schema::hasColumn('branch_transfers','payable_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM branch_transfers WHERE key_name='branch_transfers_payable_transaction_id_index'"))) {
						$table->index('payable_transaction_id');
					} 

					if (Schema::hasColumn('branch_transfers','receivable_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM branch_transfers WHERE key_name='branch_transfers_receivable_transaction_id_index'"))) {
						$table->index('receivable_transaction_id');
					}
					if (Schema::hasColumn('branch_transfers','driver_id') && !DB::select(DB::raw("SHOW INDEXES FROM branch_transfers WHERE key_name='branch_transfers_driver_id_index'"))) {
						$table->index('driver_id');
					}
					if (Schema::hasColumn('branch_transfers','contract_id') && !DB::select(DB::raw("SHOW INDEXES FROM branch_transfers WHERE key_name='branch_transfers_contract_id_index'"))) {
						$table->index('contract_id');
					} 
					if (Schema::hasColumn('branch_transfers','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM branch_transfers WHERE key_name='branch_transfers_user_id_index'"))) {
						$table->index('user_id');
					} 
				});
			}





			// add indexs to branch_transfer_details
			if(Schema::hasTable('branch_transfer_details')) {
				Schema::table('branch_transfer_details', function (Blueprint $table) {
					if (Schema::hasColumn('branch_transfer_details','branch_transfer_id') && !DB::select(DB::raw("SHOW INDEXES FROM branch_transfer_details WHERE key_name='branch_transfer_details_branch_transfer_id_index'"))) {
						$table->index('branch_transfer_id');
					}
					if (Schema::hasColumn('branch_transfer_details','asset_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM branch_transfer_details WHERE key_name='branch_transfer_details_asset_transaction_index'"))) {
						$table->index('asset_transaction');
					}
					if (Schema::hasColumn('branch_transfer_details','inventory_id') && !DB::select(DB::raw("SHOW INDEXES FROM branch_transfer_details WHERE key_name='branch_transfer_details_inventory_id_index'"))) {
						$table->index('inventory_id');
					}
					if (Schema::hasColumn('branch_transfer_details','site_id') && !DB::select(DB::raw("SHOW INDEXES FROM branch_transfer_details WHERE key_name='branch_transfer_details_site_id_index'"))) {
						$table->index('site_id');
					}
					if (Schema::hasColumn('branch_transfer_details','quantity') && !DB::select(DB::raw("SHOW INDEXES FROM branch_transfer_details WHERE key_name='branch_transfer_details_quantity_index'"))) {
						$table->index('quantity');
					}
					if (Schema::hasColumn('branch_transfer_details','um_id') && !DB::select(DB::raw("SHOW INDEXES FROM branch_transfer_details WHERE key_name='branch_transfer_details_um_id_index'"))) {
						$table->index('um_id');
					} 
					if (Schema::hasColumn('branch_transfer_details','inventory_category_id') && !DB::select(DB::raw("SHOW INDEXES FROM branch_transfer_details WHERE key_name='branch_transfer_details_inventory_category_id_index'"))) {
						$table->index('inventory_category_id');
					}
					if (Schema::hasColumn('branch_transfer_details','other_measure') && !DB::select(DB::raw("SHOW INDEXES FROM branch_transfer_details WHERE key_name='branch_transfer_details_other_measure_index'"))) {
						$table->index('other_measure');
					}
					if (Schema::hasColumn('branch_transfer_details','other_measure2') && !DB::select(DB::raw("SHOW INDEXES FROM branch_transfer_details WHERE key_name='branch_transfer_details_other_measure2_index'"))) {
						$table->index('other_measure2');
					}
				});
			}




			
			// add indexs to build_expenses
			if(Schema::hasTable('build_expenses')) {
				Schema::table('build_expenses', function (Blueprint $table) {
					if (Schema::hasColumn('build_expenses','build_id') && !DB::select(DB::raw("SHOW INDEXES FROM build_expenses WHERE key_name='build_expenses_build_id_index'"))) {
						$table->index('build_id');
					}
					if (Schema::hasColumn('build_expenses','assembly_expense_id') && !DB::select(DB::raw("SHOW INDEXES FROM build_expenses WHERE key_name='build_expenses_assembly_expense_id_index'"))) {
						$table->index('assembly_expense_id');
					}
					if (Schema::hasColumn('build_expenses','account_id') && !DB::select(DB::raw("SHOW INDEXES FROM build_expenses WHERE key_name='build_expenses_account_id_index'"))) {
						$table->index('account_id');
					}
					if (Schema::hasColumn('build_expenses','expense_transaction') && !DB::select(DB::raw("SHOW INDEXES FROM build_expenses WHERE key_name='build_expenses_expense_transaction_index'"))) {
						$table->index('expense_transaction');
					}
					if (Schema::hasColumn('build_expenses','amount') && !DB::select(DB::raw("SHOW INDEXES FROM build_expenses WHERE key_name='build_expenses_amount_index'"))) {
						$table->index('amount');
					}
					if (Schema::hasColumn('build_expenses','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM build_expenses WHERE key_name='build_expenses_company_id_index'"))) {
						$table->index('company_id');
					} 
				});
			}



			// add indexs to build_infos
			if(Schema::hasTable('build_infos')) {
				Schema::table('build_infos', function (Blueprint $table) {
					if (Schema::hasColumn('build_infos','recipe_id') && !DB::select(DB::raw("SHOW INDEXES FROM build_infos WHERE key_name='build_infos_recipe_id_index'"))) {
						$table->index('recipe_id');
					}
					if (Schema::hasColumn('build_infos','build_id') && !DB::select(DB::raw("SHOW INDEXES FROM build_infos WHERE key_name='build_infos_build_id_index'"))) {
						$table->index('build_id');
					}
					if (Schema::hasColumn('build_infos','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM build_infos WHERE key_name='build_infos_company_id_index'"))) {
						$table->index('company_id');
					}
				});
			}



			// add indexs to build_stock_ins
			if(Schema::hasTable('build_stock_ins')) {
				Schema::table('build_stock_ins', function (Blueprint $table) {
					if (Schema::hasColumn('build_stock_ins','build_id') && !DB::select(DB::raw("SHOW INDEXES FROM build_stock_ins WHERE key_name='build_stock_ins_build_id_index'"))) {
						$table->index('build_id');
					}
					if (Schema::hasColumn('build_stock_ins','stock_in_id') && !DB::select(DB::raw("SHOW INDEXES FROM build_stock_ins WHERE key_name='build_stock_ins_stock_in_id_index'"))) {
						$table->index('stock_in_id');
					}
					if (Schema::hasColumn('build_stock_ins','asset_t_id') && !DB::select(DB::raw("SHOW INDEXES FROM build_stock_ins WHERE key_name='build_stock_ins_asset_t_id_index'"))) {
						$table->index('asset_t_id');
					}
					if (Schema::hasColumn('build_stock_ins','project_build_id') && !DB::select(DB::raw("SHOW INDEXES FROM build_stock_ins WHERE key_name='build_stock_ins_project_build_id_index'"))) {
						$table->index('project_build_id');
					}
					if (Schema::hasColumn('build_stock_ins','m_stock_id') && !DB::select(DB::raw("SHOW INDEXES FROM build_stock_ins WHERE key_name='build_stock_ins_m_stock_id_index'"))) {
						$table->index('m_stock_id');
					}
					if (Schema::hasColumn('build_stock_ins','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM build_stock_ins WHERE key_name='build_stock_ins_company_id_index'"))) {
						$table->index('company_id');
					}
					if (Schema::hasColumn('build_stock_ins','cost_trans_id') && !DB::select(DB::raw("SHOW INDEXES FROM build_stock_ins WHERE key_name='build_stock_ins_cost_trans_id_index'"))) {
						$table->index('cost_trans_id');
					}
				});
			}





			// add indexs to build_stock_outs
			if(Schema::hasTable('build_stock_outs')) {
				Schema::table('build_stock_outs', function (Blueprint $table) {
					if (Schema::hasColumn('build_stock_outs','build_id') && !DB::select(DB::raw("SHOW INDEXES FROM build_stock_outs WHERE key_name='build_stock_outs_build_id_index'"))) {
						$table->index('build_id');
					} 
					if (Schema::hasColumn('build_stock_outs','asset_t_id') && !DB::select(DB::raw("SHOW INDEXES FROM build_stock_outs WHERE key_name='build_stock_outs_asset_t_id_index'"))) {
						$table->index('asset_t_id');
					}
					if (Schema::hasColumn('build_stock_outs','stock_out_id') && !DB::select(DB::raw("SHOW INDEXES FROM build_stock_outs WHERE key_name='build_stock_outs_stock_out_id_index'"))) {
						$table->index('stock_out_id');
					}
					if (Schema::hasColumn('build_stock_outs','project_build_id') && !DB::select(DB::raw("SHOW INDEXES FROM build_stock_outs WHERE key_name='build_stock_outs_project_build_id_index'"))) {
						$table->index('project_build_id');
					}
					if (Schema::hasColumn('build_stock_outs','m_stock_out_id') && !DB::select(DB::raw("SHOW INDEXES FROM build_stock_outs WHERE key_name='build_stock_outs_m_stock_out_id_index'"))) {
						$table->index('m_stock_out_id');
					}
					if (Schema::hasColumn('build_stock_outs','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM build_stock_outs WHERE key_name='build_stock_outs_company_id_index'"))) {
						$table->index('company_id');
					}
					if (Schema::hasColumn('build_stock_outs','contract_stock_out_id') && !DB::select(DB::raw("SHOW INDEXES FROM build_stock_outs WHERE key_name='build_stock_outs_contract_stock_out_id_index'"))) {
						$table->index('contract_stock_out_id');
					}
				});
			}
	


			// add indexs to cargo_contract
			if(Schema::hasTable('cargo_contract')) {
				Schema::table('cargo_contract', function (Blueprint $table) {
					if (Schema::hasColumn('cargo_contract','number') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_contract WHERE key_name='cargo_contract_number_index'"))) {
						$table->index('number');
					} 
					if (Schema::hasColumn('cargo_contract','ref_no') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_contract WHERE key_name='cargo_contract_ref_no_index'"))) {
						$table->index('ref_no');
					}
					if (Schema::hasColumn('cargo_contract','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_contract WHERE key_name='cargo_contract_member_id_index'"))) {
						$table->index('member_id');
					}
					if (Schema::hasColumn('cargo_contract','transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_contract WHERE key_name='cargo_contract_transaction_id_index'"))) {
						$table->index('transaction_id');
					}
					if (Schema::hasColumn('cargo_contract','discount') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_contract WHERE key_name='cargo_contract_discount_index'"))) {
						$table->index('discount');
					}
					if (Schema::hasColumn('cargo_contract','discount_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_contract WHERE key_name='cargo_contract_discount_transaction_id_index'"))) {
						$table->index('discount_transaction_id');
					}
					if (Schema::hasColumn('cargo_contract','income_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_contract WHERE key_name='cargo_contract_income_id_index'"))) {
						$table->index('income_id');
					}

					if (Schema::hasColumn('cargo_contract','expense_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_contract WHERE key_name='cargo_contract_expense_id_index'"))) {
						$table->index('expense_id');
					}
					if (Schema::hasColumn('cargo_contract','date') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_contract WHERE key_name='cargo_contract_date_index'"))) {
						$table->index('date');
					}
					if (Schema::hasColumn('cargo_contract','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_contract WHERE key_name='cargo_contract_user_id_index'"))) {
						$table->index('user_id');
					}
					if (Schema::hasColumn('cargo_contract','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_contract WHERE key_name='cargo_contract_company_id_index'"))) {
						$table->index('company_id');
					}
				});
			}




			// add indexs to cargo_contract_details
			if(Schema::hasTable('cargo_contract_details')) {
				Schema::table('cargo_contract_details', function (Blueprint $table) {
					if (Schema::hasColumn('cargo_contract_details','cargo_contract_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_contract_details WHERE key_name='cargo_contract_details_cargo_contract_id_index'"))) {
						$table->index('cargo_contract_id');
					} 
					if (Schema::hasColumn('cargo_contract_details','source_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_contract_details WHERE key_name='cargo_contract_details_source_id_index'"))) {
						$table->index('source_id');
					}
					if (Schema::hasColumn('cargo_contract_details','destination_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_contract_details WHERE key_name='cargo_contract_details_destination_id_index'"))) {
						$table->index('destination_id');
					}
					if (Schema::hasColumn('cargo_contract_details','income_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_contract_details WHERE key_name='cargo_contract_details_income_transaction_id_index'"))) {
						$table->index('income_transaction_id');
					}
					if (Schema::hasColumn('cargo_contract_details','discount_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_contract_details WHERE key_name='cargo_contract_details_discount_transaction_id_index'"))) {
						$table->index('discount_transaction_id');
					}
					if (Schema::hasColumn('cargo_contract_details','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_contract_details WHERE key_name='cargo_contract_details_user_id_index'"))) {
						$table->index('user_id');
					}
					if (Schema::hasColumn('cargo_contract_details','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_contract_details WHERE key_name='cargo_contract_details_company_id_index'"))) {
						$table->index('company_id');
					}

					if (Schema::hasColumn('cargo_contract_details','um_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_contract_details WHERE key_name='cargo_contract_details_um_id_index'"))) {
						$table->index('um_id');
					}
					if (Schema::hasColumn('cargo_contract_details','order_detail_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_contract_details WHERE key_name='cargo_contract_details_order_detail_id_index'"))) {
						$table->index('order_detail_id');
					}
				});
			}
			


			// add indexs to cargo_contract_order_detail
			if(Schema::hasTable('cargo_contract_order_detail')) {
				Schema::table('cargo_contract_order_detail', function (Blueprint $table) {
					if (Schema::hasColumn('cargo_contract_order_detail','cargo_contract_order_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_contract_order_detail WHERE key_name='cargo_contract_order_detail_cargo_contract_order_id_index'"))) {
						$table->index('cargo_contract_order_id');
					} 
					if (Schema::hasColumn('cargo_contract_order_detail','source_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_contract_order_detail WHERE key_name='cargo_contract_order_detail_source_id_index'"))) {
						$table->index('source_id');
					}
					if (Schema::hasColumn('cargo_contract_order_detail','destination_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_contract_order_detail WHERE key_name='cargo_contract_order_detail_destination_id_index'"))) {
						$table->index('destination_id');
					}
					if (Schema::hasColumn('cargo_contract_order_detail','quantity_in') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_contract_order_detail WHERE key_name='cargo_contract_order_detail_quantity_in_index'"))) {
						$table->index('quantity_in');
					}
					if (Schema::hasColumn('cargo_contract_order_detail','price') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_contract_order_detail WHERE key_name='cargo_contract_order_detail_price_index'"))) {
						$table->index('price');
					}
					if (Schema::hasColumn('cargo_contract_order_detail','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_contract_order_detail WHERE key_name='cargo_contract_order_detail_user_id_index'"))) {
						$table->index('user_id');
					}
					if (Schema::hasColumn('cargo_contract_order_detail','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_contract_order_detail WHERE key_name='cargo_contract_order_detail_company_id_index'"))) {
						$table->index('company_id');
					}

					if (Schema::hasColumn('cargo_contract_order_detail','um_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_contract_order_detail WHERE key_name='cargo_contract_order_detail_um_id_index'"))) {
						$table->index('um_id');
					} 
				});
			}



			// add indexs to cargo_deliveries
			if(Schema::hasTable('cargo_deliveries')) {
				Schema::table('cargo_deliveries', function (Blueprint $table) {
					if (Schema::hasColumn('cargo_deliveries','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_deliveries WHERE key_name='cargo_deliveries_member_id_index'"))) {
						$table->index('member_id');
					} 
					if (Schema::hasColumn('cargo_deliveries','date') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_deliveries WHERE key_name='cargo_deliveries_date_index'"))) {
						$table->index('date');
					}
					if (Schema::hasColumn('cargo_deliveries','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_deliveries WHERE key_name='cargo_deliveries_company_id_index'"))) {
						$table->index('company_id');
					}
					if (Schema::hasColumn('cargo_deliveries','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_deliveries WHERE key_name='cargo_deliveries_user_id_index'"))) {
						$table->index('user_id');
					}
				});
			}



			// add indexs to cargo_delivery_details
			if(Schema::hasTable('cargo_delivery_details')) {
				Schema::table('cargo_delivery_details', function (Blueprint $table) {
					if (Schema::hasColumn('cargo_delivery_details','cargo_delivery_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_delivery_details WHERE key_name='cargo_delivery_details_cargo_delivery_id_index'"))) {
						$table->index('cargo_delivery_id');
					} 
					if (Schema::hasColumn('cargo_delivery_details','cargo_loading_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_delivery_details WHERE key_name='cargo_delivery_details_cargo_loading_id_index'"))) {
						$table->index('cargo_loading_id');
					}
					if (Schema::hasColumn('cargo_delivery_details','cargo_contract_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_delivery_details WHERE key_name='cargo_delivery_details_cargo_contract_id_index'"))) {
						$table->index('cargo_contract_id');
					}
					if (Schema::hasColumn('cargo_delivery_details','driver_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_delivery_details WHERE key_name='cargo_delivery_details_driver_id_index'"))) {
						$table->index('driver_id');
					}
					if (Schema::hasColumn('cargo_delivery_details','vehicle_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_delivery_details WHERE key_name='cargo_delivery_details_vehicle_id_index'"))) {
						$table->index('vehicle_id');
					}
					if (Schema::hasColumn('cargo_delivery_details','container_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_delivery_details WHERE key_name='cargo_delivery_details_container_id_index'"))) {
						$table->index('container_id');
					}
					if (Schema::hasColumn('cargo_delivery_details','cargo_item_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_delivery_details WHERE key_name='cargo_delivery_details_cargo_item_id_index'"))) {
						$table->index('cargo_item_id');
					}

					if (Schema::hasColumn('cargo_delivery_details','site_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_delivery_details WHERE key_name='cargo_delivery_details_site_id_index'"))) {
						$table->index('site_id');
					}
					if (Schema::hasColumn('cargo_delivery_details','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_delivery_details WHERE key_name='cargo_delivery_details_company_id_index'"))) {
						$table->index('company_id');
					}
				});
			}




				// add indexs to cargo_item_expense
				if(Schema::hasTable('cargo_item_expense')) {
					Schema::table('cargo_item_expense', function (Blueprint $table) {
						if (Schema::hasColumn('cargo_item_expense','number') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_item_expense WHERE key_name='cargo_item_expense_number_index'"))) {
							$table->index('number');
						} 
						if (Schema::hasColumn('cargo_item_expense','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_item_expense WHERE key_name='cargo_item_expense_member_id_index'"))) {
							$table->index('member_id');
						}
						if (Schema::hasColumn('cargo_item_expense','currency') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_item_expense WHERE key_name='cargo_item_expense_currency_index'"))) {
							$table->index('currency');
						}
						if (Schema::hasColumn('cargo_item_expense','bank_tran_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_item_expense WHERE key_name='cargo_item_expense_bank_tran_id_index'"))) {
							$table->index('bank_tran_id');
						}
						if (Schema::hasColumn('cargo_item_expense','expense_tran_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_item_expense WHERE key_name='cargo_item_expense_expense_tran_id_index'"))) {
							$table->index('expense_tran_id');
						}
						if (Schema::hasColumn('cargo_item_expense','date') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_item_expense WHERE key_name='cargo_item_expense_date_index'"))) {
							$table->index('date');
						}
						if (Schema::hasColumn('cargo_item_expense','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_item_expense WHERE key_name='cargo_item_expense_user_id_index'"))) {
							$table->index('user_id');
						}
	
						if (Schema::hasColumn('cargo_item_expense','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_item_expense WHERE key_name='cargo_item_expense_company_id_index'"))) {
							$table->index('company_id');
						}
						if (Schema::hasColumn('cargo_item_expense','receivable_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_item_expense WHERE key_name='cie_r_transaction_id'"))) {
							$table->index('receivable_transaction_id', 'cie_r_transaction_id');
						}


						if (Schema::hasColumn('cargo_item_expense','payable_transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_item_expense WHERE key_name='cie_p_transaction_id'"))) {
							$table->index('payable_transaction_id', 'cie_p_transaction_id');
						}
	
						if (Schema::hasColumn('cargo_item_expense','expense_category_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_item_expense WHERE key_name='cargo_item_expense_expense_category_id_index'"))) {
							$table->index('expense_category_id');
						}
						if (Schema::hasColumn('cargo_item_expense','type_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_item_expense WHERE key_name='cargo_item_expense_type_id_index'"))) {
							$table->index('type_id');
						}

						if (Schema::hasColumn('cargo_item_expense','vehicle_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_item_expense WHERE key_name='cargo_item_expense_vehicle_id_index'"))) {
							$table->index('vehicle_id');
						}
						if (Schema::hasColumn('cargo_item_expense','income_tran_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_item_expense WHERE key_name='cargo_item_expense_income_tran_id_index'"))) {
							$table->index('income_tran_id');
						}
					});
				}




				
			// add indexs to cargo_item_expense_catg
			if(Schema::hasTable('cargo_item_expense_catg')) {
				Schema::table('cargo_item_expense_catg', function (Blueprint $table) {
					if (Schema::hasColumn('cargo_item_expense_catg','cargo_item_expense_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_item_expense_catg WHERE key_name='cargo_item_expense_catg_cargo_item_expense_id_index'"))) {
						$table->index('cargo_item_expense_id');
					} 
					if (Schema::hasColumn('cargo_item_expense_catg','item_expense_category_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_item_expense_catg WHERE key_name='ciec_ie_category_id'"))) {
						$table->index('item_expense_category_id', 'ciec_ie_category_id');
					}
					if (Schema::hasColumn('cargo_item_expense_catg','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_item_expense_catg WHERE key_name='cargo_item_expense_catg_company_id_index'"))) {
						$table->index('company_id');
					}
					if (Schema::hasColumn('cargo_item_expense_catg','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_item_expense_catg WHERE key_name='cargo_item_expense_catg_user_id_index'"))) {
						$table->index('user_id');
					}
				});
			}



			// add indexs to cargo_item_expense_details
			if(Schema::hasTable('cargo_item_expense_details')) {
				Schema::table('cargo_item_expense_details', function (Blueprint $table) {
					if (Schema::hasColumn('cargo_item_expense_details','cargo_item_expense_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_item_expense_details WHERE key_name='cied_ci_expense_id'"))) {
						$table->index('cargo_item_expense_id', 'cied_ci_expense_id');
					} 
					if (Schema::hasColumn('cargo_item_expense_details','amount') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_item_expense_details WHERE key_name='cargo_item_expense_details_amount_index'"))) {
						$table->index('amount');
					}
					if (Schema::hasColumn('cargo_item_expense_details','transaction_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_item_expense_details WHERE key_name='cargo_item_expense_details_transaction_id_index'"))) {
						$table->index('transaction_id');
					}
					if (Schema::hasColumn('cargo_item_expense_details','type_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_item_expense_details WHERE key_name='cargo_item_expense_details_type_id_index'"))) {
						$table->index('type_id');
					}

					if (Schema::hasColumn('cargo_item_expense_details','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_item_expense_details WHERE key_name='cargo_item_expense_details_company_id_index'"))) {
						$table->index('company_id');
					}
					if (Schema::hasColumn('cargo_item_expense_details','quantity') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_item_expense_details WHERE key_name='cargo_item_expense_details_quantity_index'"))) {
						$table->index('quantity');
					}
				});
			}




			// add indexs to cargo_item_expense_payments
			if(Schema::hasTable('cargo_item_expense_payments')) {
				Schema::table('cargo_item_expense_payments', function (Blueprint $table) {
					if (Schema::hasColumn('cargo_item_expense_payments','cargo_item_expense_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_item_expense_payments WHERE key_name='cargo_item_expense_payments_cargo_item_expense_id_index'"))) {
						$table->index('cargo_item_expense_id');
					} 
					if (Schema::hasColumn('cargo_item_expense_payments','payment_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_item_expense_payments WHERE key_name='cargo_item_expense_payments_payment_id_index'"))) {
						$table->index('payment_id');
					}
				});
			}


			// add indexs to cargo_loadings
			if(Schema::hasTable('cargo_loadings')) {
				Schema::table('cargo_loadings', function (Blueprint $table) {
					if (Schema::hasColumn('cargo_loadings','number') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_loadings WHERE key_name='cargo_loadings_number_index'"))) {
						$table->index('number');
					} 
					if (Schema::hasColumn('cargo_loadings','type') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_loadings WHERE key_name='cargo_loadings_type_index'"))) {
						$table->index('type');
					}
					if (Schema::hasColumn('cargo_loadings','date') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_loadings WHERE key_name='cargo_loadings_date_index'"))) {
						$table->index('date');
					} 
					if (Schema::hasColumn('cargo_loadings','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_loadings WHERE key_name='cargo_loadings_company_id_index'"))) {
						$table->index('company_id');
					}
					if (Schema::hasColumn('cargo_loadings','source_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_loadings WHERE key_name='cargo_loadings_source_id_index'"))) {
						$table->index('source_id');
					} 
					if (Schema::hasColumn('cargo_loadings','driver_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_loadings WHERE key_name='cargo_loadings_driver_id_index'"))) {
						$table->index('driver_id');
					}

					if (Schema::hasColumn('cargo_loadings','vehicle_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_loadings WHERE key_name='cargo_loadings_vehicle_id_index'"))) {
						$table->index('vehicle_id');
					}
					if (Schema::hasColumn('cargo_loadings','container_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_loadings WHERE key_name='cargo_loadings_container_id_index'"))) {
						$table->index('container_id');
					} 
					if (Schema::hasColumn('cargo_loadings','source') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_loadings WHERE key_name='cargo_loadings_source_index'"))) {
						$table->index('source');
					}if (Schema::hasColumn('cargo_loadings','destination') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_loadings WHERE key_name='cargo_loadings_destination_index'"))) {
						$table->index('destination');
					}
					if (Schema::hasColumn('cargo_loadings','transit_number') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_loadings WHERE key_name='cargo_loadings_transit_number_index'"))) {
						$table->index('transit_number');
					} 
					if (Schema::hasColumn('cargo_loadings','parent_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_loadings WHERE key_name='cargo_loadings_parent_id_index'"))) {
						$table->index('parent_id');
					}
					if (Schema::hasColumn('cargo_loadings','user_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_loadings WHERE key_name='cargo_loadings_user_id_index'"))) {
						$table->index('user_id');
					}
					if (Schema::hasColumn('cargo_loadings','employee_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_loadings WHERE key_name='cargo_loadings_employee_id_index'"))) {
						$table->index('employee_id');
					}
				});
			}



			// add indexs to cargo_loading_details
			if(Schema::hasTable('cargo_loading_details')) {
				Schema::table('cargo_loading_details', function (Blueprint $table) {
					if (Schema::hasColumn('cargo_loading_details','cargo_loading_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_loading_details WHERE key_name='cargo_loading_details_cargo_loading_id_index'"))) {
						$table->index('cargo_loading_id');
					} 
					if (Schema::hasColumn('cargo_loading_details','cargo_contract_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_loading_details WHERE key_name='cargo_loading_details_cargo_contract_id_index'"))) {
						$table->index('cargo_contract_id');
					}
					if (Schema::hasColumn('cargo_loading_details','driver_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_loading_details WHERE key_name='cargo_loading_details_driver_id_index'"))) {
						$table->index('driver_id');
					} 
					if (Schema::hasColumn('cargo_loading_details','vehicle_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_loading_details WHERE key_name='cargo_loading_details_vehicle_id_index'"))) {
						$table->index('vehicle_id');
					}
					if (Schema::hasColumn('cargo_loading_details','container_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_loading_details WHERE key_name='cargo_loading_details_container_id_index'"))) {
						$table->index('container_id');
					} 
					if (Schema::hasColumn('cargo_loading_details','other_driver_name') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_loading_details WHERE key_name='cargo_loading_details_other_driver_name_index'"))) {
						$table->index('other_driver_name');
					}if (Schema::hasColumn('cargo_loading_details','source') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_loading_details WHERE key_name='cargo_loading_details_source_index'"))) {
						$table->index('source');
					} 
					if (Schema::hasColumn('cargo_loading_details','destination') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_loading_details WHERE key_name='cargo_loading_details_destination_index'"))) {
						$table->index('destination');
					}if (Schema::hasColumn('cargo_loading_details','transit_number') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_loading_details WHERE key_name='cargo_loading_details_transit_number_index'"))) {
						$table->index('transit_number');
					} 
					if (Schema::hasColumn('cargo_loading_details','cmr_number') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_loading_details WHERE key_name='cargo_loading_details_cmr_number_index'"))) {
						$table->index('cmr_number');
					}if (Schema::hasColumn('cargo_loading_details','cargo_item_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_loading_details WHERE key_name='cargo_loading_details_cargo_item_id_index'"))) {
						$table->index('cargo_item_id');
					} 
					if (Schema::hasColumn('cargo_loading_details','site_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_loading_details WHERE key_name='cargo_loading_details_site_id_index'"))) {
						$table->index('site_id');
					}

					if (Schema::hasColumn('cargo_loading_details','quantity') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_loading_details WHERE key_name='cargo_loading_details_quantity_index'"))) {
						$table->index('quantity');
					} 
					if (Schema::hasColumn('cargo_loading_details','company_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_loading_details WHERE key_name='cargo_loading_details_company_id_index'"))) {
						$table->index('company_id');
					}if (Schema::hasColumn('cargo_loading_details','member_id') && !DB::select(DB::raw("SHOW INDEXES FROM cargo_loading_details WHERE key_name='cargo_loading_details_member_id_index'"))) {
						$table->index('member_id');
					} 
				});
			}

 



        // add indexs to stocks
		 		
		
		// add indexs to n_pro_order_receive_and_pay_stock_outs
		 if(Schema::hasTable('n_pro_order_receive_and_pay_stock_outs')) {
			Schema::table('n_pro_order_receive_and_pay_stock_outs', function (Blueprint $table) {
				// if (Schema::hasColumn('n_pro_order_receive_and_pay_stock_outs','order_receive_and_pay_id') && !DB::select(DB::raw("SHOW INDEXES FROM daily_expenses WHERE key_name='daily_expenses_bank_transaction_index'"))) {
				// 	$table->index('order_receive_and_pay_id','o_r_p_id_index');
				// }
			});
		}
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('all_tables', function (Blueprint $table) {
            //
        });
    }
};
