<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('cargo_contract_order_detail')) {
            Schema::create('cargo_contract_order_detail', function (Blueprint $table) {
                $table->id();
				$table->integer('cargo_contract_order_id')->nullable();
				$table->integer('source_id')->nullable();
				$table->integer('destination_id')->nullable();
				$table->string('item_description1')->nullable();
				$table->string('item_description2')->nullable();
				$table->string('item_description3')->nullable();
				$table->double('width')->nullable();
				$table->double('height')->nullable();
				$table->double('length')->nullable();
				$table->double('weight')->nullable();
				$table->double('quantity_in')->nullable();
				$table->double('price')->nullable();
				$table->double('volume')->nullable();
				$table->double('discount')->nullable();
				$table->integer('um_id')->nullable();
				$table->integer('user_id')->nullable();
				$table->integer('company_id')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cargo_contract_order_detail');
    }
};
