<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('cargo_contract_order')) {
            Schema::create('cargo_contract_order', function (Blueprint $table) {
                $table->id();
				$table->integer('number')->nullable();
				$table->string('ref_no')->nullable();
				$table->integer('member_id')->nullable();
				$table->string('currency')->nullable();
				$table->double('rate')->nullable();
				$table->string('discount_type')->nullable();
				$table->double('discount')->nullable();
				$table->string('status')->nullable();
				$table->string('cbm_price')->nullable();
				$table->text('description')->nullable();
				$table->datetime('date')->nullable();
				$table->datetime('delivery_date')->nullable();
				$table->integer('user_id')->nullable();
				$table->integer('company_id')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cargo_contract_order');
    }
};
