<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        if(!Schema::hasTable('telegram_ids')) {
            Schema::create('telegram_ids', function (Blueprint $table) {
                $table->id();
                $table->string('chat_id');
                $table->string('name')->nullable();
                $table->string('last_name')->nullable();
                $table->string('username')->nullable();
                $table->integer('company_id')->unsigned()->nullable();
                $table->timestamps();
            });
        }

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('telegram_ids');
    }
};
