<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('litters')) {
        Schema::create('litters', function (Blueprint $table) {
            $table->id();
            $table->string('title')->nullable();
            $table->string('type')->nullable();
            $table->integer('number')->nullable();
            $table->text('status')->nullable();
            $table->string('path')->nullable();
            $table->integer('reference_department_id')->nullable();
            $table->integer('litter_tittle_id')->nullable();
            $table->integer('litter_category_id')->nullable();  
            $table->text('file')->nullable();
            $table->datetime('date')->nullable();
            $table->text('description')->nullable();
            $table->text('descriptiontwo')->nullable();
            $table->integer('user_id')->unsigned()->nullable();
            $table->integer('company_id')->unsigned()->nullable();
            $table->timestamps();
        });
    }
}

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('litters');
    }
};
