<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('contract_loading_dates')) {
            Schema::create('contract_loading_dates', function (Blueprint $table) {
                $table->id();
                $table->integer('number')->nullable();
                $table->text('description')->nullable();
                $table->datetime('date')->nullable();
                $table->string('status')->nullable();
                $table->integer('contract_id')->unsigned();
                $table->integer('user_id')->unsigned()->nullable();
                $table->integer('company_id')->unsigned()->nullable();
                $table->timestamps();
            });
        }


    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('contract_loading_dates');
    }
};
