<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('rewards'))
        {
        Schema::create('rewards', function (Blueprint $table) {
            $table->id();
            $table->integer('number')->nullable();
            $table->integer('employee_id')->nullable();
            $table->datetime('date')->nullable();
            $table->integer('expense_transaction_id')->nullable();
            $table->integer('payable_transaction_id')->nullable();
            $table->integer('company_id')->nullable();
            $table->double('rate')->default(1);
            $table->double('amount');
            $table->string('currency', 10);
            $table->integer('user_id')->nullable();
            $table->string('description')->nullable();
            $table->timestamps();
        });

    }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('rewards');
    }
};
