<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('emp_overtime'))
        {
        Schema::create('emp_overtime', function (Blueprint $table) {
            $table->id();               
            $table->integer('number')->nullable();
            $table->string('code')->nullable();
            $table->datetime('date')->nullable();
            $table->string('status')->nullable();
            $table->string('second_status')->nullable();
            $table->time('from_hour')->nullable();
            $table->time('to_hour')->nullable();
            $table->integer('member_id')->nullable();
            $table->integer('company_id')->nullable();
            $table->integer('user_id')->nullable();
            $table->string('description')->nullable();
            $table->timestamps();
        });
    }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('emp_overtime');
    }
};
