<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('attachments', function (Blueprint $table) {
            if(!Schema::hasColumn('attachments','number')){
                $table->string('number')->nullable();
                $table->string('ref_number')->nullable();
                $table->integer('count')->nullable();
                $table->string('file_type')->nullable();
                $table->string('location')->nullable();
                $table->string('part')->nullable();
                $table->string('status')->nullable();
                $table->string('in_sender')->nullable();
                $table->integer('in_receiver')->nullable();
                $table->string('out_receiver')->nullable();
                $table->integer('out_sender')->nullable();
                $table->datetime('in_date')->nullable();
                $table->datetime('out_date')->nullable();
                $table->string('main_receiver')->nullable();
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('attachments', function (Blueprint $table) {
            //
        });
    }
};
