<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('employee_assessments'))
        {
            Schema::create('employee_assessments', function (Blueprint $table) {
                $table->id();
                $table->integer('assessment_category_id')->unsigned()->nullable();
                $table->integer('employee_id')->unsigned();
                $table->integer('number')->unsigned()->nullable();
                $table->string('code')->nullable();
                $table->datetime('date');
                $table->text('comments')->nullable();
                $table->text('labels')->nullable();
                $table->text('description')->nullable();
                $table->string('type')->nullable();
                $table->string('currency')->nullable();
                $table->double('rate')->nullable();
                $table->integer('income_expense_transaction')->unsigned()->nullable()->comment('income or expense depends of assessment type');
                $table->integer('member_transaction')->unsigned()->nullable();
                $table->integer('company_id')->nullable();
                $table->integer('user_id')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('employee_assessments');
    }
};
