<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('platts_rate_details'))
        {
            Schema::create('platts_rate_details', function (Blueprint $table) {
                $table->id();
                $table->integer('platts_rate_id')->unsigned();
                $table->integer('item_id')->unsigned();
                $table->integer('um_id')->unsigned();
                $table->double('amount');
                $table->integer('company_id')->nullable();
				$table->integer('user_id')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('platts_rate_details');
    }
};
