<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('platts_rates'))
        {
            Schema::create('platts_rates', function (Blueprint $table) {
                $table->id();
                $table->integer('platts_category_id')->unsigned()->nullable();
                $table->datetime('date');
                $table->string('currency');
                $table->double('rate');
                $table->text('description')->nullable();
                $table->integer('company_id')->nullable();
				$table->integer('user_id')->nullable();

                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('platts_rates');
    }
};
