<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('member_contacts'))
        {
            Schema::create('member_contacts', function (Blueprint $table) {
                $table->id();
                $table->integer('number')->unsigned()->nullable();
                $table->string('name');
                $table->string('last_name')->nullable();
                $table->string('pseudonym')->nullable();
                $table->string('father_name')->nullable();
                $table->string('phone')->nullable();
                $table->string('phone2')->nullable();
                $table->string('home_phone')->nullable();
                $table->string('work_phone')->nullable();
                $table->string('other_phone')->nullable();
                $table->string('other_phone2')->nullable();
                $table->string('email')->nullable();
                $table->string('website')->nullable();
                $table->string('gender')->nullable();
                $table->text('organization')->nullable();
                $table->text('reference')->nullable();
                $table->text('memo')->nullable();
                $table->string('ss_id')->nullable();
                $table->string('passport')->nullable();
                $table->string('photo');
                $table->text('address1')->nullable();
                $table->text('address2')->nullable();
                $table->string('post_code')->nullable();
                $table->string('city')->nullable();
                $table->string('country')->nullable();
                $table->string('district')->nullable();
                $table->string('village')->nullable();
                $table->datetime('date_of_birth')->nullable();
                $table->datetime('reg_date')->nullable();
                $table->string('job_title')->nullable();
                $table->integer('member_contact_class_id')->nullable();
                $table->integer('company_id')->nullable();
                $table->integer('user_id')->nullable();
                $table->timestamps();
            });

        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('member_contacts');
    }
};
