<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('cargo_sites')) {
			Schema::create('cargo_sites', function (Blueprint $table) {
				$table->engine = 'InnoDB';
				$table->id();
				$table->string('name')->index();
				$table->integer('number')->nullable();
				$table->string('description')->nullable();
				$table->string('stock_man_name')->nullable();
				$table->string('stock_man_phone')->nullable();
				$table->string('stock_address')->nullable();
				$table->string('other_name')->nullable();
				$table->integer('parent_id')->nullable();
				$table->integer('company_id')->nullable();
				$table->timestamps();
			});
		}
		
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cargo_sites');
    }
};
