<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('loading_details', function (Blueprint $table) {
			if (!Schema::hasColumn('loading_details','laboratory_test')) {
                $table->string('laboratory_test', 20)->nullable();
                $table->string('weighbridge_test', 20)->nullable();
            }
        });
		
        Schema::table('laboratories', function (Blueprint $table) {
			if (!Schema::hasColumn('laboratories','type_detail_id')) {
                $table->integer('type_detail_id')->nullable();
				$table->string('type_number', 40)->nullable();
            }
        });
		
        Schema::table('weighbridges', function (Blueprint $table) {
			if (!Schema::hasColumn('weighbridges','type_detail_id')) {
                $table->integer('type_detail_id')->nullable();
				$table->string('type_number', 40)->nullable();
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('loading_details', function (Blueprint $table) {
            //
        });
    }
};
