<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('shifts')) {
			Schema::create('shifts', function (Blueprint $table) {
				$table->engine = 'InnoDB';
				$table->id();
				$table->string('name', 100);
				$table->time('start_time')->nullable();
				$table->time('end_time')->nullable();
				$table->string('description')->nullable();
				$table->integer('company_id')->nullable();
				$table->integer('user_id')->nullable();
				$table->timestamps();
			});
		}
		
		Schema::table('members', function (Blueprint $table) {
			if(!Schema::hasColumn('members','shift_id')){
				$table->integer('shift_id')->nullable()->index();
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('shifts');
    }
};
