<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('stocks', function (Blueprint $table) {
            if (!Schema::hasColumn('stocks','location')) {
                $table->string('location')->nullable()->index('location');
            }
        });
		
        Schema::table('sale_infos', function (Blueprint $table) {
            if (!Schema::hasColumn('sale_infos','location')) {
                $table->string('location')->nullable();
            }
        });
		
        Schema::table('sales_order_details', function (Blueprint $table) {
            if (!Schema::hasColumn('sales_order_details','location')) {
                $table->string('location')->nullable();
            }
        });
		
        Schema::table('adjustment_details', function (Blueprint $table) {
            if (!Schema::hasColumn('adjustment_details','location')) {
                $table->string('location')->nullable();
            }
        });
		
        Schema::table('inventory_transfer_infos', function (Blueprint $table) {
            if (!Schema::hasColumn('inventory_transfer_infos','location')) {
                $table->string('location')->nullable();
                $table->string('to_location')->nullable();
            }
        });
		
        Schema::table('sales', function (Blueprint $table) {
            if (!Schema::hasColumn('sales','show_persian_desc')) {
                $table->string('show_persian_desc')->nullable();
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('stocks', function (Blueprint $table) {
            //
        });
    }
};
