<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('oil_parts')) {
			Schema::create('oil_parts', function (Blueprint $table) {
				$table->engine = 'InnoDB';
				$table->id();
				$table->string('number', 100)->nullable();
				$table->integer('sale_number')->nullable();
				$table->integer('employee_id')->nullable();
				$table->integer('site_id')->nullable();
				$table->string('description')->nullable();
				$table->integer('company_id')->nullable();
				$table->integer('user_id')->nullable();
				$table->timestamps();
			});
		}
		
		Schema::table('sales', function (Blueprint $table) {
			if(!Schema::hasColumn('sales','oil_part_id')){
				$table->integer('oil_part_id')->nullable();
            }
        });
		
		Schema::table('system_configs', function (Blueprint $table) {
			if(!Schema::hasColumn('system_configs','gas_station')){
				$table->integer('gas_station')->nullable();
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('oil_parts');
    }
};
