<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('finger_attendance_logs')) {
			Schema::create('finger_attendance_logs', function (Blueprint $table) {
				$table->id();
				$table->integer('employee_id')->nullable();
				$table->integer('attendance_id')->nullable();
				$table->datetime('date');
				$table->string('attendance_type')->nullable();
				$table->string('description')->nullable();
				$table->integer('company_id')->nullable();
				$table->integer('user_id')->nullable();
				$table->timestamps();
			});
		}
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('finger_attendance_logs');
    }
};
