<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSaleTransferRentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('sale_transfer_rents')) {
            Schema::create('sale_transfer_rents', function (Blueprint $table) {
                $table->id();
                $table->integer('sale_id')->unsigned()->nullable();
                $table->integer('receivable_member_id')->unsigned()->nullable();
                $table->integer('payable_member_id')->unsigned()->nullable();
                $table->integer('receivable_transaction')->unsigned()->nullable();
                $table->integer('payable_transaction')->unsigned()->nullable();
                $table->integer('bank_transaction')->unsigned()->nullable();
                $table->string('type')->nullable();
                $table->text('description')->nullable();
                $table->integer('user_id')->nullable();
                $table->integer('company_id')->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sale_transfer_rents');
    }
}
