<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddPercentageToBuildsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('builds', function (Blueprint $table) {
            if (!Schema::hasColumn('builds', 'percentage')) {
				$table->string('percentage')->nullable();
            }
        });
		
		Schema::table('build_details', function (Blueprint $table) {
            if (!Schema::hasColumn('build_details', 'item_percentage')) {
				$table->double('item_percentage')->nullable();
            }
        });
		
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('builds', function (Blueprint $table) {
            //
        });
    }
}
