<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCargoWastageDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('cargo_wastage_details')) {
			Schema::create('cargo_wastage_details', function (Blueprint $table) {
				$table->id();
				$table->integer('cargo_wastage_id')->unsigned()->nullable();
				$table->integer('cargo_loading_id')->unsigned()->nullable();
				$table->integer('cargo_contract_id')->unsigned()->nullable();
				$table->integer('driver_id')->unsigned()->nullable();
				$table->integer('vehicle_id')->unsigned()->nullable();
				$table->integer('container_id')->unsigned()->nullable();
				$table->integer('cargo_item_id')->unsigned();
				$table->integer('site_id')->unsigned()->nullable();
				$table->double('quantity')->nullable();
				$table->double('price')->nullable();
				$table->integer('expense_tran_id')->nullable();
				$table->integer('company_id')->nullable();
				$table->timestamps();
			});
		}
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cargo_wastage_details');
    }
}
