<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCargoWastagesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('cargo_wastages')) {
			Schema::create('cargo_wastages', function (Blueprint $table) {
				$table->id();
				$table->integer('number')->nullable();
				$table->integer('member_id')->nullable();
				$table->integer('payable_transaction_id')->nullable();
				$table->datetime('date');
				$table->string('description')->nullable();
				$table->integer('company_id')->nullable();
				$table->integer('user_id')->nullable();
				$table->timestamps();
			});
		}
		
		Schema::table('cargo_stock_outs', function (Blueprint $table) {
            if (!Schema::hasColumn('cargo_stock_outs', 'cargo_wastage_id')) {
				$table->integer('cargo_wastage_id')->nullable();
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cargo_wastages');
    }
}
