<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCargoItemExpenseCatgTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('cargo_item_expense_catg')) {
			Schema::create('cargo_item_expense_catg', function (Blueprint $table) {
				$table->id();
				$table->integer('cargo_item_expense_id')->nullable();
				$table->integer('item_expense_category_id')->nullable();
				$table->string('category');
				$table->double('amount');
				$table->integer('company_id')->nullable();
				$table->integer('user_id')->nullable();
				$table->timestamps();
			});
		}
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cargo_item_expense_catg');
    }
}
