<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddReceivableTransactionIdToCargoItemExpenseTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('cargo_item_expense', function (Blueprint $table) {
            if (!Schema::hasColumn('cargo_item_expense', 'receivable_transaction_id')) {
				$table->integer('receivable_transaction_id')->unsigned()->nullable();
				$table->integer('payable_transaction_id')->unsigned()->nullable();
				$table->integer('expense_category_id')->unsigned()->nullable();
				$table->string('money_type')->nullable();
				$table->integer('type_id')->unsigned()->nullable();
				$table->string('type')->nullable();
            }
        });
		
		Schema::table('cargo_item_expense_details', function (Blueprint $table) {
            if (!Schema::hasColumn('cargo_item_expense_details', 'percent')) {
				$table->double('percent')->nullable();
				$table->double('quantity')->nullable();
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('cargo_item_expense', function (Blueprint $table) {
            //
        });
    }
}
