<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCustomsDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		if(!Schema::hasTable('customs_details')) {
			Schema::create('customs_details', function (Blueprint $table) {
				$table->id();
				$table->double('qty')->nullable();
				$table->text('description')->nullable();
				$table->integer('customs_id')->unsigned()->nullable();
				$table->integer('customs_field_id')->unsigned()->nullable();
                $table->integer('user_id')->unsigned()->nullable();
                $table->integer('company_id')->unsigned()->nullable();
				$table->timestamps();
			});
		}
		
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('customs_details');
    }
}
